/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.commentwindow;

import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.commentwindow.CommentWindowProvider;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.DomainObjectListenerBuilder;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CommentChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.SwingUpdateManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Displays a list of comments", description="This plugin provides a component for showing all the comments in the current program.  The comment window can be filtered and used for navigation.", servicesRequired={GoToService.class})
public class CommentWindowPlugin
extends ProgramPlugin {
    private DockingAction selectAction;
    private CommentWindowProvider provider;
    private SwingUpdateManager reloadUpdateMgr;
    private DomainObjectListener domainObjectListener = this.createDomainObjectListener();

    public CommentWindowPlugin(PluginTool tool) {
        super(tool);
        this.reloadUpdateMgr = new SwingUpdateManager(1000, 60000, () -> this.doReload());
    }

    public void init() {
        super.init();
        this.provider = new CommentWindowProvider(this);
        this.createActions();
    }

    public void dispose() {
        this.reloadUpdateMgr.dispose();
        if (this.currentProgram != null) {
            this.currentProgram.removeListener(this.domainObjectListener);
        }
        this.provider.dispose();
        super.dispose();
    }

    private DomainObjectListener createDomainObjectListener() {
        return ((DomainObjectListenerBuilder)new DomainObjectListenerBuilder((Object)this).any(new EventType[]{DomainObjectEvent.RESTORED, ProgramEvent.CODE_REMOVED}).terminate(this::reload)).with(CommentChangeRecord.class).each(new EventType[]{ProgramEvent.COMMENT_CHANGED}).call(this::handleCommentChanged).build();
    }

    private void handleCommentChanged(CommentChangeRecord ccr) {
        CommentType commentType = ccr.getCommentType();
        String oldComment = ccr.getOldComment();
        String newComment = ccr.getNewComment();
        Address commentAddress = ccr.getStart();
        if (oldComment == null) {
            this.provider.commentAdded(commentAddress, commentType);
        } else if (newComment == null) {
            this.provider.commentRemoved(commentAddress, commentType);
        } else {
            this.provider.getComponent().repaint();
        }
    }

    private void reload() {
        this.reloadUpdateMgr.update();
    }

    private void doReload() {
        this.provider.reload();
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener(this.domainObjectListener);
        this.provider.programOpened(program);
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener(this.domainObjectListener);
        this.provider.programClosed();
    }

    Program getProgram() {
        return this.currentProgram;
    }

    CommentWindowProvider getProvider() {
        return this.provider;
    }

    private void createActions() {
        this.selectAction = new MakeProgramSelectionAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.selectAction);
        SelectionNavigationAction selectionAction = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)selectionAction);
    }

    private void selectComment(ProgramSelection selection) {
        ProgramSelectionPluginEvent pspe = new ProgramSelectionPluginEvent("Selection", selection, this.currentProgram);
        this.firePluginEvent(pspe);
        this.processEvent(pspe);
    }
}

