/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import ghidra.app.plugin.core.function.editor.FunctionData;
import ghidra.app.plugin.core.function.editor.FunctionDataView;
import ghidra.app.plugin.core.function.editor.ModelChangeListener;
import ghidra.app.plugin.core.function.editor.ParamInfo;
import ghidra.app.plugin.core.function.editor.VarnodeInfo;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.cparser.C.ParseException;
import ghidra.app.util.parser.FunctionSignatureParser;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableSizeException;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class FunctionEditorModel {
    public static final String PARSING_MODE_STATUS_TEXT = "<html>" + HTMLUtilities.escapeHTML((String)"<TAB> or <RETURN> to commit edits, <ESC> to abort");
    static final String NONE_CHOICE = "-NONE-";
    private FunctionData functionData;
    private FunctionDataView originalFunctionData;
    private String signatureFieldText;
    private ModelChangeListener listener = new DummyModelChangedListener(this);
    private Function function;
    private Program program;
    private List<ParamInfo> selectedParams = new ArrayList<ParamInfo>();
    private boolean isInParsingMode;
    private DataTypeManagerService dataTypeManagerService;
    private String statusText = "";
    private boolean isValid = true;
    private boolean isSignatureTransformed = false;
    private boolean hasSignificantParameterChanges = false;

    public FunctionEditorModel(DataTypeManagerService service, Function function) {
        this.dataTypeManagerService = service;
        this.function = function;
        this.program = function.getProgram();
        this.functionData = new FunctionData(function);
        this.originalFunctionData = new FunctionDataView(this.functionData);
        this.validate();
    }

    void setModelChangeListener(ModelChangeListener listener) {
        this.listener = listener;
        if (listener == null) {
            this.listener = new DummyModelChangedListener(this);
        }
    }

    boolean hasChanges() {
        return !this.functionData.equals(this.originalFunctionData);
    }

    boolean hasSignificantParameterChanges() {
        return this.hasSignificantParameterChanges;
    }

    List<String> getCallingConventionNames() {
        Collection names = this.function.getProgram().getFunctionManager().getCallingConventionNames();
        ArrayList<String> list = new ArrayList<String>(names);
        String callingConventionName = this.getCallingConventionName();
        if (callingConventionName != null && !names.contains(callingConventionName)) {
            list.add(callingConventionName);
            Collections.sort(list);
        }
        list.add(0, "default");
        list.add(0, "unknown");
        return list;
    }

    String[] getCallFixupNames() {
        return this.program.getCompilerSpec().getPcodeInjectLibrary().getCallFixupNames();
    }

    void dispose() {
        this.listener = new DummyModelChangedListener(this);
    }

    private void notifyDataChanged() {
        this.validate();
        Swing.runLater(() -> this.listener.dataChanged());
    }

    private void validate() {
        this.statusText = "";
        if (this.isSignatureTransformed) {
            this.statusText = "Signature transformed due to auto-params and/or forced-indirect storage change";
            this.isSignatureTransformed = false;
        }
        this.isValid = this.hasValidName() && this.hasValidReturnType() && this.hasValidReturnStorage() && this.hasValidParams();
        this.hasSignificantParameterChanges = false;
        if (this.isValid) {
            this.hasSignificantParameterChanges = this.functionData.hasParameterChanges(this.originalFunctionData);
            this.checkUnassignedStorage();
        }
    }

    private boolean hasValidReturnStorage() {
        if (!this.functionData.canCustomizeStorage()) {
            return true;
        }
        ParamInfo returnInfo = this.functionData.getReturnInfo();
        VariableStorage returnStorage = returnInfo.getStorage();
        DataType returnType = returnInfo.getDataType();
        if (returnStorage.isUnassignedStorage()) {
            return true;
        }
        int storageSize = returnStorage.size();
        if (returnType instanceof TypeDef) {
            returnType = ((TypeDef)returnType).getBaseDataType();
        }
        if (storageSize > 0 && returnType instanceof AbstractFloatDataType) {
            return true;
        }
        int returnDataTypeSize = returnType.getLength();
        if (storageSize < returnDataTypeSize) {
            this.statusText = "Insufficient Return Storage (" + storageSize + "-bytes) for datatype (" + returnDataTypeSize + "-bytes)";
            return false;
        }
        return true;
    }

    private void checkUnassignedStorage() {
        boolean hasUnassignedStorage;
        ParamInfo returnInfo = this.functionData.getReturnInfo();
        VariableStorage returnStorage = returnInfo.getStorage();
        DataType returnType = returnInfo.getFormalDataType();
        boolean bl = hasUnassignedStorage = returnStorage != null && returnStorage.isUnassignedStorage();
        if (!hasUnassignedStorage) {
            for (ParamInfo param : this.functionData.getParameters()) {
                if (!param.getStorage().isUnassignedStorage()) continue;
                hasUnassignedStorage = true;
                break;
            }
        }
        if (hasUnassignedStorage) {
            this.statusText = "Warning: Return Storage and/or Parameter Storage is Unassigned";
        } else if (!this.functionData.canCustomizeStorage() && "unknown".equals(this.functionData.getCallingConventionName()) && (!VoidDataType.isVoidDataType((DataType)returnType) || this.functionData.hasParameters())) {
            this.statusText = "Warning: No calling convention specified. Ghidra may automatically assign one later.";
        }
    }

    private boolean hasValidParams() {
        for (ParamInfo param : this.functionData.getParameters()) {
            if (this.isValidParamType(param) && this.isValidParamName(param) && this.isValidStorage(param)) continue;
            return false;
        }
        return this.hasNonConflictingStorage();
    }

    private void clearStorageConflicts() {
        for (ParamInfo p : this.functionData.getParameters()) {
            p.setHasStorageConflict(false);
        }
    }

    private void setStorageConflict(int ordinal) {
        for (ParamInfo p : this.functionData.getParameters()) {
            if (p.getOrdinal() != ordinal) continue;
            p.setHasStorageConflict(true);
        }
    }

    private boolean hasNonConflictingStorage() {
        this.clearStorageConflicts();
        if (!this.functionData.canCustomizeStorage()) {
            return true;
        }
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (ParamInfo paramInfo : this.functionData.getParameters()) {
            params.add(paramInfo.getParameter(SourceType.USER_DEFINED));
        }
        for (Parameter p : params) {
            if (!this.identifyStorageConflicts(p, params)) continue;
            this.statusText = "One or more parameter storage conflicts exist";
            return false;
        }
        return true;
    }

    private boolean identifyStorageConflicts(Parameter p, ArrayList<Parameter> params) {
        try {
            VariableUtilities.checkVariableConflict(params, (Variable)p, (VariableStorage)p.getVariableStorage(), conflicts -> this.handleConflicts(conflicts));
        }
        catch (VariableSizeException e) {
            this.setStorageConflict(p.getOrdinal());
            return true;
        }
        return false;
    }

    private boolean handleConflicts(List<Variable> conflicts) {
        conflicts.forEach(var -> this.setStorageConflict(((Parameter)var).getOrdinal()));
        return false;
    }

    private boolean isValidStorage(ParamInfo param) {
        if (!this.functionData.canCustomizeStorage()) {
            return true;
        }
        VariableStorage storage = param.getStorage();
        if (storage.isUnassignedStorage()) {
            return true;
        }
        int storageSize = storage.size();
        DataType datatype = param.getDataType();
        if (datatype instanceof TypeDef) {
            datatype = ((TypeDef)datatype).getBaseDataType();
        }
        if (storageSize > 0 && datatype instanceof AbstractFloatDataType) {
            return true;
        }
        int paramSize = datatype.getLength();
        if (storageSize < paramSize) {
            this.statusText = "Insufficient storage (" + storageSize + "-bytes) for datatype (" + paramSize + "-bytes) assigned to parameter " + (param.getOrdinal() + 1);
            return false;
        }
        return true;
    }

    boolean hasValidName() {
        String name = this.functionData.getName();
        if (name.length() == 0) {
            this.statusText = "Missing function name";
            return false;
        }
        if (SymbolUtilities.containsInvalidChars((String)name)) {
            this.statusText = "Invalid function name: \"" + name + "\"";
            return false;
        }
        return true;
    }

    private boolean hasValidReturnType() {
        DataType returnType = this.functionData.getReturnInfo().getDataType();
        if (VoidDataType.isVoidDataType((DataType)returnType)) {
            return true;
        }
        if (returnType.getLength() <= 0) {
            this.statusText = "\"" + returnType.getName() + "\" is not allowed as a return type: Must be fixed size.";
            return false;
        }
        return true;
    }

    private boolean isValidParamName(ParamInfo param) {
        String paramName = param.getName();
        if (SymbolUtilities.containsInvalidChars((String)paramName)) {
            this.statusText = "Invalid name for parameter " + (param.getOrdinal() + 1) + ": " + paramName;
            return false;
        }
        for (ParamInfo info : this.functionData.getParameters()) {
            if (info == param || !info.getName().equals(paramName)) continue;
            this.statusText = "Duplicate parameter name: " + paramName;
            return false;
        }
        return true;
    }

    private boolean isValidParamType(ParamInfo param) {
        DataType dataType = param.getDataType();
        if (VoidDataType.isVoidDataType((DataType)dataType)) {
            this.statusText = "\"void\" is not allowed as a parameter datatype.";
            return false;
        }
        if (dataType.getLength() < 0) {
            this.statusText = "\"" + dataType.getName() + "\" is not allowed as a parameter datatype. Must be fixed size.";
            return false;
        }
        return true;
    }

    boolean isValid() {
        return this.isValid;
    }

    String getStatusText() {
        if (this.isInParsingMode) {
            return PARSING_MODE_STATUS_TEXT;
        }
        return this.statusText;
    }

    boolean isInlineAllowed() {
        return !this.getAffectiveFunction().isExternal();
    }

    private Function getAffectiveFunction() {
        return this.function.isThunk() ? this.function.getThunkedFunction(true) : this.function;
    }

    String getFunctionSignatureTextFromModel() {
        return this.functionData.getFunctionSignatureText();
    }

    String getNameString() {
        return this.functionData.getNameString();
    }

    String getName() {
        return this.functionData.getName();
    }

    void setName(String name) {
        if (this.getName().equals(name)) {
            return;
        }
        this.functionData.setName(name.trim());
        this.notifyDataChanged();
    }

    String getCallingConventionName() {
        return this.functionData.getCallingConventionName();
    }

    public void setCallingConventionName(String callingConventionName) {
        if (Objects.equals(this.getCallingConventionName(), callingConventionName)) {
            return;
        }
        this.functionData.setCallingConventionName(callingConventionName);
        this.notifyDataChanged();
    }

    boolean hasVarArgs() {
        return this.functionData.hasVarArgs();
    }

    void setHasVarArgs(boolean b) {
        if (b == this.hasVarArgs()) {
            return;
        }
        this.functionData.setVarArgs(b);
        this.notifyDataChanged();
    }

    DataType getReturnType() {
        return this.functionData.getReturnInfo().getDataType();
    }

    DataType getFormalReturnType() {
        return this.functionData.getReturnInfo().getFormalDataType();
    }

    public boolean setFormalReturnType(DataType formalReturnType) {
        return this.setParameterFormalDataType(this.functionData.getReturnInfo(), formalReturnType);
    }

    boolean isInLine() {
        return this.functionData.isInline();
    }

    void setIsInLine(boolean isInLine) {
        if (isInLine == this.functionData.isInline()) {
            return;
        }
        this.functionData.setInline(isInLine);
        if (isInLine && this.functionData.hasCallFixup()) {
            this.functionData.clearCallFixup();
        }
        this.notifyDataChanged();
    }

    boolean isNoReturn() {
        return this.functionData.hasNoReturn();
    }

    void setNoReturn(boolean hasNoReturn) {
        if (hasNoReturn == this.functionData.hasNoReturn()) {
            return;
        }
        this.functionData.setHasNoReturn(hasNoReturn);
        this.notifyDataChanged();
    }

    String getCallFixupChoice() {
        String fixupName = this.functionData.getCallFixupName();
        return fixupName == null ? NONE_CHOICE : fixupName;
    }

    void setCallFixupChoice(String callFixupName) {
        if (callFixupName.equals(this.getCallFixupChoice())) {
            return;
        }
        if (NONE_CHOICE.equals(callFixupName)) {
            callFixupName = null;
        }
        this.functionData.setCallFixupName(callFixupName);
        if (this.isInLine() && this.functionData.hasCallFixup()) {
            this.functionData.setInline(false);
        }
        this.notifyDataChanged();
    }

    public void setSelectedParameterRows(int[] selectedRows) {
        int[] currentRows = this.getSelectedParameterRows();
        if (Arrays.equals(currentRows, selectedRows)) {
            return;
        }
        this.selectedParams.clear();
        List<ParamInfo> parameters = this.functionData.getParameters();
        for (int i : selectedRows) {
            ParamInfo p = i == 0 ? this.functionData.getReturnInfo() : parameters.get(i - 1);
            this.selectedParams.add(p);
        }
        Collections.sort(this.selectedParams);
        this.notifyDataChanged();
    }

    private ParamInfo getSelectedParam() {
        return this.selectedParams.iterator().next();
    }

    private void setSelectedParam(ParamInfo p) {
        this.selectedParams.clear();
        this.selectedParams.add(p);
    }

    int[] getSelectedParameterRows() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (ParamInfo p : this.selectedParams) {
            list.add(p.getOrdinal() + 1);
        }
        Collections.sort(list);
        int[] selectedRows = new int[list.size()];
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedRows[i] = (Integer)list.get(i);
        }
        return selectedRows;
    }

    void addParameter() {
        this.listener.tableRowsChanged();
        ParamInfo p = this.functionData.addNewParameter();
        this.setSelectedParam(p);
        this.notifyDataChanged();
    }

    public void removeParameters() {
        if (!this.canRemoveParameters()) {
            throw new AssertException("Attempted to remove parameters when not allowed.");
        }
        this.listener.tableRowsChanged();
        int ordinal = this.selectedParams.get(0).getOrdinal();
        this.functionData.removeParameters(this.selectedParams);
        this.selectedParams.clear();
        ParamInfo selectParam = null;
        Iterator<ParamInfo> iterator = this.functionData.getParameters().iterator();
        while (iterator.hasNext()) {
            ParamInfo p;
            selectParam = p = iterator.next();
            if (ordinal != p.getOrdinal()) continue;
            break;
        }
        if (selectParam != null) {
            this.setSelectedParam(selectParam);
        }
        this.notifyDataChanged();
    }

    void moveSelectedParameterUp() {
        if (!this.canMoveParameterUp()) {
            throw new AssertException("Attempted to move parameters up when not allowed.");
        }
        this.listener.tableRowsChanged();
        ParamInfo p = this.getSelectedParam();
        this.functionData.moveParameterUp(p.getOrdinal());
        this.notifyDataChanged();
    }

    void moveSelectedParameterDown() {
        if (!this.canMoveParameterDown()) {
            throw new AssertException("Attempted to move parameters down when not allowed.");
        }
        this.listener.tableRowsChanged();
        ParamInfo p = this.getSelectedParam();
        this.functionData.moveParameterDown(p.getOrdinal());
        this.notifyDataChanged();
    }

    public List<ParamInfo> getParameters() {
        return this.functionData.getParameters();
    }

    boolean canRemoveParameters() {
        if (this.selectedParams.size() == 0) {
            return false;
        }
        for (ParamInfo p : this.selectedParams) {
            if (!p.isAutoParameter() && !p.isReturnParameter()) continue;
            return false;
        }
        return true;
    }

    boolean canMoveParameterUp() {
        if (this.selectedParams.size() != 1) {
            return false;
        }
        ParamInfo p = this.selectedParams.iterator().next();
        return p.getOrdinal() > this.getAutoParamCount();
    }

    boolean canMoveParameterDown() {
        List<ParamInfo> parameters;
        if (this.selectedParams.size() != 1) {
            return false;
        }
        ParamInfo p = this.selectedParams.iterator().next();
        if (p.getOrdinal() < this.getAutoParamCount() || p.getOrdinal() >= this.getParamCount() - 1) {
            return false;
        }
        return !this.canUseCustomStorage() || !this.functionData.hasParameters() || !"this".equals((parameters = this.getParameters()).get(0).getName());
    }

    void setParameterName(ParamInfo param, String newName) {
        param.setName(newName);
        this.notifyDataChanged();
    }

    boolean setParameterFormalDataType(ParamInfo param, DataType formalDataType) {
        boolean isReturn = param.getOrdinal() == -1;
        try {
            formalDataType = VariableUtilities.checkDataType((DataType)formalDataType, (boolean)isReturn, (int)0, (Program)this.program);
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)this, null, (String)"Invalid Data Type", (Object)e.getMessage());
            return false;
        }
        if (formalDataType.equals((Object)param.getFormalDataType())) {
            return true;
        }
        param.setFormalDataType(formalDataType.clone((DataTypeManager)this.program.getDataTypeManager()));
        if (this.canUseCustomStorage()) {
            if (isReturn && VoidDataType.isVoidDataType((DataType)formalDataType)) {
                param.setStorage(VariableStorage.VOID_STORAGE);
            } else {
                VariableStorage curStorage = param.getStorage();
                int size = formalDataType.getLength();
                if (curStorage == VariableStorage.VOID_STORAGE) {
                    param.setStorage(VariableStorage.UNASSIGNED_STORAGE);
                } else if (size > 0 && size != curStorage.size() && curStorage.getVarnodeCount() == 1) {
                    this.adjustStorageSize(param, curStorage, size);
                }
            }
        } else {
            this.functionData.updateParameterAndReturnStorage();
        }
        this.notifyDataChanged();
        return true;
    }

    private void adjustStorageSize(ParamInfo param, VariableStorage curStorage, int newSize) {
        Varnode varnode = curStorage.getVarnodes()[0];
        Address address = varnode.getAddress();
        if (address != null) {
            Register reg = VarnodeInfo.getRegister(this.program, varnode.getAddress(), varnode.getSize());
            if (reg != null) {
                Register baseReg = reg.getBaseRegister();
                if (newSize > baseReg.getMinimumByteSize()) {
                    address = baseReg.getAddress();
                    newSize = baseReg.getMinimumByteSize();
                } else if (baseReg.isBigEndian()) {
                    address = baseReg.getAddress().add((long)(baseReg.getMinimumByteSize() - newSize));
                }
            }
            try {
                param.setStorage(new VariableStorage((ProgramArchitecture)this.program, address, newSize));
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
    }

    VariableStorage getReturnStorage() {
        return this.functionData.getReturnInfo().getStorage();
    }

    Function getFunction() {
        return this.function;
    }

    public void setReturnStorage(VariableStorage storage) {
        if (storage == null) {
            storage = VariableStorage.UNASSIGNED_STORAGE;
        }
        if (storage.equals((Object)this.getReturnStorage())) {
            return;
        }
        this.functionData.getReturnInfo().setStorage(storage);
        this.notifyDataChanged();
    }

    public void setParameterStorage(ParamInfo param, VariableStorage storage) {
        if (storage == null) {
            storage = VariableStorage.UNASSIGNED_STORAGE;
        }
        if (storage.equals((Object)param.getStorage())) {
            return;
        }
        param.setStorage(storage);
        this.notifyDataChanged();
    }

    public void setUseCustomizeStorage(boolean b) {
        if (b == this.canUseCustomStorage()) {
            return;
        }
        this.functionData.setUseCustomStorage(b);
        this.isSignatureTransformed = !this.functionData.getFunctionSignatureText().equals(this.originalFunctionData.getFunctionSignatureText());
        this.notifyDataChanged();
    }

    public boolean canUseCustomStorage() {
        return this.functionData.canCustomizeStorage();
    }

    boolean apply() {
        return this.apply(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean apply(boolean commitFullParamDetails) {
        int id = this.program.startTransaction("Edit Function");
        try {
            if (this.applyFunctionData(commitFullParamDetails)) {
                this.setModelUnchanged();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.program.endTransaction(id, true);
        }
    }

    private boolean applyFunctionData(boolean commitFullParamDetails) {
        try {
            String callingConventionName;
            String fixupName;
            String name = this.functionData.getName();
            if (!name.equals(this.function.getName())) {
                this.function.setName(name, SourceType.USER_DEFINED);
            }
            boolean isInline = this.functionData.isInline();
            if (this.function.isInline() != isInline) {
                this.function.setInline(isInline);
            }
            boolean hasNoReturn = this.functionData.hasNoReturn();
            if (this.function.hasNoReturn() != hasNoReturn) {
                this.function.setNoReturn(hasNoReturn);
            }
            if (!SystemUtilities.isEqual((Object)(fixupName = this.functionData.getCallFixupName()), (Object)this.function.getCallFixup())) {
                this.function.setCallFixup(fixupName);
            }
            boolean hasVarArgs = this.hasVarArgs();
            if (this.function.hasVarArgs() != hasVarArgs) {
                this.function.setVarArgs(hasVarArgs);
            }
            boolean isCallingConventionChanged = !Objects.equals(callingConventionName = this.functionData.getCallingConventionName(), this.originalFunctionData.callingConventionName);
            boolean useCustomStorage = this.functionData.canCustomizeStorage();
            if (!commitFullParamDetails) {
                if (useCustomStorage != this.function.hasCustomVariableStorage()) {
                    this.function.setCustomVariableStorage(useCustomStorage);
                }
                if (isCallingConventionChanged) {
                    this.function.setCallingConvention(callingConventionName);
                }
                if (!this.hasSignificantParameterChanges && this.functionData.hasParameterNamesChanged(this.originalFunctionData)) {
                    for (ParamInfo paramInfo : this.functionData.getParameters()) {
                        Parameter param = this.function.getParameter(paramInfo.getOrdinal());
                        if (param == null) continue;
                        if (param.getSymbol().isDeleted()) break;
                        param.setName(paramInfo.getName(), SourceType.USER_DEFINED);
                    }
                }
                return true;
            }
            SourceType sigSource = this.hasSignificantParameterChanges ? SourceType.USER_DEFINED : SourceType.ANALYSIS;
            SymbolTable symbolTable = this.program.getSymbolTable();
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            for (ParamInfo paramInfo : this.functionData.getParameters()) {
                if (paramInfo.isAutoParameter()) continue;
                SourceType source = SourceType.USER_DEFINED;
                Symbol var = symbolTable.getLocalVariableSymbol(paramInfo.getName(), (Namespace)this.function);
                if (var instanceof Parameter) {
                    source = var.getSource();
                }
                params.add(paramInfo.getParameter(source));
            }
            this.function.updateFunction(callingConventionName, (Variable)this.functionData.getReturnInfo().getParameter(SourceType.DEFAULT), params, useCustomStorage ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_FORMAL_PARAMS, true, sigSource);
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)this, null, (String)"Function Edit Error", (Object)e.getMessage());
            return false;
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)this, null, (String)"Function Edit Error", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private FunctionSignature getFunctionSignature() {
        FunctionDefinitionDataType funDt = new FunctionDefinitionDataType(this.getName());
        funDt.setReturnType(this.getFormalReturnType());
        ArrayList<ParameterDefinitionImpl> params = new ArrayList<ParameterDefinitionImpl>();
        for (ParamInfo paramInfo : this.getParameters()) {
            if (paramInfo.isAutoParameter()) continue;
            String paramName = paramInfo.getName();
            DataType paramDt = paramInfo.getFormalDataType();
            params.add(new ParameterDefinitionImpl(paramName, paramDt, null));
        }
        funDt.setArguments(params.toArray(new ParameterDefinition[params.size()]));
        funDt.setVarArgs(this.hasVarArgs());
        return funDt;
    }

    Program getProgram() {
        return this.program;
    }

    DataTypeManagerService getDataTypeManagerService() {
        return this.dataTypeManagerService;
    }

    int getAutoParamCount() {
        return this.functionData.getAutoParamCount();
    }

    int getParamCount() {
        return this.functionData.getParamCount();
    }

    private boolean isSameSize(DataType dt1, DataType dt2) {
        if (dt1 == null || dt2 == null) {
            return false;
        }
        return dt1.getLength() == dt2.getLength();
    }

    public void setFunctionData(FunctionDefinitionDataType functionDefinition) {
        this.setName(functionDefinition.getName());
        this.setCallingConventionName(functionDefinition.getCallingConventionName());
        DataType returnDt = functionDefinition.getReturnType();
        this.setFormalReturnType(returnDt);
        ArrayList<ParamInfo> oldParams = new ArrayList<ParamInfo>(this.getParameters());
        this.functionData.removeAllParameters();
        List<ParamInfo> parameters = this.functionData.getParameters();
        for (ParameterDefinition paramDefinition : functionDefinition.getArguments()) {
            parameters.add(new ParamInfo((FunctionDataView)this.functionData, paramDefinition));
        }
        this.setHasVarArgs(functionDefinition.hasVarArgs());
        this.functionData.fixupOrdinals();
        if (this.canUseCustomStorage()) {
            if (VoidDataType.isVoidDataType((DataType)returnDt)) {
                this.setReturnStorage(VariableStorage.VOID_STORAGE);
            } else if (!this.isSameSize(this.getFormalReturnType(), functionDefinition.getReturnType())) {
                this.setReturnStorage(VariableStorage.UNASSIGNED_STORAGE);
            }
            this.reconcileCustomStorage(oldParams, parameters);
        }
        this.selectedParams.clear();
        this.functionData.updateParameterAndReturnStorage();
        this.notifyDataChanged();
    }

    private void reconcileCustomStorage(List<ParamInfo> oldParams, List<ParamInfo> newParams) {
        HashSet<ParamInfo> oldMatches = new HashSet<ParamInfo>();
        HashSet<ParamInfo> newMatches = new HashSet<ParamInfo>();
        for (ParamInfo paramInfo : newParams) {
            ParamInfo oldInfo = this.findOldCustomInfoByNameAndDataTypeSize(oldParams, paramInfo.getName(), paramInfo.getDataType().getLength());
            if (oldInfo == null) continue;
            oldMatches.add(oldInfo);
            newMatches.add(paramInfo);
            paramInfo.setStorage(oldInfo.getStorage());
        }
        for (int i = 0; i < newParams.size() && i < oldParams.size(); ++i) {
            ParamInfo oldInfo = oldParams.get(i);
            ParamInfo newInfo = newParams.get(i);
            if (oldMatches.contains(oldInfo) || newMatches.contains(newInfo) || !this.isSameSize(oldInfo.getDataType(), newInfo.getDataType())) break;
            newInfo.setStorage(oldInfo.getStorage());
        }
    }

    private ParamInfo findOldCustomInfoByNameAndDataTypeSize(List<ParamInfo> oldParams, String newParamName, int size) {
        for (ParamInfo paramInfo : oldParams) {
            if (!paramInfo.getName().equals(newParamName) || paramInfo.getDataType().getLength() != size) continue;
            return paramInfo;
        }
        return null;
    }

    boolean isInParsingMode() {
        return this.isInParsingMode;
    }

    void setSignatureFieldText(String text) {
        this.signatureFieldText = text;
        boolean signatureTextFieldInSync = this.signatureFieldText.equals(this.getFunctionSignatureTextFromModel());
        if (this.isInParsingMode == signatureTextFieldInSync) {
            this.isInParsingMode = !this.isInParsingMode;
            this.notifyDataChanged();
        }
    }

    void resetSignatureTextField() {
        this.setSignatureFieldText(this.getFunctionSignatureTextFromModel());
    }

    boolean hasSignatureTextChanges() {
        return !Objects.equals(this.getFunctionSignatureTextFromModel(), this.signatureFieldText);
    }

    void parseSignatureFieldText() throws ParseException, CancelledException {
        FunctionSignatureParser parser = new FunctionSignatureParser((DataTypeManager)this.program.getDataTypeManager(), this.dataTypeManagerService);
        FunctionDefinitionDataType f = parser.parse(this.getFunctionSignature(), this.signatureFieldText);
        f.setNoReturn(this.functionData.hasNoReturn());
        try {
            f.setCallingConvention(this.getCallingConventionName());
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        this.setFunctionData(f);
        this.isInParsingMode = false;
    }

    int getFunctionNameStartPosition() {
        return this.getFormalReturnType().getName().length() + 1;
    }

    public void setModelUnchanged() {
        this.originalFunctionData = new FunctionDataView(this.functionData);
        this.resetSignatureTextField();
        this.validate();
        Swing.runLater(() -> this.listener.dataChanged());
    }

    public boolean hasChanged() {
        return !this.functionData.equals(this.originalFunctionData);
    }

    private class DummyModelChangedListener
    implements ModelChangeListener {
        private DummyModelChangedListener(FunctionEditorModel functionEditorModel) {
        }

        @Override
        public void tableRowsChanged() {
        }

        @Override
        public void dataChanged() {
        }
    }
}

