/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeSlowLoadingNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class SymbolTreeNode
extends GTreeSlowLoadingNode {
    public static final Comparator<Symbol> SYMBOL_COMPARATOR = (s1, s2) -> {
        String path2;
        Address a2;
        if (s1 == null && s2 != null) {
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        int idCompare = (int)(s1.getID() - s2.getID());
        if (idCompare == 0) {
            return idCompare;
        }
        Address a1 = s1.getAddress();
        int result = a1.compareTo((Object)(a2 = s2.getAddress()));
        if (result != 0) {
            return result;
        }
        Namespace ns1 = s1.getParentNamespace();
        Namespace ns2 = s2.getParentNamespace();
        String path1 = ns1.getName(true);
        result = path1.compareTo(path2 = ns2.getName(true));
        if (result != 0) {
            return result;
        }
        return idCompare;
    };
    static final Comparator<GTreeNode> DEFAULT_NODE_COMPARATOR = (node1, node2) -> node1.compareTo(node2);

    public abstract boolean canCut();

    public abstract boolean canPaste(List<GTreeNode> var1);

    public abstract void setNodeCut(boolean var1);

    public abstract boolean isCut();

    public abstract DataFlavor getNodeDataFlavor();

    public abstract boolean supportsDataFlavors(DataFlavor[] var1);

    public abstract Namespace getNamespace();

    public Comparator<GTreeNode> getChildrenComparator() {
        return DEFAULT_NODE_COMPARATOR;
    }

    public Symbol getSymbol() {
        return null;
    }

    public GTreeNode findSymbolTreeNode(SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        if (!this.isLoaded() && !loadChildren || monitor.isCancelled()) {
            return null;
        }
        Symbol searchSymbol = key.getSymbol();
        if (this.getSymbol() == searchSymbol) {
            return this;
        }
        List children = this.getChildren();
        int index = Collections.binarySearch(children, key, this.getChildrenComparator());
        if (index >= 0) {
            GTreeNode node = (GTreeNode)children.get(index);
            SymbolTreeNode symbolNode = (SymbolTreeNode)node;
            if (symbolNode.getSymbol() == searchSymbol) {
                return symbolNode;
            }
            node = symbolNode.findSymbolTreeNode(key, loadChildren, monitor);
            return node;
        }
        for (GTreeNode childNode : children) {
            SymbolTreeNode symbolNode;
            GTreeNode foundNode;
            if (monitor.isCancelled()) {
                return null;
            }
            if (!(childNode instanceof SymbolTreeNode) || (foundNode = (symbolNode = (SymbolTreeNode)childNode).findSymbolTreeNode(key, loadChildren, monitor)) == null) continue;
            return foundNode;
        }
        return null;
    }

    protected GTreeNode findNode(GTreeNode parent, SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        GTreeNode node;
        SymbolTreeNode symbolNode;
        SymbolTreeNode symbolNode2;
        if (!this.isLoaded() && !loadChildren || monitor.isCancelled()) {
            return null;
        }
        Symbol searchSymbol = key.getSymbol();
        if (parent instanceof SymbolTreeNode && (symbolNode2 = (SymbolTreeNode)parent).getSymbol() == searchSymbol) {
            return symbolNode2;
        }
        Comparator<GTreeNode> comparator = ((SymbolTreeNode)parent).getChildrenComparator();
        List children = parent.getChildren();
        int index = Collections.binarySearch(children, key, comparator);
        if (index >= 0 && (symbolNode = (SymbolTreeNode)(node = (GTreeNode)children.get(index))).getSymbol() == searchSymbol) {
            return symbolNode;
        }
        return null;
    }
}

