/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macos.cfm;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.macos.cfm.CFragResourceMember;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CFragResource
implements StructConverter {
    private int reservedA;
    private int reservedB;
    private int version;
    private int reservedC;
    private int reservedD;
    private int reservedE;
    private int reservedF;
    private int memberCount;
    private List<CFragResourceMember> _members = new ArrayList<CFragResourceMember>();

    public CFragResource(BinaryReader reader) throws IOException {
        this.reservedA = reader.readNextInt();
        this.reservedB = reader.readNextInt();
        this.version = reader.readNextInt();
        this.reservedD = reader.readNextInt();
        this.reservedE = reader.readNextInt();
        this.reservedF = reader.readNextInt();
        this.reservedC = reader.readNextInt();
        this.memberCount = reader.readNextInt();
        if (this.reservedA != 0 || this.reservedB != 0 || this.reservedC != 0 || this.reservedD != 0 || this.reservedE != 0 || this.reservedF != 0) {
            throw new IOException("Reserved fields contain invalid value(s).");
        }
        for (int i = 0; i < this.memberCount; ++i) {
            long oldIndex = reader.getPointerIndex();
            CFragResourceMember member = new CFragResourceMember(reader);
            this._members.add(member);
            reader.setPointerIndex(oldIndex + (long)member.getMemberSize());
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public List<CFragResourceMember> getMembers() {
        return this._members;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(CFragResource.class);
    }
}

