/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pdb.PdbInfoCodeView;
import ghidra.app.util.bin.format.pdb.PdbInfoDotNet;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.debug.DebugCodeView;
import ghidra.app.util.bin.format.pe.debug.DebugDirectory;
import ghidra.app.util.bin.format.pe.debug.DebugDirectoryParser;
import ghidra.app.util.bin.format.pe.debug.DebugMisc;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DebugDataDirectory
extends DataDirectory {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_DEBUG";
    private DebugDirectoryParser parser;

    DebugDataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public boolean parse() throws IOException {
        int ptr = this.getPointer();
        if (ptr < 0) {
            return false;
        }
        this.parser = new DebugDirectoryParser(this.reader, ptr, this.size, this.ntHeader.getOptionalHeader().getSizeOfImage());
        return true;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader nt) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        DebugDirectory[] ddarr;
        monitor.setMessage(program.getName() + ": debug...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, nt, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        for (DebugDirectory dd : ddarr = this.parser.getDebugDirectories()) {
            boolean success;
            PeUtils.createData(program, addr, dd.toDataType(), log);
            addr = addr.add(28L);
            Address dataAddr = this.getDataAddress(dd, isBinary, space, nt);
            if (dataAddr == null || (success = this.createFragment(program, "Debug Data", dataAddr, dataAddr.add((long)dd.getSizeOfData())))) continue;
            log.appendMsg("Unable to create fragment: Debug Data");
        }
        this.markupDebigMisc(program, isBinary, log, space);
        this.markupDebugCodeView(program, isBinary, log, space);
    }

    private void markupDebugCodeView(Program program, boolean isBinary, MessageLog log, AddressSpace space) {
        Address dataAddr;
        DebugCodeView dcv = this.parser.getDebugCodeView();
        if (dcv != null && (dataAddr = this.getDataAddress(dcv.getDebugDirectory(), isBinary, space, this.ntHeader)) != null) {
            PdbInfoDotNet dotNetPdbInfo;
            PdbInfoCodeView pdbInfo = dcv.getPdbInfo();
            if (pdbInfo != null) {
                this.setPlateComment(program, dataAddr, "CodeView PDB Info");
                PeUtils.createData(program, dataAddr, pdbInfo.toDataType(), log);
            }
            if ((dotNetPdbInfo = dcv.getDotNetPdbInfo()) != null) {
                this.setPlateComment(program, dataAddr, ".NET PDB Info");
                PeUtils.createData(program, dataAddr, dotNetPdbInfo.toDataType(), log);
            }
        }
    }

    private void markupDebigMisc(Program program, boolean isBinary, MessageLog log, AddressSpace space) throws DuplicateNameException {
        Address dataAddr;
        DebugMisc dm = this.parser.getDebugMisc();
        if (dm != null && (dataAddr = this.getDataAddress(dm.getDebugDirectory(), isBinary, space, this.ntHeader)) != null) {
            this.setPlateComment(program, dataAddr, "Misc Debug Info");
            PeUtils.createData(program, dataAddr, dm.toDataType(), log);
        }
    }

    private Address getDataAddress(DebugDirectory dd, boolean isBinary, AddressSpace space, NTHeader nt) {
        long ptr = 0L;
        if (isBinary) {
            ptr = dd.getPointerToRawData();
            if (ptr != 0L && !nt.checkPointer(ptr)) {
                Msg.error((Object)this, (Object)("Invalid pointer " + Long.toHexString(ptr)));
                return null;
            }
        } else {
            ptr = dd.getAddressOfRawData();
        }
        if (ptr != 0L) {
            if (isBinary) {
                return space.getAddress(ptr);
            }
            return space.getAddress(ptr + nt.getOptionalHeader().getImageBase());
        }
        return null;
    }

    public DebugDirectoryParser getParser() {
        return this.parser;
    }

    @Override
    public void writeBytes(RandomAccessFile raf, DataConverter dc, PortableExecutable template) throws IOException {
        OptionalHeader optionalHeader = template.getNTHeader().getOptionalHeader();
        DataDirectory[] originalDataDirs = optionalHeader.getDataDirectories();
        if (optionalHeader.getNumberOfRvaAndSizes() <= 6L) {
            return;
        }
        if (originalDataDirs[6] == null || originalDataDirs[6].getSize() == 0) {
            return;
        }
        DebugDataDirectory templateDDD = (DebugDataDirectory)template.getNTHeader().getOptionalHeader().getDataDirectories()[6];
        DebugDirectory[] templateDD = templateDDD.getParser().getDebugDirectories();
        DebugDirectory[] dd = this.parser.getDebugDirectories();
        for (int i = 0; i < dd.length; ++i) {
            dd[i].writeHeader(raf, dc);
            if (dd[i].getSizeOfData() == 0 || dd[i].getPointerToRawData() == 0) continue;
            int ptr = dd[i].getPointerToRawData();
            if (!this.ntHeader.checkPointer(ptr)) {
                Msg.error((Object)this, (Object)("Invalid pointer " + Long.toHexString(ptr)));
                continue;
            }
            raf.seek(ptr);
            raf.write(templateDD[i].toBytes(dc));
        }
    }

    void updatePointers(int offset, int postOffset) {
        DebugDirectory[] debugDirs;
        for (DebugDirectory debugDir : debugDirs = this.parser.getDebugDirectories()) {
            if (debugDir.getSizeOfData() == 0 || debugDir.getPointerToRawData() == 0) continue;
            debugDir.updatePointers(offset, postOffset);
        }
    }
}

