/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.values;

import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.values.AbstractValue;
import docking.widgets.values.BooleanValue;
import docking.widgets.values.ChoiceValue;
import docking.widgets.values.DoubleValue;
import docking.widgets.values.FileValue;
import docking.widgets.values.IntValue;
import docking.widgets.values.LongValue;
import docking.widgets.values.StringValue;
import docking.widgets.values.ValuesMapParseException;
import docking.widgets.values.ValuesMapValidator;
import ghidra.util.StatusListener;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class GValuesMap {
    protected Map<String, AbstractValue<?>> valuesMap = new LinkedHashMap();
    private ValuesMapValidator validator;

    public Collection<AbstractValue<?>> getValues() {
        return this.valuesMap.values();
    }

    public AbstractValue<?> addValue(AbstractValue<?> value) {
        String name = value.getName();
        this.checkDup(name);
        this.valuesMap.put(name, value);
        return value;
    }

    public void setValidator(ValuesMapValidator validator) {
        this.validator = validator;
    }

    public boolean isValid(StatusListener listener) {
        if (this.validator != null) {
            return this.validator.validate(this, listener);
        }
        return true;
    }

    public void updateFromComponents() throws ValuesMapParseException {
        for (AbstractValue<?> inputValue : this.valuesMap.values()) {
            inputValue.updateValueFromComponent();
        }
    }

    public AbstractValue<?> getAbstractValue(String name) {
        return this.valuesMap.get(name);
    }

    public boolean isDefined(String name) {
        return this.valuesMap.containsKey(name);
    }

    public boolean hasValue(String name) {
        AbstractValue<?> abstractValue = this.valuesMap.get(name);
        if (abstractValue == null) {
            throw new IllegalArgumentException("No value defined for " + name);
        }
        return abstractValue.hasValue();
    }

    public void copyValues(GValuesMap otherMap) {
        for (AbstractValue<?> v : this.valuesMap.values()) {
            AbstractValue<?> otherValue = otherMap.getAbstractValue(v.getName());
            if (otherValue == null || otherValue.getClass() != v.getClass()) {
                throw new IllegalArgumentException("Can't copy values from incompatable " + this.getClass().getSimpleName() + "s!");
            }
            v.copyValue((AbstractValue)v.getClass().cast(otherValue));
        }
    }

    public BooleanValue defineBoolean(String name, boolean defaultValue) {
        this.checkDup(name);
        BooleanValue value = new BooleanValue(name, defaultValue);
        this.valuesMap.put(name, value);
        return value;
    }

    public ChoiceValue defineChoice(String name, String defaultValue, String ... choices) {
        this.checkDup(name);
        ChoiceValue value = new ChoiceValue(name, defaultValue, choices);
        this.valuesMap.put(name, value);
        return value;
    }

    public FileValue defineDirectory(String name, File defaultValue) {
        this.checkDup(name);
        FileValue value = new FileValue(name, defaultValue, null, GhidraFileChooserMode.DIRECTORIES_ONLY);
        this.valuesMap.put(name, value);
        return value;
    }

    public DoubleValue defineDouble(String name) {
        this.checkDup(name);
        DoubleValue value = new DoubleValue(name, null);
        this.valuesMap.put(name, value);
        return value;
    }

    public DoubleValue defineDouble(String name, double defaultValue) {
        this.checkDup(name);
        DoubleValue value = new DoubleValue(name, defaultValue);
        this.valuesMap.put(name, value);
        return value;
    }

    public FileValue defineFile(String name, File defaultValue) {
        return this.defineFile(name, defaultValue, null);
    }

    public FileValue defineFile(String name, File defaultValue, File startingDir) {
        this.checkDup(name);
        FileValue value = new FileValue(name, defaultValue, startingDir, GhidraFileChooserMode.FILES_ONLY);
        this.valuesMap.put(name, value);
        return value;
    }

    public IntValue defineHexInt(String name) {
        this.checkDup(name);
        IntValue value = new IntValue(name, null, true);
        this.valuesMap.put(name, value);
        return value;
    }

    public IntValue defineHexInt(String name, int defaultValue) {
        this.checkDup(name);
        IntValue value = new IntValue(name, defaultValue, true);
        this.valuesMap.put(name, value);
        return value;
    }

    public LongValue defineHexLong(String name) {
        this.checkDup(name);
        LongValue value = new LongValue(name, null, true);
        this.valuesMap.put(name, value);
        return value;
    }

    public LongValue defineHexLong(String name, long defaultValue) {
        this.checkDup(name);
        LongValue value = new LongValue(name, defaultValue, true);
        this.valuesMap.put(name, value);
        return value;
    }

    public IntValue defineInt(String name) {
        this.checkDup(name);
        IntValue value = new IntValue(name, null, false);
        this.valuesMap.put(name, value);
        return value;
    }

    public IntValue defineInt(String name, int defaultValue) {
        this.checkDup(name);
        IntValue value = new IntValue(name, defaultValue, false);
        this.valuesMap.put(name, value);
        return value;
    }

    public LongValue defineLong(String name) {
        this.checkDup(name);
        LongValue value = new LongValue(name, null, false);
        this.valuesMap.put(name, value);
        return value;
    }

    public LongValue defineLong(String name, long defaultValue) {
        this.checkDup(name);
        LongValue value = new LongValue(name, defaultValue, false);
        this.valuesMap.put(name, value);
        return value;
    }

    public StringValue defineString(String name) {
        this.checkDup(name);
        StringValue value = new StringValue(name, null);
        this.valuesMap.put(name, value);
        return value;
    }

    public StringValue defineString(String name, String defaultValue) {
        this.checkDup(name);
        StringValue value = new StringValue(name, defaultValue);
        this.valuesMap.put(name, value);
        return value;
    }

    public boolean getBoolean(String name) {
        BooleanValue booleanValue = this.getValue(name, BooleanValue.class, "Boolean");
        Boolean value = (Boolean)booleanValue.getValue();
        return value == null ? false : value;
    }

    public String getChoice(String name) {
        ChoiceValue choiceValue = this.getValue(name, ChoiceValue.class, "Choice");
        return (String)choiceValue.getValue();
    }

    public double getDouble(String name) {
        DoubleValue doubleValue = this.getValue(name, DoubleValue.class, "Double");
        Double value = (Double)doubleValue.getValue();
        return value == null ? 0.0 : value;
    }

    public File getFile(String name) {
        FileValue fileValue = this.getValue(name, FileValue.class, "File");
        return (File)fileValue.getValue();
    }

    public int getInt(String name) {
        IntValue intValue = this.getValue(name, IntValue.class, "Int");
        Integer value = (Integer)intValue.getValue();
        return value == null ? 0 : value;
    }

    public long getLong(String name) {
        LongValue longValue = this.getValue(name, LongValue.class, "Int");
        Long value = (Long)longValue.getValue();
        return value == null ? 0L : value;
    }

    public String getString(String name) {
        StringValue stringValue = this.getValue(name, StringValue.class, "String");
        return (String)stringValue.getValue();
    }

    public void setBoolean(String name, boolean value) {
        BooleanValue booleanValue = this.getValue(name, BooleanValue.class, "Boolean");
        booleanValue.setValue(value);
    }

    public void setChoice(String name, String choice) {
        ChoiceValue choiceValue = this.getValue(name, ChoiceValue.class, "Choice");
        choiceValue.setValue(choice);
    }

    public void setDouble(String name, double value) {
        DoubleValue doubleValue = this.getValue(name, DoubleValue.class, "Double");
        doubleValue.setValue(value);
    }

    public void setFile(String name, File value) {
        FileValue fileValue = this.getValue(name, FileValue.class, "File");
        fileValue.setValue(value);
    }

    public void setInt(String name, int value) {
        IntValue intValue = this.getValue(name, IntValue.class, "Int");
        intValue.setValue(value);
    }

    public void setLong(String name, long value) {
        LongValue intValue = this.getValue(name, LongValue.class, "Long");
        intValue.setValue(value);
    }

    public void setString(String name, String value) {
        StringValue stringValue = this.getValue(name, StringValue.class, "String");
        stringValue.setValue(value);
    }

    protected <T> T getValue(String name, Class<T> c, String typeName) {
        AbstractValue<?> value = this.valuesMap.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No value defined for " + name);
        }
        if (value.getClass().isAssignableFrom(c)) {
            return (T)value;
        }
        throw new IllegalArgumentException("Wrong type! No " + typeName + " value defined for: " + name);
    }

    protected void checkDup(String name) {
        if (this.valuesMap.containsKey(name)) {
            throw new IllegalArgumentException("value already exits named " + name);
        }
    }

    protected void reset() {
        for (AbstractValue<?> inputValue : this.valuesMap.values()) {
            inputValue.reset();
        }
    }
}

