/*
 * Decompiled with CFR 0.152.
 */
package docking.wizard;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.EmptyBorderButton;
import docking.widgets.label.GDLabel;
import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.util.HelpLocation;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import resources.Icons;

public class WizardDialog
extends DialogComponentProvider {
    public static final String FINISH = "Finish";
    public static final String NEXT = "Next >>";
    public static final String BACK = "<< Back";
    private static final String INIT_TITLE = "<< untitled >>";
    private static final String FONT_ID = "font.wizard.border.title";
    private WizardModel<?> model;
    private JButton backButton;
    private JButton nextButton;
    private JButton finishButton;
    private JLabel titleLabel;
    private JPanel containerPanel;

    public WizardDialog(WizardModel<?> model) {
        this(model, true);
    }

    public WizardDialog(WizardModel<?> model, boolean modal) {
        super(model.getTitle(), modal, true, true, false);
        this.model = model;
        model.initialize(this);
        this.addWorkPanel(this.buildWorkPanel());
        this.setRememberLocation(false);
        this.setRememberSize(false);
        this.createButtons();
        this.wizardStepChanged(this.getCurrentStep());
    }

    public String getStatusMessage() {
        return this.getStatusText();
    }

    public void setStatusMessage(String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setStatusText(message);
        } else {
            Runnable r = () -> this.setStatusText(message);
            SwingUtilities.invokeLater(r);
        }
    }

    public void focusNext() {
        this.nextButton.requestFocus();
    }

    public void focusFinish() {
        this.finishButton.requestFocus();
        this.setDefaultButton(this.finishButton);
    }

    public WizardStep<?> getCurrentStep() {
        return this.model.getCurrentStep();
    }

    public void show() {
        this.show(null);
    }

    public void show(Component parent) {
        DockingWindowManager.showDialog(parent, this);
    }

    @Override
    public void dispose() {
        this.model.dispose();
    }

    public void cancel() {
        this.model.cancel();
        this.close();
    }

    @Override
    protected void cancelCallback() {
        this.cancel();
    }

    void statusChanged() {
        this.backButton.setEnabled(this.model.canGoBack());
        this.nextButton.setEnabled(this.model.canGoNext());
        this.setStatusText(this.model.getStatusMessage());
        this.finishButton.setEnabled(this.model.canFinish());
        this.setCancelEnabled(this.model.canCancel());
    }

    void wizardStepChanged(WizardStep<?> step) {
        this.containerPanel.removeAll();
        JComponent component = step.getComponent();
        this.containerPanel.add(component);
        this.containerPanel.repaint();
        this.titleLabel.setText(step.getTitle());
        HelpLocation helpLocation = step.getHelpLocation();
        this.setHelpLocation(helpLocation);
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this.getComponent(), helpLocation);
        this.statusChanged();
    }

    private void createButtons() {
        this.backButton = new JButton(BACK);
        this.backButton.setMnemonic('B');
        this.nextButton = new JButton(NEXT);
        this.nextButton.setMnemonic('N');
        this.finishButton = new JButton(FINISH);
        this.finishButton.setMnemonic('F');
        this.backButton.addActionListener(evt -> this.model.goBack());
        this.nextButton.addActionListener(evt -> this.model.goNext());
        this.finishButton.addActionListener(evt -> this.model.finish());
        this.addButton(this.backButton);
        this.addButton(this.nextButton);
        this.addButton(this.finishButton);
        this.addCancelButton();
        this.setDefaultButton(this.nextButton);
    }

    private JPanel buildWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.createTitlePanel(), "North");
        panel.add((Component)this.createContainerPanel(), "Center");
        panel.setPreferredSize(this.model.getPreferredSize());
        return panel;
    }

    private Component createTitlePanel() {
        Icon wizardIcon = this.model.getIcon();
        this.titleLabel = wizardIcon == null ? new GDLabel(INIT_TITLE) : new GDLabel(INIT_TITLE, wizardIcon, 11);
        EmptyBorderButton helpButton = new EmptyBorderButton(Icons.INFO_ICON);
        helpButton.setToolTipText("Help (F1)");
        helpButton.addActionListener(e -> DockingWindowManager.getHelpService().showHelp((Object)this.rootPanel, false, (Component)this.rootPanel));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        titlePanel.add(helpButton);
        return titlePanel;
    }

    private JPanel createContainerPanel() {
        this.containerPanel = new JPanel(new BorderLayout());
        Dimension panelSize = this.model.getPreferredSize();
        this.containerPanel.setPreferredSize(panelSize);
        JComponent component = this.model.getCurrentStep().getComponent();
        this.containerPanel.add((Component)component, "Center");
        this.containerPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WizardDialog.this.updateContainerPanelBorder();
            }
        });
        return this.containerPanel;
    }

    private void updateContainerPanelBorder() {
        Component component = this.containerPanel.getComponent(0);
        Dimension size = component.getSize();
        Dimension minSize = component.getMinimumSize();
        if (size.height < minSize.height) {
            TitledBorder titledBorder = new TitledBorder(BorderFactory.createEmptyBorder(), "(Dialog too small!)");
            Gui.addThemeListener(e -> {
                if (e.isFontChanged(FONT_ID)) {
                    titledBorder.setTitleFont(Gui.getFont((String)FONT_ID));
                }
            });
            titledBorder.setTitleFont(Gui.getFont((String)FONT_ID));
            titledBorder.setTitleColor((Color)GThemeDefaults.Colors.Messages.NORMAL);
            titledBorder.setTitlePosition(5);
            titledBorder.setTitleJustification(5);
            this.containerPanel.setBorder(titledBorder);
        } else {
            this.containerPanel.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

