/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.util.Conv;
import ghidra.util.Msg;
import java.util.ArrayList;

public abstract class RepeatedDynamicDataType
extends DynamicDataType {
    protected String description;
    protected DataType header;
    protected DataType baseStruct;
    protected long terminatorValue;
    protected int terminatorSize;

    public RepeatedDynamicDataType(String name, String description, DataType header, DataType baseStruct, long terminatorValue, int terminatorSize, DataTypeManager dtm) {
        super(name, dtm);
        this.description = description;
        this.header = header;
        this.baseStruct = baseStruct;
        this.terminatorValue = terminatorValue;
        this.terminatorSize = terminatorSize;
    }

    @Override
    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        ReadOnlyDataTypeComponent comp;
        Memory memory = buf.getMemory();
        ArrayList<ReadOnlyDataTypeComponent> compList = new ArrayList<ReadOnlyDataTypeComponent>();
        int countSize = 0;
        int ordinal = 0;
        if (this.header != null) {
            comp = new ReadOnlyDataTypeComponent(this.header, this, this.header.getLength(), ordinal, 0, this.header.getName() + "_" + String.valueOf(buf.getAddress()), "");
            compList.add(ordinal++, comp);
            countSize = comp.getLength();
        }
        int offset = countSize;
        MemoryBufferImpl newBuf = new MemoryBufferImpl(memory, buf.getAddress());
        try {
            newBuf.advance(countSize);
            while (this.moreComponents(memory, newBuf.getAddress())) {
                DataTypeInstance dti = DataTypeInstance.getDataTypeInstance(this.baseStruct, newBuf, false);
                if (dti == null) {
                    Msg.error((Object)this, (Object)("ERROR: problem with data at " + String.valueOf(newBuf.getAddress())));
                    return null;
                }
                int len = dti.getLength();
                comp = new ReadOnlyDataTypeComponent(dti.getDataType(), this, len, ordinal, offset, this.baseStruct.getName() + "_" + String.valueOf(newBuf.getAddress()), "");
                compList.add(ordinal, comp);
                offset += len;
                newBuf.advance(len);
                ++ordinal;
            }
        }
        catch (AddressOverflowException e) {
            Msg.error((Object)this, (Object)("ERROR: problem with data at " + String.valueOf(newBuf.getAddress())));
            return null;
        }
        DataTypeComponent[] comps = new DataTypeComponent[compList.size()];
        for (int i = 0; i < compList.size(); ++i) {
            comps[i] = (DataTypeComponent)compList.get(i);
        }
        return comps;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    private boolean moreComponents(Memory memory, Address loc) {
        long test = 0L;
        try {
            switch (this.terminatorSize) {
                case 1: {
                    test = Conv.byteToLong((byte)memory.getByte(loc));
                    break;
                }
                case 2: {
                    test = Conv.shortToLong((short)memory.getShort(loc));
                    break;
                }
                case 4: {
                    test = Conv.intToLong((int)memory.getInt(loc));
                    break;
                }
                case 8: {
                    test = memory.getLong(loc);
                    break;
                }
                default: {
                    for (int i = 0; i < this.terminatorSize; ++i) {
                        test = memory.getByte(loc);
                        if (test == this.terminatorValue) continue;
                        return true;
                    }
                    return false;
                }
            }
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)((Object)e));
        }
        return test != this.terminatorValue;
    }
}

