/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import ghidra.framework.PluggableServiceRegistryException;
import java.util.HashMap;
import java.util.Map;

public class PluggableServiceRegistry {
    private static Map<Class<?>, Object> MAP = new HashMap();

    public static <T> void registerPluggableService(Class<? extends T> pluggableServiceClass, T replacementInstance) throws PluggableServiceRegistryException {
        Class<?> replacementClass;
        if (!MAP.containsKey(pluggableServiceClass)) {
            MAP.put(pluggableServiceClass, replacementInstance);
            return;
        }
        Object registeredInstance = MAP.get(pluggableServiceClass);
        Class<?> alreadyRegisteredClass = registeredInstance.getClass();
        if (alreadyRegisteredClass.isAssignableFrom(replacementClass = replacementInstance.getClass())) {
            MAP.put(pluggableServiceClass, replacementInstance);
            return;
        }
        if (replacementClass.isAssignableFrom(alreadyRegisteredClass)) {
            return;
        }
        throw new PluggableServiceRegistryException(pluggableServiceClass, alreadyRegisteredClass, replacementClass);
    }

    public static <T> T getPluggableService(Class<? extends T> pluggableServiceClass) {
        return (T)MAP.get(pluggableServiceClass);
    }
}

