/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.decompiler;

/**
 * The highlighter interface passed to clients of the {@link DecompilerHighlightService}.
 *
 * <p>The expected workflow for this class is:  create the highlighter, clients
 * will request highlights via {@link #applyHighlights()}, clients will clear highlights via
 * {@link #clearHighlights()} and the highlighter may be removed via {@link #dispose()}.
 */
public interface DecompilerHighlighter {

	/**
	 * Call this method when you wish to apply your highlights.
	 */
	public void applyHighlights();

	/**
	 * Call this method when you wish to remove your highlights.
	 */
	public void clearHighlights();

	/**
	 * Call this method to remove your highlighter from the Decompiler.
	 */
	public void dispose();

	/**
	 * Returns the ID used by this highlighter.  This will either be generated by this API or
	 * supplied by the client.
	 * @return the ID
	 * @see DecompilerHighlightService#createHighlighter(String, CTokenHighlightMatcher)
	 */
	public String getId();
}
