---
title: History Overview
---
# Notable Recent Historical Events

1. **Sirichana reaches Murtis** (UST -143)
1. **Imperial Proclamation** (UST 0): Creation of the Empire
<% if faction.get("Proteron"):known() then %>
1. **Project Proteron** (UST 13:4355)
<% end %>
1. **Project Za'lek** (UST 42:6284)
<% if faction.get("Proteron"):known() then %>
1. **Creation of [House Proteron](lore/factions/proteron)** (UST 47)
<% end %>
1. **Creation of [House Za'lek](lore/factions/zalek)** (UST 72)
<% if faction.get("Thurion"):known() then %>
1. **[Project Thurion](lore/factions/thurion)** (UST 84:8324)
<% end %>
1. **Creation of [House Sirius](lore/factions/sirius)** (UST 97)
<% if faction.get("Collective"):known() then %>
1. **Project Collective** (UST 266:7626)
<% end %>
1. **Dvaered Revolts** (UST 307)
1. **Sorom Plague** (UST 328)
1. **Creation of [House Dvaered](lore/factions/dvaered)** (UST 331)
1. **Quarantine of Sorom** (UST 333)
1. **Formalization of [Soromid](lore/factions/soromid)** (UST 387)
<% if faction.get("Thurion"):known() then %>
1. **Thurion Revival** (UST 437)
<% end %>
<% if false then %>
1. **Hypergate Project** (UST 572)
<% end %>
<% if faction.get("Collective"):known() then %>
1. **Collective Goes Rogue** (UST 590)
<% end %>
1. **[The Incident](lore/history/incident)** (UST 593:3726.4663)

## The First Growth (roughly UST -1000 to UST -400)

The First Growth is seen as the true beginning of mankind's space age.
Though space travel existed before this time, it was limited to Earth's immediate environs, and bore little in the way of fruit.

When Earth scientists devised an effective means of crossing the interstellar void, using advanced, long-life sublight engines and a non-lethal method of cryogenic suspension, mankind began to dream big dreams.
Over the course of fifty years, massive starships were constructed that could carry human life to other planets and start new colonies there.
In total, twenty such ships were constructed, and eventually eleven of those managed to seed new human colonies in outer space.
It was an achievement never before witnessed in human history.

For a long time, the eleven colonies were on their own, as communication with each other and with Earth was a matter of years.
That would change, abruptly and dramatically.

## The Second Growth (roughly UST -400 to UST -100)

While the eleven colonies painstakingly tried to develop themselves into economies resembling Earth's, Earth itself continued to progress scientifically.
Though no new colonization efforts were made after the first twenty, as this was deemed too costly, different avenues of deep space exploration were being invented, tested and discarded on a regular basis.
Then, there was the breakthrough that lies at the foundation of space travel as we know it today: the discovery of hyperspace.

Hyperspace was found to allow travel between one point to another point without having to cross the space in between.
More importantly, the time taken to complete the journey in hyperspace was a fraction of the time it would normally take.
Soon, the existence of naturally occurring hyperspace connections between systems were discovered, which sealed the deal.
The stars were now within reach.
Indeed, the entire galaxy lay open for humanity to claim.

Hyperspace-capable starships were built, and sent out to explore.
They brought back reports of many potentially habitable worlds ready for the taking.
Soon after, a new colonization program was devised, and mankind truly started spreading its wings.
The Second Growth had begun.

As humanity settled farther and farther away from Earth, a decision was made to streamline the interplanetary relations by creating a large, democratic body to unite all worlds in a single political system.
This body was known as the Federation.

## The Federation (roughly UST -300 to UST -100)

Though each colony was granted the right of self-government, the Federation was tasked with managing interplanetary affairs.
Interstellar trade and security came to fall under the Federation's jurisdiction, and each standard cycle the planetary governments would convene in an interstellar summit, discussing the current state of affairs.
On paper, it looked good.

Over the course of many years, many new planets were settled, converted or exploited.
Interstellar trade became immensely lucrative, new fortunes were made.
But humanity, even in times of prosperity, tends to strife and conflict.
Not only did piracy manifest itself in the vast stretches of space, there appeared a growing discontent between the various colonies.
The Federation proved increasingly less capable of dealing with the security concerns and the discontent between the various worlds.
Gradually, the colonies began to lose faith in Federal leadership, and began to band together in local alliances that guarded their own interests.
These interests began to conflict with each other.
Tensions grew higher and higher, until eventually the situation degenerated into armed conflict.

## The Faction Wars (roughly UST -100 to UST 0)

The Faction Wars are the first interstellar war on record, and they also count as the largest human war ever waged.
Truly every human world was at war, and precious few were safe from attack.
Even Earth itself was bombed on two occasions.
Any colony that couldn't fight off its attackers was conquered and claimed.
Colonies changed ownership time and again, factions were eliminated, new factions formed as colonies rose against their oppressors.
Untold human lives were lost.
Needless to say, no new worlds were settled during this time, as attempting to do so would mean certain death.

After many, many cycles of constant fighting, the Faction Wars stabilized into a three-way conflict between factions calling themselves the Earth Federation, the Free Colonies, and the Rimward Block.
These factions were similar in strength, and for a time there was a balance of power.
Many believed that eventually hostilities would cease, and new political and trade relations would establish themselves.
But this didn't happen.

A general serving in the Earth Federation called Duram Daedris devised a cunning strategy.
Through deceit and trickery he managed to entice both the Free Colonies and the Rimward Block to launch an all-out offensive on the same system, at the same time.
The two fleets clashed, as was Daedris' plan, decimating each other.
This gave the Earth Federation the opening it needed to take the initiative and gain the upper hand.
The other two factions couldn't recover in time. The Earth Federation had won the Faction Wars.

## Rise of the Empire (roughly UST 0 to UST 300)

After his military victory, Daedris took political control in a military coup.
The Earth Federation was re-branded the Empire, and Daedris proclaimed himself Emperor over all human space, ruling over the Galaxy from his throne on Earth.
For cycles, order was kept with an iron fist, while at the same time trade was brought back to pre-war capacity.
Eventually, the colonies accepted that to live under Imperial rule was better than to die in autonomy.

The vertical chain of command installed by the Empire proved to work better than the democratic ideals of the old Federation.
A period of extended peace and prosperity began, which would later be referred to as the Imperial Golden Age.
The wounds left by the Faction Wars slowly healed over time, and eventually humanity began to expand anew in an ambitious Third Growth.

## Decline of the Empire (roughly UST 300 to UST 593)

Though the Empire was the greatest and most stable political system in all of human history, it did not prove strong enough to stand the test of time.
Little by little, as the Empire grew and its Emperors made ill-advised decisions, dissent crept into the minds of the Imperial citizens.
Piracy once again started rearing its ugly head, and some worlds started growing restless.
Historians are still debating what ended the Imperial Golden Age, but all agree that by the time the working class rose in what became known as the Dvaered Revolts, it was well and truly over.

The Empire found itself forced to cede territory and political control to the newly formed House Dvaered, to the mysterious figure known as Sirichana and to the ever-demanding Za'lek.
Though all human worlds remained loyal to the Empire by treaty, the sphere of influence of the line of Emperors had dwindled considerably.
What really broke the Empire's power, though, was a sudden, cataclysmic event known only as the Incident.

## The Incident (UST 593:3726.4663)

Little is known about the Incident, other than what can be observed.
An eruption of some kind occurred which decimated all planets in Sol and several systems around it.
In its wake it left a dense, volatile nebula that has proven almost impregnable to most means of observation.
Nobody ever came out of that nebula to tell what happened.

The Empire was shaken to the core.
With Earth lost, along with most of the Imperial bureaucracy, the Imperial leadership floundered, taking almost a cycle to re-establish itself in Gamma Polaris.
Such a show of weakness caused whatever loyalty the Empire had left from the Great Houses to evaporate, to the point that it's now a public secret that the Empire no longer holds any sway over anybody else.

This was several cycles ago.
The galaxy is now an unstable place, full of danger and opportunity. Nobody knows what the future holds, but perhaps one person can make all the difference.
