/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AdminPropertiesPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(AdminPropertiesPanel.class.getName());
    MySQLOptions options = MySQLOptions.getDefault();
    DialogDescriptor descriptor;
    private Color nbErrorForeground = UIManager.getColor("nb.errorForeground");
    private static String recentDirectory = null;
    private JButton btnAdminBrowse;
    private JButton btnStartBrowse;
    private JButton btnStopBrowse;
    private JLabel labelAdmin;
    private JLabel labelAdminArgs;
    private JLabel labelStart;
    private JLabel labelStartArgs;
    private JLabel labelStartArgs1;
    private JLabel labelStop;
    private JLabel messageLabel;
    private JTextField txtAdmin;
    private JTextField txtAdminArgs;
    private JTextField txtStart;
    private JTextField txtStartArgs;
    private JTextField txtStop;
    private JTextField txtStopArgs;

    private void validatePanel() {
        this.descriptor.setValid(false);
        this.messageLabel.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.MSG_ValidatingCommandPaths"));
        this.revalidate();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AdminPropertiesPanel.this.descriptor == null) {
                        return;
                    }
                    String error = null;
                    String admin = AdminPropertiesPanel.this.getAdminPath();
                    String start = AdminPropertiesPanel.this.getStartPath();
                    String stop = AdminPropertiesPanel.this.getStopPath();
                    if (!Utils.isValidExecutable(start, true)) {
                        error = NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.MSG_InvalidStartPath");
                    }
                    if (!Utils.isValidExecutable(stop, true)) {
                        error = NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.MSG_InvalidStopPath");
                    }
                    if (!Utils.isValidURL(admin, true) && !Utils.isValidExecutable(admin, true)) {
                        error = NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.MSG_InvalidAdminPath");
                    }
                    final String finalError = error;
                    Mutex.EVENT.postReadRequest(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (finalError != null) {
                                this.this$1.AdminPropertiesPanel.this.messageLabel.setForeground(this.this$1.AdminPropertiesPanel.this.nbErrorForeground);
                                this.this$1.AdminPropertiesPanel.this.messageLabel.setText(finalError);
                                this.this$1.AdminPropertiesPanel.this.descriptor.setValid(false);
                            } else {
                                this.this$1.AdminPropertiesPanel.this.messageLabel.setText(" ");
                                this.this$1.AdminPropertiesPanel.this.descriptor.setValid(true);
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    AdminPropertiesPanel.this.messageLabel.setForeground(AdminPropertiesPanel.this.nbErrorForeground);
                    AdminPropertiesPanel.this.messageLabel.setText(" ");
                    AdminPropertiesPanel.this.descriptor.setValid(true);
                    throw new RuntimeException(t);
                }
            }
        });
    }

    public AdminPropertiesPanel(DatabaseServer server) {
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.initComponents();
        this.setBackground(this.getBackground());
        this.messageLabel.setBackground(this.getBackground());
        this.messageLabel.setText(" ");
        this.txtAdmin.setText(server.getAdminPath());
        this.txtAdminArgs.setText(server.getAdminArgs());
        this.txtStart.setText(server.getStartPath());
        this.txtStartArgs.setText(server.getStartArgs());
        this.txtStop.setText(server.getStopPath());
        this.txtStopArgs.setText(server.getStopArgs());
    }

    public String getAdminPath() {
        return this.txtAdmin.getText().trim();
    }

    public String getAdminArgs() {
        return this.txtAdminArgs.getText().trim();
    }

    public String getStartPath() {
        return this.txtStart.getText().trim();
    }

    public String getStartArgs() {
        return this.txtStartArgs.getText().trim();
    }

    public String getStopPath() {
        return this.txtStop.getText().trim();
    }

    public String getStopArgs() {
        return this.txtStopArgs.getText().trim();
    }

    public void setDialogDescriptor(DialogDescriptor desc) {
        this.descriptor = desc;
    }

    private void chooseFile(JTextField txtField) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(null);
        chooser.setFileSelectionMode(0);
        String path = txtField.getText().trim();
        if (path != null && path.length() > 0) {
            chooser.setSelectedFile(new File(path));
        } else if (recentDirectory != null) {
            chooser.setCurrentDirectory(new File(recentDirectory));
        }
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        recentDirectory = selectedFile.getParentFile().getAbsolutePath();
        txtField.setText(selectedFile.getAbsolutePath());
    }

    private void initComponents() {
        this.txtAdmin = new JTextField();
        this.btnAdminBrowse = new JButton();
        this.txtAdminArgs = new JTextField();
        this.messageLabel = new JLabel();
        this.labelAdmin = new JLabel();
        this.labelAdminArgs = new JLabel();
        this.labelStart = new JLabel();
        this.txtStart = new JTextField();
        this.btnStartBrowse = new JButton();
        this.txtStartArgs = new JTextField();
        this.labelStartArgs = new JLabel();
        this.labelStop = new JLabel();
        this.txtStop = new JTextField();
        this.btnStopBrowse = new JButton();
        this.txtStopArgs = new JTextField();
        this.labelStartArgs1 = new JLabel();
        this.txtAdmin.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdmin.text"));
        this.txtAdmin.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdmin.AccessibleContext.accessibleDescription"));
        this.txtAdmin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminPropertiesPanel.this.txtAdminActionPerformed(evt);
            }
        });
        this.txtAdmin.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AdminPropertiesPanel.this.txtAdminFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdminBrowse, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnAdminBrowse.text"));
        this.btnAdminBrowse.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnAdminBrowse.AccessibleContext.accessibleDescription"));
        this.btnAdminBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminPropertiesPanel.this.btnAdminBrowseActionPerformed(evt);
            }
        });
        this.txtAdminArgs.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdminArgs.text"));
        this.txtAdminArgs.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdminArgs.AccessibleContext.accessibleDescription"));
        this.messageLabel.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.messageLabel.text"));
        this.labelAdmin.setHorizontalAlignment(4);
        this.labelAdmin.setLabelFor(this.txtAdmin);
        Mnemonics.setLocalizedText((JLabel)this.labelAdmin, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelAdmin.text"));
        this.labelAdminArgs.setHorizontalAlignment(4);
        this.labelAdminArgs.setLabelFor(this.txtAdminArgs);
        Mnemonics.setLocalizedText((JLabel)this.labelAdminArgs, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelAdminArgs.text"));
        this.labelStart.setHorizontalAlignment(4);
        this.labelStart.setLabelFor(this.txtStart);
        Mnemonics.setLocalizedText((JLabel)this.labelStart, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelStart.text"));
        this.txtStart.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStart.text"));
        this.txtStart.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStart.AccessibleContext.accessibleDescription"));
        this.txtStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminPropertiesPanel.this.txtStartActionPerformed(evt);
            }
        });
        this.txtStart.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AdminPropertiesPanel.this.txtStartFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnStartBrowse, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnStartBrowse.text"));
        this.btnStartBrowse.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnStartBrowse.AccessibleContext.accessibleDescription"));
        this.btnStartBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminPropertiesPanel.this.btnStartBrowseActionPerformed(evt);
            }
        });
        this.txtStartArgs.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStartArgs.text"));
        this.txtStartArgs.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStartArgs.AccessibleContext.accessibleDescription"));
        this.labelStartArgs.setHorizontalAlignment(4);
        this.labelStartArgs.setLabelFor(this.txtStartArgs);
        Mnemonics.setLocalizedText((JLabel)this.labelStartArgs, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelStartArgs.text"));
        this.labelStop.setHorizontalAlignment(4);
        this.labelStop.setLabelFor(this.txtStop);
        Mnemonics.setLocalizedText((JLabel)this.labelStop, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelStop.text"));
        this.txtStop.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStop.text"));
        this.txtStop.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStop.AccessibleContext.accessibleDescription"));
        this.txtStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminPropertiesPanel.this.txtStopActionPerformed(evt);
            }
        });
        this.txtStop.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AdminPropertiesPanel.this.txtStopFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnStopBrowse, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnStopBrowse.text"));
        this.btnStopBrowse.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnStopBrowse.AccessibleContext.accessibleDescription"));
        this.btnStopBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminPropertiesPanel.this.btnStopBrowseActionPerformed(evt);
            }
        });
        this.txtStopArgs.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStopArgs.text"));
        this.txtStopArgs.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStopArgs.AccessibleContext.accessibleDescription"));
        this.labelStartArgs1.setHorizontalAlignment(4);
        this.labelStartArgs1.setLabelFor(this.txtStopArgs);
        Mnemonics.setLocalizedText((JLabel)this.labelStartArgs1, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelStopArgs.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, -1, 734, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.labelAdminArgs, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.labelStartArgs, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.labelStart, GroupLayout.Alignment.LEADING, -1, 177, Short.MAX_VALUE).addComponent(this.labelAdmin, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.labelStartArgs1, -1, -1, Short.MAX_VALUE).addComponent(this.labelStop, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.txtStopArgs, -1, 469, Short.MAX_VALUE).addComponent(this.txtStop, -1, 469, Short.MAX_VALUE).addComponent(this.txtAdmin, -1, 469, Short.MAX_VALUE).addComponent(this.txtAdminArgs, -1, 469, Short.MAX_VALUE).addComponent(this.txtStart, GroupLayout.Alignment.LEADING, -1, 469, Short.MAX_VALUE).addComponent(this.txtStartArgs, GroupLayout.Alignment.LEADING, -1, 469, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnStopBrowse).addComponent(this.btnStartBrowse).addComponent(this.btnAdminBrowse)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAdminBrowse).addComponent(this.labelAdmin).addComponent(this.txtAdmin, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelAdminArgs, -2, 16, -2).addComponent(this.txtAdminArgs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelStart).addComponent(this.btnStartBrowse).addComponent(this.txtStart, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelStartArgs, -2, 16, -2).addComponent(this.txtStartArgs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnStopBrowse).addComponent(this.labelStop).addComponent(this.txtStop, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelStartArgs1, -2, 16, -2).addComponent(this.txtStopArgs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.messageLabel).addGap(108, 108, 108)));
        this.txtAdmin.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdmin.AccessibleContext.accessibleDescription"));
        this.btnAdminBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnAdminBrowse.AccessibleContext.accessibleDescription"));
        this.txtAdminArgs.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdminArgs.AccessibleContext.accessibleName"));
        this.txtAdminArgs.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdminArgs.AccessibleContext.accessibleDescription"));
    }

    private void btnAdminBrowseActionPerformed(ActionEvent evt) {
        this.chooseFile(this.txtAdmin);
    }

    private void txtAdminFocusLost(FocusEvent evt) {
        this.validatePanel();
    }

    private void txtAdminActionPerformed(ActionEvent evt) {
    }

    private void txtStartActionPerformed(ActionEvent evt) {
    }

    private void txtStartFocusLost(FocusEvent evt) {
        this.validatePanel();
    }

    private void btnStartBrowseActionPerformed(ActionEvent evt) {
        this.chooseFile(this.txtStart);
    }

    private void txtStopActionPerformed(ActionEvent evt) {
    }

    private void txtStopFocusLost(FocusEvent evt) {
        this.validatePanel();
    }

    private void btnStopBrowseActionPerformed(ActionEvent evt) {
        this.chooseFile(this.txtStop);
    }
}

