/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.node.ColumnNameProvider;
import org.netbeans.modules.db.explorer.node.ColumnNode;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.netbeans.modules.db.explorer.node.ViewNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public abstract class QueryAction
extends BaseAction {
    private static final Logger LOG = Logger.getLogger(QueryAction.class.getName());

    protected boolean enable(Node[] activatedNodes) {
        boolean result;
        if (activatedNodes.length == 1) {
            Lookup lookup = activatedNodes[0].getLookup();
            result = lookup.lookup(TableNode.class) != null || lookup.lookup(ViewNode.class) != null || lookup.lookup(ColumnNode.class) != null;
        } else {
            result = true;
            for (Node node : activatedNodes) {
                if (node.getLookup().lookup(ColumnNode.class) != null) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean appendQualifiedName(StringBuilder tableNameBuilder, SQLIdentifiers.Quoter quoter, String name, String authenticatedName, boolean tableIsQualified, String seperator) {
        if (name != null && (tableIsQualified || !name.equals(authenticatedName))) {
            tableNameBuilder.append(quoter.quoteIfNeeded(name));
            if (seperator == null || seperator.trim().isEmpty()) {
                tableNameBuilder.append(".");
            } else {
                tableNameBuilder.append(seperator);
            }
            return true;
        }
        return tableIsQualified;
    }

    private String getQualifiedTableName(String simpleTableName, DatabaseConnection connection, SchemaNameProvider provider, SQLIdentifiers.Quoter quoter, DatabaseMetaData dmd) throws SQLException {
        String schemaName = provider.getSchemaName();
        String catName = provider.getCatalogName();
        StringBuilder fullTableName = new StringBuilder();
        boolean tableIsQualified = false;
        tableIsQualified = this.appendQualifiedName(fullTableName, quoter, catName, connection.getJDBCConnection().getCatalog(), tableIsQualified, dmd.getCatalogSeparator());
        this.appendQualifiedName(fullTableName, quoter, schemaName, null, tableIsQualified, null);
        fullTableName.append(quoter.quoteIfNeeded(simpleTableName));
        return fullTableName.toString();
    }

    protected String getDefaultQuery(Node[] activatedNodes) {
        DatabaseConnection connection = (DatabaseConnection)activatedNodes[0].getLookup().lookup(DatabaseConnection.class);
        try {
            String columnList;
            String tableName;
            DatabaseMetaData dmd = connection.getJDBCConnection().getMetaData();
            SQLIdentifiers.Quoter quoter = SQLIdentifiers.createQuoter(dmd);
            SchemaNameProvider provider = (SchemaNameProvider)activatedNodes[0].getLookup().lookup(SchemaNameProvider.class);
            boolean isColumn = activatedNodes[0].getLookup().lookup(ColumnNode.class) != null;
            int limit = NbPreferences.root().node("/org/netbeans/modules/db/dataview").getInt("storedPageSize", 100);
            if (limit <= 0) {
                limit = 100;
            }
            if (!isColumn) {
                tableName = this.getQualifiedTableName(activatedNodes[0].getName(), connection, provider, quoter, dmd);
                columnList = "*";
            } else {
                String parentName = ((ColumnNameProvider)activatedNodes[0].getLookup().lookup(ColumnNameProvider.class)).getParentName();
                tableName = this.getQualifiedTableName(parentName, connection, provider, quoter, dmd);
                StringBuilder cols = new StringBuilder();
                for (Node node : activatedNodes) {
                    if (cols.length() > 0) {
                        cols.append(", ");
                    }
                    cols.append(quoter.quoteIfNeeded(node.getName()));
                }
                columnList = cols.toString();
            }
            String dbname = dmd.getDatabaseProductName();
            if (dbname == null) {
                dbname = "";
            }
            if (dbname.startsWith("DB2/") || dbname.equals("Apache Derby")) {
                return "SELECT " + columnList + " FROM " + tableName + " FETCH FIRST " + limit + " ROWS ONLY";
            }
            if (dbname.contains("MySQL") || dbname.contains("MariaDB") || dbname.equals("H2") || dbname.startsWith("HSQL ") || dbname.contains("Sybase") || dbname.equals("Adaptive Server Anywhere") || dbname.equals("PostgreSQL") || dbname.equals("HypersonicSQL")) {
                return "SELECT " + columnList + " FROM " + tableName + " LIMIT " + limit;
            }
            if (dbname.equals("Microsoft SQL Server") || dbname.equals("ACCESS")) {
                return "SELECT TOP " + limit + " " + columnList + " FROM " + tableName;
            }
            if (dbname.equals("INFORMIX-OnLine") || dbname.equals("Informix Dynamic Server") || dbname.contains("Informix") || dbname.contains("Firebird")) {
                return "SELECT FIRST " + limit + " " + columnList + " FROM " + tableName;
            }
            if (dbname.contains("Oracle")) {
                return "SELECT " + columnList + " FROM " + tableName + " WHERE ROWNUM <= " + limit;
            }
            LOG.log(Level.INFO, "Failed to generate limited SELECT for: DB Connection ''{0}'', DatabaseProductName ''{1}'', Table ''{2}''", new Object[]{connection.getDisplayName(), dbname, tableName});
            return "SELECT " + columnList + " FROM " + tableName;
        }
        catch (SQLException ex) {
            String message = NbBundle.getMessage(QueryAction.class, (String)"ShowDataError", (Object)ex.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            return "";
        }
    }
}

