/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.javafx2.editor.completion.beans.FxProperty;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionUtils;
import org.netbeans.modules.javafx2.editor.completion.impl.ValueItem;
import org.netbeans.spi.editor.completion.CompletionItem;

public final class EnumValueCompleter
implements Completer,
Completer.Factory {
    private CompletionContext ctx;
    private TypeElement enumType;
    private static final String ICON_ENUM_VALUE = "org/netbeans/modules/javafx2/editor/resources/property.png";

    public EnumValueCompleter() {
    }

    EnumValueCompleter(CompletionContext ctx) {
        this.ctx = ctx;
    }

    public EnumValueCompleter(CompletionContext ctx, TypeElement enumType) {
        this.ctx = ctx;
        this.enumType = enumType;
    }

    private boolean isBooleanType() {
        return this.enumType == null;
    }

    public List<CompletionItem> complete() {
        ArrayList<String> valueStrings = new ArrayList<String>();
        if (this.isBooleanType()) {
            valueStrings.add(Boolean.FALSE.toString());
            valueStrings.add(Boolean.TRUE.toString());
        } else {
            for (Element element : this.enumType.getEnclosedElements()) {
                if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
                valueStrings.add(element.getSimpleName().toString());
            }
        }
        String prefix = this.ctx.getPrefix();
        if (!prefix.isEmpty()) {
            if (prefix.charAt(0) == '\"' || prefix.charAt(0) == '\'') {
                prefix = prefix.substring(1);
            }
            Iterator iterator = valueStrings.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                if (CompletionUtils.startsWith(s, prefix)) continue;
                iterator.remove();
            }
        }
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
        for (String v : valueStrings) {
            ValueItem vi = new ValueItem(this.ctx, v, ICON_ENUM_VALUE);
            arrayList.add(vi);
        }
        return arrayList;
    }

    @Override
    public boolean hasMoreItems() {
        return false;
    }

    @Override
    public Completer createCompleter(CompletionContext ctx) {
        FxProperty p = ctx.getEnclosingProperty();
        if (p == null || p.getType() == null) {
            return null;
        }
        TypeMirror m = p.getType().resolve(ctx.getCompilationInfo());
        if (m.getKind() == TypeKind.BOOLEAN) {
            return new EnumValueCompleter(ctx);
        }
        if (m.getKind() != TypeKind.DECLARED) {
            return null;
        }
        DeclaredType t = (DeclaredType)m;
        TypeElement tel = (TypeElement)t.asElement();
        if (tel.getQualifiedName().contentEquals("java.lang.Boolean")) {
            return new EnumValueCompleter(ctx);
        }
        if (tel.getKind() == ElementKind.ENUM) {
            return new EnumValueCompleter(ctx, tel);
        }
        return null;
    }
}

