/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.mylyn.internal.bugzilla.core.Messages;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskSchema;

public enum BugzillaAttribute {
    STATUS_WHITEBOARD(Messages.BugzillaAttribute_Status_Whiteboard, "status_whiteboard", "shortText", AbstractTaskSchema.Flag.ATTRIBUTE),
    ACTUAL_TIME(Messages.BugzillaAttribute_Worked, "actual_time", "shortText", AbstractTaskSchema.Flag.READ_ONLY),
    ADD_COMMENT(Messages.BugzillaAttribute_Additional_Comments, "comment", "longText"),
    ALIAS(Messages.BugzillaAttribute_Alias, "alias", "shortText"),
    ASSIGNED_TO(Messages.BugzillaAttribute_Assigned_to, "assigned_to", "person", AbstractTaskSchema.Flag.PEOPLE, AbstractTaskSchema.Flag.READ_ONLY),
    ASSIGNED_TO_NAME(Messages.BugzillaAttribute_Assigned_to_NAME, "assigned_to_name", "person", AbstractTaskSchema.Flag.READ_ONLY),
    ATTACHID(Messages.BugzillaAttribute_ATTACH_ID, "attachid", "shortText", AbstractTaskSchema.Flag.ATTRIBUTE),
    ATTACHMENT(Messages.BugzillaAttribute_attachment, "attachment", "attachment", AbstractTaskSchema.Flag.ATTRIBUTE),
    BLOCKED(Messages.BugzillaAttribute_Blocks, "blocked", "taskDepenedency", AbstractTaskSchema.Flag.ATTRIBUTE),
    BUG(Messages.BugzillaAttribute_bug, "bug", "shortText"),
    BUG_FILE_LOC(Messages.BugzillaAttribute_URL, "bug_file_loc", "url", AbstractTaskSchema.Flag.ATTRIBUTE),
    BUG_ID(Messages.BugzillaAttribute_Bug_ID, "bug_id", "shortText"),
    BUG_SEVERITY(Messages.BugzillaAttribute_Severity, "bug_severity", "singleSelect", AbstractTaskSchema.Flag.ATTRIBUTE),
    BUG_STATUS(Messages.BugzillaAttribute_Status, "bug_status", "shortText", AbstractTaskSchema.Flag.READ_ONLY),
    BUG_WHEN(Messages.BugzillaAttribute_bug_when, "bug_when", "date", AbstractTaskSchema.Flag.READ_ONLY),
    BUGZILLA(Messages.BugzillaAttribute_bugzilla, "bugzilla", "shortText"),
    CC(Messages.BugzillaAttribute_CC, "cc", "bugzilla.editor.removecc", AbstractTaskSchema.Flag.READ_ONLY),
    REMOVECC(Messages.BugzillaAttribute_Remove_CC, "removecc", "bugzilla.editor.removecc", AbstractTaskSchema.Flag.READ_ONLY),
    CCLIST_ACCESSIBLE(Messages.BugzillaAttribute_CC_List, "cclist_accessible", "boolean"),
    CLASSIFICATION(Messages.BugzillaAttribute_Classification, "classification", "shortText"),
    CLASSIFICATION_ID(Messages.BugzillaAttribute_Classification_ID, "classification_id", "shortText"),
    COMMENTID(Messages.BugzillaAttribute_Comment_ID, "commentid", "shortText"),
    COMPONENT(Messages.BugzillaAttribute_Component, "component", "singleSelect", AbstractTaskSchema.Flag.ATTRIBUTE),
    CONFIRM_PRODUCT_CHANGE("confirm_product_change", "confirm_product_change", "boolean"),
    CREATION_TS(Messages.BugzillaAttribute_Opened, "creation_ts", "date"),
    CTYPE(Messages.BugzillaAttribute_Content_Type, "ctype", "shortText", AbstractTaskSchema.Flag.ATTRIBUTE),
    DATA(Messages.BugzillaAttribute_data, "data", "shortText", AbstractTaskSchema.Flag.ATTRIBUTE),
    DATE(Messages.BugzillaAttribute_Date, "date", "date", AbstractTaskSchema.Flag.ATTRIBUTE),
    DEADLINE(Messages.BugzillaAttribute_Due, "deadline", "date"),
    DELTA_TS(Messages.BugzillaAttribute_Modified, "delta_ts", "date"),
    DEPENDSON(Messages.BugzillaAttribute_Depends_on__Subtasks_, "dependson", "taskDepenedency", AbstractTaskSchema.Flag.ATTRIBUTE),
    DESC(Messages.BugzillaAttribute_desc, "desc", "longText", AbstractTaskSchema.Flag.READ_ONLY),
    DUP_ID(Messages.BugzillaAttribute_Duplicate_of, "dup_id", "taskDepenedency", AbstractTaskSchema.Flag.ATTRIBUTE),
    EVERCONFIRMED(Messages.BugzillaAttribute_everconfirmed, "everconfirmed", "boolean"),
    ESTIMATED_TIME(Messages.BugzillaAttribute_Estimated_Time, "estimated_time", "shortText"),
    EXPORTER_NAME(Messages.BugzillaAttribute_Exporter, "exporter", "person", AbstractTaskSchema.Flag.READ_ONLY),
    FILENAME(Messages.BugzillaAttribute_filename, "filename", "shortText", AbstractTaskSchema.Flag.ATTRIBUTE),
    FLAG(Messages.BugzillaAttribute_flag, "flag", "bugzilla.editor.flag"),
    GROUP(Messages.BugzillaAttribute_Group, "group", "boolean", AbstractTaskSchema.Flag.READ_ONLY),
    IS_OBSOLETE(Messages.BugzillaAttribute_Obsolete, "isobsolete", "boolean"),
    IS_PATCH(Messages.BugzillaAttribute_Patch, "ispatch", "boolean"),
    IS_PRIVATE(Messages.BugzillaAttribute_Private, "isprivate", "boolean"),
    KEYWORDS(Messages.BugzillaAttribute_Keywords, "keywords", "bugzilla.editor.keywords", AbstractTaskSchema.Flag.ATTRIBUTE),
    LONG_DESC(Messages.BugzillaAttribute_Description, "long_desc", "longRichText", AbstractTaskSchema.Flag.READ_ONLY),
    LONGDESCLENGTH(Messages.BugzillaAttribute_Number_of_comments, "longdesclength", "shortText"),
    NEWCC(Messages.BugzillaAttribute_Add_CC, "newcc", "person", AbstractTaskSchema.Flag.PEOPLE),
    OP_SYS(Messages.BugzillaAttribute_OS, "op_sys", "singleSelect", AbstractTaskSchema.Flag.ATTRIBUTE),
    PRIORITY(Messages.BugzillaAttribute_Priority, "priority", "singleSelect", AbstractTaskSchema.Flag.ATTRIBUTE),
    PRODUCT(Messages.BugzillaAttribute_Product, "product", "singleSelect", AbstractTaskSchema.Flag.ATTRIBUTE),
    REP_PLATFORM(Messages.BugzillaAttribute_Platform, "rep_platform", "singleSelect", AbstractTaskSchema.Flag.ATTRIBUTE),
    REPORTER(Messages.BugzillaAttribute_Reporter, "reporter", "person", AbstractTaskSchema.Flag.PEOPLE, AbstractTaskSchema.Flag.READ_ONLY),
    REPORTER_NAME(Messages.BugzillaAttribute_REPORT_NAME, "reporter_name", "person", AbstractTaskSchema.Flag.READ_ONLY),
    REPORTER_ACCESSIBLE(Messages.BugzillaAttribute_REPORT_ACCESSIBLE, "reporter_accessible", "boolean"),
    RESOLUTION(Messages.BugzillaAttribute_Resolution, "resolution", "shortText", AbstractTaskSchema.Flag.ATTRIBUTE, AbstractTaskSchema.Flag.READ_ONLY),
    REMAINING_TIME(Messages.BugzillaAttribute_Remaining, "remaining_time", "shortText"),
    REMOVE_SEE_ALSO(Messages.BugzillaAttribute_See_Also, "remove_see_also", "bugzilla.editor.seealso"),
    SEE_ALSO(Messages.BugzillaAttribute_AddSeeAlso, "see_also", "url", AbstractTaskSchema.Flag.ATTRIBUTE),
    SEE_ALSO_READ(Messages.BugzillaAttribute_See_Also, "read_see_also", "bugzilla.editor.seealso", AbstractTaskSchema.Flag.ATTRIBUTE),
    SET_DEFAULT_ASSIGNEE(Messages.BugzillaAttribute_Reassign_to_default_assignee, "set_default_assignee", "boolean"),
    SHORT_DESC(Messages.BugzillaAttribute_Summary, "short_desc", "shortRichText"),
    SIZE(Messages.BugzillaAttribute_Size, "size", "shortText", AbstractTaskSchema.Flag.ATTRIBUTE),
    TARGET_MILESTONE(Messages.BugzillaAttribute_Target_milestone, "target_milestone", "singleSelect", AbstractTaskSchema.Flag.ATTRIBUTE),
    THETEXT(Messages.BugzillaAttribute_thetext, "thetext", "shortText", AbstractTaskSchema.Flag.ATTRIBUTE, AbstractTaskSchema.Flag.READ_ONLY),
    TYPE(Messages.BugzillaAttribute_type, "type", "shortText", AbstractTaskSchema.Flag.ATTRIBUTE),
    UNKNOWN(Messages.BugzillaAttribute_UNKNOWN, "UNKNOWN", "shortText", AbstractTaskSchema.Flag.ATTRIBUTE),
    VERSION(Messages.BugzillaAttribute_Version, "version", "singleSelect", AbstractTaskSchema.Flag.ATTRIBUTE),
    INSTALL_VERSION(Messages.BugzillaAttribute_version_of_bugzilla_installed, "install_version", null),
    VOTES(Messages.BugzillaAttribute_Votes, "votes", "bugzilla.editor.votes", AbstractTaskSchema.Flag.ATTRIBUTE, AbstractTaskSchema.Flag.READ_ONLY),
    WORK_TIME(Messages.BugzillaAttribute_Add, "work_time", "shortText"),
    WHO(Messages.BugzillaAttribute_who, "who", "person", AbstractTaskSchema.Flag.ATTRIBUTE),
    WHO_NAME(Messages.BugzillaAttribute_who_name, "who_name", "shortText", AbstractTaskSchema.Flag.READ_ONLY),
    QA_CONTACT(Messages.BugzillaAttribute_QA_Contact, "qa_contact", "person", AbstractTaskSchema.Flag.PEOPLE),
    QA_CONTACT_NAME(Messages.BugzillaAttribute_QA_Contact_NAME, "qa_contact_name", "shortText", AbstractTaskSchema.Flag.READ_ONLY),
    ADDSELFCC(Messages.BugzillaAttribute_Add_self_to_CC, "addselfcc", "boolean"),
    STATUS_OPEN(Messages.BugzillaAttribute_open_status_values, "status_open", null, AbstractTaskSchema.Flag.READ_ONLY),
    NEW_COMMENT(Messages.BugzillaAttribute_new_comment, "new_comment", "longRichText"),
    TOKEN("token", "token", null, AbstractTaskSchema.Flag.READ_ONLY),
    LI(Messages.BugzillaAttribute_used_by_search_engine_li, "li", null),
    ID(Messages.BugzillaAttribute_used_by_search_engine_id, "id", null),
    SHORT_SHORT_DESC(Messages.BugzillaAttribute_used_by_search_engine_desc, "short_short_desc", null, AbstractTaskSchema.Flag.ATTRIBUTE),
    SEQ(Messages.BugzillaAttribute_used_by_search_engine_seq, "seq", null, AbstractTaskSchema.Flag.ATTRIBUTE),
    RESULT(Messages.BugzillaAttribute_used_by_search_engine_result, "result", null, AbstractTaskSchema.Flag.ATTRIBUTE),
    RDF(Messages.BugzillaAttribute_used_by_search_engine_rdf, "rdf", null, AbstractTaskSchema.Flag.ATTRIBUTE),
    INSTALLATION(Messages.BugzillaAttribute_used_by_search_engine_installation, "installation", null, AbstractTaskSchema.Flag.ATTRIBUTE),
    BUGS(Messages.BugzillaAttribute_used_by_search_engine_bugs, "bugs", null, AbstractTaskSchema.Flag.ATTRIBUTE),
    QUERY_TIMESTAMP(Messages.BugzillaAttribute_Query_Timestamp, "query_timestamp", null, AbstractTaskSchema.Flag.ATTRIBUTE),
    ATTACHER(Messages.BugzillaAttribute_Attacher, "attacher", null, AbstractTaskSchema.Flag.ATTRIBUTE);

    public static final String KIND_FLAG = "task.common.kind.flag";
    public static final String KIND_FLAG_TYPE = "task.common.kind.flag_type";
    private final String keyString;
    private final String prettyName;
    private final String type;
    private EnumSet<AbstractTaskSchema.Flag> flags;
    public static final BugzillaAttribute[] EXTENDED_ATTRIBUTES;
    public static final BugzillaAttribute[] PERSON_ATTRIBUTES;

    static {
        EXTENDED_ATTRIBUTES = new BugzillaAttribute[]{DELTA_TS, BUG_SEVERITY, PRODUCT};
        PERSON_ATTRIBUTES = new BugzillaAttribute[]{ASSIGNED_TO, REPORTER, QA_CONTACT};
    }

    private BugzillaAttribute(String prettyName, String idKey, String type) {
        this(prettyName, idKey, type, null);
    }

    private BugzillaAttribute(String prettyName, String idKey, String type, AbstractTaskSchema.Flag ... flags) {
        this.prettyName = prettyName;
        this.keyString = idKey;
        this.type = type;
        this.flags = flags == null || flags.length == 0 ? EnumSet.noneOf(AbstractTaskSchema.Flag.class) : EnumSet.copyOf(Arrays.asList(flags));
    }

    public String getKey() {
        return this.keyString;
    }

    public boolean isReadOnly() {
        return this.flags.contains(AbstractTaskSchema.Flag.READ_ONLY);
    }

    public String toString() {
        return this.prettyName;
    }

    public String getKind() {
        if (this.flags.contains(AbstractTaskSchema.Flag.ATTRIBUTE)) {
            return "task.common.kind.default";
        }
        if (this.flags.contains(AbstractTaskSchema.Flag.PEOPLE)) {
            return "task.common.kind.people";
        }
        if (this.flags.contains(AbstractTaskSchema.Flag.OPERATION)) {
            return "task.common.kind.operation";
        }
        return null;
    }

    public String getType() {
        return this.type;
    }
}

