/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.modules.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.CompletionJList;

public class CompletionJListOperator
extends JListOperator {
    public static final String INSTANT_SUBSTITUTION = "InstantSubstitution";
    private static final Logger LOG = Logger.getLogger(CompletionJListOperator.class.getName());

    public CompletionJListOperator() {
        this(CompletionJListOperator.findCompletionJList());
    }

    private CompletionJListOperator(JList list) {
        super(list);
    }

    public List getCompletionItems() throws Exception {
        return CompletionJListOperator.getCompletionItems((JList)this.getSource());
    }

    private static List<Object> getCompletionItems(JList compJList) throws Exception {
        CompletionJListOperator oper = new CompletionJListOperator(compJList);
        int size = oper.getModelSize();
        ArrayList<Object> data = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            data.add(oper.getModelElementAt(i));
        }
        return data;
    }

    private static JList findCompletionJList() {
        final String PLEASE_WAIT = Bundle.getStringTrimmed((String)"org.netbeans.modules.editor.completion.Bundle", (String)"completion-please-wait");
        Object result = CompletionJListOperator.waitFor(new Waitable(){

            public Object actionProduced(Object obj) {
                if (DocumentWatcher.isActive() && DocumentWatcher.isModified()) {
                    return CompletionJListOperator.INSTANT_SUBSTITUTION;
                }
                try {
                    CompletionImpl comp = CompletionImpl.get();
                    Field layoutField = CompletionImpl.class.getDeclaredField("layout");
                    layoutField.setAccessible(true);
                    Object layout = layoutField.get(comp);
                    Field popupField = layout.getClass().getDeclaredField("completionPopup");
                    popupField.setAccessible(true);
                    Object popup = popupField.get(layout);
                    Field csPaneField = popup.getClass().getDeclaredField("completionScrollPane");
                    csPaneField.setAccessible(true);
                    Object compSPane = csPaneField.get(popup);
                    if (compSPane == null) {
                        return null;
                    }
                    Field crField = comp.getClass().getDeclaredField("completionResult");
                    crField.setAccessible(true);
                    Object completionResult = crField.get(comp);
                    if (completionResult != null) {
                        Method grsMethod = completionResult.getClass().getDeclaredMethod("getResultSets", new Class[0]);
                        grsMethod.setAccessible(true);
                        Object resultSets = grsMethod.invoke(completionResult, new Object[0]);
                        Method iarfMethod = comp.getClass().getDeclaredMethod("isAllResultsFinished", List.class);
                        iarfMethod.setAccessible(true);
                        Boolean allResultsFinished = (Boolean)iarfMethod.invoke((Object)comp, resultSets);
                        if (!allResultsFinished.booleanValue()) {
                            LOG.fine(System.currentTimeMillis() + ": all CC Results not finished yet.");
                            return null;
                        }
                    }
                    Field viewField = compSPane.getClass().getDeclaredField("view");
                    viewField.setAccessible(true);
                    CompletionJList compJList = (CompletionJList)viewField.get(compSPane);
                    List list = CompletionJListOperator.getCompletionItems((JList)compJList);
                    if (list.size() > 0 && !list.contains(PLEASE_WAIT)) {
                        LOG.fine(list.toString());
                        return compJList;
                    }
                    return null;
                }
                catch (Exception ex) {
                    throw new JemmyException("Exception when waiting for completion items.", (Throwable)ex);
                }
            }

            public String getDescription() {
                return "Wait for completion items data";
            }
        });
        if (result.equals(INSTANT_SUBSTITUTION)) {
            return null;
        }
        return (CompletionJList)result;
    }

    private static Object waitFor(Waitable action) {
        Waiter waiter = new Waiter(action);
        Timeouts waiterTimeouts = waiter.getTimeouts();
        waiterTimeouts.setTimeout("Waiter.TimeDelta", 500L);
        waiterTimeouts.setTimeout("Waiter.AfterWaitingTime", 500L);
        waiter.setTimeouts(waiterTimeouts);
        try {
            return waiter.waitAction(null);
        }
        catch (InterruptedException ex) {
            throw new JemmyException(action.getDescription() + " has been interrupted.", (Throwable)ex);
        }
    }

    public static CompletionJListOperator showCompletion() {
        CompletionJListOperator operator = null;
        DocumentWatcher.start();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Completion.get().showCompletion();
            }
        };
        CompletionJListOperator.runInAWT(run);
        JList list = CompletionJListOperator.findCompletionJList();
        if (list != null) {
            operator = new CompletionJListOperator(list);
        }
        DocumentWatcher.stop();
        return operator;
    }

    public static void showDocumentation() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Completion.get().showDocumentation();
            }
        };
        CompletionJListOperator.runInAWT(run);
    }

    public static void showToolTipPopup() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Completion.get().showToolTip();
            }
        };
        CompletionJListOperator.runInAWT(run);
    }

    public static void hideAll() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Completion.get().hideAll();
            }
        };
        CompletionJListOperator.runInAWT(run);
    }

    public static void hideCompletion() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Completion.get().hideCompletion();
            }
        };
        CompletionJListOperator.runInAWT(run);
    }

    public static void hideDocumentation() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Completion.get().hideDocumentation();
            }
        };
        CompletionJListOperator.runInAWT(run);
    }

    public static void hideToolTipPopup() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Completion.get().hideToolTip();
            }
        };
        CompletionJListOperator.runInAWT(run);
    }

    private static void runInAWT(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (Exception exc) {
                throw new JemmyException("INVOKATION FAILED", (Throwable)exc);
            }
        }
    }

    private int getModelSize() {
        return this.runMapping(new Operator.MapIntegerAction("getModel().getSize()"){

            public int map() throws Exception {
                return CompletionJListOperator.this.getModel().getSize();
            }
        });
    }

    private Object getModelElementAt(final int index) {
        return this.runMapping(new Operator.MapAction(this, "getModel().getElementAt()"){
            final /* synthetic */ CompletionJListOperator this$0;
            {
                this.this$0 = this$0;
                super((Operator)this$0, description);
            }

            public Object map() throws Exception {
                return this.this$0.getModel().getElementAt(index);
            }
        });
    }

    public int findItemIndex(final JListOperator.ListItemChooser chooser, final int index) {
        return this.runMapping(new Operator.MapIntegerAction(this, "findItemIndex"){
            final /* synthetic */ CompletionJListOperator this$0;
            {
                this.this$0 = this$0;
                super((Operator)this$0, description);
            }

            public int map() throws Exception {
                return CompletionJListOperator.super.findItemIndex(chooser, index);
            }
        });
    }

    public Object clickOnItem(final String item) {
        return this.runMapping(new Operator.MapAction(this, "clickOnItem( String )"){
            final /* synthetic */ CompletionJListOperator this$0;
            {
                this.this$0 = this$0;
                super((Operator)this$0, description);
            }

            public Object map() throws Exception {
                return CompletionJListOperator.super.clickOnItem(item);
            }
        });
    }

    public Object clickOnItem(String item, Operator.StringComparator comp) {
        return this.clickOnItem(item, comp, 1);
    }

    public Object clickOnItem(final String item, final Operator.StringComparator comp, final int clickCount) {
        return this.runMapping(new Operator.MapAction(this, "clickOnItem( String, Comparator )"){
            final /* synthetic */ CompletionJListOperator this$0;
            {
                this.this$0 = this$0;
                super((Operator)this$0, description);
            }

            public Object map() throws Exception {
                final int itemIndex = CompletionJListOperator.super.findItemIndex(item, comp, 0);
                if (itemIndex < 0 || itemIndex >= this.this$0.getModel().getSize()) {
                    throw new JListOperator.NoSuchItemException((JListOperator)this.this$0, itemIndex);
                }
                return this.this$0.getQueueTool().invokeSmoothly(new QueueTool.QueueAction(this, "Path selecting"){
                    final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = this$1;
                        super(description);
                    }

                    public Object launch() {
                        Rectangle rect;
                        if (((JList)this.this$1.this$0.getSource()).getAutoscrolls()) {
                            ((JList)this.this$1.this$0.getSource()).ensureIndexIsVisible(itemIndex);
                        }
                        if ((rect = this.this$1.this$0.getCellBounds(itemIndex, itemIndex)) == null) {
                            return null;
                        }
                        Point point = new Point((int)(rect.getX() + rect.getWidth() / 2.0), (int)(rect.getY() + rect.getHeight() / 2.0));
                        Object result = this.this$1.this$0.getModel().getElementAt(itemIndex);
                        this.this$1.this$0.clickMouse(point.x, point.y, clickCount);
                        return result;
                    }
                });
            }
        });
    }

    static class DocumentWatcher {
        private static BaseDocument doc;
        private static boolean modified;
        private static boolean active;
        static DocumentListener listener;

        DocumentWatcher() {
        }

        public static void start() {
            JTextComponent jtc = EditorRegistry.lastFocusedComponent();
            BaseDocument baseDocument = doc = jtc != null ? Utilities.getDocument((JTextComponent)jtc) : null;
            if (doc != null) {
                doc.addDocumentListener(listener);
            }
            modified = false;
            active = true;
        }

        public static void stop() {
            if (doc != null) {
                doc.removeDocumentListener(listener);
                doc = null;
            }
            active = false;
        }

        public static boolean isModified() {
            if (!active) {
                throw new IllegalStateException("start() must be called before this.");
            }
            return modified;
        }

        public static boolean isActive() {
            return active;
        }

        private static void setModified(boolean b) {
            modified = b;
            if (doc != null) {
                doc.removeDocumentListener(listener);
                doc = null;
            }
        }

        static {
            modified = false;
            active = false;
            listener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    DocumentWatcher.setModified(true);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                }
            };
        }
    }
}

