/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.model.GenericResourceBean;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifact;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifacts;
import org.netbeans.modules.websvc.saas.model.jaxb.Authenticator;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;
import org.netbeans.modules.websvc.saas.model.jaxb.Params;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;
import org.netbeans.modules.websvc.saas.model.jaxb.Sign;
import org.netbeans.modules.websvc.saas.model.jaxb.UseGenerator;
import org.netbeans.modules.websvc.saas.model.jaxb.UseTemplates;
import org.netbeans.modules.websvc.saas.util.SaasUtil;

public abstract class SaasBean
extends GenericResourceBean {
    public static final String RESOURCE_TEMPLATE = "Templates/SaaSServices/WrapperResource.java";
    private List<String> outputWrapperNames = new ArrayList<String>();
    private List<String> wrapperPackageNames = new ArrayList<String>();
    private List<ParameterInfo> inputParams;
    private List<ParameterInfo> headerParams;
    private List<ParameterInfo> templateParams;
    private List<ParameterInfo> queryParams;
    private String resourceTemplate;
    private Constants.SaasAuthenticationType authType;
    private SaasAuthentication auth;
    private boolean isDropTargetWeb = false;
    private String groupName;
    private String displayName;
    private Saas saas;

    public SaasBean(Saas saas, String name, String packageName, String uriTemplate, Constants.MimeType[] mediaTypes, String[] representationTypes, Constants.HttpMethodType[] methodTypes) {
        super(name, packageName, uriTemplate, mediaTypes, representationTypes, methodTypes);
        this.saas = saas;
        SaasGroup g = saas.getParentGroup();
        if (g.getParent() == null) {
            g = saas.getTopLevelGroup();
        }
        this.groupName = Util.normailizeName(g.getName());
        this.displayName = Util.normailizeName(saas.getDisplayName());
    }

    public Saas getSaas() {
        return this.saas;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSaasName() {
        return this.getGroupName() + this.getDisplayName();
    }

    public String getSaasServiceName() {
        return this.getGroupName() + this.getDisplayName();
    }

    public String getSaasServicePackageName() {
        return "org.netbeans.saas." + SaasUtil.toValidJavaName((String)this.getGroupName()).toLowerCase();
    }

    public String getAuthenticatorClassName() {
        return Util.getAuthenticatorClassName(this.getSaasName());
    }

    public String getAuthorizationFrameClassName() {
        return Util.getAuthorizationFrameClassName(this.getSaasName());
    }

    public boolean isDropTargetWeb() {
        return this.isDropTargetWeb;
    }

    public void setIsDropTargetWeb(boolean isDropTargetWeb) {
        this.isDropTargetWeb = isDropTargetWeb;
    }

    protected void setInputParameters(List<ParameterInfo> inputParams) {
        this.inputParams = inputParams;
    }

    @Override
    public List<ParameterInfo> getInputParameters() {
        if (this.inputParams == null) {
            this.inputParams = this.initInputParameters();
        }
        return this.inputParams;
    }

    public List<ParameterInfo> getHeaderParameters() {
        if (this.headerParams == null) {
            this.headerParams = new ArrayList<ParameterInfo>();
            for (ParameterInfo param : this.getInputParameters()) {
                if (param.getStyle() != ParameterInfo.ParamStyle.HEADER) continue;
                this.headerParams.add(param);
            }
        }
        return this.headerParams;
    }

    @Override
    public String[] getUriParams() {
        ArrayList<String> uriParams = new ArrayList<String>();
        for (ParameterInfo param : this.getTemplateParameters()) {
            uriParams.add(param.getName());
        }
        return uriParams.toArray(new String[0]);
    }

    public List<ParameterInfo> getTemplateParameters() {
        if (this.templateParams == null) {
            this.templateParams = new ArrayList<ParameterInfo>();
            for (ParameterInfo param : this.getInputParameters()) {
                if (param.getStyle() != ParameterInfo.ParamStyle.TEMPLATE) continue;
                this.templateParams.add(param);
            }
        }
        return this.templateParams;
    }

    protected void setTemplateParameters(List<ParameterInfo> templateParams) {
        this.templateParams = templateParams;
    }

    protected abstract List<ParameterInfo> initInputParameters();

    @Override
    public List<ParameterInfo> getQueryParameters() {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<ParameterInfo>();
            for (ParameterInfo param : this.getInputParameters()) {
                if (param.getStyle() != ParameterInfo.ParamStyle.QUERY) continue;
                this.queryParams.add(param);
            }
        }
        return this.queryParams;
    }

    public List<String> getOutputWrapperNames() {
        if (this.outputWrapperNames.isEmpty()) {
            String wName = this.getName();
            if (wName.endsWith("Resource")) {
                wName = wName.substring(0, wName.length() - 8);
            }
            wName = wName + "Converter";
            this.outputWrapperNames.add(wName);
        }
        return this.outputWrapperNames;
    }

    public void addOutputWrapperName(String outputWrapperName) {
        this.outputWrapperNames.add(outputWrapperName);
    }

    public List<String> getOutputWrapperPackageNames() {
        return this.wrapperPackageNames;
    }

    public void addOutputWrapperPackageName(String packageName) {
        this.wrapperPackageNames.add(packageName);
    }

    @Override
    public String[] getRepresentationTypes() {
        if (this.getMimeTypes().length == 1 && this.getMimeTypes()[0] == Constants.MimeType.HTML) {
            return new String[]{String.class.getName()};
        }
        ArrayList<String> repList = new ArrayList<String>();
        for (int i = 0; i < this.getOutputWrapperNames().size(); ++i) {
            String rep = this.getOutputWrapperPackageNames().get(i) + "." + this.getOutputWrapperNames().get(i);
            for (Constants.MimeType m : this.getMimeTypes()) {
                repList.add(rep);
            }
        }
        return repList.toArray(new String[0]);
    }

    public String[] getOutputTypes() {
        String[] types = new String[]{"java.lang.String"};
        return types;
    }

    public String getResourceClassTemplate() {
        return this.resourceTemplate;
    }

    protected void setResourceClassTemplate(String template) {
        this.resourceTemplate = template;
    }

    @Override
    public Constants.SaasAuthenticationType getAuthenticationType() {
        return this.authType;
    }

    public void setAuthenticationType(Constants.SaasAuthenticationType authType) {
        this.authType = authType;
    }

    @Override
    public SaasAuthentication getAuthentication() {
        return this.auth;
    }

    public void setAuthentication(SaasAuthentication auth) {
        this.auth = auth;
    }

    private SaasAuthentication.UseGenerator.Method createSessionKeyUseGeneratorMethod(Method method, SaasAuthentication.UseGenerator useGenerator) {
        if (method != null) {
            SaasAuthentication.UseGenerator.Method skMethod = useGenerator.createMethod();
            skMethod.setId(method.getId());
            skMethod.setName(method.getName());
            skMethod.setHref(method.getHref());
            return skMethod;
        }
        return null;
    }

    private List<ParameterInfo> findSignParameters(Sign sign) {
        Params params;
        if (sign != null && (params = sign.getParams()) != null && params.getParam() != null) {
            ArrayList<ParameterInfo> signParams = new ArrayList<ParameterInfo>();
            this.findSaasParams(signParams, params.getParam());
            return signParams;
        }
        return Collections.emptyList();
    }

    protected Object getSignedUrl(SaasMetadata.Authentication auth) {
        return null;
    }

    protected Object getSessionKey(SaasMetadata.Authentication auth) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void findAuthentication(SaasMethod m) throws IOException {
        SaasMetadata.Authentication auth2 = m.getSaas().getSaasMetadata().getAuthentication();
        if (auth2 == null) {
            this.setAuthenticationType(Constants.SaasAuthenticationType.PLAIN);
            return;
        }
        if (auth2.getHttpBasic() != null) {
            SaasMetadata.Authentication.HttpBasic httpBasic = auth2.getHttpBasic();
            this.setAuthenticationType(Constants.SaasAuthenticationType.HTTP_BASIC);
            HttpBasicAuthentication httpBasicAuth = new HttpBasicAuthentication(httpBasic.getUsername(), httpBasic.getPassword());
            this.setAuthentication(httpBasicAuth);
            SaasAuthentication.UseGenerator skUseGenerator = httpBasicAuth.createUseGenerator();
            SaasAuthentication.UseTemplates skUseTemplates = httpBasicAuth.createUseTemplates();
            if (this.findUseGenerator(m, httpBasic.getAuthenticator(), skUseGenerator)) {
                httpBasicAuth.setUseGenerator(skUseGenerator);
                return;
            } else {
                if (!this.findUseTemplates(m, httpBasic.getAuthenticator(), skUseTemplates)) throw new IOException("authentication element has no use-generator or use-templates children.");
                httpBasicAuth.setUseTemplates(skUseTemplates);
            }
            return;
        } else if (auth2.getCustom() != null) {
            this.setAuthenticationType(Constants.SaasAuthenticationType.CUSTOM);
            this.setAuthentication(new CustomAuthentication());
            return;
        } else if (auth2.getApiKey() != null) {
            this.setAuthenticationType(Constants.SaasAuthenticationType.API_KEY);
            this.setAuthentication(new ApiKeyAuthentication(auth2.getApiKey().getId()));
            return;
        } else if (auth2.getSignedUrl() != null && auth2.getSignedUrl().size() > 0) {
            Params params;
            this.setAuthenticationType(Constants.SaasAuthenticationType.SIGNED_URL);
            List signedUrlList = auth2.getSignedUrl();
            SaasMetadata.Authentication.SignedUrl signedUrl = (SaasMetadata.Authentication.SignedUrl)this.getSignedUrl(auth2);
            if (signedUrl == null) {
                signedUrl = (SaasMetadata.Authentication.SignedUrl)signedUrlList.get(0);
            }
            SignedUrlAuthentication signedUrlAuth = new SignedUrlAuthentication();
            if (signedUrl.getSigId() != null) {
                signedUrlAuth.setSigKeyName(signedUrl.getSigId());
            }
            this.setAuthentication(signedUrlAuth);
            Sign sign = signedUrl.getSign();
            if (sign == null || (params = sign.getParams()) == null || params.getParam() == null) return;
            ArrayList<ParameterInfo> signParams = new ArrayList<ParameterInfo>();
            this.findSaasParams(signParams, params.getParam());
            signedUrlAuth.setParameters(signParams);
            return;
        } else if (auth2.getSessionKey() != null && auth2.getSessionKey().size() > 0) {
            Params params;
            List sessionKeyList = auth2.getSessionKey();
            SaasMetadata.Authentication.SessionKey sessionKey = (SaasMetadata.Authentication.SessionKey)this.getSessionKey(auth2);
            if (sessionKey == null) {
                sessionKey = (SaasMetadata.Authentication.SessionKey)sessionKeyList.get(0);
            }
            this.setAuthenticationType(Constants.SaasAuthenticationType.SESSION_KEY);
            SessionKeyAuthentication sessionKeyAuth = new SessionKeyAuthentication(sessionKey.getApiId(), sessionKey.getSessionId(), sessionKey.getSigId());
            this.setAuthentication(sessionKeyAuth);
            Sign sign = sessionKey.getSign();
            if (sign != null && (params = sign.getParams()) != null && params.getParam() != null) {
                ArrayList<ParameterInfo> signParams = new ArrayList<ParameterInfo>();
                this.findSaasParams(signParams, params.getParam());
                sessionKeyAuth.setParameters(signParams);
            }
            SaasAuthentication.UseGenerator skUseGenerator = sessionKeyAuth.createUseGenerator();
            SaasAuthentication.UseTemplates skUseTemplates = sessionKeyAuth.createUseTemplates();
            if (this.findUseGenerator(m, sessionKey.getAuthenticator(), skUseGenerator)) {
                sessionKeyAuth.setUseGenerator(skUseGenerator);
                return;
            } else {
                if (!this.findUseTemplates(m, sessionKey.getAuthenticator(), skUseTemplates)) throw new IOException("authentication element has no use-generator or use-templates children.");
                sessionKeyAuth.setUseTemplates(skUseTemplates);
            }
            return;
        } else {
            this.setAuthenticationType(Constants.SaasAuthenticationType.PLAIN);
        }
    }

    private boolean findUseGenerator(SaasMethod m, Authenticator authenticator, SaasAuthentication.UseGenerator skUseGenerator) throws IOException {
        if (authenticator == null) {
            throw new IOException("No authentication element inside sessionkey element in saas-metadata.");
        }
        if (authenticator.getUseGenerator() != null) {
            UseGenerator.Token token;
            UseGenerator useGenerator = authenticator.getUseGenerator();
            Sign sign = null;
            UseGenerator.Login login = useGenerator.getLogin();
            if (login != null) {
                SaasAuthentication.UseGenerator.Login skLogin = skUseGenerator.createLogin();
                skUseGenerator.setLogin(skLogin);
                sign = login.getSign();
                if (sign != null) {
                    skLogin.setSignId(sign.getId());
                    skLogin.setParameters(this.findSignParameters(sign));
                }
                skLogin.setMethod(this.createSessionKeyUseGeneratorMethod(login.getMethod(), skUseGenerator));
            }
            if ((token = useGenerator.getToken()) != null) {
                SaasAuthentication.UseGenerator.Token skToken = skUseGenerator.createToken(token.getId());
                skUseGenerator.setToken(skToken);
                sign = token.getSign();
                if (sign != null) {
                    skToken.setSignId(sign.getId());
                    skToken.setParameters(this.findSignParameters(sign));
                }
                skToken.setMethod(this.createSessionKeyUseGeneratorMethod(token.getMethod(), skUseGenerator));
            }
            UseGenerator.Logout logout = useGenerator.getLogout();
            return true;
        }
        return false;
    }

    private boolean findUseTemplates(SaasMethod m, Authenticator authenticator, SaasAuthentication.UseTemplates skUseTemplates) throws IOException {
        if (authenticator == null) {
            throw new IOException("No authentication element inside sessionkey element in saas-metadata.");
        }
        if (authenticator.getUseTemplates() != null) {
            UseTemplates useTemplates = authenticator.getUseTemplates();
            List templates = null;
            if (!this.isDropTargetWeb() && useTemplates.getDesktop() != null && useTemplates.getDesktop().getTemplate() != null) {
                templates = useTemplates.getDesktop().getTemplate();
            } else if (this.isDropTargetWeb() && useTemplates.getWeb() != null && useTemplates.getWeb().getTemplate() != null) {
                templates = useTemplates.getWeb().getTemplate();
            }
            if (templates == null || templates.isEmpty()) {
                throw new IOException("WARN_UnsupportedDropTarget");
            }
            ArrayList<SaasAuthentication.UseTemplates.Template> templateNames = new ArrayList<SaasAuthentication.UseTemplates.Template>();
            Map<String, Map<String, String>> artifactsMap = this.getArtifactTemplates(m);
            for (Map.Entry<String, Map<String, String>> e1 : artifactsMap.entrySet()) {
                String dropTypes = e1.getKey();
                Map<String, String> artifacts = e1.getValue();
                for (Map.Entry<String, String> e2 : artifacts.entrySet()) {
                    String href = e2.getKey();
                    String[] val = e2.getValue().split(":");
                    templateNames.add(skUseTemplates.createTemplate(dropTypes, href, val[0], val[1]));
                }
            }
            skUseTemplates.setTemplates(templateNames);
            return true;
        }
        return false;
    }

    public boolean isUseTemplates() {
        return this.getAuthenticationType() == Constants.SaasAuthenticationType.SESSION_KEY && ((SessionKeyAuthentication)this.getAuthentication()).getUseTemplates() != null || this.getAuthenticationType() == Constants.SaasAuthenticationType.HTTP_BASIC && ((HttpBasicAuthentication)this.getAuthentication()).getUseTemplates() != null;
    }

    private Map<String, Map<String, String>> getArtifactTemplates(SaasMethod m) throws IOException {
        List artifactsList;
        HashMap<String, Map<String, String>> targetMaps = new HashMap<String, Map<String, String>>();
        SaasMetadata.CodeGen codegen = m.getSaas().getSaasMetadata().getCodeGen();
        if (codegen != null && (artifactsList = codegen.getArtifacts()) != null) {
            for (Artifacts artifacts : artifactsList) {
                HashMap<String, String> map = new HashMap<String, String>();
                String targets = artifacts.getTargets();
                List artifactList = artifacts.getArtifact();
                if (artifactList == null) continue;
                for (Artifact artifact : artifactList) {
                    String id = artifact.getId();
                    String type = artifact.getType();
                    if (type == null) {
                        throw new IOException("saas-metadata/code-gen/artifacts/artifact/@type value is null.");
                    }
                    String artifactUrl = artifact.getUrl();
                    if (artifactUrl == null) {
                        throw new IOException("saas-metadata/code-gen/artifacts/artifact/@url value is null.");
                    }
                    if (!type.equals("template")) continue;
                    map.put(id, type + ":" + artifactUrl);
                }
                targetMaps.put(targets, map);
            }
        }
        return targetMaps;
    }

    public void findSaasParams(List<ParameterInfo> paramInfos, List<Params.Param> params) {
        if (params != null) {
            for (Params.Param param : params) {
                String paramName = param.getName();
                Class paramType = SaasBean.findJavaType(param.getType());
                ParameterInfo paramInfo = new ParameterInfo(paramName, paramType);
                if (param.getId() != null && !param.getId().trim().equals("")) {
                    paramInfo.setId(param.getId());
                }
                paramInfo.setIsRequired(param.isRequired() != null ? param.isRequired() : false);
                paramInfo.setFixed(param.getFixed());
                paramInfo.setDefaultValue(param.getDefault());
                paramInfos.add(paramInfo);
            }
        }
    }

    public static Class findJavaType(String schemaType) {
        if (schemaType != null) {
            int index = schemaType.indexOf(":");
            if (index != -1) {
                schemaType = schemaType.substring(index + 1);
            }
            if (schemaType.equalsIgnoreCase("string")) {
                return String.class;
            }
            if (schemaType.equalsIgnoreCase("int")) {
                return Integer.class;
            }
            if (schemaType.equalsIgnoreCase("date")) {
                return Date.class;
            }
            if (schemaType.equalsIgnoreCase("time")) {
                return Time.class;
            }
            if (schemaType.equalsIgnoreCase("httpMethod")) {
                return Constants.HttpMethodType.class;
            }
        }
        return String.class;
    }

    public void findSaasMediaType(List<Constants.MimeType> mimeTypes, Method.Output.Media media) {
        String[] mTypes;
        String mediaType = media.getType();
        for (String m1 : mTypes = mediaType.split(",")) {
            Constants.MimeType mType = Constants.MimeType.find(m1);
            if (mType == null) continue;
            mimeTypes.add(mType);
        }
    }

    public static boolean canAccept(SaasMethod m, Class classType, Constants.DropFileType type) {
        List artifactsList;
        if (classType == null || type == null) {
            throw new IllegalArgumentException("Argument classType or type is null");
        }
        if (!classType.isInstance(m)) {
            return false;
        }
        SaasMetadata.CodeGen codegen = m.getSaas().getSaasMetadata().getCodeGen();
        if (codegen != null && (artifactsList = codegen.getArtifacts()) != null) {
            for (Artifacts artifacts : artifactsList) {
                String[] fileTypes;
                String targets = artifacts.getTargets();
                if (targets == null) continue;
                for (String fileType : fileTypes = targets.split(",")) {
                    if (!fileType.equalsIgnoreCase(type.prefix())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getProfile(SaasMethod m, Constants.DropFileType type) {
        List artifactsList;
        SaasMetadata.CodeGen codegen = m.getSaas().getSaasMetadata().getCodeGen();
        if (codegen != null && (artifactsList = codegen.getArtifacts()) != null) {
            for (Artifacts artifacts : artifactsList) {
                String[] fileTypes;
                String targets = artifacts.getTargets();
                if (targets == null) continue;
                for (String fileType : fileTypes = targets.split(",")) {
                    if (!fileType.equalsIgnoreCase(type.prefix())) continue;
                    return artifacts.getProfile();
                }
            }
        }
        return null;
    }

    public class SaasAuthentication {
        public UseGenerator createUseGenerator() {
            return new UseGenerator();
        }

        public UseTemplates createUseTemplates() {
            return new UseTemplates();
        }

        public class UseGenerator {
            private Login login;
            private Token token;
            private Logout logout;

            public Login getLogin() {
                return this.login;
            }

            public void setLogin(Login login) {
                this.login = login;
            }

            public Token getToken() {
                return this.token;
            }

            public void setToken(Token token) {
                this.token = token;
            }

            public Logout getLogout() {
                return this.logout;
            }

            public void setLogout(Logout logout) {
                this.logout = logout;
            }

            public Login createLogin() {
                return new Login();
            }

            public Token createToken(String id) {
                return new Token(id);
            }

            public Logout createLogout() {
                return new Logout();
            }

            public Method createMethod() {
                return new Method();
            }

            public class Login {
                List<ParameterInfo> params = Collections.emptyList();
                Method method;
                String signId;

                public String getSignId() {
                    return this.signId;
                }

                public void setSignId(String signId) {
                    this.signId = signId;
                }

                public List<ParameterInfo> getParameters() {
                    return this.params;
                }

                public void setParameters(List<ParameterInfo> params) {
                    this.params = params;
                }

                public Method getMethod() {
                    return this.method;
                }

                public void setMethod(Method method) {
                    this.method = method;
                }
            }

            public class Token
            extends Login {
                private String id;
                private Prompt prompt;

                public Token(String id) {
                    this.id = id;
                }

                public String getId() {
                    return this.id;
                }

                public Prompt getPrompt() {
                    return this.prompt;
                }

                public void setPrompt(Prompt prompt) {
                    this.prompt = prompt;
                }

                private Prompt createPrompt() {
                    return new Prompt();
                }

                public class Prompt {
                    private String deskTopUrl;
                    private String webUrl;
                    List<ParameterInfo> params = Collections.emptyList();
                    private String signId;

                    public String getSignId() {
                        return this.signId;
                    }

                    public void setSignId(String signId) {
                        this.signId = signId;
                    }

                    public List<ParameterInfo> getParameters() {
                        return this.params;
                    }

                    public void setParameters(List<ParameterInfo> params) {
                        this.params = params;
                    }

                    public String getDesktopUrl() {
                        return this.deskTopUrl;
                    }

                    public void setDesktopUrl(String deskTopUrl) {
                        this.deskTopUrl = deskTopUrl;
                    }

                    public String getWebUrl() {
                        return this.webUrl;
                    }

                    public void setWebUrl(String webUrl) {
                        this.webUrl = webUrl;
                    }
                }
            }

            public class Logout
            extends Login {
            }

            public class Method {
                String id;
                String name;
                String href;

                public String getId() {
                    return this.id;
                }

                public void setId(String id) {
                    this.id = id;
                }

                public String getName() {
                    return this.name;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public String getHref() {
                    return this.href;
                }

                public void setHref(String href) {
                    this.href = href;
                }
            }
        }

        public class UseTemplates {
            private List<Template> templates = Collections.emptyList();

            public List<Template> getTemplates() {
                return this.templates;
            }

            public void setTemplates(List<Template> templates) {
                this.templates = templates;
            }

            public Template createTemplate(String dropTypes, String id, String type, String url) {
                return new Template(dropTypes, id, type, url);
            }

            public class Template {
                private List<String> dropTypeList = new ArrayList<String>();
                private String id;
                private String type;
                private String url;

                public Template(String dropTypes, String id, String type, String url) {
                    for (String dropType : dropTypes.split(",")) {
                        this.dropTypeList.add(dropType);
                    }
                    this.id = id;
                    this.type = type;
                    this.url = url;
                }

                public List<String> getDropTypeList() {
                    return this.dropTypeList;
                }

                public String getId() {
                    return this.id;
                }

                public String getType() {
                    return this.type;
                }

                public String getUrl() {
                    return this.url;
                }
            }
        }
    }

    public class HttpBasicAuthentication
    extends SaasAuthentication {
        private String username;
        private String password;
        private SaasAuthentication.UseTemplates useTemplates;
        private SaasAuthentication.UseGenerator useGenerator;

        public HttpBasicAuthentication(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUserNameId() {
            return this.username;
        }

        public String getPasswordId() {
            return this.password;
        }

        public SaasAuthentication.UseTemplates getUseTemplates() {
            return this.useTemplates;
        }

        public void setUseTemplates(SaasAuthentication.UseTemplates useTemplates) {
            this.useTemplates = useTemplates;
        }

        public SaasAuthentication.UseGenerator getUseGenerator() {
            return this.useGenerator;
        }

        public void setUseGenerator(SaasAuthentication.UseGenerator useGenerator) {
            this.useGenerator = useGenerator;
        }
    }

    public class CustomAuthentication
    extends SaasAuthentication {
    }

    public class ApiKeyAuthentication
    extends SaasAuthentication {
        private String keyName;

        public ApiKeyAuthentication(String keyName) {
            this.keyName = keyName;
        }

        public String getApiKeyName() {
            return this.keyName;
        }
    }

    public class SignedUrlAuthentication
    extends SaasAuthentication {
        private String sig;
        List<ParameterInfo> params = Collections.emptyList();

        public String getSigKeyName() {
            return this.sig;
        }

        public void setSigKeyName(String sig) {
            this.sig = sig;
        }

        public List<ParameterInfo> getParameters() {
            return this.params;
        }

        public void setParameters(List<ParameterInfo> params) {
            this.params = params;
        }
    }

    public class SessionKeyAuthentication
    extends SaasAuthentication {
        private String apiId;
        private String sessionId;
        private String sig;
        private List<ParameterInfo> params = Collections.emptyList();
        private SaasAuthentication.UseTemplates useTemplates;
        private SaasAuthentication.UseGenerator useGenerator;

        public SessionKeyAuthentication(String apiId, String sessionId, String sig) {
            this.apiId = apiId;
            this.sessionId = sessionId;
            this.sig = sig;
        }

        public String getApiKeyName() {
            return this.apiId;
        }

        public String getSessionKeyName() {
            return this.sessionId;
        }

        public String getSigKeyName() {
            return this.sig;
        }

        public List<ParameterInfo> getParameters() {
            return this.params;
        }

        public void setParameters(List<ParameterInfo> params) {
            this.params = params;
        }

        public SaasAuthentication.UseTemplates getUseTemplates() {
            return this.useTemplates;
        }

        public void setUseTemplates(SaasAuthentication.UseTemplates useTemplates) {
            this.useTemplates = useTemplates;
        }

        public SaasAuthentication.UseGenerator getUseGenerator() {
            return this.useGenerator;
        }

        public void setUseGenerator(SaasAuthentication.UseGenerator useGenerator) {
            this.useGenerator = useGenerator;
        }
    }

    public class Time {
    }
}

