/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.protractor.preferences;

import java.io.File;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ProtractorPreferences {
    public static final String USER_CONFIGURATION_FILE = "user.configuration.file";
    public static final String ENABLED = "enabled";
    private static final String PROTRACTOR = "protractor";
    private final Project project;
    private Preferences preferences;

    public ProtractorPreferences(Project project) {
        assert (project != null);
        this.project = project;
    }

    public static boolean isEnabled(Project project) {
        return ProtractorPreferences.getPreferences(project).getBoolean(ENABLED, false);
    }

    public static void setEnabled(Project project, boolean enabled) {
        ProtractorPreferences.getPreferences(project).putBoolean(ENABLED, enabled);
    }

    @CheckForNull
    public static String getProtractor(Project project) {
        return ProtractorPreferences.resolvePath(project, ProtractorPreferences.getPreferences(project).get(PROTRACTOR, null));
    }

    public static void setProtractor(Project project, String protractor) {
        ProtractorPreferences.getPreferences(project).put(PROTRACTOR, ProtractorPreferences.relativizePath(project, protractor));
    }

    @CheckForNull
    public static String getUserConfigurationFile(Project project) {
        return ProtractorPreferences.resolvePath(project, ProtractorPreferences.getPreferences(project).get(USER_CONFIGURATION_FILE, null));
    }

    public static void setUserConfigurationFile(Project project, String userConfigurationFile) {
        ProtractorPreferences.getPreferences(project).put(USER_CONFIGURATION_FILE, ProtractorPreferences.relativizePath(project, userConfigurationFile));
    }

    public static void addPreferenceChangeListener(Project project, PreferenceChangeListener listener) {
        ProtractorPreferences.getPreferences(project).addPreferenceChangeListener(listener);
    }

    public static void removePreferenceChangeListener(Project project, PreferenceChangeListener listener) {
        ProtractorPreferences.getPreferences(project).removePreferenceChangeListener(listener);
    }

    private static Preferences getPreferences(Project project) {
        assert (project != null);
        return ((ProtractorPreferences)project.getLookup().lookup(ProtractorPreferences.class)).getPreferences();
    }

    synchronized Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = ProjectUtils.getPreferences((Project)this.project, ProtractorPreferences.class, (boolean)false);
        }
        return this.preferences;
    }

    private static String relativizePath(Project project, String filePath) {
        if (filePath == null || filePath.trim().isEmpty()) {
            return "";
        }
        File file = new File(filePath);
        String path = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (File)file);
        if (path == null || path.startsWith("../")) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    private static String resolvePath(Project project, String filePath) {
        if (filePath == null || filePath.trim().isEmpty()) {
            return null;
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)filePath).getAbsolutePath();
    }
}

