/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.types.Revision;

public class ExternalItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String targetDir;
    private String url;
    private Revision revision;
    private Revision pegRevision;

    public ExternalItem(String targetDir, String url, Revision revision, Revision pegRevision) throws SubversionException {
        this(false, targetDir, url, revision, pegRevision);
        ExternalItem.validateRevision(revision, "revision");
        ExternalItem.validateRevision(pegRevision, "pegRevision");
    }

    private ExternalItem(boolean dummy_parameter_to_discriminate_constructors, String targetDir, String url, Revision revision, Revision pegRevision) {
        this.targetDir = targetDir;
        this.url = url;
        this.pegRevision = pegRevision != null ? pegRevision : Revision.HEAD;
        this.revision = revision != null ? revision : this.pegRevision;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public String getUrl() {
        return this.url;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public Revision getPegRevision() {
        return this.pegRevision;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExternalItem)) {
            return false;
        }
        ExternalItem that = (ExternalItem)obj;
        return this.targetDir.equals(that.targetDir) && this.url.equals(that.url) && this.revision.equals(that.revision) && this.pegRevision.equals(that.pegRevision);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 33 + (null != this.targetDir ? this.targetDir.hashCode() : 0);
        hash = hash * 33 + (null != this.url ? this.url.hashCode() : 0);
        hash = hash * 33 + (null != this.revision ? this.revision.hashCode() : 0);
        hash = hash * 33 + (null != this.pegRevision ? this.pegRevision.hashCode() : 0);
        return hash;
    }

    private static void validateRevision(Revision revision, String param) throws SubversionException {
        if (revision != null && revision.getKind() != Revision.Kind.number && revision.getKind() != Revision.Kind.date && revision.getKind() != Revision.Kind.head) {
            throw new BadRevisionKindException(param);
        }
    }

    private static class BadRevisionKindException
    extends SubversionException {
        private static final long serialVersionUID = 1L;

        public BadRevisionKindException(String param) {
            super("the '" + param + "' constructor argument must be a date, a number, or Revision.HEAD");
        }
    }
}

