/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.monitoring.model.AlarmHistoryEntry;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AlarmHistoryCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="alarmId")
    private final String alarmId;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="entries")
    private final List<AlarmHistoryEntry> entries;

    @Deprecated
    @ConstructorProperties(value={"alarmId", "isEnabled", "entries"})
    public AlarmHistoryCollection(String alarmId, Boolean isEnabled, List<AlarmHistoryEntry> entries) {
        this.alarmId = alarmId;
        this.isEnabled = isEnabled;
        this.entries = entries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAlarmId() {
        return this.alarmId;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public List<AlarmHistoryEntry> getEntries() {
        return this.entries;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AlarmHistoryCollection(");
        sb.append("super=").append(super.toString());
        sb.append("alarmId=").append(String.valueOf(this.alarmId));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", entries=").append(String.valueOf(this.entries));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlarmHistoryCollection)) {
            return false;
        }
        AlarmHistoryCollection other = (AlarmHistoryCollection)((Object)o);
        return Objects.equals(this.alarmId, other.alarmId) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.entries, other.entries) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.alarmId == null ? 43 : this.alarmId.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.entries == null ? 43 : this.entries.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="alarmId")
        private String alarmId;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="entries")
        private List<AlarmHistoryEntry> entries;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder alarmId(String alarmId) {
            this.alarmId = alarmId;
            this.__explicitlySet__.add("alarmId");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder entries(List<AlarmHistoryEntry> entries) {
            this.entries = entries;
            this.__explicitlySet__.add("entries");
            return this;
        }

        public AlarmHistoryCollection build() {
            AlarmHistoryCollection model = new AlarmHistoryCollection(this.alarmId, this.isEnabled, this.entries);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AlarmHistoryCollection model) {
            if (model.wasPropertyExplicitlySet("alarmId")) {
                this.alarmId(model.getAlarmId());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("entries")) {
                this.entries(model.getEntries());
            }
            return this;
        }
    }
}

