/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.jaxb.Group;
import org.openide.util.NbBundle;

public class SaasGroup
implements Comparable<SaasGroup> {
    public static final String PROP_GROUP_NAME = "groupName";
    private final Group delegate;
    private final SaasGroup parent;
    private boolean userDefined = true;
    private SortedMap<String, Saas> services;
    private SortedMap<String, SaasGroup> children;
    private String icon16Path;
    private String icon32Path;

    public SaasGroup(SaasGroup parent, Group group) {
        this.parent = parent;
        this.delegate = group;
        this.services = Collections.synchronizedSortedMap(new TreeMap());
    }

    public SaasGroup getParent() {
        return this.parent;
    }

    public Group getDelegate() {
        return this.delegate;
    }

    public List<Saas> getServices() {
        return new ArrayList<Saas>(this.services.values());
    }

    public Saas getChildService(String name) {
        this.getServices();
        return (Saas)this.services.get(name);
    }

    public void addService(Saas service) {
        this.getServices();
        this.services.put(service.getDisplayName(), service);
    }

    public boolean removeService(Saas service) {
        Saas removed = (Saas)this.services.remove(service.getDisplayName());
        return removed != null;
    }

    public void setName(String value) {
        if (this.getParent() == null) {
            throw new IllegalArgumentException("Cannot rename root group");
        }
        if (value == null || value.equals(this.getName())) {
            return;
        }
        String message = null;
        if (!this.isUserDefined()) {
            message = NbBundle.getMessage(this.getClass(), (String)"MSG_GroupNotUserDefined");
        }
        for (SaasGroup g : this.getParent().getChildrenGroups()) {
            if (!g.getName().equals(value)) continue;
            message = NbBundle.getMessage(this.getClass(), (String)"MSG_DuplicateGroupName");
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        this.delegate.setName(value);
        this.resetAllServicesGroupPath();
    }

    private void resetAllServicesGroupPath() {
        for (Saas s : this.getServices()) {
            s.computePathFromRoot();
        }
        for (SaasGroup g : this.getChildrenGroups()) {
            g.resetAllServicesGroupPath();
        }
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    void setUserDefined(boolean v) {
        if (this.userDefined) {
            this.userDefined = v;
        }
    }

    public String getIcon16Path() {
        return this.icon16Path;
    }

    protected void setIcon16Path(String icon16Path) {
        this.icon16Path = icon16Path;
    }

    public String getIcon32Path() {
        return this.icon32Path;
    }

    protected void setIcon32Path(String icon32Path) {
        this.icon32Path = icon32Path;
    }

    public List<SaasGroup> getChildrenGroups() {
        if (this.children == null) {
            this.children = Collections.synchronizedSortedMap(new TreeMap());
            for (Group g : this.delegate.getGroup()) {
                SaasGroup sg = new SaasGroup(this, g);
                this.children.put(sg.getName(), sg);
            }
        }
        return new ArrayList<SaasGroup>(this.children.values());
    }

    public SaasGroup getChildGroup(String name) {
        this.getChildrenGroups();
        return (SaasGroup)this.children.get(name);
    }

    protected boolean removeChildGroup(SaasGroup group) {
        if (!group.canRemove()) {
            return false;
        }
        this._removeChildGroup(group);
        return true;
    }

    private void _removeChildGroup(SaasGroup child) {
        if (child != null) {
            for (Saas saas : child.getServices()) {
                this.removeService(saas);
                SaasServicesModel.getInstance()._removeService(saas);
            }
            for (SaasGroup c : child.getChildrenGroups()) {
                this._removeChildGroup(c);
            }
            this.getDelegate().getGroup().remove(child.getDelegate());
            this.children.remove(child.getName());
        }
    }

    public boolean canRemove() {
        if (!this.isUserDefined()) {
            return false;
        }
        for (Saas s : this.getServices()) {
            if (s.isUserDefined()) continue;
            return false;
        }
        for (SaasGroup child : this.getChildrenGroups()) {
            if (child.canRemove()) continue;
            return false;
        }
        return true;
    }

    protected void addChildGroup(SaasGroup group) {
        this.getChildrenGroups();
        this.children.put(group.getName(), group);
        this.getDelegate().getGroup().add(group.getDelegate());
    }

    public Group getPathFromRoot() {
        SaasGroup parentGroup = this.getParent();
        if (parentGroup == null) {
            return null;
        }
        Group group = new Group();
        group.setName(this.getName());
        while (parentGroup != SaasServicesModel.getInstance().getRootGroup()) {
            Group p = new Group();
            p.setName(parentGroup.getName());
            p.getGroup().add(group);
            group = p;
            parentGroup = parentGroup.getParent();
        }
        return group;
    }

    public boolean serviceExists(String url) {
        SaasGroup root = this.getRoot();
        return this.serviceExists(root, url);
    }

    private boolean serviceExists(SaasGroup group, String url) {
        for (Saas service : group.getServices()) {
            if (!url.equals(service.getUrl())) continue;
            return true;
        }
        for (SaasGroup g : group.getChildrenGroups()) {
            if (!this.serviceExists(g, url)) continue;
            return true;
        }
        return false;
    }

    protected SaasGroup createGroup(String name) {
        List<SaasGroup> childGroups = this.getChildrenGroups();
        for (SaasGroup g : childGroups) {
            if (!g.getName().equals(name)) continue;
            throw new IllegalArgumentException(NbBundle.getMessage(SaasGroup.class, (String)"MSG_GroupAlreadyExists"));
        }
        Group g = new Group();
        g.setName(name);
        SaasGroup child = new SaasGroup(this, g);
        child.setUserDefined(true);
        return child;
    }

    private SaasGroup getRoot() {
        SaasGroup root = this;
        SaasGroup parent = this;
        while ((parent = parent.getParent()) != null) {
            root = parent;
        }
        return root;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(SaasGroup group) {
        return this.getName().compareTo(group.getName());
    }
}

