/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetIPSecConnectionTunnelErrorRequest
extends BmcRequest<Void> {
    private String ipscId;
    private String tunnelId;

    public String getIpscId() {
        return this.ipscId;
    }

    public String getTunnelId() {
        return this.tunnelId;
    }

    public Builder toBuilder() {
        return new Builder().ipscId(this.ipscId).tunnelId(this.tunnelId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ipscId=").append(String.valueOf(this.ipscId));
        sb.append(",tunnelId=").append(String.valueOf(this.tunnelId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetIPSecConnectionTunnelErrorRequest)) {
            return false;
        }
        GetIPSecConnectionTunnelErrorRequest other = (GetIPSecConnectionTunnelErrorRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ipscId, other.ipscId) && Objects.equals(this.tunnelId, other.tunnelId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ipscId == null ? 43 : this.ipscId.hashCode());
        result = result * 59 + (this.tunnelId == null ? 43 : this.tunnelId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIPSecConnectionTunnelErrorRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ipscId = null;
        private String tunnelId = null;

        public Builder ipscId(String ipscId) {
            this.ipscId = ipscId;
            return this;
        }

        public Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIPSecConnectionTunnelErrorRequest o) {
            this.ipscId(o.getIpscId());
            this.tunnelId(o.getTunnelId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIPSecConnectionTunnelErrorRequest build() {
            GetIPSecConnectionTunnelErrorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetIPSecConnectionTunnelErrorRequest buildWithoutInvocationCallback() {
            GetIPSecConnectionTunnelErrorRequest request = new GetIPSecConnectionTunnelErrorRequest();
            request.ipscId = this.ipscId;
            request.tunnelId = this.tunnelId;
            return request;
        }
    }
}

