/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetNatGatewayRequest
extends BmcRequest<Void> {
    private String natGatewayId;

    public String getNatGatewayId() {
        return this.natGatewayId;
    }

    public Builder toBuilder() {
        return new Builder().natGatewayId(this.natGatewayId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",natGatewayId=").append(String.valueOf(this.natGatewayId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetNatGatewayRequest)) {
            return false;
        }
        GetNatGatewayRequest other = (GetNatGatewayRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.natGatewayId, other.natGatewayId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.natGatewayId == null ? 43 : this.natGatewayId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNatGatewayRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String natGatewayId = null;

        public Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNatGatewayRequest o) {
            this.natGatewayId(o.getNatGatewayId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNatGatewayRequest build() {
            GetNatGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetNatGatewayRequest buildWithoutInvocationCallback() {
            GetNatGatewayRequest request = new GetNatGatewayRequest();
            request.natGatewayId = this.natGatewayId;
            return request;
        }
    }
}

