/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ml;

import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.ml.IgnoreSimilarExtractor;
import org.opensearch.ad.ml.ThresholdingResult;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.feature.FeatureManager;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.ml.ModelColdStart;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.ml.Sample;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.util.ModelUtil;
import org.opensearch.timeseries.util.ParseUtils;

public class ADColdStart
extends ModelColdStart<ThresholdedRandomCutForest, ADIndex, ADIndexManagement, AnomalyResult> {
    private static final Logger logger = LogManager.getLogger(ADColdStart.class);

    public ADColdStart(Clock clock, ThreadPool threadPool, NodeStateManager nodeStateManager, int rcfSampleSize, int numberOfTrees, int numMinSamples, int defaultSampleStride, int defaultTrainSamples, SearchFeatureDao searchFeatureDao, double thresholdMinPvalue, FeatureManager featureManager, Duration modelTtl, long rcfSeed, int maxRoundofColdStart, int coolDownMinutes, int resultSchemaVersion) {
        super(modelTtl, coolDownMinutes, clock, threadPool, numMinSamples, rcfSeed, numberOfTrees, rcfSampleSize, thresholdMinPvalue, nodeStateManager, defaultSampleStride, defaultTrainSamples, searchFeatureDao, featureManager, maxRoundofColdStart, "ad-threadpool", AnalysisType.AD, resultSchemaVersion);
    }

    public ADColdStart(Clock clock, ThreadPool threadPool, NodeStateManager nodeStateManager, int rcfSampleSize, int numberOfTrees, int numMinSamples, int maxSampleStride, int maxTrainSamples, SearchFeatureDao searchFeatureDao, double thresholdMinPvalue, FeatureManager featureManager, Duration modelTtl, int maxRoundofColdStart, int coolDownMinutes, int resultSchemaVersion) {
        this(clock, threadPool, nodeStateManager, rcfSampleSize, numberOfTrees, numMinSamples, maxSampleStride, maxTrainSamples, searchFeatureDao, thresholdMinPvalue, featureManager, modelTtl, -1L, maxRoundofColdStart, coolDownMinutes, resultSchemaVersion);
    }

    @Override
    protected List<AnomalyResult> trainModelFromDataSegments(List<Sample> pointSamples, ModelState<ThresholdedRandomCutForest> entityState, Config config, String taskId) {
        List descriptors;
        if (pointSamples == null || pointSamples.size() == 0) {
            logger.info("Return early since data points must not be empty.");
            return null;
        }
        double[] firstPoint = pointSamples.get(0).getValueList();
        if (firstPoint == null || firstPoint.length == 0) {
            logger.info("Return early since the first data point must not be empty.");
            return null;
        }
        int shingleSize = config.getShingleSize();
        int baseDimension = firstPoint.length;
        int dimensions = baseDimension * shingleSize;
        ThresholdedRandomCutForest.Builder rcfBuilder = ThresholdedRandomCutForest.builder().dimensions(dimensions).sampleSize(this.rcfSampleSize).numberOfTrees(this.numberOfTrees).timeDecay(config.getTimeDecay().doubleValue()).transformDecay(config.getTimeDecay().doubleValue()).outputAfter(Math.max(shingleSize, this.numMinSamples)).initialAcceptFraction(this.initialAcceptFraction).parallelExecutionEnabled(false).compact(true).precision(Precision.FLOAT_32).boundingBoxCacheFraction(0.0).shingleSize(shingleSize).internalShinglingEnabled(true).anomalyRate(1.0 - this.thresholdMinPvalue).transformMethod(TransformMethod.NORMALIZE).alertOnce(true).autoAdjust(true);
        if (shingleSize > 1) {
            rcfBuilder.forestMode(ForestMode.STREAMING_IMPUTE);
            rcfBuilder = ADColdStart.applyImputationMethod(config, rcfBuilder);
        } else {
            rcfBuilder.forestMode(ForestMode.STANDARD);
        }
        if (this.rcfSeed > 0L) {
            rcfBuilder.randomSeed(this.rcfSeed);
        }
        AnomalyDetector detector = (AnomalyDetector)config;
        ADColdStart.applyRule(rcfBuilder, detector);
        ThresholdedRandomCutForest trcf = rcfBuilder.build();
        double[][] sequentialData = new double[pointSamples.size()][];
        long[] timestamps = new long[pointSamples.size()];
        ArrayList<Pair> sequentialTime = new ArrayList<Pair>();
        for (int i = 0; i < pointSamples.size(); ++i) {
            Sample dataSample = pointSamples.get(i);
            double[] dataValue = dataSample.getValueList();
            sequentialData[i] = dataValue;
            timestamps[i] = dataSample.getDataEndTime().getEpochSecond();
            sequentialTime.add(Pair.of((Object)dataSample.getDataStartTime(), (Object)dataSample.getDataEndTime()));
        }
        try {
            descriptors = trcf.processSequentially((double[][])sequentialData, timestamps, x -> true);
        }
        catch (Exception e) {
            logger.error("Error while running processSequentially", (Throwable)e);
            return null;
        }
        if (descriptors.size() != sequentialTime.size()) {
            logger.warn("processSequentially returned a different size than expected: got [{}], expected [{}].", (Object)descriptors.size(), (Object)sequentialTime.size());
            return null;
        }
        ArrayList<AnomalyResult> results = new ArrayList<AnomalyResult>();
        for (int i = 0; i < descriptors.size(); ++i) {
            AnomalyDescriptor descriptor = (AnomalyDescriptor)descriptors.get(i);
            double[] dataValue = sequentialData[i];
            Pair time = (Pair)sequentialTime.get(i);
            ThresholdingResult thresholdingResult = ModelUtil.toResult(trcf.getForest(), descriptor, dataValue, false, config);
            Instant now = Instant.now();
            results.addAll(thresholdingResult.toIndexableResults(config, (Instant)time.getLeft(), (Instant)time.getRight(), now, now, ParseUtils.getFeatureData(dataValue, config), entityState.getEntity(), this.resultMappingVersion, entityState.getModelId(), taskId, null));
        }
        entityState.setModel(trcf);
        return results;
    }

    public static void applyRule(ThresholdedRandomCutForest.Builder rcfBuilder, AnomalyDetector detector) {
        IgnoreSimilarExtractor.ThresholdArrays thresholdArrays = IgnoreSimilarExtractor.processDetectorRules(detector);
        if (thresholdArrays != null) {
            if (thresholdArrays.ignoreSimilarFromAbove != null && thresholdArrays.ignoreSimilarFromAbove.length > 0) {
                rcfBuilder.ignoreNearExpectedFromAbove(thresholdArrays.ignoreSimilarFromAbove);
            }
            if (thresholdArrays.ignoreSimilarFromBelow != null && thresholdArrays.ignoreSimilarFromBelow.length > 0) {
                rcfBuilder.ignoreNearExpectedFromBelow(thresholdArrays.ignoreSimilarFromBelow);
            }
            if (thresholdArrays.ignoreSimilarFromAboveByRatio != null && thresholdArrays.ignoreSimilarFromAboveByRatio.length > 0) {
                rcfBuilder.ignoreNearExpectedFromAboveByRatio(thresholdArrays.ignoreSimilarFromAboveByRatio);
            }
            if (thresholdArrays.ignoreSimilarFromBelowByRatio != null && thresholdArrays.ignoreSimilarFromBelowByRatio.length > 0) {
                rcfBuilder.ignoreNearExpectedFromBelowByRatio(thresholdArrays.ignoreSimilarFromBelowByRatio);
            }
        }
    }
}

