/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvmstat;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.MonitoredValue;

class OracleJRockitJvmJvmstatModel
extends JvmJvmstatModel {
    private static final String PERM_GEN_PREFIX = "oracle.cls.memory.";

    OracleJRockitJvmJvmstatModel(Application app, JvmstatModel stat) {
        super(app, stat);
        this.initMonitoredVales();
    }

    private void initMonitoredVales() {
        this.loadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.loadedClasses");
        this.sharedLoadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.sharedLoadedClasses");
        this.sharedUnloadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.sharedUnloadedClasses");
        this.unloadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.unloadedClasses");
        this.threadsDaemon = this.jvmstat.findMonitoredValueByName("java.threads.daemon");
        this.threadsLive = this.jvmstat.findMonitoredValueByName("java.threads.live");
        this.threadsLivePeak = this.jvmstat.findMonitoredValueByName("java.threads.livePeak");
        this.threadsStarted = this.jvmstat.findMonitoredValueByName("java.threads.started");
        this.applicationTime = this.jvmstat.findMonitoredValueByName("sun.rt.applicationTime");
        this.upTime = this.jvmstat.findMonitoredValueByName("oracle.rt.ticks");
        MonitoredValue osFrequencyMon = this.jvmstat.findMonitoredValueByName("oracle.rt.counterFrequency");
        this.osFrequency = this.getLongValue(osFrequencyMon);
        this.genCapacity = this.jvmstat.findMonitoredValueByPattern("((jrockit.gc.pool.heap)|(oracle.cls.memory)).committed");
        this.genUsed = this.jvmstat.findMonitoredValueByPattern("((jrockit.gc.pool.heap)|(jrockit.gc.pool.nursery)|(oracle.cls.memory)).used");
        this.genMaxCapacity = this.getGenerationSum(this.jvmstat.findMonitoredValueByPattern("((jrockit.gc.pool.heap)|(oracle.cls.memory)).max"));
    }

    protected String getPermGenPrefix() {
        return PERM_GEN_PREFIX;
    }
}

