/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import org.parosproxy.paros.common.AbstractParam;

public class BreakpointsParam
extends AbstractParam {
    public static final int BUTTON_MODE_SIMPLE = 1;
    public static final int BUTTON_MODE_DUAL = 2;
    private static final String PARAM_BASE_KEY = "breakpoints";
    private static final String PARAM_CONFIRM_DROP_MESSAGE_KEY = "breakpoints.confirmDropMessage";
    private static final String PARAM_UI_BUTTON_MODE = "breakpoints.buttonMode";
    private static final String PARAM_BRK_ALWAYS_ON_TOP = "breakpoints.alwaysOnTop";
    private static final String PARAM_BRK_IN_SCOPE_ONLY = "breakpoints.inScopeOnly";
    private static final String SHOW_IGNORE_REQUESTS_BUTTONS = "breakpoints.showIgnoreRequestsButtons";
    private static final String JAVASCRIPT_URL_REGEX = "breakpoints.javaScriptUrlRegex";
    private static final String CSS_AND_FONTS_URL_REGEX = "breakpoints.cssAndFontsUrlRegex";
    private static final String MULTIMEDIA_URL_REGEX = "breakpoints.multimediaUrlRegex";
    private static final String JAVASCRIPT_URL_REGEX_DEFAULT = ".*\\.js.*";
    private static final String CSS_AND_FONTS_URL_REGEX_DEFAULT = ".*\\.(?:css|woff|woff2|ttf).*";
    private static final String MULTIMEDIA_URL_REGEX_DEFAULT = ".*\\.(?:png|gif|jpg|jpeg|svg|mp4|mp3|webm|webp|ico).*";
    private boolean confirmDropMessage = false;
    private int buttonMode = 1;
    private Boolean alwaysOnTop = null;
    private boolean inScopeOnly = false;
    private boolean showIgnoreFilesButtons = false;
    private String javascriptUrlRegex = ".*\\.js.*";
    private String cssAndFontsUrlRegex = ".*\\.(?:css|woff|woff2|ttf).*";
    private String multimediaUrlRegex = ".*\\.(?:png|gif|jpg|jpeg|svg|mp4|mp3|webm|webp|ico).*";

    @Override
    protected void parse() {
        this.confirmDropMessage = this.getBoolean(PARAM_CONFIRM_DROP_MESSAGE_KEY, false);
        this.buttonMode = this.getInt(PARAM_UI_BUTTON_MODE, 1);
        this.alwaysOnTop = this.getConfig().getBoolean(PARAM_BRK_ALWAYS_ON_TOP, null);
        this.inScopeOnly = this.getBoolean(PARAM_BRK_IN_SCOPE_ONLY, false);
        this.showIgnoreFilesButtons = this.getBoolean(SHOW_IGNORE_REQUESTS_BUTTONS, false);
        this.javascriptUrlRegex = this.getString(JAVASCRIPT_URL_REGEX, JAVASCRIPT_URL_REGEX_DEFAULT);
        this.cssAndFontsUrlRegex = this.getString(CSS_AND_FONTS_URL_REGEX, CSS_AND_FONTS_URL_REGEX_DEFAULT);
        this.multimediaUrlRegex = this.getString(MULTIMEDIA_URL_REGEX_DEFAULT, MULTIMEDIA_URL_REGEX_DEFAULT);
    }

    public boolean isConfirmDropMessage() {
        return this.confirmDropMessage;
    }

    public void setConfirmDropMessage(boolean confirmDrop) {
        if (this.confirmDropMessage != confirmDrop) {
            this.confirmDropMessage = confirmDrop;
            this.getConfig().setProperty(PARAM_CONFIRM_DROP_MESSAGE_KEY, (Object)confirmDrop);
        }
    }

    public int getButtonMode() {
        return this.buttonMode;
    }

    public void setButtonMode(int buttonMode) {
        this.buttonMode = buttonMode;
        this.getConfig().setProperty(PARAM_UI_BUTTON_MODE, (Object)buttonMode);
    }

    public Boolean getAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setAlwaysOnTop(Boolean alwaysOnTop) {
        this.alwaysOnTop = alwaysOnTop;
        this.getConfig().setProperty(PARAM_BRK_ALWAYS_ON_TOP, (Object)alwaysOnTop);
    }

    public boolean isInScopeOnly() {
        return this.inScopeOnly;
    }

    public void setInScopeOnly(boolean inScopeOnly) {
        this.inScopeOnly = inScopeOnly;
        this.getConfig().setProperty(PARAM_BRK_IN_SCOPE_ONLY, (Object)inScopeOnly);
    }

    public boolean isShowIgnoreFilesButtons() {
        return this.showIgnoreFilesButtons;
    }

    public void setShowIgnoreFilesButtons(boolean showIgnoreFilesButtons) {
        this.showIgnoreFilesButtons = showIgnoreFilesButtons;
        this.getConfig().setProperty(SHOW_IGNORE_REQUESTS_BUTTONS, (Object)showIgnoreFilesButtons);
    }

    public String getJavascriptUrlRegex() {
        return this.javascriptUrlRegex;
    }

    public void setJavascriptUrlRegex(String javascriptUrlRegex) {
        this.javascriptUrlRegex = javascriptUrlRegex;
        this.getConfig().setProperty(JAVASCRIPT_URL_REGEX, (Object)javascriptUrlRegex);
    }

    public String getCssAndFontsUrlRegex() {
        return this.cssAndFontsUrlRegex;
    }

    public void setCssAndFontsUrlRegex(String cssAndFontsUrlRegex) {
        this.cssAndFontsUrlRegex = cssAndFontsUrlRegex;
        this.getConfig().setProperty(CSS_AND_FONTS_URL_REGEX, (Object)cssAndFontsUrlRegex);
    }

    public String getMultimediaUrlRegex() {
        return this.multimediaUrlRegex;
    }

    public void setMultimediaUrlRegex(String multimediaUrlRegex) {
        this.multimediaUrlRegex = multimediaUrlRegex;
        this.getConfig().setProperty(MULTIMEDIA_URL_REGEX, (Object)multimediaUrlRegex);
    }
}

