﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace imagebuilder {
namespace Model {
class DeleteContainerRecipeResult {
 public:
  AWS_IMAGEBUILDER_API DeleteContainerRecipeResult() = default;
  AWS_IMAGEBUILDER_API DeleteContainerRecipeResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IMAGEBUILDER_API DeleteContainerRecipeResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The request ID that uniquely identifies this request.</p>
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteContainerRecipeResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the container recipe that was deleted.</p>
   */
  inline const Aws::String& GetContainerRecipeArn() const { return m_containerRecipeArn; }
  template <typename ContainerRecipeArnT = Aws::String>
  void SetContainerRecipeArn(ContainerRecipeArnT&& value) {
    m_containerRecipeArnHasBeenSet = true;
    m_containerRecipeArn = std::forward<ContainerRecipeArnT>(value);
  }
  template <typename ContainerRecipeArnT = Aws::String>
  DeleteContainerRecipeResult& WithContainerRecipeArn(ContainerRecipeArnT&& value) {
    SetContainerRecipeArn(std::forward<ContainerRecipeArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_requestId;

  Aws::String m_containerRecipeArn;
  bool m_requestIdHasBeenSet = false;
  bool m_containerRecipeArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace imagebuilder
}  // namespace Aws
