/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.Collections;
import java.util.List;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.utils.Stats;

public class VariantPlainBody
implements Variant {
    private static final String SHORT_NAME = "bodyPlain";
    private static final String STATS_NAME = "stats.ascan.variant.bodyPlain.content-type";
    private List<NameValuePair> paramList = Collections.emptyList();

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void setMessage(HttpMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Parameter message must not be null.");
        }
        if (msg.getRequestBody().length() > 0 && VariantPlainBody.isApplicableContent(msg)) {
            this.paramList = List.of(new NameValuePair(40, "", msg.getRequestBody().toString(), 0));
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.paramList;
    }

    private static boolean isApplicableContent(HttpMessage msg) {
        if (msg.getRequestHeader().getHeader("content-type") == null) {
            Stats.incCounter("stats.ascan.variant.bodyPlain.content-type.none");
            return true;
        }
        if (msg.getRequestHeader().hasContentType("text/plain")) {
            Stats.incCounter("stats.ascan.variant.bodyPlain.content-type.plain");
            return true;
        }
        return false;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        msg.getRequestBody().setBody(value);
        return value;
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        return this.setParameter(msg, originalPair, param, value);
    }
}

