/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.35 from the
 * contents of SEC.xs. Do not edit this file, edit SEC.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "SEC.xs"

#define XS_Id "$Id: SEC.xs 1777 2020-05-07 08:24:01Z willem $"


#if 0
  "Skipped embedded POD."
#endif
#line 39 "SEC.xs"


#ifdef __cplusplus
extern "C" {
#endif

#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#define OPENSSL_SUPPRESS_DEPRECATED
#include <openssl/opensslv.h>
#include <openssl/evp.h>
#include <openssl/bn.h>
#include <openssl/dsa.h>
#include <openssl/ec.h>
#include <openssl/ecdsa.h>
#include <openssl/rsa.h>

#ifdef __cplusplus
}
#endif


#ifdef OPENSSL_NO_DSA
#define NO_DSA
#endif

#ifdef OPENSSL_NO_RSA
#define NO_RSA
#endif

#ifdef OPENSSL_NO_EC
#define NO_ECCGOST
#define NO_ECDSA
#define NO_EdDSA
#endif


#ifndef OPENSSL_VERSION_NUMBER		/* 0xMNN00PP0L	retain backward compatibility */
#define OPENSSL_VERSION_NUMBER  \
	( (OPENSSL_VERSION_MAJOR<<28) | (OPENSSL_VERSION_MINOR<<20) | (OPENSSL_VERSION_PATCH<<4) | 0x0L )
#endif


#ifdef LIBRESSL_VERSION_NUMBER
#undef OPENSSL_VERSION_NUMBER
#define OPENSSL_VERSION_NUMBER 0x10100000L
#endif


#if (OPENSSL_VERSION_NUMBER < 0x10101000)
#define NO_ECCGOST
#define NO_EdDSA
#define NO_SHA3

int EVP_DigestSign(EVP_MD_CTX *ctx,
		unsigned char *sig, size_t *sig_len,
		const unsigned char *data, size_t data_len)
{
	EVP_DigestUpdate( ctx, data, data_len );
	return EVP_DigestSignFinal( ctx, sig, sig_len );
}

int EVP_DigestVerify(EVP_MD_CTX *ctx,
		const unsigned char *sig, size_t sig_len,
		const unsigned char *data, size_t data_len)
{
	EVP_DigestUpdate( ctx, data, data_len );
	return EVP_DigestVerifyFinal( ctx, sig, sig_len );
}
#endif


#if (OPENSSL_VERSION_NUMBER < 0x10100000)

#define EVP_MD_CTX_new()	EVP_MD_CTX_create()
#define EVP_MD_CTX_free(ctx)	EVP_MD_CTX_destroy((ctx))

int DSA_set0_pqg(DSA *d, BIGNUM *p, BIGNUM *q, BIGNUM *g)
{
	d->p = p;
	d->q = q;
	d->g = g;
	return 1;
}

int DSA_set0_key(DSA *d, BIGNUM *pub_key, BIGNUM *priv_key)
{
	d->priv_key = priv_key;
	d->pub_key  = pub_key;
	return 1;
}

int RSA_set0_key(RSA *r, BIGNUM *n, BIGNUM *e, BIGNUM *d)
{
	r->n = n;
	r->e = e;
	r->d = d;
	return 1;
}

int RSA_set0_factors(RSA *r, BIGNUM *p, BIGNUM *q)
{
	r->p = p;
	r->q = q;
	return 1;
}
#endif


#if (OPENSSL_VERSION_NUMBER < 0x10001000)
#define NO_ECDSA
#error	unsupported libcrypto version
#include OPENSSL_VERSION_TEXT /* in error log; by any means, however reprehensible! */
#endif


#ifndef NO_ECCGOST
BIGNUM *bn_new_hex(const char *hex)
{
	BIGNUM *bn = BN_new();
	BN_hex2bn( &bn, hex );
	return bn;
}
#endif


void checkret(const int ret, int line)
{
	if ( ret != 1 ) croak("libcrypto error (%s line %d)", __FILE__, line);
}

#define checkerr(arg)	checkret( (arg), __LINE__ )
#define nocheckerr(arg)	/* NOOP */


#line 157 "SEC.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 301 "SEC.c"

XS_EUPXS(XS_Net__DNS__SEC__libcrypto_VERSION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_VERSION)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "void");
    {
#line 184 "SEC.xs"
	char *v = SvEND( newSVpv(XS_Id, 17) );
#line 312 "SEC.c"
	SV *	RETVAL;
#line 186 "SEC.xs"
	RETVAL = newSVpvf( "%s	%s", v-5, OPENSSL_VERSION_TEXT );
#line 316 "SEC.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	EVP_PKEY *	RETVAL;

	RETVAL = EVP_PKEY_new();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EVP_PKEYPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sign); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sign)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "message, pkey, md=NULL");
    {
	SV *	RETVAL;
	SV *	message = ST(0)
;
	EVP_PKEY *	pkey;
	const EVP_MD *	md;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "EVP_PKEYPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    pkey = INT2PTR(EVP_PKEY *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_sign",
			"pkey", "EVP_PKEYPtr")
;

	if (items < 3)
	    md = NULL;
	else {
	    if (SvROK(ST(2)) && sv_derived_from(ST(2), "const EVP_MDPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(2)));
		md = INT2PTR(const EVP_MD *,tmp);
	    }
	    else
		Perl_croak_nocontext("%s: %s is not of type %s",
			    "Net::DNS::SEC::libcrypto::EVP_sign",
			    "md", "const EVP_MDPtr")
;
	}
#line 199 "SEC.xs"
	EVP_MD_CTX *ctx = EVP_MD_CTX_new();
	unsigned char *m = (unsigned char*) SvPVX(message);
	unsigned char sigbuf[512];		/* RFC3110(2) */
	STRLEN mlen = SvCUR(message);
	STRLEN slen = sizeof(sigbuf);
	int r;
#line 388 "SEC.c"
#line 206 "SEC.xs"
	checkerr( EVP_DigestSignInit( ctx, NULL, md, NULL, pkey ) );
	r = EVP_DigestSign( ctx, sigbuf, &slen, m, mlen );
	EVP_MD_CTX_free(ctx);
	EVP_PKEY_free(pkey);
	checkerr(r);
	RETVAL = newSVpvn( (char*)sigbuf, slen );
#line 396 "SEC.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_verify)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "message, signature, pkey, md=NULL");
    {
	int	RETVAL;
	dXSTARG;
	SV *	message = ST(0)
;
	SV *	signature = ST(1)
;
	EVP_PKEY *	pkey;
	const EVP_MD *	md;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "EVP_PKEYPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    pkey = INT2PTR(EVP_PKEY *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_verify",
			"pkey", "EVP_PKEYPtr")
;

	if (items < 4)
	    md = NULL;
	else {
	    if (SvROK(ST(3)) && sv_derived_from(ST(3), "const EVP_MDPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(3)));
		md = INT2PTR(const EVP_MD *,tmp);
	    }
	    else
		Perl_croak_nocontext("%s: %s is not of type %s",
			    "Net::DNS::SEC::libcrypto::EVP_verify",
			    "md", "const EVP_MDPtr")
;
	}
#line 218 "SEC.xs"
	EVP_MD_CTX *ctx = EVP_MD_CTX_new();
	unsigned char *m = (unsigned char*) SvPVX(message);
	unsigned char *s = (unsigned char*) SvPVX(signature);
	STRLEN mlen = SvCUR(message);
	STRLEN slen = SvCUR(signature);
#line 449 "SEC.c"
#line 224 "SEC.xs"
	checkerr( EVP_DigestVerifyInit( ctx, NULL, md, NULL, pkey ) );
	RETVAL = EVP_DigestVerify( ctx, s, slen, m, mlen );
	EVP_MD_CTX_free(ctx);
	EVP_PKEY_free(pkey);
#line 455 "SEC.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	EVP_MD_CTX *	RETVAL;

	RETVAL = EVP_MD_CTX_new();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EVP_MD_CTXPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	EVP_MD_CTX *	ctx;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EVP_MD_CTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ctx = INT2PTR(EVP_MD_CTX *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_MD_CTX_free",
			"ctx", "EVP_MD_CTXPtr")
;

	EVP_MD_CTX_free(ctx);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestInit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestInit)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, type");
    {
	EVP_MD_CTX *	ctx;
	const EVP_MD *	type;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EVP_MD_CTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ctx = INT2PTR(EVP_MD_CTX *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_DigestInit",
			"ctx", "EVP_MD_CTXPtr")
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "const EVP_MDPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    type = INT2PTR(const EVP_MD *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_DigestInit",
			"type", "const EVP_MDPtr")
;
#line 241 "SEC.xs"
	checkerr( EVP_DigestInit( ctx, type ) );
#line 539 "SEC.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestUpdate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestUpdate)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, message");
    {
	EVP_MD_CTX *	ctx;
	SV *	message = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EVP_MD_CTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ctx = INT2PTR(EVP_MD_CTX *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_DigestUpdate",
			"ctx", "EVP_MD_CTXPtr")
;
#line 246 "SEC.xs"
	unsigned char *m = (unsigned char*) SvPVX(message);
	unsigned int mlen = SvCUR(message);
#line 568 "SEC.c"
#line 249 "SEC.xs"
	checkerr( EVP_DigestUpdate( ctx, m, mlen ) );
#line 571 "SEC.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestFinal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestFinal)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SV *	RETVAL;
	EVP_MD_CTX *	ctx;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EVP_MD_CTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ctx = INT2PTR(EVP_MD_CTX *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_DigestFinal",
			"ctx", "EVP_MD_CTXPtr")
;
#line 254 "SEC.xs"
	unsigned char digest[EVP_MAX_MD_SIZE];
	unsigned int size = sizeof(digest);
	const EVP_MD *type = EVP_MD_CTX_md( ctx );
#line 600 "SEC.c"
#line 258 "SEC.xs"
	checkerr( EVP_DigestFinal( ctx, digest, &size ) );
	checkerr( EVP_DigestInit( ctx, type ) );	/* reinitialise; behave like Digest::SHA */
	RETVAL = newSVpvn( (char*)digest, size );
#line 605 "SEC.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_md5); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_md5)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_md5();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha1)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha1();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha224); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha224)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha224();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha256); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha256)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha256();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha384); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha384)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha384();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha512); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha512)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha512();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#ifndef NO_SHA3
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha3_224); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha3_224)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha3_224();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha3_256); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha3_256)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha3_256();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha3_384); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha3_384)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha3_384();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha3_512); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha3_512)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha3_512();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#ifndef NO_DSA
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_assign_DSA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_assign_DSA)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pkey, key");
    {
	EVP_PKEY *	pkey;
	DSA *	key;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EVP_PKEYPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    pkey = INT2PTR(EVP_PKEY *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_PKEY_assign_DSA",
			"pkey", "EVP_PKEYPtr")
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "DSAPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    key = INT2PTR(DSA *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_PKEY_assign_DSA",
			"key", "DSAPtr")
;
#line 307 "SEC.xs"
	checkerr( EVP_PKEY_assign( pkey, EVP_PKEY_DSA, (char*)key ) );
#line 861 "SEC.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_DSA_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_DSA_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	DSA *	RETVAL;

	RETVAL = DSA_new();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "DSAPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_DSA_set0_pqg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_DSA_set0_pqg)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "d, p_SV, q_SV, g_SV");
    {
	DSA *	d;
	SV *	p_SV = ST(1)
;
	SV *	q_SV = ST(2)
;
	SV *	g_SV = ST(3)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "DSAPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    d = INT2PTR(DSA *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::DSA_set0_pqg",
			"d", "DSAPtr")
;
#line 315 "SEC.xs"
	BIGNUM *p = BN_bin2bn( (unsigned char*) SvPVX(p_SV), SvCUR(p_SV), NULL );
	BIGNUM *q = BN_bin2bn( (unsigned char*) SvPVX(q_SV), SvCUR(q_SV), NULL );
	BIGNUM *g = BN_bin2bn( (unsigned char*) SvPVX(g_SV), SvCUR(g_SV), NULL );
#line 916 "SEC.c"
#line 319 "SEC.xs"
	checkerr( DSA_set0_pqg( d, p, q, g ) );
#line 919 "SEC.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_DSA_set0_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_DSA_set0_key)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "dsa, y_SV, x_SV");
    {
	DSA *	dsa;
	SV *	y_SV = ST(1)
;
	SV *	x_SV = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "DSAPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    dsa = INT2PTR(DSA *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::DSA_set0_key",
			"dsa", "DSAPtr")
;
#line 324 "SEC.xs"
	BIGNUM *x = BN_bin2bn( (unsigned char*) SvPVX(x_SV), SvCUR(x_SV), NULL );
	BIGNUM *y = BN_bin2bn( (unsigned char*) SvPVX(y_SV), SvCUR(y_SV), NULL );
#line 950 "SEC.c"
#line 327 "SEC.xs"
	checkerr( DSA_set0_key( dsa, y, x ) );
#line 953 "SEC.c"
    }
    XSRETURN_EMPTY;
}

#endif
#ifndef NO_RSA
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_assign_RSA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_assign_RSA)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pkey, key");
    {
	EVP_PKEY *	pkey;
	RSA *	key;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EVP_PKEYPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    pkey = INT2PTR(EVP_PKEY *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_PKEY_assign_RSA",
			"pkey", "EVP_PKEYPtr")
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "RSAPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    key = INT2PTR(RSA *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_PKEY_assign_RSA",
			"key", "RSAPtr")
;
#line 339 "SEC.xs"
	checkerr( EVP_PKEY_assign( pkey, EVP_PKEY_RSA, (char*)key ) );
#line 994 "SEC.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_RSA_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_RSA_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	RSA *	RETVAL;

	RETVAL = RSA_new();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "RSAPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_RSA_set0_factors); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_RSA_set0_factors)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "r, p_SV, q_SV");
    {
	RSA *	r;
	SV *	p_SV = ST(1)
;
	SV *	q_SV = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "RSAPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    r = INT2PTR(RSA *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::RSA_set0_factors",
			"r", "RSAPtr")
;
#line 347 "SEC.xs"
	BIGNUM *p = BN_bin2bn( (unsigned char*) SvPVX(p_SV), SvCUR(p_SV), NULL );
	BIGNUM *q = BN_bin2bn( (unsigned char*) SvPVX(q_SV), SvCUR(q_SV), NULL );
#line 1046 "SEC.c"
#line 350 "SEC.xs"
	checkerr( RSA_set0_factors( r, p, q ) );
#line 1049 "SEC.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_RSA_set0_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_RSA_set0_key)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "r, n_SV, e_SV, d_SV");
    {
	RSA *	r;
	SV *	n_SV = ST(1)
;
	SV *	e_SV = ST(2)
;
	SV *	d_SV = ST(3)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "RSAPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    r = INT2PTR(RSA *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::RSA_set0_key",
			"r", "RSAPtr")
;
#line 355 "SEC.xs"
	BIGNUM *d = BN_bin2bn( (unsigned char*) SvPVX(d_SV), SvCUR(d_SV), NULL );
	BIGNUM *e = BN_bin2bn( (unsigned char*) SvPVX(e_SV), SvCUR(e_SV), NULL );
	BIGNUM *n = BN_bin2bn( (unsigned char*) SvPVX(n_SV), SvCUR(n_SV), NULL );
#line 1083 "SEC.c"
#line 359 "SEC.xs"
	checkerr( RSA_set0_key( r, n, e, d ) );
#line 1086 "SEC.c"
    }
    XSRETURN_EMPTY;
}

#endif
#ifndef NO_ECDSA
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_assign_EC_KEY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_assign_EC_KEY)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pkey, key");
    {
	EVP_PKEY *	pkey;
	EC_KEY *	key;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EVP_PKEYPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    pkey = INT2PTR(EVP_PKEY *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_PKEY_assign_EC_KEY",
			"pkey", "EVP_PKEYPtr")
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "EC_KEYPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    key = INT2PTR(EC_KEY *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EVP_PKEY_assign_EC_KEY",
			"key", "EC_KEYPtr")
;
#line 371 "SEC.xs"
	checkerr( EVP_PKEY_assign( pkey, EVP_PKEY_EC, (char*)key ) );
#line 1127 "SEC.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EC_KEY_new_by_curve_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EC_KEY_new_by_curve_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "nid");
    {
	EC_KEY *	RETVAL;
	int	nid = (int)SvIV(ST(0))
;

	RETVAL = EC_KEY_new_by_curve_name(nid);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EC_KEYPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EC_KEY_set_private_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EC_KEY_set_private_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "key, prv_SV");
    {
	EC_KEY *	key;
	SV *	prv_SV = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EC_KEYPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    key = INT2PTR(EC_KEY *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EC_KEY_set_private_key",
			"key", "EC_KEYPtr")
;
#line 380 "SEC.xs"
	BIGNUM *prv = BN_bin2bn( (unsigned char*) SvPVX(prv_SV), SvCUR(prv_SV), NULL );
	int status;
#line 1179 "SEC.c"
#line 383 "SEC.xs"
	status = EC_KEY_set_private_key( key, prv );
	BN_clear_free(prv);
	checkerr(status);
#line 1184 "SEC.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EC_KEY_set_public_key_affine_coordinates); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EC_KEY_set_public_key_affine_coordinates)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "key, x_SV, y_SV");
    {
	EC_KEY *	key;
	SV *	x_SV = ST(1)
;
	SV *	y_SV = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EC_KEYPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    key = INT2PTR(EC_KEY *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::EC_KEY_set_public_key_affine_coordinates",
			"key", "EC_KEYPtr")
;
#line 390 "SEC.xs"
	BIGNUM *x = BN_bin2bn( (unsigned char*) SvPVX(x_SV), SvCUR(x_SV), NULL );
	BIGNUM *y = BN_bin2bn( (unsigned char*) SvPVX(y_SV), SvCUR(y_SV), NULL );
	int status;
#line 1216 "SEC.c"
#line 394 "SEC.xs"
	status = EC_KEY_set_public_key_affine_coordinates( key, x, y );
	BN_free(x);
	BN_free(y);
	checkerr(status);
#line 1222 "SEC.c"
    }
    XSRETURN_EMPTY;
}

#endif
#ifndef NO_EdDSA
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_raw_private_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_raw_private_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "nid, key");
    {
	EVP_PKEY *	RETVAL;
	int	nid = (int)SvIV(ST(0))
;
	SV *	key = ST(1)
;
#line 409 "SEC.xs"
	RETVAL = EVP_PKEY_new_raw_private_key( nid, NULL, (unsigned char*) SvPVX(key) , SvCUR(key) );
#line 1246 "SEC.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EVP_PKEYPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_raw_public_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_raw_public_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "nid, key");
    {
	EVP_PKEY *	RETVAL;
	int	nid = (int)SvIV(ST(0))
;
	SV *	key = ST(1)
;
#line 416 "SEC.xs"
	RETVAL = EVP_PKEY_new_raw_public_key( nid, NULL, (unsigned char*) SvPVX(key) , SvCUR(key) );
#line 1272 "SEC.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EVP_PKEYPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#ifndef NO_ECCGOST
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EC_KEY_new_ECCGOST); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EC_KEY_new_ECCGOST)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 432 "SEC.xs"
	BIGNUM *a = bn_new_hex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD94");
	BIGNUM *b = bn_new_hex("00A6");
	BIGNUM *p = bn_new_hex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD97");
	BIGNUM *q = bn_new_hex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF6C611070995AD10045841B09B761B893");
	BIGNUM *x = bn_new_hex("01");
	BIGNUM *y = bn_new_hex("8D91E471E0989CDA27DF505A453F2B7635294F2DDF23E3B122ACC99C9E9F1E14");
	BIGNUM *h = bn_new_hex("01");
	BN_CTX *ctx = BN_CTX_new();
	EC_GROUP *group = EC_GROUP_new_curve_GFp(p, a, b, ctx);
	EC_POINT *G = EC_POINT_new(group);
#line 1306 "SEC.c"
	EC_KEY *	RETVAL;
#line 443 "SEC.xs"
	checkerr( EC_POINT_set_affine_coordinates(group, G, x, y, ctx) );
	checkerr( EC_GROUP_set_generator(group, G, q, h) );
	EC_POINT_free(G);
	BN_free(a);
	BN_free(b);
	BN_free(p);
	BN_free(q);
	BN_free(x);
	BN_free(y);
	BN_free(h);
	nocheckerr( EC_GROUP_check(group, ctx) );
	BN_CTX_free(ctx);
	RETVAL = EC_KEY_new();
	checkerr( EC_KEY_set_group(RETVAL, group) );
	EC_GROUP_free(group);
#line 1324 "SEC.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EC_KEYPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_ECCGOST_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_ECCGOST_verify)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "H, r_SV, s_SV, eckey");
    {
	int	RETVAL;
	dXSTARG;
	SV *	H = ST(0)
;
	SV *	r_SV = ST(1)
;
	SV *	s_SV = ST(2)
;
	EC_KEY *	eckey;

	if (SvROK(ST(3)) && sv_derived_from(ST(3), "EC_KEYPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(3)));
	    eckey = INT2PTR(EC_KEY *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"Net::DNS::SEC::libcrypto::ECCGOST_verify",
			"eckey", "EC_KEYPtr")
;
#line 464 "SEC.xs"
	STRLEN len = SvCUR(H);
	unsigned char *bin = (unsigned char*) SvPVX(H);
	BIGNUM *alpha = BN_bin2bn( bin, len, NULL );
	BIGNUM *r = BN_bin2bn( (unsigned char*) SvPVX(r_SV), SvCUR(r_SV), NULL );
	BIGNUM *s = BN_bin2bn( (unsigned char*) SvPVX(s_SV), SvCUR(s_SV), NULL );
	const EC_GROUP *group = EC_KEY_get0_group(eckey);
	BN_CTX *ctx = BN_CTX_new();
	BIGNUM *e = BN_new();
	BIGNUM *m = BN_new();
	BIGNUM *q = BN_new();
	ECDSA_SIG *ecsig = ECDSA_SIG_new();
#line 1374 "SEC.c"
#line 476 "SEC.xs"
	checkerr( EC_GROUP_get_order(group, q, ctx) );
	checkerr( BN_mod(e, alpha, q, ctx) );
	if ( BN_is_zero(e) ) BN_set_word(e, 1);
	BN_free(alpha);

	/* algebraic transformation of ECC-GOST into equivalent ECDSA problem */
	checkerr( BN_mod_sub(m, q, s, q, ctx) );
	checkerr( BN_mod_sub(s, q, e, q, ctx) );
	BN_free(e);
	BN_free(q);

	checkerr( ECDSA_SIG_set0(ecsig, r, s) );

	BN_bn2binpad(m, bin, len);
	BN_free(m);
	RETVAL = ECDSA_do_verify( bin, len, ecsig, eckey );
	BN_CTX_free(ctx);
	EC_KEY_free(eckey);
	ECDSA_SIG_free(ecsig);
#line 1395 "SEC.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__DNS__SEC__libcrypto_checkerr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_checkerr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ret");
    {
	int	ret = (int)SvIV(ST(0))
;
#line 505 "SEC.xs"
	checkerr(ret);
#line 1414 "SEC.c"
    }
    XSRETURN_EMPTY;
}

#ifdef croak_memory_wrap
#define XSubPPtmpAAAG 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_croak_memory_wrap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_croak_memory_wrap)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	croak_memory_wrap();
    }
    XSRETURN_EMPTY;
}

#endif
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Net__DNS__SEC); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Net__DNS__SEC)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::VERSION", XS_Net__DNS__SEC__libcrypto_VERSION, file, "$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_PKEY_new", XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sign", XS_Net__DNS__SEC__libcrypto_EVP_sign, file, "$$;$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_verify", XS_Net__DNS__SEC__libcrypto_EVP_verify, file, "$$$;$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_MD_CTX_new", XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_new, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_MD_CTX_free", XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_free, file, "$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_DigestInit", XS_Net__DNS__SEC__libcrypto_EVP_DigestInit, file, "$$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_DigestUpdate", XS_Net__DNS__SEC__libcrypto_EVP_DigestUpdate, file, "$$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_DigestFinal", XS_Net__DNS__SEC__libcrypto_EVP_DigestFinal, file, "$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_md5", XS_Net__DNS__SEC__libcrypto_EVP_md5, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha1", XS_Net__DNS__SEC__libcrypto_EVP_sha1, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha224", XS_Net__DNS__SEC__libcrypto_EVP_sha224, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha256", XS_Net__DNS__SEC__libcrypto_EVP_sha256, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha384", XS_Net__DNS__SEC__libcrypto_EVP_sha384, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha512", XS_Net__DNS__SEC__libcrypto_EVP_sha512, file, "");
#if XSubPPtmpAAAA
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha3_224", XS_Net__DNS__SEC__libcrypto_EVP_sha3_224, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha3_256", XS_Net__DNS__SEC__libcrypto_EVP_sha3_256, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha3_384", XS_Net__DNS__SEC__libcrypto_EVP_sha3_384, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha3_512", XS_Net__DNS__SEC__libcrypto_EVP_sha3_512, file, "");
#endif
#if XSubPPtmpAAAB
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_PKEY_assign_DSA", XS_Net__DNS__SEC__libcrypto_EVP_PKEY_assign_DSA, file, "$$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::DSA_new", XS_Net__DNS__SEC__libcrypto_DSA_new, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::DSA_set0_pqg", XS_Net__DNS__SEC__libcrypto_DSA_set0_pqg, file, "$$$$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::DSA_set0_key", XS_Net__DNS__SEC__libcrypto_DSA_set0_key, file, "$$$");
#endif
#if XSubPPtmpAAAC
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_PKEY_assign_RSA", XS_Net__DNS__SEC__libcrypto_EVP_PKEY_assign_RSA, file, "$$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::RSA_new", XS_Net__DNS__SEC__libcrypto_RSA_new, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::RSA_set0_factors", XS_Net__DNS__SEC__libcrypto_RSA_set0_factors, file, "$$$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::RSA_set0_key", XS_Net__DNS__SEC__libcrypto_RSA_set0_key, file, "$$$$");
#endif
#if XSubPPtmpAAAD
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_PKEY_assign_EC_KEY", XS_Net__DNS__SEC__libcrypto_EVP_PKEY_assign_EC_KEY, file, "$$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EC_KEY_new_by_curve_name", XS_Net__DNS__SEC__libcrypto_EC_KEY_new_by_curve_name, file, "$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EC_KEY_set_private_key", XS_Net__DNS__SEC__libcrypto_EC_KEY_set_private_key, file, "$$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EC_KEY_set_public_key_affine_coordinates", XS_Net__DNS__SEC__libcrypto_EC_KEY_set_public_key_affine_coordinates, file, "$$$");
#endif
#if XSubPPtmpAAAE
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_PKEY_new_raw_private_key", XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_raw_private_key, file, "$$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_PKEY_new_raw_public_key", XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_raw_public_key, file, "$$");
#endif
#if XSubPPtmpAAAF
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EC_KEY_new_ECCGOST", XS_Net__DNS__SEC__libcrypto_EC_KEY_new_ECCGOST, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::ECCGOST_verify", XS_Net__DNS__SEC__libcrypto_ECCGOST_verify, file, "$$$$");
#endif
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::checkerr", XS_Net__DNS__SEC__libcrypto_checkerr, file, "$");
#if XSubPPtmpAAAG
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::croak_memory_wrap", XS_Net__DNS__SEC__libcrypto_croak_memory_wrap, file, "");
#endif

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#if XSubPPtmpAAAG
#endif
#line 1533 "SEC.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

