/* Copyright (C) 2002 Mickael Marchand <marchand@kde.org>

	 This program is free software; you can redistribute it and/or
	 modify it under the terms of the GNU General Public
	 License as published by the Free Software Foundation; either
	 version 2 of the License, or (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	 General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; see the file COPYING.  If not, write to
	 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	 Boston, MA 02111-1307, USA.
	 */

#include <klocale.h>

#include "xvim_win.h"

XVim_Win::XVim_Win(QWidget *parent) : QWidget (parent) {
	vbl = new QVBoxLayout(this);
	gb = new QVButtonGroup(i18n("Select Mode"),this);
	gb->setRadioButtonExclusive(true);
	eval = new QRadioButton(i18n("Evaluate expressions"),gb);
	eval->setChecked(true);
	keys = new QRadioButton(i18n("Send keys"),gb);
	server = new KLineEdit(this); //servername
	command = new KLineEdit(this); //command line
	result = new QLabel(this); //expressions result
	xvim = new XVim();

	vbl->addWidget(gb);
	vbl->addWidget(server);
	vbl->addWidget(command);
	vbl->addWidget(result);

	connect (command,SIGNAL(returnPressed(const QString &)), this,SLOT(execute(const QString &)));
	setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding));
}

XVim_Win::~XVim_Win() {
}

void XVim_Win::execute(const QString &cmd) {
	int code=0;
	char *res;
	res = xvim->sendToVim(qt_xdisplay(), server->text().latin1(),
					cmd.latin1(),
				 	eval->isChecked() ? 0 : 1,
					&code);
	if (code!=0 && res==NULL) {
		result->setText(i18n("Error code: %1").arg(code) );
	} else if (res) {
		result->setText(i18n("Result: %1").arg(res));
	}
}

#include "xvim_win.moc"
