#include "kmwnewconfig.h"
KmwConfigurator::KmwConfigurator(QWidget *parent, const char *name) : KmwConfig(parent, name)
{
	themeID=0L;
	config = kapp->config();
	grabData();
	enableSilly(); //this just enables sylables section or not...
}

KmwConfigurator::~KmwConfigurator()
{

}

void KmwConfigurator::grabData()
{
	themeSelector->clear();

	config->setGroup("Theme");
	themeName=config->readEntry("Name","default");

	QDir d(locate("data","kmessedwords/themes/")); //the theme directory...
	d.setFilter( QDir::Dirs);
	d.setSorting( QDir::Name);

	for ( unsigned int i=0; i<d.count(); i++ ) {
	 	if ((d[i] != ".") && (d[i] != "..")) {
			themeSelector->insertItem(d[i]);
			kdDebug() << d[i] << endl;
			if (d[i]==themeName){
				themeID=i-2;
			}
		}
	}


	config->setGroup("Theme");
	themeSelector->setCurrentItem(themeID);
	chkThmSnd->setChecked(config->readBoolEntry("Sound",false));
	chkBgPix->setChecked(config->readBoolEntry("Background",true));
	chkBtnPix->setChecked(config->readBoolEntry("Buttons",false));

	config->setGroup("Environment");
	chkGfxStyle->setChecked(config->readBoolEntry("UseGfxStyle",true));

	QString shareLoginName;
	shareLoginName=config->readEntry("GamerName", "");

	struct passwd* pw;
	if (shareLoginName.isEmpty()) {
		pw = getpwuid(getuid());
		if (pw) {
			shareLoginName = pw->pw_gecos;
			int i = shareLoginName.find(',');
			if (i>0)
				shareLoginName.truncate(i);
		}
	}
	nameEdit->setText(config->readEntry("GamerName", shareLoginName));

//we load the memorized syllables support...
	config->setGroup("Syllables");
	chkMemSilly->setChecked(config->readBoolEntry("MemSilly", true));
	chkSilly->setChecked(config->readBoolEntry("UseSilly",false));
	globalSillyFile= config->readEntry("SillyFile", "");
// ^-- is this "safe"?
}

void KmwConfigurator::slotOk()
{
	config->setGroup("Theme");
	config->writeEntry("Name",themeSelector->currentText());
	config->writeEntry("Sound", chkThmSnd->isChecked());
	config->writeEntry("Background", chkBgPix->isChecked());
	config->writeEntry("Buttons",chkBtnPix->isChecked());

	config->setGroup("Environment");
	config->writeEntry("UseGfxStyle",chkGfxStyle->isChecked());
	config->writeEntry("GamerName", nameEdit->text());

	config->setGroup("Syllables");
	config->writeEntry("UseSilly",chkSilly->isChecked());
	config->writeEntry("SillyFile", globalSillyFile);
	config->writeEntry("MemSilly", chkMemSilly->isChecked());
	config->sync();

	emit sig_reload();

	close();
}

void KmwConfigurator::slotCancel()
{
	grabData();
	close();
}

void KmwConfigurator::slotLoadSillyFile()
{
	QString getOpenedFile=KFileDialog::getOpenFileName(QString::null, QString::null, this, i18n("Open File"));
	if (! getOpenedFile.isEmpty() )
	{
		globalSillyFile=getOpenedFile;
		showSillyFile->setText("File: " + getOpenedFile);
	}
}

void KmwConfigurator::enableSilly()
{
	showSillyFile->setEnabled(chkSilly->isChecked());
	btnLoadSilly->setEnabled(chkSilly->isChecked());
	chkMemSilly->setEnabled(chkSilly->isChecked());
}

#include "kmwnewconfig.moc"
