/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2003	  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef CATALOGMANAGERPREF_H
#define CATALOGMANAGERPREF_H

#include <kdialogbase.h>
#include <qptrlist.h>

#include "settings.h"

class GeneralPreferences;
class DirCommandsPreferences;
class FileCommandsPreferences;
class ViewPreferences;

class CatalogManagerPreferences : public KDialogBase
{
    Q_OBJECT
public:
    CatalogManagerPreferences(CatManSettings);
    
    void mergeSettings(CatManSettings&);

public slots:
    void updateCatManSettings(CatManSettings);

signals:
    void catmanOptionsChanged(CatManSettings);

protected slots:
   virtual void slotHelp();
   virtual void slotDefault();
   virtual void slotApply();
   virtual void slotOk();
   virtual void slotCancel();


private:
    GeneralPreferences *_generalPage;
    DirCommandsPreferences *_dirCommandsPage;
    FileCommandsPreferences *_fileCommandsPage;
    ViewPreferences *_viewPage;

    CatManSettings _catmanSettings;
};


#endif // CATALOGMANAGERPREF_H
