/***************************************************************************
                          sigslotview.cpp  -  description
                             -------------------
    begin                : Tue May 1 2001
    copyright            : (C) 2001 by Richard Moore
    email                : rich@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qobjectlist.h>
#include <qobjectdict.h>
#include <qmetaobject.h>
#include <qstrlist.h>
#include <qvariant.h>

#include "sigslotview.h"

SigSlotView::SigSlotView(QWidget *parent, const char *name ) : QListView(parent,name)
{
  addColumn( "Signals/Slots" );
  //  addColumn( "Connections" );

  setRootIsDecorated( true );
  setAllColumnsShowFocus( true );
}

SigSlotView::~SigSlotView()
{
}

void SigSlotView::buildList( QObject *o )
{
  QMetaObject *mo = o->metaObject();

  QListViewItem *sigs = new QListViewItem( this, "Signals" );
  QStrList sigList = mo->signalNames( true );
  QStrListIterator sigIt( sigList );
  char *si;
  while ( (si=sigIt.current()) != 0 ) {
    ++sigIt;
    new QListViewItem( sigs, si /*, "someSlot()"*/ );
  }

  QListViewItem *slts = new QListViewItem( this, "Slots" );
  QStrList sltList = mo->slotNames( true );
  QStrListIterator sltIt( sltList );
  char *sl;
  while ( (sl=sltIt.current()) != 0 ) {
    ++sltIt;
    new QListViewItem( sigs, sl/*, "someSlot()"*/ );
  }

  setOpen( sigs, true );
  setOpen( slts, true );
}

void SigSlotView::setTarget( QObject *o )
{
  clear();
  buildList( o );
}

#include "sigslotview.moc"
