/*
 * palmpix.c:  Translate PalmPix image format
 *
 * Copyright 2001 Angus Ainslie <angusa@deltatee.com>
 * Copyright 2001 John Marshall <jmarshall@acm.org>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if HAVE_STDINT_H
# include <stdint.h>
#else
# if HAVE_INTTYPES_H
#  include <inttypes.h>
# else

#  ifndef uint8_t
#   define uint8_t unsigned char
#  endif

#  ifndef uint16_t
#   define uint16_t unsigned short
#  endif

#  ifndef uint32_t
#   define uint32_t unsigned long
#  endif

#  ifndef int8_t
#   define int8_t char
#  endif

#  ifndef int16_t
#   define int16_t short
#  endif

#  ifndef int32_t
#   define int32_t long
#  endif

# endif /* HAVE_INTTYPES_H */
#endif /* HAVE_STDINT_H */

#include "pi-macros.h"
#include "pi-palmpix.h"

void DecodeRow(uint8_t *compData, uint8_t *lastRow, uint8_t *unCompData,
               uint32_t *offset, int32_t *firstWord, int16_t *PPLutsW,
               uint8_t *PPLuts, uint16_t halfWidth);

uint8_t huffWidth[] = {
   0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x0c,0x0c,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
     0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
     0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
     0x0a,0x0a,0x0a,0x0a,0x0b,0x0b,0x0c,0x0c
};

uint16_t huffTable[] = 
{
   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,0xfffd,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,
     0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,
     0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,
     0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,
     0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,0xffe8,
     0xff60,0xff7b,0xffa5,0xffa5,0xffbd,0xffbd,0xffbd,0xffbd,
     0xffd0,0xffd0,0xffd0,0xffd0,0xffd0,0xffd0,0xffd0,0xffd0,
     0xffdc,0xffdc,0xffdc,0xffdc,0xffdc,0xffdc,0xffdc,0xffdc,
     0xffdc,0xffdc,0xffdc,0xffdc,0xffdc,0xffdc,0xffdc,0xffdc,
     0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,
     0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,
     0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,
     0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,
     0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,
     0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,
     0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,
     0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,0xffef,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,0xfffa,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,0x000d,
     0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
     0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
     0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
     0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
     0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
     0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
     0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
     0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
     0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,
     0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,
     0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,
     0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,
     0x0024,0x0024,0x0024,0x0024,0x0024,0x0024,0x0024,0x0024,
     0x0024,0x0024,0x0024,0x0024,0x0024,0x0024,0x0024,0x0024,
     0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,
     0x0043,0x0043,0x0043,0x0043,0x005b,0x005b,0x0085,0x00a0
};

/****************************************************************
 * Bias
 * 
 * Bias is based on the Fast Alternative to Perlin's Bias algorithm 
 * in Graphics Gems IV by
 * Christophe Schlick schlick@labri.u-bordeuax.fr
 *****************************************************************/
  
static void Bias( float bias, int width, int height, uint8_t *data )
{
   int i;
   float num, denom, t;
      
   for( i=0; i<width*height; i++ )
     {
	t = (float)data[i]/256.0;
	num = t;
	denom = (1.0/bias - 2) * (1.0 - t) + 1;
	data[i] = num/denom * 256.0;     
     }
}

static void Interpolate( const struct PalmPixHeader *pixHdr, uint8_t *red, uint8_t *greenR, uint8_t *greenB, uint8_t *blue, uint8_t *pp, int offset_r, int offset_g, int offset_b )
{
   int idx, offset, ppOff;
   int x, y, rowOff;
   uint8_t r, g, b;
   int rawWidth = pixHdr->w/2;
   
   for( y=1; y<pixHdr->h-1; y++ )
     {
	
	idx = y/2;
	offset = idx * rawWidth;
	ppOff = y * pixHdr->w;
	
	if( y%2 == 1 )
	  {
	     for( x=1; x<rawWidth-1; x++ )
	       {
		  
		  rowOff = x*2;
		  
		  r = (red[offset+x-1] + red[offset + x] + red[offset + rawWidth + x -1] + red[offset + rawWidth + x])>>2;
		  g = (greenR[offset+x] + greenR[offset+x+rawWidth] + greenB[offset + x - 1] + greenB[offset + x])>>2;
		  b = blue[offset + x];
		  pp[3 * (ppOff + rowOff) + offset_r] = r;
		  pp[3 * (ppOff + rowOff) + offset_g] = g;
		  pp[3 * (ppOff + rowOff) + offset_b] = b;
		  
		  r = (red[offset + x] + red[offset + rawWidth + x])>>1;
		  g = greenB[offset + x];
		  b = (blue[offset + x] + blue[offset + x + 1])>>1;
		  pp[3 * (ppOff + rowOff + 1) + offset_r] = r;
		  pp[3 * (ppOff + rowOff + 1) + offset_g] = g;
		  pp[3 * (ppOff + rowOff + 1) + offset_b] = b;
		  
	       }
	  }
	else
	  {
	     for( x=1; x<rawWidth-1; x++ )
	       {
		  rowOff = x*2;
		  
		  r = (red[offset + x - 1] + red[offset + x])>>1;
		  g = greenR[offset + x];
		  b = (blue[offset-rawWidth+x] + blue[offset+x])>>1;
		  pp[3 * (ppOff + rowOff) + offset_r] = r;
		  pp[3 * (ppOff + rowOff) + offset_g] = g;
		  pp[3 * (ppOff + rowOff) + offset_b] = b;
		  
		  r = red[offset+x];
		  g = (greenR[offset+x] + greenR[offset+x+1] + greenB[offset-rawWidth+x] + greenB[offset + x])>>2;
		  b = (blue[offset+x-rawWidth] + blue[offset+x-rawWidth-1] + blue[offset+x] + blue[offset+x+1])>>2;
		  pp[3 * (ppOff + rowOff + 1) + offset_r] = r;
		  pp[3 * (ppOff + rowOff + 1) + offset_g] = g;
		  pp[3 * (ppOff + rowOff + 1) + offset_b] = b;
		  
	       }
	  }
     }
   
}

void DecodeRow( uint8_t *compData, uint8_t *lastRow, uint8_t *unCompData, uint32_t *offset, int32_t *firstWord, int16_t *PPLutsW, uint8_t *PPLuts, uint16_t halfWidth )
{
   uint8_t *saveStartP, shiftOut;
   int16_t tmpW3, tmpResult, tmpW0, idx, resultW;
   uint32_t lutIdx, tmpL0, tmpL2, tmpL5;
   
   saveStartP = compData;

   tmpW3 = 32 - *firstWord;

   tmpResult = 32 - tmpW3;
   
   tmpL5 = compData[0]<<24 | compData[1]<<16 | compData[2]<<8 | compData[3] ;
   tmpL5 = tmpL5<<tmpResult;
   tmpL0 = tmpL5;
   
   compData += 4;
   
   tmpL0 = tmpL0 >> 24;
   
   unCompData[0] = (uint8_t)tmpL0;
   
   tmpL5 = tmpL5 << 8;
   tmpW3 = tmpW3 - 8;
   idx = 1;           
   
   while( idx < halfWidth )
     {
	if( tmpW3 < 12 )
	  {
	     tmpW0 = 16 - tmpW3;
	     tmpL2 = ( compData[0]<<8 | compData[1] ) << tmpW0;
	     tmpL5 = tmpL5 | tmpL2;
	     tmpW3 += 16;
	     compData += 2;
	  }

	lutIdx = tmpL5 >> 20;

	shiftOut = PPLuts[lutIdx];

	tmpL5 = tmpL5 << shiftOut;
	
	tmpW3 = tmpW3 - shiftOut;
	
	resultW = ( unCompData[idx-1] + lastRow[idx] ) >> 1;
	
	resultW = resultW + PPLutsW[lutIdx];
	
	if( resultW > 255 )
	  resultW = 255;
	
	if( resultW < 0 ) 
	  resultW = 0;
	
	unCompData[idx++] = (uint8_t)resultW;
	  
     }
   
   while( tmpW3 > 0 )
     {
	compData--;
	tmpW3 -= 8;
     }
     
   *offset = compData - saveStartP;
   *firstWord = -tmpW3;

}

/* A binary PalmPixHeader is a record of length 196 in the following format.
       Note that multibyte integers are in little endian byte order -- they are
       NOT in m68k byte order.
    
        0UInt8 numRec;
        1UInt8 s0;		// Always zero
        2UInt8 month;
        3UInt8 day;
        4UInt8 cent;
        5UInt8 year;
        6UInt8 hour;
        7UInt8 min;
        8UInt8 sec;
        9UInt8 resolution;  	// 640x480 = 1, 320x240 = 2, 400x300 = 3, 800x600 = 4
       10UInt16 w;
       12UInt16 h;
       14UInt16 thumbLen;	// Size of the thumbnail following the name
       16UInt16 GRsize;
       18UInt8 sep0;
       19UInt16 Rsize;
       21UInt8 sep1;
       22UInt16 Bsize;
       24UInt8 sep2;
       25UInt16 GBsize;
       27UInt16 pad1;
       29UInt16 num;		// hires 1200, lowres 300
       31UInt8 resA[14];
       45UInt8 zoom;
       46UInt8 softMajor;	// Always 0x0102  [see below]
       47UInt8 softMinor;	// Always 0x0102  [see below]
       48UInt8 resB[34];
       82UInt16 dir[57];
    
       */
  
  
  /* The remainder is due to John Marshall.  It is pretty trivial compared to
       the analysis above.  */
  
static int
  get_le_short (const unsigned char *p)
{
   
   return p[0] | (p[1] << 8);
   
}

int
  unpack_PalmPixHeader (struct PalmPixHeader *h, const unsigned char *p, int len)
{
   int magic1, magic2;
   
   if (len != 196)
     return 0;

   magic1 = p[1];
   magic2 = get_le_short (&p[46]);
   
   /* FIXME For now, don't check the magic.  I've seen 0x0002 and 0x0201.
    I'm not sure that the endianness is right on this one.  Possibly it
    should be interpreted as two bytes instead (major and minor?).   */
   #if 0
   if (magic1 != 0 || (magic2 != 0x0102 && magic2 != 0x0002))
     return 0;
   #endif
   
   h->numRec= p[0];
   h->month= p[2];
   h->day= p[3];
   h->year= p[4] * 100 + p[5];
   h->hour= p[6];
   h->min= p[7];
   h->sec= p[8];
   h->resolution= p[9];
   h->w= get_le_short (&p[10]);
   h->h= get_le_short (&p[12]);
   h->thumbLen= get_le_short (&p[14]);
   h->chansize[pixChannelGR] = get_le_short (&p[16]);
   h->chansize[pixChannelR]  = get_le_short (&p[19]);
   h->chansize[pixChannelB]  = get_le_short (&p[22]);
   h->chansize[pixChannelGB] = get_le_short (&p[25]);
   h->num= get_le_short (&p[29]);
   h->zoom= p[45];
   
   return 196;
   
}

int unpack_PalmPix (struct PalmPixState *s,
		  const struct PalmPixHeader *h, int header_recno, int wanted)
{
   int retcode = 1;
   
   if (wanted & pixName) 
     {
	  
	void *buffer;
	int bufsize;
	if (s->getrecord (s, header_recno + 1, &buffer, &bufsize) == 0
	        && bufsize == 32) 
	  {
	       
	     memcpy (s->pixname, buffer, 32);
	     s->pixname[32] = '\0';
	     
	  }
	else
	  retcode = 0;
	  
       }
   
   if (wanted & pixThumbnail) 
     {
	
	/* FIXME */
	retcode = 0;
	fprintf (stderr,
		  "palmpix.c: thumbnail reader not implemented\n");
	
     }
   
   if (wanted & pixPixmap) 
     {
	  
	int rawWidth = h->w / 2;
	int rawHeight = h->h / 2;
	unsigned char *raw;
	unsigned char *chan[4];  /* red/greenR/greenB/blue channels */
	int chansize_max = 0;
	int recno = header_recno;
	int failed = 1;
	int k;
	
	for (k = 0; k < 4; k++)
	  chan[k] = NULL;
	raw = NULL;
	s->pixmap = NULL;
	
	for (k = 0; k < 4; k++) 
	  {
		 
	     chan[k] = malloc (rawWidth * rawHeight);
	     if (chan[k] == NULL)
	       goto failed;
	     memset (chan[k], 0, rawWidth * rawHeight);
	     if (chansize_max < h->chansize[k])
	       chansize_max = h->chansize[k];
	     
	  }
	  
	
	raw = malloc (chansize_max);
	if (raw == NULL)
	  goto failed;
	
	s->pixmap = malloc (h->w * h->h * 3);
	if (s->pixmap == NULL)
	  goto failed;
	
	recno += 4;  /* Skip to the first channel record.  */
	
	for (k = 0; k < 4; k++) 
	  {
	     unsigned long nbytes, offset;
	     int32_t lastWord = 0;
	     int j;
	     
	     for (nbytes = 0; nbytes < h->chansize[k]; recno++) 
	       {
		  void *buffer;
		  int bufsize;
		  if (s->getrecord (s, recno, &buffer, &bufsize) == 0) 
		    {
		       if (bufsize > h->chansize[k] - nbytes)
			 bufsize = h->chansize[k] - nbytes;
		       memcpy (&raw[nbytes], buffer, bufsize);
		       nbytes += bufsize;
		       
		    }
		  else
		    goto failed;
		  
	       }
		 
	     offset = 0;
	     memcpy (chan[k], &raw[offset], rawWidth);
	     offset += rawWidth;
	     
	     for (j = 1; j < rawHeight; j++) 
	       {
		  uint32_t eaten;
		  DecodeRow (&raw[offset],
			     &chan[k][rawWidth * (j - 1)],
			     &chan[k][rawWidth * j],
			     &eaten, &lastWord,
			     huffTable, huffWidth, rawWidth);
		  offset += eaten;
		  
	       }
		 
	     
	     Bias (0.85, rawWidth, rawHeight, chan[k]);
	     
	  }
	  
	Interpolate (h,
		     chan[pixChannelR], chan[pixChannelGR],
		     chan[pixChannelGB], chan[pixChannelB],
		     s->pixmap, s->offset_r, s->offset_g, s->offset_b);
	failed = 0;
	
failed:
	for (k = 0; k < 4; k++)
	  free (chan[k]);
	free (raw);
	if (failed) 
	    {
	       free (s->pixmap);
	       retcode = 0;
	    }
     }
   
   s->highest_recno = header_recno + 3 + h->numRec;
   
   return retcode;
}

int
  free_PalmPix_data (struct PalmPixState *s)
{
   free (s->pixmap);
   
   return 1;
}

