/***************************************************************************

    Disk Based Hash library DBH

    static functions

copyright Edscott Wilson Garcia 2002-2003
published under LGPL Public license
You should have received a license copy along with this file.

**************************************************************************/
/* smd_s0.c           FUNCIONES ESTATICAS  */

	/* defines */
#define NEW 1
#define OLD 0

/* variables privadas: */
static int           DBH_datasize=1024;
static DBHashTable  *DBH_desnode;
static char         *DBH_tempdir=NULL;

  /* Funciones nivel 0: */
static void          DBH_operate(DBHashTable * node){if (node==NULL) ABORT5;}

static int           DBH_updateBranch(DBHashTable *,FILE_POINTER);
static unsigned char DBH_readBranches(DBHashTable *,FILE_POINTER);

static FILE_POINTER *DBH_locate(DBHashTable *);
static FILE_POINTER *DBH_locateI(DBHashTable *); /* for insert */
static FILE_POINTER *DBH_locateT(DBHashTable *,int); /*for find */
static void          DBH_cuenta(unsigned char *,unsigned char,FILE_POINTER);
static FILE_POINTER  DBH_write(char,DBHashTable *,unsigned char);
static int           DBH_read(char, DBHashTable *,unsigned char);
static int           DBH_readheader(DBHashTable *);

#ifdef TURN
static FILE_POINTER  DBH_turnaround(FILE_POINTER);
#endif
static FILE_POINTER  DBH_z(unsigned char,unsigned char);
static unsigned char DBH_cuantumR(FILE_POINTER,unsigned char,FILE_POINTER *);
static unsigned char DBH_cuantum(FILE_POINTER,unsigned char,FILE_POINTER *);
static void          DBH_cifra(unsigned char *,unsigned char,unsigned char,FILE_POINTER *);

  /* Funciones nivel 1: */
static int           DBH_barrelong(DBHashTable *,FILE_POINTER,int);
static int           DBH_reversebarrelong(DBHashTable *,FILE_POINTER,int);
static int           DBH_reversebarre(DBHashTable *,FILE_POINTER,int);
static int           DBH_barre(DBHashTable *,FILE_POINTER,int);

  /* Funciones nivel 2: */
static void          DBH_transfer(struct DBHashTable *);
static void          DBH_sortingS(struct DBHashTable *);
#if 0
static void          DBH_sorting(struct DBHashTable *);
#endif

#if 0
 /* funciones de memoria */
static int DBH_memread(int,DBHashTable *,FILE_POINTER);
static unsigned char DBH_mload_address(DBHashTable *,FILE_POINTER);
static int DBH_mbarre(DBHashTable *,FILE_POINTER,int);
#endif

/*  funciones de usuario puestas estaticas */
static DBHashTable          *DBH_open_S(char *,int);

/* old non static functions **/
static int        DBH_size(DBHashTable *,int);


  /* Funciones: ***************************************************************/
static unsigned char DBH_readBranches(DBHashTable *node,FILE_POINTER seek)
{
 FILE_POINTER *rama;
 unsigned char ramas;
 rama=node->newbranch;
 if (fseek(node->database,seek,SEEK_SET)) return ERROR_VALUE;
 if (fread(&ramas,1,1,node->database) != 1) return ERROR_VALUE;
 fseek(node->database,1+sizeof(FILE_POINTER),SEEK_CUR);
 if (fread(rama,sizeof(FILE_POINTER)*ramas,1,node->database) != 1) return ERROR_VALUE;
#ifdef TURN
{
 int i;
 for (i=0;i<ramas;i++) rama[i]=DBH_turnaround(rama[i]);
}
#endif
 return ramas;
} /***************************************************/

static int DBH_updateBranch(DBHashTable *node,FILE_POINTER seek)
{
 FILE_POINTER *rama;
 unsigned char ramas;
 rama=node->newbranch;
 if (fseek(node->database,seek,SEEK_SET)) return ERROR_VALUE;
 fread(&ramas,1,1,node->database);
 fseek(node->database,1+sizeof(FILE_POINTER),SEEK_CUR);
#ifdef TURN
{int i;
 for (i=0;i<ramas;i++) rama[i]=DBH_turnaround(rama[i]);
}
#endif
 if (fwrite(rama,sizeof(FILE_POINTER)*ramas,1,node->database) != 1) return ERROR_VALUE;
#ifdef TURN
{int i;
 for (i=0;i<ramas;i++) rama[i]=DBH_turnaround(rama[i]);
}
#endif
 return 1;
}  /*****************************************************/

#define BRANCHOFF (node->head_info->n_limit-node->newbranches)
#define CURRENTSEEK fp[0]
#define LASTSEEK fp[1]
#define CURR_BRANCH fp[2]
#define SWITCHED (node->head_info->reservedD)

static FILE_POINTER *DBH_locate(DBHashTable *node)
{
 FILE_POINTER    currentseek,lastseek;
 static FILE_POINTER fp[3];
 int i; /*,offset;*/
 lastseek=currentseek=0;
 CURRENTSEEK=LASTSEEK=CURR_BRANCH=0;    /* ERROR value assigned */
 currentseek = node->head_info->bof;
 if (fseek(node->database,currentseek,SEEK_SET)) return fp;	  /* error en la busqueda del principio  */
 if (!DBH_read(NEW,node,1)) return fp;
 loop:
#define OFFSET (i+(node->head_info->n_limit-node->newbranches))
 for (i = 0;i < node->newbranches;i++)
 {
/*    offset=i+(node->head_info->n_limit-node->newbranches);
    if (*(node->key+offset) != *(node->newkey+offset))*/
    if (*(node->key+OFFSET) != *(node->newkey+OFFSET))
/*    if ((node->key)[OFFSET] ^ (node->newkey)[OFFSET])   */
    {
     lastseek = currentseek;
     if ((currentseek = *(node->newbranch+i)) == 0) {CURR_BRANCH=i; break; }
     if (fseek(node->database,currentseek,SEEK_SET)) return fp;
     if (!DBH_read(NEW,node,1)) return fp;
     goto loop;
  }
 }
 CURRENTSEEK=currentseek;
 LASTSEEK=lastseek;
 return fp;
}


static FILE_POINTER *DBH_locateI(DBHashTable *node)
{
 FILE_POINTER    currentseek,lastseek;
 static FILE_POINTER fp[3];
 int i,dataswitch=0;
 lastseek=currentseek=0;
 CURRENTSEEK=LASTSEEK=CURR_BRANCH=0;    /* ERROR value assigned */
 currentseek = node->head_info->bof;
 if (fseek(node->database,currentseek,SEEK_SET)) return fp;	  /* error en la busqueda del principio  */
 if (!DBH_read(NEW,node,1)) return fp;
 loop:
#
 for (i = 0;i < node->newbranches;i++)            
 {
 /*   offset=i+(node->head_info->n_limit-node->newbranches);*/
    if (*(node->key+OFFSET) != *(node->newkey+OFFSET))
    {
     if (node->head_info->reservedC) { /* only used in insert() */
          if (node->head_info->descending) {
          if (*(node->key+OFFSET) > *(node->newkey+OFFSET)) dataswitch=1;
         }
         else {
          if (*(node->key+OFFSET) < *(node->newkey+OFFSET)) dataswitch=1;
         }
         if (dataswitch) {
          void * temp;
          SWITCHED=(unsigned char)(!SWITCHED);
          if (fseek(node->database,currentseek,SEEK_SET)) return fp;
          if (!DBH_write(OLD,node,0)) return fp;
          node->bytes_userdata=node->newbytes_userdata;
          temp=node->data; 	node->data=node->newdata;	node->newdata=temp;
          temp=(void *)node->key; 	node->key=node->newkey;
          node->newkey=(unsigned char *)temp;
          dataswitch=0;
         }
     }  /* end insert subsection */
     lastseek = currentseek;
     if ((currentseek = *(node->newbranch+i)) == 0) {CURR_BRANCH=i; break; }
     if (fseek(node->database,currentseek,SEEK_SET)) return fp;
     if (!DBH_read(NEW,node,1)) return fp;
     goto loop;
  }
 }
 CURRENTSEEK=currentseek;
 LASTSEEK=lastseek;
 return fp;
}


static FILE_POINTER *DBH_locateT(DBHashTable *node,int keys)
{
 FILE_POINTER    currentseek,lastseek;
 static FILE_POINTER fp[3];
 int i;
 lastseek=currentseek=0;
 CURRENTSEEK=LASTSEEK=CURR_BRANCH=0;    /* ERROR value assigned */
 currentseek = node->head_info->bof;
 if (fseek(node->database,currentseek,SEEK_SET)) return fp;	  /* error en la busqueda del principio  */
 if (!DBH_read(NEW,node,1)) return fp;
 if (keys>node->head_info->n_limit) keys=node->head_info->n_limit;
 loop:
 for (i = 0;i < node->newbranches-(node->head_info->n_limit-keys);i++)
 {
  /*  offset=i+(node->head_info->n_limit-node->newbranches);*/
    if (*(node->key+OFFSET) != *(node->newkey+OFFSET))
    {
     lastseek = currentseek;
     if ((currentseek = *(node->newbranch+i)) == 0) {CURR_BRANCH=i; break; }
     if (fseek(node->database,currentseek,SEEK_SET)) return fp;
     if (!DBH_read(NEW,node,1)) return fp;
     goto loop;
  }
 }
 CURRENTSEEK=currentseek;
 LASTSEEK=lastseek;
 return fp;
}

static DBHashTable *DBH_open_S(char *archivo,int mode)
{
 DBHashTable *node; FILE *archin;
 if (strlen(archivo)>255) {
     ABORT3
     return NULL;
 }
 if (mode)
 {
  archin = fopen(archivo,"rb+");
  if (archin == NULL) { archin = fopen(archivo,"rb"); if (archin) WARNING3; }
 }
 else archin = fopen(archivo,"rb");
 if (archin == NULL) return NULL;
 node=(DBHashTable *)malloc(sizeof(DBHashTable));
 memset(node, 0 , sizeof(DBHashTable));
 if (node== NULL) return NULL;
 node->head_info = (header *)malloc(1024); node->database = archin;
 if (fseek(node->database,0L,SEEK_END)) return NULL;
 if(ftell(node->database)< 1024)
 {
  fprintf(stdout,"\nFin de la base de datos (ftell()) = %ld", ftell(node->database));
  fprintf(stdout,"\ntamao de base de datos valida y vacia = %d", 1024);
  ABORT1
  return NULL;
 }
 if (!DBH_readheader(node)){
     fclose(archin);
     free(node->head_info);
     free(node);
     return NULL;
 }
 node->operate=DBH_operate;
 node->branch    = (FILE_POINTER *)malloc(node->head_info->n_limit*sizeof(FILE_POINTER));
 node->newbranch = (FILE_POINTER *)malloc(node->head_info->n_limit*sizeof(FILE_POINTER));
 node->key=(unsigned char *)malloc(node->head_info->n_limit);
 node->newkey=(unsigned char *)malloc(node->head_info->n_limit);
 strcpy(node->head_info->archivo,archivo);
 node->head_info->membof=NULL;
 node->head_info->reservedA=0;
 if (mode==WRITE) node->head_info->writeOK=1;
 else node->head_info->writeOK=0;
 DBH_size(node,(int)node->head_info->record_length);
 return node;
}  /****************************************************************************/

static void DBH_cuenta(unsigned char * numero,unsigned char orden,FILE_POINTER cuanto)
{
 unsigned char q; FILE_POINTER m;
 if (orden==0) numero[0]=0;
 if (orden==1) numero[0]=(unsigned char)cuanto;
 q=DBH_cuantumR(cuanto,orden,&m);  /* en que cuantum estamos */
 orden--; DBH_cifra(numero,q,orden,&m);
/* DBH_cifra(numero,q,orden-1,&m);*/
} /***********************************************************************/

#define RECORD_EXTENT  ( 2 + sizeof(FILE_POINTER)*(*how_many_branches+1) + node->head_info->n_limit + the_user_databytes )
static FILE_POINTER DBH_write(char newinfo,DBHashTable *node,unsigned char write_branches)
{
 int i;
 void * the_data; unsigned char *how_many_branches;
 FILE_POINTER the_user_databytes;
 FILE_POINTER *the_branches; unsigned char * the_key;
 if (newinfo) {  the_branches=node->newbranch; } else {  the_branches=node->branch; }
 the_data=node->data;
 how_many_branches=&(node->newbranches);
 the_user_databytes=node->bytes_userdata;
 the_key=node->key;

#if 0 
 FILE_POINTER newsize;
 newsize=ftell(node->database)+RECORD_EXTENT;

#if I32_32
 if (newsize>INT_MAX) {WARNING7; return ERROR_VALUE;}
#endif
#if I64_64
 if (newsize>INT_MAX) {WARNING7; return ERROR_VALUE;}
#endif
#if I64_32
 if (newsize>SHRT_MAX) {WARNING7; return ERROR_VALUE;}
#endif
#if I32_64
 if (newsize>LONG_MAX) {WARNING7; return ERROR_VALUE;}
#endif
#if I16_32
 if (newsize>LONG_MAX) {WARNING7; return ERROR_VALUE;}
#endif
#endif

/* only first write is condition tested. The remainder are assumed if one is passed */

 if (the_user_databytes>node->head_info->record_length) {DBH_size(node,(int)the_user_databytes); WARNING4;}
 if (fwrite(how_many_branches,1,1,node->database) != 1) return ERROR_VALUE;
 if (fwrite(&(node->flag),1,1,node->database) != 1) return ERROR_VALUE;
 i=fwrite(&the_user_databytes,sizeof(FILE_POINTER),1,node->database);
 if (i==0) return ERROR_VALUE;
 if (write_branches)
 {
#ifdef TURN
 for (i=0;i<*how_many_branches;i++) the_branches[i]=DBH_turnaround(the_branches[i]);
#endif
	i=fwrite(the_branches,sizeof(FILE_POINTER),*how_many_branches,node->database);
   if (i==0) return ERROR_VALUE;
#ifdef TURN
 for (i=0;i<*how_many_branches;i++) the_branches[i]=DBH_turnaround(the_branches[i]);
#endif
 }
 else	fseek(node->database,*how_many_branches*sizeof(FILE_POINTER),SEEK_CUR);
 fwrite(the_key,node->head_info->n_limit,1,node->database);
 if (the_user_databytes)
 {
  if (node->head_info->reservedC) the_user_databytes=fwrite(the_data,node->head_info->record_length,1,node->database);
  else the_user_databytes=fwrite(the_data,the_user_databytes,1,node->database);
  return (the_user_databytes);
 }
 else return (1);
}  /************************************************************************************/

static int DBH_read(char newinfo,DBHashTable *node,unsigned char read_data)
{
 unsigned char  keylength;
 void * the_data; unsigned char * how_many_branches;
 FILE_POINTER *the_user_databytes;
 FILE_POINTER *the_branches; unsigned char * the_key;
 if (newinfo)
 {
  the_branches=node->newbranch;
  the_data=node->newdata;
  how_many_branches=&(node->newbranches);
  the_user_databytes=&(node->newbytes_userdata);
  the_key=node->newkey;
 }
 else
 {
  the_branches=node->branch;
  the_data=node->data;
  how_many_branches=&(node->branches);
  the_user_databytes=&(node->bytes_userdata);
  the_key=node->key;
 }
 keylength=node->head_info->n_limit;


 if (fread(how_many_branches,1,1,node->database) < 1) return ERROR_VALUE;
 if (fread(&(node->flag),1,1,node->database) < 1) return ERROR_VALUE;
 if (fread(the_user_databytes,sizeof(FILE_POINTER),1,node->database) < 1) return ERROR_VALUE;

 if (*the_user_databytes>node->head_info->record_length) {DBH_size(node,(int)*the_user_databytes); WARNING4;}
 fread(the_branches,sizeof(FILE_POINTER),*how_many_branches,node->database);
#ifdef TURN
{
 int i;
 for (i=0;i<*how_many_branches;i++) the_branches[i]=DBH_turnaround(the_branches[i]);
}
#endif
  fread(the_key,keylength,1,node->database);
  if (read_data) fread(the_data,*the_user_databytes,1,node->database);
 return 1;
} /************************************************************************************/

static int DBH_readheader(DBHashTable *node)
{
 if (fseek(node->database,0L,SEEK_SET) != 0) goto error;
 if (fread(node->head_info,1024,1,node->database) == 0 ) goto error;
 if (strstr(node->head_info->version,DBH_FILE_VERSION)==NULL) goto error;
#ifdef TURN
 node->head_info->bof=DBH_turnaround(node->head_info->bof);
 node->head_info->record_length=DBH_turnaround(node->head_info->record_length);
 node->head_info->total_space=DBH_turnaround(node->head_info->total_space);
 node->head_info->data_space=DBH_turnaround(node->head_info->data_space);
 node->head_info->erased_space=DBH_turnaround(node->head_info->erased_space);
 node->head_info->records=DBH_turnaround(node->head_info->records);
 node->head_info->reservedA=DBH_turnaround(node->head_info->reservedA);
 node->head_info->reservedB=DBH_turnaround(node->head_info->reservedB);
#endif
 return 1;
 error:
#if 0
 {
  int i;
  unsigned char *byte;
#ifdef TURN
 node->head_info->bof=DBH_turnaround(node->head_info->bof);
 node->head_info->record_length=DBH_turnaround(node->head_info->record_length);
 node->head_info->total_space=DBH_turnaround(node->head_info->total_space);
 node->head_info->data_space=DBH_turnaround(node->head_info->data_space);
 node->head_info->erased_space=DBH_turnaround(node->head_info->erased_space);
 node->head_info->records=DBH_turnaround(node->head_info->records);
 node->head_info->reservedA=DBH_turnaround(node->head_info->reservedA);
 node->head_info->reservedB=DBH_turnaround(node->head_info->reservedB);
#endif
  byte= (unsigned char *)node->head_info;
  fprintf(stderr,"head_info->version=%s\n",node->head_info->version);
  fprintf(stderr,"sizeof header= %d\n",sizeof(header));
  fprintf(stderr,"sizeof FILE_POINTER= %d\n",sizeof(FILE_POINTER));
  fprintf(stderr,"sizeof int= %d\n",sizeof(int));
  fprintf(stderr,"sizeof char= %d\n",sizeof(char));
  fprintf(stderr,"sizeof unsigned char= %d\n",sizeof(unsigned char));
  fprintf(stderr,"bof= %d\n",node->head_info->bof);
  fprintf(stderr,"DBHashTable header dump:\n");
  for (i=0;i<sizeof(header);i++)
  {
	if ((byte[i]>32)&&(byte[i]<126))	fprintf(stderr,"%c",byte[i]);
	else  fprintf(stderr,"<%d>",byte[i]);
  }
 }
#endif
 ABORT1
 return 0;
}  /************************************************************************************/

#ifdef TURN
static FILE_POINTER DBH_turnaround(FILE_POINTER x)
{
 char * where,temp;
 where=(char *)&x;  temp=where[0]; where[0]=where[3];  where[3]=temp;
 temp=where[1]; where[1]=where[2]; where[2]=temp; return x;
} /************************************************************************************/
#endif

static FILE_POINTER DBH_z(unsigned char n, unsigned char m) /* n=cuantum m=orden */
{
 FILE_POINTER s=0;  unsigned char i;
 if (m<2) return 1;
 if (m==2) return (n+1);
 m--; for (i=n;i>0;i--) s += DBH_z(i,m);
/* for (i=n;i>0;i--) s += DBH_z(i,m-1);*/
 return (s+1);
}  /************************************************************************************/

static unsigned char DBH_cuantumR(FILE_POINTER cuanto,unsigned char orden,FILE_POINTER *m)
{
 unsigned char i; FILE_POINTER ztotal,grandtotal=0;
 for (i=0;1;i++)
 {
  if (i==orden) ztotal=grandtotal; else ztotal = DBH_z(i,orden);
  grandtotal += ztotal;
  if (cuanto<=grandtotal) { if (m) *m=grandtotal-cuanto+1; break; }
 }
 return i;
}  /************************************************************************************/

static unsigned char DBH_cuantum(FILE_POINTER cuanto,unsigned char orden,FILE_POINTER *m)
{
 unsigned char i; FILE_POINTER ztotal,grandtotal=0;
 for (i=0;1;i++)
 {
  if (i==orden) ztotal=grandtotal; else ztotal = DBH_z(i,orden);
  grandtotal += ztotal;
  if (cuanto<=grandtotal) break;
  if (m) *m=cuanto-grandtotal;
 }
 return i;
}  /************************************************************************************/

static void DBH_cifra(unsigned char *numero,unsigned char q,unsigned char orden,FILE_POINTER *m)
{
 unsigned char subcuantum;
 int t;
 if (orden==1)
 {
  t=q - (*m-1); numero[0]=(unsigned char)t;
/*  numero[0]=q - (*m-1);*/
  t= *m-1;numero[1]=(unsigned char)t;
/*  numero[1]= *m-1;*/
  return;
 }
 subcuantum=DBH_cuantum(*m,orden,m);
 t=q-subcuantum;numero[0]=(unsigned char)t;
/* numero[0]=q-subcuantum;*/
 orden--; DBH_cifra(numero+1,subcuantum,orden,m);
 /* DBH_cifra(numero+1,subcuantum,orden-1,m);*/
 return;
}  /************************************************************************************/

  /* Funciones estaticas nivel 1 : *************************************************/
/*static DBHashTable *DBH_updatefile(DBHashTable * node)
{
 DBH_writeheader(node);
 fclose(node->database);
 if ((node->database = fopen(node->head_info->archivo,"wb+")) == NULL) return NULL;
 return node;
}     */
  /*************************************************************************/


static int DBH_barrelong(DBHashTable *node,FILE_POINTER startadd,int ramas)
{
 unsigned char        i;
 if (DBH_load_address(node,startadd) == ERROR_VALUE) return ERROR_VALUE;
 if (node->head_info->DBH_exit) return 2;
 if (!ERASED || (ERASED && node->head_info->sweep_erased)) (*(node->operate))(node);
 if (ramas) {if ((ramas=node->branches-ramas)<0) ramas=0;}
 for (i = node->branches;i > ramas;i--)
 {
  if (node->branch[i-1]) DBH_barrelong(node,node->branch[i-1],0);
  DBH_load_address(node,startadd);
 }
 return 1;
}    /**********************************************************************/

static int DBH_reversebarrelong(DBHashTable *node,FILE_POINTER startadd,int ramas)
{
 int        i;
 if (DBH_load_address(node,startadd) == ERROR_VALUE) return ERROR_VALUE;
 if (node->head_info->DBH_exit) return 2;
 if (!ERASED || (ERASED && node->head_info->sweep_erased)) (*(node->operate))(node);
/* if (!ERASED) (*(node->operate))(node);*/
 if (ramas) {if ((ramas=node->branches-ramas)<0) ramas=0;}
 for (i = ramas;i<node->branches;i++)
 {
	if (node->branch[i]) DBH_reversebarrelong(node,node->branch[i],0);
	DBH_load_address(node,startadd);
 }
 return 1;
}   /******************************************************************************/

static int DBH_reversebarre(DBHashTable *node,FILE_POINTER startadd,int ramas)
{
 int  i;
 unsigned char oldbranches;
 FILE_POINTER  *oldbranch;
 char  fullmemory = 0;
 if (DBH_load_address(node,startadd) == ERROR_VALUE) return ERROR_VALUE;
 if (node->head_info->DBH_exit) return 2;
 if (!ERASED || (ERASED && node->head_info->sweep_erased)) (*(node->operate))(node);
/* if (!ERASED) (*(node->operate))(node);*/
 oldbranch = (FILE_POINTER *)malloc(node->branches*sizeof(FILE_POINTER));
 if (oldbranch == NULL) fullmemory=1;
 oldbranches=node->branches;
 if (ramas) {if ((ramas=node->branches-ramas)<0) ramas=0;}
 if (!fullmemory)
 {
  for (i = 0;i < oldbranches;i++) oldbranch[i] = node->branch[i];
  for (i = ramas;i<oldbranches;i++) if (oldbranch[i]) DBH_reversebarre(node,oldbranch[i],0);
  free(oldbranch);
 }
 else for (i = ramas;i<oldbranches;i++)
 {
	if (node->branch[i]) DBH_reversebarrelong(node,node->branch[i],0);
	DBH_load_address(node,startadd);
 }
 return 1;
}  /******************************************************************************/

static int DBH_barre(DBHashTable *node,FILE_POINTER startadd,int ramas)
{
 unsigned char i; FILE_POINTER  *oldbranch; char fullmemory = 0;
 if (DBH_load_address(node,startadd) == ERROR_VALUE) return ERROR_VALUE;
 if (node->head_info->DBH_exit) return 2;
#if 0
 printf("barre: currentseek at %lu\n",(long unsigned)startadd);
 printf("record is erased? -> %d\n",ERASED);
#endif
 if (!ERASED || (ERASED && node->head_info->sweep_erased)) (*(node->operate))(node);
/* if (!ERASED) (*(node->operate))(node);*/
 oldbranch = (FILE_POINTER *)malloc(node->branches*sizeof(FILE_POINTER));
 if (oldbranch == NULL) fullmemory=1;
 if (ramas) {if ((ramas=node->branches-ramas)<0) ramas=0;}
 if (!fullmemory)
 {
  for (i = 0;i < node->branches;i++) oldbranch[i] = node->branch[i];
  for (i = node->branches;i > ramas;i--) if (oldbranch[i-1]) DBH_barre(node,oldbranch[i-1],0);
  free(oldbranch);
 }
 else for (i = node->branches;i > ramas;i--)
 {
	if (node->branch[i-1]) DBH_barrelong(node,node->branch[i-1],0);
	DBH_load_address(node,startadd);
 }
 return 1;
}   /************************************************************************/


  /* Functions: */
static void DBH_transfer(struct DBHashTable *srcnode)
{
 DBH_desnode->bytes_userdata=srcnode->bytes_userdata;
 DBH_update(DBH_desnode);
/* if ((count++ % 100)==0) printf("\n %ld registros procesados",count);*/
 return;
} /***************************************************************************/

#if 0
static void DBH_sorting(struct DBHashTable *srcnode)
{
 unsigned char i; char * datum;
 unsigned int checkvalue;

 checkvalue=DBH_desnode->head_info->length+DBH_desnode->head_info->position;
 if (srcnode->bytes_userdata<checkvalue) return;
 datum=(char *)srcnode->data;
 DBH_desnode->bytes_userdata=srcnode->bytes_userdata;

  for (i=DBH_desnode->head_info->position;i<DBH_desnode->head_info->length+DBH_desnode->head_info->position;i++)
  {
	DBH_desnode->key[i-DBH_desnode->head_info->position]=datum[i];
  }
  if (DBH_desnode->head_info->totalkeylength > DBH_desnode->head_info->length)
  for (i=DBH_desnode->head_info->length;i<DBH_desnode->head_info->totalkeylength;i++)
  {
	DBH_desnode->key[i]=datum[i-DBH_desnode->head_info->length];
  }

 DBH_insert(DBH_desnode);
/* if ((count++ % 100)==0) printf("\n %ld registros procesados",count);*/
 return;
} /***************************************************************************/
#endif

static void DBH_sortingS(struct DBHashTable *srcnode)
{
 DBH_desnode->bytes_userdata=srcnode->bytes_userdata;
 DBH_insert(DBH_desnode);
/* if ((count++ % 100)==0) printf("\n %ld registros procesados",count);*/
 return;
} /***************************************************************************/

#if 0
static int DBH_memread(int cual,DBHashTable *node,FILE_POINTER where)
{
 unsigned char keylength;
 unsigned char * the_data;
 unsigned char * how_many_branches;

 FILE_POINTER *the_user_databytes,*the_branches;
 unsigned char * the_key;
 int k,cuantos;
 unsigned int kk;
 unsigned char *d_branch;
#ifdef TURN
 int i;
#endif
 if (cual)
 {
  the_branches=node->newbranch;
  the_data=(unsigned char *)node->newdata;
  how_many_branches=&(node->newbranches);
  the_key=node->newkey;
 }
 else
 {
  the_branches=node->branch;
  the_data=(unsigned char *)node->data;
  how_many_branches=&(node->branches);
  the_key=node->key;
 }
 keylength=node->head_info->n_limit;


 *how_many_branches       = node->head_info->membof[where++];
 node->flag               = node->head_info->membof[where++];

 the_user_databytes = (FILE_POINTER *)((node->head_info->membof)+where);
 if (cual) node->newbytes_userdata=*the_user_databytes;
 else node->bytes_userdata=*the_user_databytes;

 where += sizeof(FILE_POINTER);

 cuantos= *how_many_branches * sizeof(FILE_POINTER);
 d_branch=(unsigned char *)the_branches;
 for (k=0;k<cuantos;k++,where++) {d_branch[k]=node->head_info->membof[where];}

#ifdef TURN
 for (i=0;i<*how_many_branches;i++) the_branches[i]=DBH_turnaround(the_branches[i]);
#endif


  for (k=0;k<keylength;k++,where++) {the_key[k]=node->head_info->membof[where];}
  for (kk=0;kk<*the_user_databytes;kk++,where++){the_data[kk]=node->head_info->membof[where];}
 return 1;
} /************************************************************************************/

static unsigned char DBH_mload_address(DBHashTable *node,FILE_POINTER currentseek)
{
 unsigned char   i;
 if (currentseek == 0) return ERROR_VALUE;
 for (i = 1;i <= node->head_info->n_limit;i++) node->branch[i-1] = 0;
 if (DBH_memread(0,node,currentseek)!=1) return ERROR_VALUE;
 return node->branches;
}  /*********************************************************************************/


static int DBH_mbarre(DBHashTable *node,FILE_POINTER startadd,int ramas)
{
 unsigned char i; FILE_POINTER  *oldbranch; char fullmemory = 0;
 if (DBH_mload_address(node,startadd) == 0) return ERROR_VALUE;
 if (!ERASED || (ERASED && node->head_info->sweep_erased)) (*(node->operate))(node);
// if (!ERASED && !node->head_info->sweep_erased) (*(node->operate))(node);
/* if (!ERASED) (*(node->operate))(node);*/
 oldbranch = (FILE_POINTER *)malloc(node->branches*sizeof(FILE_POINTER));
 if (oldbranch == NULL) fullmemory=1;
 if (ramas) {if ((ramas=node->branches-ramas)<0) ramas=0;}
 if (!fullmemory)
 {
  for (i = 0;i < node->branches;i++) oldbranch[i] = node->branch[i];
  for (i = node->branches;i > ramas;i--) if (oldbranch[i-1]) DBH_mbarre(node,oldbranch[i-1],0);
  free(oldbranch);
 }
 else
 {
	return ERROR_VALUE;
 }
 return 1;
}   
/******************************************************************************/
#endif

/*****************************************************************************/
/***    old   non static functions ***/
/*****************************************************************************/

static int DBH_size(DBHashTable * node,int record_length)
{
 unsigned char *oldD1=NULL,*tmp1,*oldD2=NULL,*tmp2;
 FILE_POINTER last;

 last=DBH_datasize;
 /* despues de abrir DBHashTable */
 if (node!=NULL)
 {
  if (node->head_info->record_length==0) node->head_info->record_length=record_length;
  if (record_length<node->head_info->record_length) {WARNING6; return 1;}
  if (node->data!=NULL)
  {
    if (record_length>node->head_info->record_length)
    {
     DBH_datasize=record_length;
     tmp1 = (unsigned char *)malloc(record_length);
     tmp2 = (unsigned char *)malloc(record_length);
     if ((tmp1==NULL)||(tmp2==NULL)) return ERROR_VALUE;
     oldD1 = (unsigned char *)node->data; 
     oldD2 = (unsigned char *)node->newdata;
#ifdef HAVE_MEMCPY
     memcpy((void *)tmp1,(void *)oldD1,node->head_info->record_length);
     memcpy((void *)tmp2,(void *)oldD2,node->head_info->record_length);
#else
     {
       int i;	
       for (i=0;i<node->head_info->record_length;i++) {
	     tmp1[i]=oldD1[i];tmp2[i]=oldD2[i];
       }
     }
#endif
#ifdef HAVE_MEMSET
     memset(&tmp1[node->head_info->record_length], 0, 
		     record_length - node->head_info->record_length);
     memset(&tmp2[node->head_info->record_length], 0, 
		     record_length - node->head_info->record_length);
#else
     {
       int i;	   
       for (i=node->head_info->record_length;i<record_length;i++) {
	     tmp1[i]=tmp2[i]=0;
       }
     }
#endif
     free(node->data); 
     free(node->newdata);
     node->data = tmp1;
     node->newdata = tmp2;
    }
  }
  else
  {
   node->data     = (void *)malloc(record_length);
   node->newdata  = (void *)malloc(record_length);
   if ((node->data==NULL)||(node->newdata==NULL)) return ERROR_VALUE;
#ifdef HAVE_MEMSET
   memset(node->data, 0, record_length);
   memset(node->newdata, 0, record_length);
#else
   {
     int i;
     tmp1 = (unsigned char *)node->data; 
     tmp2 = (unsigned char *)node->newdata;
     for (i=0;i<record_length;i++) {
	 tmp1[i]=tmp2[i]=0;
     }
   }
#endif
  }
  node->head_info->record_length=record_length;
  if (node->head_info->writeOK) DBH_writeheader(node);
 } else  DBH_datasize=record_length;
 return last;
} /****************************************************************************************/

static int DBH_newbarre(DBHashTable *node,unsigned char *key1,unsigned char *key2,unsigned char keylength)
{
 int i; FILE_POINTER pointer;
 if (!node) {WARNING8; return ERROR_VALUE;}
 node->head_info->DBH_exit=0; 
 if (key1==NULL) { DBH_barre(node,node->head_info->bof,0);return 1;}
 if (key2!=NULL)
 {
#ifdef HAVE_MEMCPY
  memcpy((void *)(node->key),(void *)key1,node->head_info->n_limit);
#else
  for (i=0;i<node->head_info->n_limit;i++)  node->key[i]=key1[i];
#endif
  for (i=0;i<node->head_info->n_limit;i++) if (key1[i]!=key2[i]) break;
  /* que pedo con ERASED?? (load returns errorvalue on ERASED */
  pointer=DBH_load(node);
  if ((pointer==ERROR_VALUE) && !(ERASED))return ERROR_VALUE;
/*  if ((pointer=DBH_load(node)) == ERROR_VALUE) return ERROR_VALUE;*/
  /* aqui hay que considerar que el nodo puede estar marcado como ERASED */
  else  {  pointer=DBH_find(node,i);  DBH_barre(node,pointer,node->head_info->n_limit-i); }
 }
 else if (keylength)
 {
#ifdef HAVE_MEMCPY
  memcpy((void *)(node->key),(void *)key1,keylength);
#else
  for (i=0;i<keylength;i++)  node->key[i]=key1[i];
#endif
  pointer=DBH_find(node,keylength);
  if (pointer==ERROR_VALUE) return ERROR_VALUE;
  DBH_barre(node,pointer,node->head_info->n_limit-keylength);
 }
 return 1;
} /***************************************************************************************/
static int DBH_newreversebarre(DBHashTable *node,unsigned char *key1,unsigned char *key2,unsigned char keylength)
{
 int i; FILE_POINTER pointer;
	if (!node) {WARNING8; return ERROR_VALUE;}
 node->head_info->DBH_exit=0; 
 if (key1==NULL) { DBH_reversebarre(node,node->head_info->bof,0);return 1;}
 if (key2!=NULL)
 {
#ifdef HAVE_MEMCPY
  memcpy((void *)(node->key),(void *)key1,node->head_info->n_limit);
#else
  for (i=0;i<node->head_info->n_limit;i++)  node->key[i]=key1[i];
#endif
  for (i=0;i<node->head_info->n_limit;i++) if (key1[i]!=key2[i]) break;
  /* que pedo con ERASED?? (load returns errorvalue on ERASED */
  pointer=DBH_load(node);
  if ((pointer==ERROR_VALUE) && !(ERASED))return ERROR_VALUE;
/*  if ((pointer=DBH_load(node)) == ERROR_VALUE) return ERROR_VALUE;*/
  else  {  pointer=DBH_find(node,i);  DBH_reversebarre(node,pointer,i); }
 }
 else if (keylength!=0)
 {
#ifdef HAVE_MEMCPY
  memcpy((void *)node->key,(void *)key1,keylength);
#else
  for (i=0;i<keylength;i++)  node->key[i]=key1[i];
#endif
  pointer=DBH_find(node,keylength);
  if (pointer==ERROR_VALUE) return ERROR_VALUE;
  DBH_reversebarre(node,pointer,keylength);
 }
 return 1;
}  /************************************************************************************/



