/*  xfce4
 *  Copyright (C) 2002 Olivier Fourdan (fourdan@xfce.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __XFCE_MOVEHANDLER_H__
#define __XFCE_MOVEHANDLER_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>


#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */


#define XFCE_MOVEHANDLER(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, xfce_movehandler_get_type (), XfceMovehandler)
#define XFCE_MOVEHANDLER_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, xfce_movehandler_get_type (), XfceMovehandlerClass)
#define XFCE_IS_MOVEHANDLER(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, xfce_movehandler_get_type ())

    typedef struct _XfceMovehandler XfceMovehandler;
    typedef struct _XfceMovehandlerClass XfceMovehandlerClass;

    struct _XfceMovehandler
    {

	GtkWidget widget;	/* parent */
	GtkWidget *gtk_window;	/* top_level managed window */

	/* Private data */

	GdkWindow *float_window;
	GtkAllocation float_allocation;
	gboolean in_drag;
	gint deskoff_x, deskoff_y;
	GdkBitmap *dark_bmap;
	GdkBitmap *mid_bmap;
	GdkBitmap *light_bmap;

	gint screen_x, screen_maxx, screen_y, screen_maxy;
	gint snapx[8], snapy[8];
    };

    struct _XfceMovehandlerClass
    {
	GtkWidgetClass parent_class;

	void (*move_start) (GtkWidget * widget);
	void (*move) (GtkWidget * widget, gint new_x, gint new_y);
	void (*move_end) (GtkWidget * widget);
    };


    GtkType xfce_movehandler_get_type (void);
    GtkWidget *xfce_movehandler_new (GtkWidget * window);

#ifdef __cplusplus
}
#endif				/* __cplusplus */


#endif				/* __XFCE_MOVEHANDLER_H__ */
