/*******************************************************************
* reportassistantpages_base.h
* Copyright 2009    Dario Andres Rodriguez <andresbajotierra@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation; either version 2 of
* the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
******************************************************************/

#ifndef REPORTASSISTANTPAGES__BASE__H
#define REPORTASSISTANTPAGES__BASE__H

#include "reportassistantdialog.h"
#include "reportassistantpage.h"

#include "backtracewidget.h"

#include "ui_assistantpage_introduction.h"
#include "ui_assistantpage_bugawareness.h"
#include "ui_assistantpage_conclusions.h"
#include "ui_assistantpage_conclusions_dialog.h"

#include <QtCore/QPointer>

/** Introduction page **/
class IntroductionPage: public ReportAssistantPage
{
    Q_OBJECT

public:
    explicit IntroductionPage(ReportAssistantDialog *);

private:
    Ui::AssistantPageIntroduction   ui;
};

/** Backtrace page **/
class CrashInformationPage: public ReportAssistantPage
{
    Q_OBJECT

public:
    explicit CrashInformationPage(ReportAssistantDialog *);

    void aboutToShow();
    void aboutToHide();
    bool isComplete();
    bool showNextPage();

private:
    BacktraceWidget *        m_backtraceWidget;
};

/** Bug Awareness page **/
class BugAwarenessPage: public ReportAssistantPage
{
    Q_OBJECT

public:
    explicit BugAwarenessPage(ReportAssistantDialog *);

    void aboutToShow();
    void aboutToHide();

private Q_SLOTS:
    void showApplicationDetailsExamples();

    void updateCheckBoxes();

private:
    Ui::AssistantPageBugAwareness   ui;
};

/** Conclusions page **/
class ConclusionPage : public ReportAssistantPage
{
    Q_OBJECT

public:
    explicit ConclusionPage(ReportAssistantDialog *);

    void aboutToShow();
    void aboutToHide();

    bool isComplete();

private Q_SLOTS:
    void finishClicked();

    void openReportInformation();

private:
    Ui::AssistantPageConclusions            ui;

    QPointer<KDialog>                       m_infoDialog;

    bool                                    isBKO;
    bool                                    needToReport;

Q_SIGNALS:
    void finished(bool);
};

class ReportInformationDialog : public KDialog
{
    Q_OBJECT
public:
    explicit ReportInformationDialog(const QString & reportText);
    ~ReportInformationDialog();

private Q_SLOTS:
    void saveReport();

private:
    Ui::AssistantPageConclusionsDialog ui;
};

#endif
