


LESSKEY(1)               USER COMMANDS                 LESSKEY(1)



NAME
     lesskey - specify key bindings for less

SYNOPSIS
     lesskey [-o output] [input]

DESCRIPTION
     _L_e_s_s_k_e_y is used to specify a set of key bindings to be  used
     by  _l_e_s_s.  The input file is a text file which describes the
     key bindings, and the output file is a binary file which  is
     used  by _l_e_s_s. If no input file is specified, standard input
     is used.  If no output file  is  specified,  $HOME/.less  is
     used.

     The input file consists of lines of the form:

          _s_t_r_i_n_g <whitespace> _a_c_t_i_o_n [extra-string] <newline>

     Whitespace is any sequence of  one  or  more  spaces  and/or
     tabs.   The  _s_t_r_i_n_g  is  the command key(s) which invoke the
     action.  The _s_t_r_i_n_g may  be  a  single  command  key,  or  a
     sequence  of  up  to 15 keys.  The _a_c_t_i_o_n is the name of the
     less action, from the list below.   The  characters  in  the
     _s_t_r_i_n_g  may  appear  literally, or be prefixed by a carat to
     indicate a control key.  A  backslash  followed  by  one  to
     three octal digits may be used to specify a character by its
     octal value.  A backslash followed by b, e, n, r or t speci-
     fies  BACKSPACE,  ESCAPE,  NEWLINE,  RETURN  or TAB, respec-
     tively.  A backslash followed by any other  character  indi-
     cates  that  character is to be taken literally.  Characters
     which must be preceded by backslash  include  carat,  space,
     tab  and  the backslash itself.  Blank lines and lines which
     start with a pound sign (#) are ignored.

     An action may be followed by an extra string.   This  string
     is  parsed  after the command is entered, just as if it were
     entered on the command line.  This feature can  be  used  in
     certain cases to extend the functionality of a command.  For
     example, these entries would create a pair  of  commands  to
     turn on/off line numbers using _v_i syntax:

          :set\ nu       toggle-option -N
          :set\ nonu     toggle-option +N

     See also the ":t" command in the example below.


EXAMPLE
     The following input file describes the set of  default  com-
     mand keys used by less:

          \r        forw-line



                                                                1






LESSKEY(1)               USER COMMANDS                 LESSKEY(1)



          \n        forw-line
          e         forw-line
          j         forw-line
          ^E        forw-line
          ^N        forw-line
          k         back-line
          y         back-line
          ^Y        back-line
          ^K        back-line
          ^P        back-line
          J         forw-line-force
          K         back-line-force
          Y         back-line-force
          d         forw-scroll
          ^D        forw-scroll
          u         back-scroll
          ^U        back-scroll
          \40       forw-screen
          f         forw-screen
          ^F        forw-screen
          ^V        forw-screen
          b         back-screen
          ^B        back-screen
          \ev       back-screen
          z         forw-window
          w         back-window
          F         forw-forever
          R         repaint-flush
          r         repaint
          ^R        repaint
          ^L        repaint
          g         goto-line
          <         goto-line
          \e<       goto-line
          p         percent
          %         percent
          {         forw-bracket {}
          }         back-bracket {}
          (         forw-bracket ()
          )         back-bracket ()
          [         forw-bracket []
          ]         back-bracket []
          \e^F      forw-bracket
          \e^B      back-bracket
          G         goto-end
          \e>       goto-end
          >         goto-end
          =         status
          ^G        status
          :f        status
          /         forw-search
          ?         back-search



                                                                2






LESSKEY(1)               USER COMMANDS                 LESSKEY(1)



          \e/       forw-search *
          \e?       back-search *
          n         repeat-search
          \en       repeat-search-all
          N         reverse-search
          \eN       reverse-search-all
          \u        undo-hilite
          m         set-mark
          '         goto-mark
          ^X^X      goto-mark
          E         examine
          :e        examine
          ^X^V      examine
          :n        next-file
          :p        prev-file
          :x        index-file
          -         toggle-option
          :t        toggle-option t
          s         toggle-option o
          _         display-option
          |         pipe
          v         visual
          !         shell
          +         firstcmd
          H         help
          h         help
          V         version
          q         quit
          :q        quit
          :Q        quit
          ZZ        quit

     Commands specified  by  _l_e_s_s_k_e_y  take  precedence  over  the
     default  commands.  A default command key may be disabled by
     including it in the key file with the action  "invalid".   A
     key  may be defined to do nothing by using the action "noac-
     tion".  This is similar to "invalid", but _l_e_s_s will give  an
     error  beep  for  an "invalid" command, but not for a "noac-
     tion" command.


SEE ALSO
     less(1)


WARNINGS
     If you already have a $HOME/.less file, running lesskey will
     overwrite it.


COPYRIGHT
     Copyright (c) 1984,1985,1989,1994  Mark Nudelman



                                                                3



