/*
 * @(#)ioctlent.h	1.4 91/09/05	- SunOS 4.1.1 ioctl's
 *
 *	culled from /usr/include approximately as follows:
 *			grep '_IO' `find . -type f -name \*.h -print` |
 *			sed -e 's/^\([^:][^:]*\):#define[ 	][ 	]* \
 *				\([_A-Z][_A-Z]*\)[ 	][ 	]* \
 *				\(\<_IO[RW]*\>([^)][^)]*)\)/ \
 *				{"\1",	"\2",	\3},/'
 *
 *	Based on SunOS 4.1.1
 *	A few #ifdef's have been included that will make this
 *	compile on SunOS 4.1 also.
 */

{"./net/nit_buf.h",	"NIOCSTIME",	_IOW(p, 6, struct timeval)	/* set timeout info */},
{"./net/nit_buf.h",	"NIOCGTIME",	_IOWR(p, 7, struct timeval)	/* get timeout info */},
{"./net/nit_buf.h",	"NIOCCTIME",	_IO(p, 8)			/* clear timeout */},
{"./net/nit_buf.h",	"NIOCSCHUNK",	_IOW(p, 9, u_int)		/* set chunksize */},
{"./net/nit_buf.h",	"NIOCGCHUNK",	_IOWR(p, 10, u_int)		/* get chunksize */},
{"./net/nit_if.h",	"NIOCBIND",	_IOW(p, 3, struct ifreq)	/* bind to interface */},
{"./net/nit_if.h",	"NIOCSFLAGS",	_IOW(p, 4, u_long)		/* set nit_if flags */},
{"./net/nit_if.h",	"NIOCGFLAGS",	_IOWR(p, 5, u_long)		/* get nit_if flags */},
{"./net/nit_if.h",	"NIOCSSNAP",	_IOW(p, 6, u_long)		/* set snapshot len */},
{"./net/nit_if.h",	"NIOCGSNAP",	_IOWR(p, 7, u_long)		/* get snapshot len */},
{"./net/nit_pf.h",	"NIOCSETF",	_IOW(p, 2, struct packetfilt)	/* set packet filter */},
{"./sys/des.h",		"DESIOCBLOCK",	_IOWR(d, 6, struct desparams)},
{"./sys/des.h",		"DESIOCQUICK",	_IOWR(d, 7, struct desparams) },
{"./sys/filio.h",	"FIOCLEX",	_IO(f, 1)		/* set exclusive use on fd */},
{"./sys/filio.h",	"FIONCLEX",	_IO(f, 2)		/* remove exclusive use */},
{"./sys/filio.h",	"FIONREAD",	_IOR(f, 127, int)	/* get # bytes to read */},
{"./sys/filio.h",	"FIONBIO",	_IOW(f, 126, int)	/* set/clear non-blocking i/o */},
{"./sys/filio.h",	"FIOASYNC",	_IOW(f, 125, int)	/* set/clear async i/o */},
{"./sys/filio.h",	"FIOSETOWN",	_IOW(f, 124, int)	/* set owner */},
{"./sys/filio.h",	"FIOGETOWN",	_IOR(f, 123, int)	/* get owner */},
{"./sys/mtio.h",	"MTIOCTOP",	_IOW(m, 1, struct mtop)		/* do a mag tape op */},
{"./sys/mtio.h",	"MTIOCGET",	_IOR(m, 2, struct mtget)	/* get tape status */},
{"./sys/sockio.h",	"SIOCSHIWAT",	_IOW(s,  0, int)		/* set high watermark */},
{"./sys/sockio.h",	"SIOCGHIWAT",	_IOR(s,  1, int)		/* get high watermark */},
{"./sys/sockio.h",	"SIOCSLOWAT",	_IOW(s,  2, int)		/* set low watermark */},
{"./sys/sockio.h",	"SIOCGLOWAT",	_IOR(s,  3, int)		/* get low watermark */},
{"./sys/sockio.h",	"SIOCATMARK",	_IOR(s,  7, int)		/* at oob mark? */},
{"./sys/sockio.h",	"SIOCSPGRP",	_IOW(s,  8, int)		/* set process group */},
{"./sys/sockio.h",	"SIOCGPGRP",	_IOR(s,  9, int)		/* get process group */},
{"./sys/sockio.h",	"SIOCADDRT",	_IOW(r, 10, struct rtentry)	/* add route */},
{"./sys/sockio.h",	"SIOCDELRT",	_IOW(r, 11, struct rtentry)	/* delete route */},
{"./sys/sockio.h",	"SIOCSIFADDR",	_IOW(i, 12, struct ifreq)	/* set ifnet address */},
{"./sys/sockio.h",	"SIOCGIFADDR",	_IOWR(i,13, struct ifreq)	/* get ifnet address */},
{"./sys/sockio.h",	"SIOCSIFDSTADDR",	_IOW(i, 14, struct ifreq)	/* set p-p address */},
{"./sys/sockio.h",	"SIOCGIFDSTADDR",	_IOWR(i,15, struct ifreq)	/* get p-p address */},
{"./sys/sockio.h",	"SIOCSIFFLAGS",	_IOW(i, 16, struct ifreq)	/* set ifnet flags */},
{"./sys/sockio.h",	"SIOCGIFFLAGS",	_IOWR(i,17, struct ifreq)	/* get ifnet flags */},
{"./sys/sockio.h",	"SIOCSIFMEM",	_IOW(i, 18, struct ifreq)	/* set interface mem */},
{"./sys/sockio.h",	"SIOCGIFMEM",	_IOWR(i,19, struct ifreq)	/* get interface mem */},
{"./sys/sockio.h",	"SIOCGIFCONF",	_IOWR(i,20, struct ifconf)	/* get ifnet list */},
{"./sys/sockio.h",	"SIOCSIFMTU",	_IOW(i, 21, struct ifreq)	/* set if_mtu */},
{"./sys/sockio.h",	"SIOCGIFMTU",	_IOWR(i,22, struct ifreq)	/* get if_mtu */},
{"./sys/sockio.h",	"SIOCGIFBRDADDR",	_IOWR(i,23, struct ifreq)	/* get broadcast addr */},
{"./sys/sockio.h",	"SIOCSIFBRDADDR",	_IOW(i,24, struct ifreq)	/* set broadcast addr */},
{"./sys/sockio.h",	"SIOCGIFNETMASK",	_IOWR(i,25, struct ifreq)	/* get net addr mask */},
{"./sys/sockio.h",	"SIOCSIFNETMASK",	_IOW(i,26, struct ifreq)	/* set net addr mask */},
{"./sys/sockio.h",	"SIOCGIFMETRIC",	_IOWR(i,27, struct ifreq)	/* get IF metric */},
{"./sys/sockio.h",	"SIOCSIFMETRIC",	_IOW(i,28, struct ifreq)	/* set IF metric */},
{"./sys/sockio.h",	"SIOCSARP",	_IOW(i, 30, struct arpreq)	/* set arp entry */},
{"./sys/sockio.h",	"SIOCGARP",	_IOWR(i,31, struct arpreq)	/* get arp entry */},
{"./sys/sockio.h",	"SIOCDARP",	_IOW(i, 32, struct arpreq)	/* delete arp entry */},
{"./sys/sockio.h",	"SIOCUPPER",	_IOW(i, 40, struct ifreq)       /* attach upper layer */},
{"./sys/sockio.h",	"SIOCLOWER",	_IOW(i, 41, struct ifreq)       /* attach lower layer */},
{"./sys/sockio.h",	"SIOCSETSYNC",	_IOW(i,  44, struct ifreq)	/* set syncmode */},
{"./sys/sockio.h",	"SIOCGETSYNC",	_IOWR(i, 45, struct ifreq)	/* get syncmode */},
{"./sys/sockio.h",	"SIOCSSDSTATS",	_IOWR(i, 46, struct ifreq)	/* sync data stats */},
{"./sys/sockio.h",	"SIOCSSESTATS",	_IOWR(i, 47, struct ifreq)	/* sync error stats */},
{"./sys/sockio.h",	"SIOCSPROMISC",	_IOW(i, 48, int)		/* request promisc mode},
{"./sys/sockio.h",	"SIOCADDMULTI",	_IOW(i, 49, struct ifreq)	/* set m/c address */},
{"./sys/sockio.h",	"SIOCDELMULTI",	_IOW(i, 50, struct ifreq)	/* clr m/c address */},
{"./sys/sockio.h",	"SIOCFDRESET",	_IOW(i, 51, struct ifreq)	/* Reset FDDI */},
{"./sys/sockio.h",	"SIOCFDSLEEP",	_IOW(i, 52, struct ifreq)	/* Sleep until next dnld req */},
{"./sys/sockio.h",	"SIOCSTRTFMWAR",	_IOW(i, 53, struct ifreq)	/* Start FW at an addr */},
{"./sys/sockio.h",	"SIOCLDNSTRTFW",	_IOW(i, 54, struct ifreq)	/* Load the shared memory */},
{"./sys/sockio.h",	"SIOCGETFDSTAT",	_IOW(i, 55, struct ifreq)	/* Get FDDI stats */},
{"./sys/sockio.h",	"SIOCFDNMIINT",	_IOW(i, 56, struct ifreq)        /* NMI to fddi */},
{"./sys/sockio.h",	"SIOCFDEXUSER",	_IOW(i, 57, struct ifreq)        /* Exec in user mode */},
{"./sys/sockio.h",	"SIOCFDGNETMAP",	_IOW(i, 58, struct ifreq)        /* Get a netmap entry */},
{"./sys/sockio.h",	"SIOCFDGIOCTL",	_IOW(i, 59, struct ifreq)	 /* Generic ioctl for fddi */},
{"./sys/sockio.h",	"SIOCSNIT",	_IOW(p,  0, struct nit_ioc)	/* set nit modes */},
{"./sys/sockio.h",	"SIOCGNIT",	_IOWR(p, 1, struct nit_ioc)	/* get nit modes */},
{"./sys/stropts.h",	"I_NREAD",	_IOR(S,01,int)},
{"./sys/stropts.h",	"I_PUSH",	_IOWN(S,02,FMNAMESZ+1)},
{"./sys/stropts.h",	"I_POP",	_IO(S,03)},
{"./sys/stropts.h",	"I_LOOK",	_IORN(S,04,FMNAMESZ+1)},
{"./sys/stropts.h",	"I_FLUSH",	_IO(S,05)},
{"./sys/stropts.h",	"I_SRDOPT",	_IO(S,06)},
{"./sys/stropts.h",	"I_GRDOPT",	_IOR(S,07,int)},
{"./sys/stropts.h",	"I_STR",	_IOWR(S,010,struct strioctl)},
{"./sys/stropts.h",	"I_SETSIG",	_IO(S,011)},
{"./sys/stropts.h",	"I_GETSIG",	_IOR(S,012,int)},
{"./sys/stropts.h",	"I_FIND",	_IOWN(S,013,FMNAMESZ+1)},
{"./sys/stropts.h",	"I_LINK",	_IO(S,014)},
{"./sys/stropts.h",	"I_UNLINK",	_IO(S,015)},
{"./sys/stropts.h",	"I_PEEK",	_IOWR(S,017,struct strpeek)},
{"./sys/stropts.h",	"I_FDINSERT",	_IOW(S,020,struct strfdinsert)},
{"./sys/stropts.h",	"I_SENDFD",	_IO(S,021)},
{"./sys/stropts.h",	"I_RECVFD",	_IOR(S,022,struct strrecvfd)},
{"./sys/stropts.h",	"I_PLINK",	_IO(S,023)},
{"./sys/stropts.h",	"I_PUNLINK",	_IO(S,024)},
{"./sys/ttold.h",	"TIOCGETD",	_IOR(t, 0, int)		/* get line discipline */},
{"./sys/ttold.h",	"TIOCSETD",	_IOW(t, 1, int)		/* set line discipline */},
{"./sys/ttold.h",	"TIOCHPCL",	_IO(t, 2)		/* hang up on last close */},
{"./sys/ttold.h",	"TIOCMODG",	_IOR(t, 3, int)		/* get modem state - OBSOLETE */},
{"./sys/ttold.h",	"TIOCMODS",	_IOW(t, 4, int)		/* set modem state - OBSOLETE */},
{"./sys/ttold.h",	"TIOCGETP",	_IOR(t, 8,struct sgttyb)/* get parameters -- gtty */},
{"./sys/ttold.h",	"TIOCSETP",	_IOW(t, 9,struct sgttyb)/* set parameters -- stty */},
{"./sys/ttold.h",	"TIOCSETN",	_IOW(t,10,struct sgttyb)/* as above, but no flushtty */},
{"./sys/ttold.h",	"TIOCEXCL",	_IO(t, 13)		/* set exclusive use of tty */},
{"./sys/ttold.h",	"TIOCNXCL",	_IO(t, 14)		/* reset exclusive use of tty */},
{"./sys/ttold.h",	"TIOCFLUSH",	_IOW(t, 16, int)	/* flush buffers */},
{"./sys/ttold.h",	"TIOCSETC",	_IOW(t,17,struct tchars)/* set special characters */},
{"./sys/ttold.h",	"TIOCGETC",	_IOR(t,18,struct tchars)/* get special characters */},
{"./sys/ttold.h",	"TIOCLBIS",	_IOW(t, 127, int)	/* bis local mode bits */},
{"./sys/ttold.h",	"TIOCLBIC",	_IOW(t, 126, int)	/* bic local mode bits */},
{"./sys/ttold.h",	"TIOCLSET",	_IOW(t, 125, int)	/* set entire local mode word */},
{"./sys/ttold.h",	"TIOCLGET",	_IOR(t, 124, int)	/* get local modes */},
{"./sys/ttold.h",	"TIOCSBRK",	_IO(t, 123)		/* set break bit */},
{"./sys/ttold.h",	"TIOCCBRK",	_IO(t, 122)		/* clear break bit */},
{"./sys/ttold.h",	"TIOCSDTR",	_IO(t, 121)		/* set data terminal ready */},
{"./sys/ttold.h",	"TIOCCDTR",	_IO(t, 120)		/* clear data terminal ready */},
{"./sys/ttold.h",	"TIOCSLTC",	_IOW(t,117,struct ltchars)/* set local special chars */},
{"./sys/ttold.h",	"TIOCGLTC",	_IOR(t,116,struct ltchars)/* get local special chars */},
{"./sys/ttold.h",	"TIOCSTOP",	_IO(t, 111)		/* stop output, like ^S */},
{"./sys/ttold.h",	"TIOCSTART",	_IO(t, 110)		/* start output, like ^Q */},
{"./sys/ttold.h",	"_O_TIOCCONS",	_IO(t, 104)		/* get console I/O */},
{"./sys/ttold.h",	"_O_TIOCSSIZE",	_IOW(t,103,struct ttysize)/* get tty size */},
{"./sys/ttold.h",	"_O_TIOCGSIZE",	_IOR(t,102,struct ttysize)/* get tty size */},
{"./sys/ttold.h",	"TIOCSETX",	_IOW(t, 34, int)	/* set extra modes for S5 compatibility */},
{"./sys/ttold.h",	"TIOCGETX",	_IOR(t, 35, int)	/* get extra modes for S5 compatibility */},
{"./sys/ttycom.h",	"TIOCGWINSZ",	_IOR(t, 104, struct winsize)	/* get window size */},
{"./sys/ttycom.h",	"TIOCSWINSZ",	_IOW(t, 103, struct winsize)	/* set window size */},
{"./sys/ttycom.h",	"TIOCSSIZE",	_IOW(t,37,struct ttysize)/* set tty size */},
{"./sys/ttycom.h",	"TIOCGSIZE",	_IOR(t,38,struct ttysize)/* get tty size */},
{"./sys/ttycom.h",	"TIOCSCTTY",	_IO(t, 132)		/* get a ctty */},
{"./sys/ttycom.h",	"TIOCGPGRP",	_IOR(t, 119, int)	/* get pgrp of tty */},
{"./sys/ttycom.h",	"TIOCGETPGRP",	_IOR(t, 131, int)	/* get pgrp of tty (posix) */},
{"./sys/ttycom.h",	"TIOCSPGRP",	_IOW(t, 118, int)	/* set pgrp of tty */},
{"./sys/ttycom.h",	"TIOCSETPGRP",	_IOW(t, 130, int)	/* set pgrp of tty (posix) */},
{"./sys/ttycom.h",	"TIOCOUTQ",	_IOR(t, 115, int)	/* output queue size */},
{"./sys/ttycom.h",	"TIOCSTI",	_IOW(t, 114, char)	/* simulate terminal input */},
{"./sys/ttycom.h",	"TIOCNOTTY",	_IO(t, 113)		/* void tty association */},
{"./sys/ttycom.h",	"TIOCPKT",	_IOW(t, 112, int)	/* pty: set/clear packet mode */},
{"./sys/ttycom.h",	"TIOCMSET",	_IOW(t, 109, int)	/* set all modem bits */},
{"./sys/ttycom.h",	"TIOCMBIS",	_IOW(t, 108, int)	/* bis modem bits */},
{"./sys/ttycom.h",	"TIOCMBIC",	_IOW(t, 107, int)	/* bic modem bits */},
{"./sys/ttycom.h",	"TIOCMGET",	_IOR(t, 106, int)	/* get all modem bits */},
{"./sys/ttycom.h",	"TIOCREMOTE",	_IOW(t, 105, int)	/* remote input editing */},
{"./sys/ttycom.h",	"TIOCUCNTL",	_IOW(t, 102, int)	/* pty: set/clr usr cntl mode */},
{"./sys/ttycom.h",	"TIOCTCNTL",	_IOW(t, 32, int)	/* pty: set/clr intercept ioctl mode */},
{"./sys/ttycom.h",	"TIOCSIGNAL",	_IOW(t, 33, int)	/* pty: send signal to slave */},
{"./sys/ttycom.h",	"TIOCCONS",	_IO(t, 36)		/* get console I/O */},
{"./sys/ttycom.h",	"TIOCSSOFTCAR",	_IOW(t, 101, int)	/* set soft carrier flag */},
{"./sys/ttycom.h",	"TIOCGSOFTCAR",	_IOR(t, 100, int)	/* get soft carrier flag */},
{"./sys/ttycom.h",	"TIOCISPACE",	_IOR(t, 128, int)	/* space left in input queue */},
{"./sys/ttycom.h",	"TIOCISIZE",	_IOR(t, 129, int)	/* size of input queue */},
{"./sys/ttycom.h",	"TIOCSINTR",	_IOW(t, 99, int)	/* set DOS interrupt number */},
{"./sys/vcmd.h",	"VGETSTATE",	_IOR(v, 0, int)},
{"./sys/vcmd.h",	"VSETSTATE",	_IOW(v, 1, int)},
{"./sbusdev/audio_79C30.h",	"AUDIOGETREG",	_IOWR(i, 1, struct audio_ioctl)},
{"./sbusdev/audio_79C30.h",	"AUDIOSETREG",	_IOW(i, 2, struct audio_ioctl)},
{"./scsi/impl/uscsi.h",		"USCSICMD",	_IOWR(u, 1, struct uscsi_cmd) /* user scsi command */},
{"./scsi/targets/stdef.h",	"STIOCGET",	_IOR(m, 2, struct st_mtget)},
{"./scsi/targets/srdef.h",	"CDROMPAUSE",	_IO(c, 10)	/* Pause Audio Operation */},
{"./scsi/targets/srdef.h",	"CDROMRESUME",	_IO(c, 11)	/* Resume paused Audio Operation */},
{"./scsi/targets/srdef.h",	"CDROMPLAYMSF",	_IOW(c, 12, struct cdrom_msf)	/* Play Audio MSF */},
{"./scsi/targets/srdef.h",	"CDROMPLAYTRKIND",	_IOW(c, 13, struct cdrom_ti)	/*},
{"./scsi/targets/srdef.h",	"CDROMREADTOCHDR",	_IOR(c, 103, struct cdrom_tochdr)	/* Read TOC header */},
{"./scsi/targets/srdef.h",	"CDROMREADTOCENTRY",	_IOWR(c, 104, struct cdrom_tocentry)		/* Read a TOC entry */},
{"./scsi/targets/srdef.h",	"CDROMSTOP",	_IO(c, 105)	/* Stop the cdrom drive */},
{"./scsi/targets/srdef.h",	"CDROMSTART",	_IO(c, 106)	/* Start the cdrom drive */},
{"./scsi/targets/srdef.h",	"CDROMEJECT",	_IO(c, 107)	/* Ejects the cdrom caddy */},
{"./scsi/targets/srdef.h",	"CDROMVOLCTRL",	_IOW(c, 14, struct cdrom_volctrl)	/* control output volume */},
{"./scsi/targets/srdef.h",	"CDROMSUBCHNL",	_IOWR(c, 108, struct cdrom_subchnl)	/* read the subchannel data */},
{"./scsi/targets/srdef.h",	"CDROMREADMODE2",_IOW(c, 110, struct cdrom_read)		/* read CDROM mode 2 data */},
{"./scsi/targets/srdef.h",	"CDROMREADMODE1",_IOW(c, 111, struct cdrom_read)		/* read CDROM mode 1 data */},
{"./sun/audioio.h",	"AUDIO_GETINFO",	_IOR(A, 1, audio_info_t)},
{"./sun/audioio.h",	"AUDIO_SETINFO",	_IOWR(A, 2, audio_info_t)},
{"./sun/audioio.h",	"AUDIO_DRAIN",		_IO(A, 3)},
{"./sun/audioio.h",	"AUDIOREADSTART",	_IO(1, 3)},
{"./sun/audioio.h",	"AUDIOSTOP",	_IO(1, 4)},
{"./sun/audioio.h",	"AUDIOPAUSE",	_IO(1, 5)},
{"./sun/audioio.h",	"AUDIORESUME",	_IO(1, 6)},
{"./sun/audioio.h",	"AUDIOREADQ",	_IOR(1, 7, int)},
{"./sun/audioio.h",	"AUDIOWRITEQ",	_IOR(1, 8, int)},
{"./sun/audioio.h",	"AUDIOGETQSIZE",	_IOR(1, 9, int)},
{"./sun/audioio.h",	"AUDIOSETQSIZE",	_IOW(1, 10, int)},
{"./sun/dkio.h",	"DKIOCGGEOM",	_IOR(d, 2, struct dk_geom)	/* Get geometry */},
{"./sun/dkio.h",	"DKIOCSGEOM",	_IOW(d, 3, struct dk_geom)	/* Set geometry */},
{"./sun/dkio.h",	"DKIOCGPART",	_IOR(d, 4, struct dk_map)	/* Get partition info */},
{"./sun/dkio.h",	"DKIOCSPART",	_IOW(d, 5, struct dk_map)	/* Set partition info */},
{"./sun/dkio.h",	"DKIOCINFO",	_IOR(d, 8, struct dk_info)	/* Get info */},
{"./sun/dkio.h",	"DKIOCGCONF",	_IOR(d, 126, struct dk_conf)	/* Get conf info */},
{"./sun/dkio.h",	"DKIOCSTYPE",	_IOW(d, 125, struct dk_type)	/* Set drive info */},
{"./sun/dkio.h",	"DKIOCGTYPE",	_IOR(d, 124, struct dk_type)	/* Get drive info */},
{"./sun/dkio.h",	"DKIOCSAPART",	_IOW(d, 123, struct dk_allmap)	/* Set all partitions */},
{"./sun/dkio.h",	"DKIOCGAPART",	_IOR(d, 122, struct dk_allmap)	/* Get all partitions */},
{"./sun/dkio.h",	"DKIOCSBAD",	_IOW(d, 121, struct dk_badmap)	/* Set bad sector map */},
{"./sun/dkio.h",	"DKIOCGBAD",	_IOW(d, 120, struct dk_badmap)	/* Get bad sector map */},
{"./sun/dkio.h",	"DKIOCSCMD",	_IOW(d, 119, struct dk_cmd)	/* Set generic cmd */},
{"./sun/dkio.h",	"DKIOCGLOG",	_IOR(d, 118, struct dk_loghdr)	/* Get error log */},
{"./sun/dkio.h",	"DKIOCGDIAG",	_IOR(d, 116, struct dk_diag)	/* Get diagnostics */},
{"./sun/dkio.h",	"DKIOCWCHK",	_IOWR(d, 115, int)		/* Toggle write check */},
{"./sun/dkio.h",	"FDKIOGCHAR",	_IOR(d, 114, struct fdk_char)	/* GetCharacteristics */},
{"./sun/dkio.h",	"FDKIOSCHAR",	_IOW(d, 113, struct fdk_char)	/* SetCharacteristics */},
{"./sun/dkio.h",	"FDKEJECT",	_IO(d, 112)			/* Eject floppy disk */},
{"./sun/dkio.h",	"FDKGETCHANGE",	_IOR(d, 111, int)		/* Get diskchng stat */},
{"./sun/dkio.h",	"FDKGETDRIVECHAR",	_IOR(d, 110, struct fdk_drive)	/* Get drivechar */},
{"./sun/dkio.h",	"FDKSETDRIVECHAR",	_IOW(d, 109, struct fdk_drive)	/* Set drivechar */},
{"./sun/dkio.h",	"FDKGETSEARCH",	_IOR(d, 108, struct fdk_search)	/* Get search tbl */},
{"./sun/dkio.h",	"FDKSETSEARCH",	_IOW(d, 107, struct fdk_search)	/* Set search tbl */},
{"./sun/dkio.h",	"FDKIOCSCMD",	_IOWR(d, 106, struct fdk_cmd)	/* Floppy command */},
{"./sun/dkio.h",	"F_RAW",	_IOWR(d, 105, struct fdraw)	/* ECDstyle genericcmd*/},
{"./sun/fbio.h",	"FBIOGTYPE",	_IOR(F, 0, struct fbtype)},
{"./sun/fbio.h",	"FBIOGPIXRECT",	_IOWR(F, 1, struct fbpixrect)},
{"./sun/fbio.h",	"FBIOGINFO",	_IOR(F, 2, struct fbinfo)},
{"./sun/fbio.h",	"FBIOPUTCMAP",	_IOW(F, 3, struct fbcmap)},
{"./sun/fbio.h",	"FBIOGETCMAP",	_IOW(F, 4, struct fbcmap)},
{"./sun/fbio.h",	"FBIOSATTR",	_IOW(F, 5, struct fbsattr)},
{"./sun/fbio.h",	"FBIOGATTR",	_IOR(F, 6, struct fbgattr)},
{"./sun/fbio.h",	"FBIOSVIDEO",	_IOW(F, 7, int)},
{"./sun/fbio.h",	"FBIOGVIDEO",	_IOR(F, 8, int)},
{"./sun/fbio.h",	"FBIOVERTICAL",	_IOW(F, 9, int)},
{"./sun/fbio.h",	"GRABPAGEALLOC",	_IOR(F, 10, caddr_t)},
{"./sun/fbio.h",	"GRABPAGEFREE",	_IOW(F, 11, caddr_t)},
{"./sun/fbio.h",	"GRABATTACH",	_IOW(F, 12, caddr_t)},
{"./sun/fbio.h",	"FBIOGPLNGRP",	_IOR(F, 13, int)},
{"./sun/fbio.h",	"FBIOGCMSIZE",	_IOR(F, 14, int)},
{"./sun/fbio.h",	"FBIOSCMSIZE",	_IOW(F, 15, int)},
{"./sun/fbio.h",	"FBIOSCMS",	_IOW(F, 16, int)},
{"./sun/fbio.h",	"FBIOAVAILPLNGRP",	_IOR(F, 17, int)},
{"./sun/fbio.h",	"FBIODBLGINFO",	_IOR(F, 18, struct fbdblinfo)},
{"./sun/fbio.h",	"FBIODBLSINFO",	_IOW(F, 19, struct fbdblinfo)},
{"./sun/fbio.h",	"FBIOSWINFD",	_IOR(F, 20, int)},
{"./sun/fbio.h",	"FBIOSAVWINFD",	_IOR(F, 21, int)},
{"./sun/fbio.h",	"FBIORESWINFD",	_IOR(F, 22, int)},
{"./sun/fbio.h",	"FBIOSRWINFD",	_IOR(F, 23, int)},
#ifdef FBIO_WID_ALLOC
{"./sun/fbio.h",	"FBIO_WID_ALLOC",	_IOWR(F, 30, struct fb_wid_alloc)},
{"./sun/fbio.h",	"FBIO_WID_FREE",	_IOW(F, 31, struct fb_wid_alloc)},
{"./sun/fbio.h",	"FBIO_WID_PUT",	_IOW(F, 32, struct fb_wid_list)},
{"./sun/fbio.h",	"FBIO_WID_GET",	_IOW(F, 33, struct fb_wid_list)},
#endif
{"./sun/fbio.h",	"FBIO_WID_DBL_SET",	_IO(F, 37)},
{"./sun/fbio.h",	"FBIO_DEVID",	_IOR(F, 34, int)},
{"./sun/fbio.h",	"FBIO_U_RST",	_IOW(F, 35, int)},
{"./sun/fbio.h",	"FBIO_FULLSCREEN_ELIMINATION_GROUPS",	_IOR(F, 36, unsigned char *)},
#ifdef FBIOSCURSOR
{"./sun/fbio.h",	"FBIOSCURSOR",	_IOW(F, 24, struct fbcursor)},
{"./sun/fbio.h",	"FBIOGCURSOR",	_IOWR(F, 25, struct fbcursor)},
{"./sun/fbio.h",	"FBIOSCURPOS",	_IOW(F, 26, struct fbcurpos)},
{"./sun/fbio.h",	"FBIOGCURPOS",	_IOW(F, 27, struct fbcurpos)},
{"./sun/fbio.h",	"FBIOGCURMAX",	_IOR(F, 28, struct fbcurpos)},
#endif
{"./sun/fbio.h",	"GRABLOCKINFO",	_IOR(F, 29, caddr_t)},
{"./sun/gpio.h",	"GP1IO_PUT_INFO",	_IOW(G, 0, struct gp1fbinfo)},
{"./sun/gpio.h",	"GP1IO_GET_STATIC_BLOCK",	_IOR(G, 1, int)},
{"./sun/gpio.h",	"GP1IO_FREE_STATIC_BLOCK",	_IOW(G, 2, int)},
{"./sun/gpio.h",	"GP1IO_GET_GBUFFER_STATE",	_IOR(G, 3, int)},
{"./sun/gpio.h",	"GP1IO_CHK_GP",	_IOW(G, 4, int)},
{"./sun/gpio.h",	"GP1IO_GET_RESTART_COUNT	",	_IOR(G, 5, int)},
{"./sun/gpio.h",	"GP1IO_REDIRECT_DEVFB",	_IOW(G, 6, int)},
{"./sun/gpio.h",	"GP1IO_GET_REQDEV",	_IOR(G, 7, dev_t)},
{"./sun/gpio.h",	"GP1IO_GET_TRUMINORDEV",	_IOR(G, 8, char)},
{"./sun/gpio.h",	"GP1IO_CHK_FOR_GBUFFER",	_IOR(G, 9, int)},
{"./sun/gpio.h",	"GP1IO_SET_USING_GBUFFER",	_IOW(G, 10, int)},
#ifdef GP1IO_INFO_STATIC_BLOCK
{"./sun/gpio.h",	"GP1IO_INFO_STATIC_BLOCK",	_IOWR(G, 11, struct static_block_info)},
#endif
{"./sun/mem.h",		"_SUNDIAG_V2P",	_IOWR(M, 1, struct v2p)	/* Get physical address */},
{"./sun/mem.h",		"MM_HRCNT",	_IO(M, 2)},
{"./sun/mem.h",		"MM_CCRW",	_IOW(M, 3, int)},
{"./sun/mem.h",		"MM_PCNT0",	_IOW(M, 4, int)},
{"./sun/mem.h",		"MM_PCNT1",	_IOW(M, 5, int)},
{"./sun/ndio.h",	"NDIOCSON",	_IO(n, 0)	/* server on */},
{"./sun/ndio.h",	"NDIOCSOFF",	_IO(n, 1)	/* server off */},
{"./sun/ndio.h",	"NDIOCUSER",	_IOW(n, 3, struct ndiocuser) /* set user parameters */},
{"./sun/ndio.h",	"NDIOCSAT",	_IOW(n, 4, int) /* server at ipaddress */},
{"./sun/ndio.h",	"NDIOCCLEAR",	_IO(n, 5)	/* clear table of reg. users */},
{"./sun/ndio.h",	"NDIOCVER",	_IOW(n, 7, int)	/* version number */},
{"./sun/ndio.h",	"NDIOCETHER",	_IOW(n, 8, struct ndiocether) /* set ether address */},
{"./sun/sqz.h",		"SQZSET",	_IOW(q, 1, int)},
{"./sun/sqz.h",		"SQZGET",	_IOR(q, 2, struct sqz_status)},
{"./sun/tvio.h",	"TVIOGFORMAT",	_IOR(X, 1, int)		/* Get input format */},
{"./sun/tvio.h",	"TVIOSFORMAT",	_IOW(X, 2, int)		/* Set input format */},
{"./sun/tvio.h",	"TVIOGCOMPOUT",	_IOR(X, 3, int)		/* Get component out */},
{"./sun/tvio.h",	"TVIOSCOMPOUT",	_IOW(X, 4, int)		/* Set component out */},
{"./sun/tvio.h",	"TVIOGSYNC",	_IOR(X, 5, int)		/* Get sync select */},
{"./sun/tvio.h",	"TVIOSSYNC",	_IOW(X, 6, int)	    	/* Set sync select */},
{"./sun/tvio.h",	"TVIOGOUT",	_IOR(X, 7, int)		/* Get video output select */},
{"./sun/tvio.h",	"TVIOSOUT",	_IOW(X, 8, int)		/* Set video output select */},
{"./sun/tvio.h",	"TVIOGCOMPRESS",	_IOR(X, 9, int)		/* Get compression/expansion */},
{"./sun/tvio.h",	"TVIOSCOMPRESS",	_IOW(X, 10, int)	/* Set compression/expansion */},
{"./sun/tvio.h",	"TVIOGCHROMAGAIN",	_IOR(X, 11, int)	/* Get chroma gain */},
{"./sun/tvio.h",	"TVIOSCHROMAGAIN",	_IOW(X, 12, int)	/* Set chroma gain */},
{"./sun/tvio.h",	"TVIOGREDGAIN",	_IOR(X, 13, int)	/* Get red gain */},
{"./sun/tvio.h",	"TVIOSREDGAIN",	_IOW(X, 14, int)	/* Set red gain */},
{"./sun/tvio.h",	"TVIOGREDBLACK",	_IOR(X, 15, int)	/* Get red black level */},
{"./sun/tvio.h",	"TVIOSREDBLACK",	_IOW(X, 16, int)	/* Set red black level */},
{"./sun/tvio.h",	"TVIOGGREENGAIN",	_IOR(X, 17, int)	/* Get green gain */},
{"./sun/tvio.h",	"TVIOSGREENGAIN",	_IOW(X, 18, int)	/* Set green gain */},
{"./sun/tvio.h",	"TVIOGGREENBLACK",	_IOR(X, 19, int)	/* Get green black level */},
{"./sun/tvio.h",	"TVIOSGREENBLACK",	_IOW(X, 20, int)	/* Set green Black level */},
{"./sun/tvio.h",	"TVIOGBLUEGAIN",	_IOR(X, 21, int)	/* Get blue gain */},
{"./sun/tvio.h",	"TVIOSBLUEGAIN",	_IOW(X, 22, int)	/* Set blue gain */},
{"./sun/tvio.h",	"TVIOGBLUEBLACK",	_IOR(X, 23, int)	/* Get blue black level */},
{"./sun/tvio.h",	"TVIOSBLUEBLACK",	_IOW(X, 24, int)	/* Set blue balck level */},
{"./sun/tvio.h",	"TVIOGLUMAGAIN",	_IOR(X, 25, int)	/* Get luma gain */},
{"./sun/tvio.h",	"TVIOSLUMAGAIN",	_IOW(X, 26, int)	/* Set Luma gain */},
{"./sun/tvio.h",	"TVIOGPOS",	_IOR(X, 27, struct pr_pos) /* get video start position */},
{"./sun/tvio.h",	"TVIOSPOS",	_IOW(X, 28, struct pr_pos) /* set video start position */},
{"./sun/tvio.h",	"TVIOGRAB",	_IO(X, 29)		/* Grab device */},
{"./sun/tvio.h",	"TVIORELEASE",	_IO(X, 30)		/* Release device */},
{"./sun/tvio.h",	"TVIOGBIND",	_IOR(X, 31, dev_t)	/* Get bound device's dev_t */},
{"./sun/tvio.h",	"TVIOSBIND",	_IOW(X, 32, dev_t)	/* Set bound device's dev_t  */},
{"./sun/tvio.h",	"TVIOGBTYPE",	_IOR(X, 33, int)	/* get bound device's type */},
{"./sun/tvio.h",	"TVIOREDIRECT",	_IO(X, 34)		/* Redirect /dev/fb */},
{"./sun/tvio.h",	"TVIOGLIVE",	_IOR(X, 35, int)	/* Get live status */},
{"./sun/tvio.h",	"TVIOSLIVE",	_IOW(X, 36, int)	/* Set live status */},
{"./sun/tvio.h",	"TVIOSYNC",	_IO(X, 37)		/* Syncronize buffer */},
{"./sun/tvio.h",	"TVIOGCHROMASEP",	_IOR(X, 39, int)	/* Get chroma separation */},
{"./sun/tvio.h",	"TVIOSCHROMASEP",	_IOW(X, 40, int)	/* Set chroma separation */},
{"./sun/tvio.h",	"TVIOGCHROMADEMOD",	_IOR(X, 41, int)	/* Get chroma demod. */},
{"./sun/tvio.h",	"TVIOSCHROMADEMOD",	_IOW(X, 42, int)	/* Set chroma demod. */},
{"./sun/tvio.h",	"TVIOGGENLOCK",	_IOR(X, 43, int)	/* Get Genlock status */},
{"./sun/tvio.h",	"TVIOSGENLOCK",	_IOW(X, 44, int)	/* Set Genlock status */},
{"./sun/tvio.h",	"TVIOVWAIT",	_IO(X, 45)		/* Wait for vertical sync */},
{"./sun/tvio.h",	"TVIOGSYNCABSENT",	_IOR(X, 46, int)	/* Check sync absent */},
{"./sun/tvio.h",	"TVIOGBURSTABSENT",	_IOR(X, 47, int)	/* Check burst absent */},
{"./sun/tvio.h",	"TVIOGVIDEOCAL",	_IOR(X, 49, union tv1_nvram)  /* Get calibration */},
{"./sun/tvio.h",	"TVIOSVIDEOCAL",	_IOW(X, 50, union tv1_nvram)  /* Set Calibration */},
{"./sun/tvio.h",	"TVIONVREAD",	_IOR(X, 51, union tv1_nvram)  /* Read cal from NV */ },
{"./sun/tvio.h",	"TVIONVWRITE",	_IOW(X, 52, union tv1_nvram)  /* Write cal to NV */},
{"./sun/tvio.h",	"TVIOSIBADVANCE",	_IOW(X, 53, int)   /* Advance ibstate */},
{"./sun/tvio.h",	"TVIOGIBSTATE",	_IOR(X, 55, int)   /* Get ibstate */},
{"./sun/tvio.h",	"TVIOSABSTATE",	_IOW(X, 56, int)   /* Set ibstate */},
{"./sun/tvio.h",	"TVIOGABSTATE",	_IOR(X, 57, int)   /* Get abstate */},
{"./sun/tvio.h",	"TVIOGCONTROL",	_IOR(X, 59, int)   /* Get control register */},
{"./sun/tvio.h",	"TVIOSCONTROL",	_IOW(X, 60, int)  /* Set control register */},
{"./sun/tvio.h",	"TVIOSLOOPBACKCAL",	_IO(X, 61)	  /* switch to Loopback cal */},
{"./sun/vddrv.h",	"VDLOAD",	_IOWR(V, 0, struct vdioctl_load)},
{"./sun/vddrv.h",	"VDUNLOAD",	_IOWR(V, 1, struct vdioctl_unload)},
{"./sun/vddrv.h",	"VDSTAT",	_IOWR(V, 2, struct vdioctl_stat)},
{"./sun/vddrv.h",	"VDGETVADDR",	_IOWR(V, 3, struct vdioctl_getvaddr)},
{"./sun/vddrv.h",	"VDFREEVADDR",	_IOW(V, 4, struct vdioctl_freevaddr)},
{"./sundev/dbio.h",	"DBIOBUTLITE",	_IOW(B, 0, int)},
{"./sundev/fdreg.h",	"V_FORMAT",		_IOW(V, 5, union io_arg)     /* Format track(s) */},
#if 0
{"./sundev/fpareg.h",	"FPA_ACCESS_ON",	_IO(p, 1)},
{"./sundev/fpareg.h",	"FPA_ACCESS_OFF",	_IO(p, 2)},
{"./sundev/fpareg.h",	"FPA_LOAD_ON",	_IO(p, 3)},
{"./sundev/fpareg.h",	"FPA_LOAD_OFF",	_IO(p, 4)},
{"./sundev/fpareg.h",	"FPA_GET_DATAREGS",	_IOWR(p, 6, union fpa_qtr_dregs)},
{"./sundev/fpareg.h",	"FPA_FAIL",		_IOW(p, 7, struct fpa_line)},
{"./sundev/fpareg.h",	"FPA_INIT_DONE",	_IO(p, 8)},
{"./sundev/fpareg.h",	"FPA_WRITE_STATE",	_IO(p, 9)},
{"./sundev/fpareg.h",	"FPA_WRITE_HCP",	_IO(p, 10)},
#endif
{"./sundev/kbio.h", "KIOCTRANS",	_IOW(k, 0, int)	/* set keyboard translation */},
{"./sundev/kbio.h", "KIOCGTRANS",	_IOR(k, 5, int)	/* get keyboard translation */},
{"./sundev/kbio.h", "KIOCTRANSABLE",	_IOW(k, 6, int)	/* set keyboard translatability */},
{"./sundev/kbio.h", "KIOCGTRANSABLE",	_IOR(k, 7, int)	/* get keyboard translatability */},
{"./sundev/kbio.h", "KIOCSETKEY",	_IOW(k, 1, struct kiockey)},
{"./sundev/kbio.h", "KIOCGETKEY",	_IOWR(k, 2, struct kiockey)},
{"./sundev/kbio.h", "KIOCCMD",	_IOW(k, 8, int)	/* Send keyboard command */},
{"./sundev/kbio.h", "KIOCTYPE",	_IOR(k, 9, int)	/* get keyboard type */},
{"./sundev/kbio.h", "KIOCSDIRECT",	_IOW(k, 10, int)},
{"./sundev/kbio.h", "KIOCGDIRECT",	_IOR(k, 11, int)},
{"./sundev/kbio.h", "KIOCSKEY",	_IOW(k, 12, struct kiockeymap)},
{"./sundev/kbio.h", "KIOCGKEY",	_IOWR(k, 13, struct kiockeymap)},
{"./sundev/kbio.h", "KIOCSLED",	_IOW(k, 14, char)},
{"./sundev/kbio.h", "KIOCGLED",	_IOR(k, 15, char)},
{"./sundev/kbio.h", "KIOCSCOMPAT",	_IOW(k, 16, int)},
{"./sundev/kbio.h", "KIOCGCOMPAT",	_IOR(k, 17, int)},
{"./sundev/kbio.h", "KIOCLAYOUT",	_IOR(k, 20, int)},
{"./sundev/mcpcmd.h", "MCPIOSPR",	_IOWR(M, 1, u_char)},
{"./sundev/mcpcmd.h", "MCPIOGPR",	_IOR(M, 1, u_char)},
{"./sundev/msio.h", "MSIOGETPARMS",	_IOR(m, 2, Ms_parms) },
{"./sundev/msio.h", "MSIOSETPARMS",	_IOW(m, 3, Ms_parms) },
{"./sundev/msreg.h", "MSIOGETBUF",	_IOWR(m, 1, int)},
{"./sundev/openpromio.h", "OPROMGETOPT",	_IO(O, 1)},
{"./sundev/openpromio.h", "OPROMSETOPT",	_IO(O, 2)},
{"./sundev/openpromio.h", "OPROMNXTOPT",	_IO(O, 3)},
{"./sundev/openpromio.h", "OPROMSETOPT2",	_IO(O, 4)},
{"./sundev/openpromio.h", "OPROMNEXT",	_IO(O, 5)},
{"./sundev/openpromio.h", "OPROMCHILD",	_IO(O, 6)},
{"./sundev/openpromio.h", "OPROMGETPROP",	_IO(O, 7)},
{"./sundev/openpromio.h", "OPROMNXTPROP",	_IO(O, 8)},
{"./sundev/openpromio.h", "OPROMU2P",	_IO(O, 9)},
{"./sundev/ppreg.h", "PPIOCGETS",	_IOR(p, 0, char)},
{"./sundev/ppreg.h", "PPIOCGETC",	_IOR(p, 1, char)},
{"./sundev/ppreg.h", "PPIOCSETC",	_IOW(p, 2, char)},
{"./sundev/srreg.h", "SR_IOC_AUDSEARCH",	_IOW(o, 20,int)},
{"./sundev/srreg.h", "SR_IOC_AUDPLAY",	_IO(o, 21)},
{"./sundev/srreg.h", "CDROMPAUSE",	_IO(c, 10)},
{"./sundev/srreg.h", "CDROMRESUME",	_IO(c, 11)},
{"./sundev/srreg.h", "CDROMPLAYMSF",	_IOW(c, 12, struct cdrom_msf)},
{"./sundev/srreg.h", "CDROMPLAYTRKIND",	_IOW(c, 13, struct cdrom_ti)},
{"./sundev/srreg.h", "CDROMREADTOCHDR",	_IOR(c, 103, struct cdrom_tochdr)},
{"./sundev/srreg.h", "USCSICMD",		_IOWR(u, 1, struct uscsi_cmd)},
{"./sundev/srreg.h", "CDROMREADTOCENTRY",	_IOWR(c, 104, struct cdrom_tocentry)},
{"./sundev/srreg.h", "CDROMSTOP",		_IO(c, 105)},
{"./sundev/srreg.h", "CDROMSTART",	_IO(c, 106)},
{"./sundev/srreg.h", "CDROMEJECT",	_IO(c, 107)},
{"./sundev/srreg.h", "CDROMVOLCTRL",	_IOW(c, 14, struct cdrom_volctrl)},
{"./sundev/srreg.h", "CDROMSUBCHNL",	_IOWR(c, 108, struct cdrom_subchnl)},
{"./sundev/srreg.h", "CDROMREADMODE2",	_IOW(c, 110, struct cdrom_read)},
{"./sundev/srreg.h", "CDROMREADMODE1",	_IOW(c, 111, struct cdrom_read)},
{"./sundev/streg.h", "STIOCGET",		_IOR(m, 2, struct st_mtget)},
{"./sundev/vuid_event.h", "VUIDSFORMAT",	_IOW(v, 1, int)},
{"./sundev/vuid_event.h", "VUIDGFORMAT",	_IOR(v, 2, int)},
{"./sundev/vuid_event.h", "VUIDSADDR",	_IOW(v, 3, struct  vuid_addr_probe)},
{"./sundev/vuid_event.h", "VUIDGADDR",	_IOWR(v, 4, struct  vuid_addr_probe)},
{"./pixrect/gp1var.h", "GP1IO_SATTR",	_IOW(G, 101, struct fbgattr)},
{"./pixrect/gp1var.h", "GP1IO_SCMAP",	_IO(G, 102)},
{"./sunwindow/win_ioctl.h", "WINSETLINK",	_IOW(g, 1, struct winlink)},
{"./sunwindow/win_ioctl.h", "WINGETLINK",	_IOWR(g, 2, struct winlink)},
{"./sunwindow/win_ioctl.h", "WININSERT",	_IO(g, 3)},
{"./sunwindow/win_ioctl.h", "WINREMOVE",	_IO(g, 4)},
{"./sunwindow/win_ioctl.h", "WINNEXTFREE",	_IOR(g, 5, struct winlink)},
{"./sunwindow/win_ioctl.h", "WINGETTREELAYER",	_IOWR(g, 25, Win_tree_layer)},
{"./sunwindow/win_ioctl.h", "WINSETMOUSE",	_IOW(g, 6, struct mouseposition)},
{"./sunwindow/win_ioctl.h", "WINSETCURSOR",	_IOW(g, 7, struct old_cursor)},
{"./sunwindow/win_ioctl.h", "WINGETCURSOR",	_IOWR(g, 8, struct old_cursor)},
{"./sunwindow/win_ioctl.h", "WINSETLOCATOR",	_IOW(g, 48, struct cursor)},
{"./sunwindow/win_ioctl.h", "WINGETLOCATOR",	_IOWR(g, 49, struct cursor)},
{"./sunwindow/win_ioctl.h", "WINFINDINTERSECT",	_IOWR(g, 9, struct winintersect)},
{"./sunwindow/win_ioctl.h", "WINGETRECT",	_IOR(g, 10, struct rect)},
{"./sunwindow/win_ioctl.h", "WINSETRECT",	_IOW(g, 11, struct rect)},
{"./sunwindow/win_ioctl.h", "WINSETSAVEDRECT",	_IOW(g, 12, struct rect)},
{"./sunwindow/win_ioctl.h", "WINGETSAVEDRECT",	_IOR(g, 13, struct rect)},
{"./sunwindow/win_ioctl.h", "WINGETUSERFLAGS",	_IOR(g, 14, int)},
{"./sunwindow/win_ioctl.h", "WINSETUSERFLAGS",	_IOW(g, 15, int)},
{"./sunwindow/win_ioctl.h", "WINGETOWNER",	_IOR(g, 16, int)},
{"./sunwindow/win_ioctl.h", "WINSETOWNER",	_IOW(g, 17, int)},
{"./sunwindow/win_ioctl.h", "WINGETNOTIFYALL",	_IOR(g, 81, int)},
{"./sunwindow/win_ioctl.h", "WINSETNOTIFYALL",	_IOW(g, 82, int)},
{"./sunwindow/win_ioctl.h", "WINGETINPUTMASK",	_IOR(g, 19, struct inputmaskdata)},
{"./sunwindow/win_ioctl.h", "WINSETINPUTMASK",	_IOW(g, 20, struct inputmaskdata)},
{"./sunwindow/win_ioctl.h", "WINGETKBDMASK",	_IOR(g, 52, struct inputmask)},
{"./sunwindow/win_ioctl.h", "WINGETPICKMASK",	_IOR(g, 53, struct inputmask)},
{"./sunwindow/win_ioctl.h", "WINSETKBDMASK",	_IOW(g, 54, struct inputmask)},
{"./sunwindow/win_ioctl.h", "WINSETPICKMASK",	_IOW(g, 55, struct inputmask)},
{"./sunwindow/win_ioctl.h", "WINSETNEXTINPUT",	_IOW(g, 56, int)},
{"./sunwindow/win_ioctl.h", "WINGETNEXTINPUT",	_IOR(g, 57, int)},
{"./sunwindow/win_ioctl.h", "WINGETBUTTONORDER",	_IOR(g, 36, int)},
{"./sunwindow/win_ioctl.h", "WINSETBUTTONORDER",	_IOW(g, 37, int)},
{"./sunwindow/win_ioctl.h", "WINGETSCALING",	_IOR(g, 38, Ws_scale_list)},
{"./sunwindow/win_ioctl.h", "WINSETSCALING",	_IOW(g, 39, Ws_scale_list)},
{"./sunwindow/win_ioctl.h", "WINSETFOCUSEVENT",	_IOW(g, 70, struct focus_event)},
{"./sunwindow/win_ioctl.h", "WINGETFOCUSEVENT",	_IOR(g, 71, struct focus_event)},
{"./sunwindow/win_ioctl.h", "WINSETSWALLOWEVENT",	_IOW(g, 72, struct focus_event)},
{"./sunwindow/win_ioctl.h", "WINGETSWALLOWEVENT",	_IOR(g, 73, struct focus_event)},
{"./sunwindow/win_ioctl.h", "WINREFUSEKBDFOCUS",	_IO(g, 58)},
{"./sunwindow/win_ioctl.h", "WINSETKBDFOCUS",	_IOW(g, 61, int)},
{"./sunwindow/win_ioctl.h", "WINGETKBDFOCUS",	_IOWR(g, 62, int)},
{"./sunwindow/win_ioctl.h", "WINGETVUIDVALUE",	_IOWR(g, 27, struct firm_event)},
{"./sunwindow/win_ioctl.h", "WINSETEVENTTIMEOUT",	_IOW(g, 59, struct timeval)},
{"./sunwindow/win_ioctl.h", "WINGETEVENTTIMEOUT",	_IOR(g, 60, struct timeval)},
{"./sunwindow/win_ioctl.h", "WINUNLOCKEVENT",	_IO(g, 28)},
{"./sunwindow/win_ioctl.h", "WINLOCKDATA",	_IO(g, 21)},
{"./sunwindow/win_ioctl.h", "WINCOMPUTECLIPPING",	_IO(g, 18)},
{"./sunwindow/win_ioctl.h", "WINPARTIALREPAIR",	_IOW(g, 43, struct rect)},
{"./sunwindow/win_ioctl.h", "WINUNLOCKDATA",	_IO(g, 22)},
{"./sunwindow/win_ioctl.h", "WINGRABIO",	_IO(g, 23)},
{"./sunwindow/win_ioctl.h", "WINRELEASEIO",	_IO(g, 24)},
{"./sunwindow/win_ioctl.h", "WINLOCKSCREEN",	_IOWR(g, 29, struct winlock)},
{"./sunwindow/win_ioctl.h", "WINUNLOCKSCREEN",	_IO(g, 30)},
{"./sunwindow/win_ioctl.h", "WINGETEXPOSEDRL",	_IOWR(g, 31, struct winclip)},
{"./sunwindow/win_ioctl.h", "WINGETDAMAGEDRL",	_IOWR(g, 32, struct winclip)},
{"./sunwindow/win_ioctl.h", "WINDONEDAMAGED",	_IOW(g, 33, int)},
{"./sunwindow/win_ioctl.h", "WINSHAREQUEUE",	_IO(g, 80)},
{"./sunwindow/win_ioctl.h", "WINSETCMS",	_IOWR(g, 34, struct cmschange)},
{"./sunwindow/win_ioctl.h", "WINGETCMS",	_IOWR(g, 35, struct cmschange)},
{"./sunwindow/win_ioctl.h", "WINSETPLANEGROUP",	_IOW(g, 63, int)},
{"./sunwindow/win_ioctl.h", "WINGETPLANEGROUP",	_IOR(g, 64, int)},
{"./sunwindow/win_ioctl.h", "WINSETAVAILPLANEGROUPS",	_IOW(g, 65, struct win_plane_groups_available)},
{"./sunwindow/win_ioctl.h", "WINGETAVAILPLANEGROUPS",	_IOR(g, 66, struct win_plane_groups_available)},
{"./sunwindow/win_ioctl.h", "WINSCREENNEW",	_IOW(g, 40, struct usrdesktop)},
{"./sunwindow/win_ioctl.h", "WINSCREENGET",	_IOR(g, 41, struct screen)},
{"./sunwindow/win_ioctl.h", "WINSCREENDESTROY",	_IO(g, 42)},
{"./sunwindow/win_ioctl.h", "WINSCREENPOSITIONS",	_IOW(g, 43, struct winscreenposdummy)},
{"./sunwindow/win_ioctl.h", "WINGETSCREENPOSITIONS",	_IOR(g, 45, struct winscreenposdummy)},
{"./sunwindow/win_ioctl.h", "WINSETKBD",	_IOW(g, 46, struct usrdesktop)},
{"./sunwindow/win_ioctl.h", "WINSETMS",	_IOW(g, 47, struct usrdesktop)},
{"./sunwindow/win_ioctl.h", "WINSETINPUTDEV",	_IOW(g, 50, struct input_device)},
{"./sunwindow/win_ioctl.h", "WINGETINPUTDEV",	_IOWR(g, 51, struct input_device)},
{"./sunwindow/win_ioctl.h", "WINPRINT",	_IO(g, 44)},
{"./sunwindow/win_ioctl.h", "WINDBLACCESS",	_IO(g, 71)},
{"./sunwindow/win_ioctl.h", "WINDBLFLIP",	_IO(g, 72)},
{"./sunwindow/win_ioctl.h", "WINDBLABSORB",	_IO(g, 73)},
{"./sunwindow/win_ioctl.h", "WINDBLRLSE",	_IO(g, 74)},
{"./sunwindow/win_ioctl.h", "WINDBLSET",	_IOW(g, 75, struct pwset)},
{"./sunwindow/win_ioctl.h", "WINDBLGET",	_IOWR(g, 76, struct pwset)},
{"./sunwindow/win_ioctl.h", "WINDBLCURRENT",	_IOR(g, 77, struct rect)},
#ifdef WINWIDSET
{"./sunwindow/win_ioctl.h", "WINWIDSET",	_IOWR(g, 78, struct fb_wid_dbl_info)},
{"./sunwindow/win_ioctl.h", "WINWIDGET",	_IOWR(g, 79, struct fb_wid_dbl_info)},
#endif
{"./sunwindow/win_ioctl.h", "WINSETCPCURSOR",	_IOW(g, 150, struct cursor)},
{"./sunwindow/win_ioctl.h", "WINGETCPCURSOR",	_IOWR(g, 151, struct cursor)},
{"./sunwindow/win_ioctl.h", "WINDISCONNECT",	_IO(g, 152)},
{"./sunwindow/win_ioctl.h", "WINRECONNECT",	_IO(g, 153)},
{"./sunwindow/win_ioctl.h", "WINGETROOTWIN",	_IOWR(g, 154, struct input_device)},
#if 0
{"./sunwindow/win_ioctl.h", "WINGETVALIDVALUES",	_IOR(g, 155, struct valid_values_table)},
{"./sunwindow/win_ioctl.h", "WINTUNINGVALUE",	_IOWR(g, 156, struct tuning_pair)},
{"./sunwindow/win_ioctl.h", "WINSETRECQUE",	_IOW(g, 200, struct winrecq_setup)},
{"./sunwindow/win_ioctl.h", "WINSETRECORD",	_IOW(g, 201, int)},
{"./sunwindow/win_ioctl.h", "WINREADRECQ",	_IOWR(g, 202, struct winrecq_readbuf)},
#endif
{"./sunwindow/win_ioctl.h", "WINSETPLAYBACK",	_IOW(g, 203, int)},
{"./sunwindow/win_ioctl.h", "WINSETPLAYINTR",	_IOW(g, 204, struct winplay_intr)},
{"./sunwindow/win_ioctl.h", "WINSETSYNCPT",	_IOW(g, 205, struct winrecplay_syncbuf)},
{"./stropts.h", "I_NREAD",	_IOR(S,01,int)},
{"./stropts.h", "I_PUSH",		_IOWN(S,02,FMNAMESZ+1)},
{"./stropts.h", "I_POP",		_IO(S,03)},
{"./stropts.h", "I_LOOK",		_IORN(S,04,FMNAMESZ+1)},
{"./stropts.h", "I_FLUSH",	_IO(S,05)},
{"./stropts.h", "I_SRDOPT",	_IO(S,06)},
{"./stropts.h", "I_GRDOPT",	_IOR(S,07,int)},
{"./stropts.h", "I_STR",		_IOWR(S,010,struct strioctl)},
{"./stropts.h", "I_SETSIG",	_IO(S,011)},
{"./stropts.h", "I_GETSIG",	_IOR(S,012,int)},
{"./stropts.h", "I_FIND",		_IOWN(S,013,FMNAMESZ+1)},
{"./stropts.h", "I_LINK",		_IO(S,014)},
{"./stropts.h", "I_UNLINK",	_IO(S,015)},
{"./stropts.h", "I_PEEK",		_IOWR(S,017,struct strpeek)},
{"./stropts.h", "I_FDINSERT",	_IOW(S,020,struct strfdinsert)},
{"./stropts.h", "I_SENDFD",	_IO(S,021)},
{"./stropts.h", "I_RECVFD",	_IOR(S,022,struct strrecvfd)},
{"./stropts.h", "I_PLINK",	_IO(S,023)},
{"./stropts.h", "I_PUNLINK",	_IO(S,024)},
#if 1
{"./sys/termios.h",	"TCXONC",	_IO(T, 6)},
{"./sys/termios.h",	"TCFLSH",	_IO(T, 7)},
{"./sys/termios.h",	"TCGETS",	_IOR(T, 8, struct termios)},
{"./sys/termios.h",	"TCSETS",	_IOW(T, 9, struct termios)},
{"./sys/termios.h",	"TCSETSW",	_IOW(T, 10, struct termios)},
{"./sys/termios.h",	"TCSETSF",	_IOW(T, 11, struct termios)},
{"./sys/termio.h",	"TCGETA",	_IOR(T, 1, struct termio)},
{"./sys/termio.h",	"TCSETA",	_IOW(T, 2, struct termio)},
{"./sys/termio.h",	"TCSETAW",	_IOW(T, 3, struct termio)},
{"./sys/termio.h",	"TCSETAF",	_IOW(T, 4, struct termio)},
{"./sys/termio.h",	"TCSBRK",	_IO(T, 5)},
#endif
