#include <stdio.h>
#include <sys/types.h>
#include "defs.h"

struct ioctlent {
	char *doth;
	char *symbol;
	long code;
} ioctlent[] = {
#ifndef linux
/*
 * `ioctlent.sorted.h' is generated from `ioctlent.h' by the auxiliary
 * program `ioctlsort', such that the list is sorted by the `code' field.
 * This has the side-effect of resolving the _IO.. macros into
 * plain integers, eliminating the need to include here everything
 * in "/usr/include/*\/*" .
 */
#include "ioctlent.sorted.h"
#else
/* manually created */
#include "ioctlents.h"
#endif
};

int nioctlent = sizeof ioctlent / sizeof ioctlent[0];

static int
compare(a,b)
struct ioctlent *a, *b;
{
	return (a->code - b->code);
}

char *
ioctl_lookup(code)
int code;
{
	struct ioctlent *iop, ioent;

	ioent.code = code;
	iop = (struct ioctlent *)bsearch((char *)&ioent, (char *)ioctlent,
			nioctlent, sizeof(struct ioctlent), compare);
	if (iop == (struct ioctlent *)0)
		return NULL;
	return iop->symbol;
}

int
ioctl_decode(tcp, code, arg)
struct tcb *tcp;
unsigned code, arg;
{
/*
 * Registry of ioctl characters, culled from
 *	@(#)ioccom.h 1.7 89/06/16 SMI; from UCB ioctl.h 7.1 6/4/86
 *
 * char	file where defined		notes
 * ----	------------------		-----
 *   F	sun/fbio.h
 *   G	sun/gpio.h
 *   H	vaxif/if_hy.h
 *   M	sundev/mcpcmd.h			*overlap*
 *   M	sys/modem.h			*overlap*
 *   S	sys/stropts.h
 *   T	sys/termio.h			-no overlap-
 *   T	sys/termios.h			-no overlap-
 *   V	sundev/mdreg.h
 *   a	vaxuba/adreg.h
 *   d	sun/dkio.h			-no overlap with sys/des.h-
 *   d	sys/des.h			(possible overlap)
 *   d	vax/dkio.h			(possible overlap)
 *   d	vaxuba/rxreg.h			(possible overlap)
 *   f	sys/filio.h
 *   g	sunwindow/win_ioctl.h		-no overlap-
 *   g	sunwindowdev/winioctl.c		!no manifest constant! -no overlap-
 *   h	sundev/hrc_common.h
 *   i	sys/sockio.h			*overlap*
 *   i	vaxuba/ikreg.h			*overlap*
 *   k	sundev/kbio.h
 *   m	sundev/msio.h			(possible overlap)
 *   m	sundev/msreg.h			(possible overlap)
 *   m	sys/mtio.h			(possible overlap)
 *   n	sun/ndio.h
 *   p	net/nit_buf.h			(possible overlap)
 *   p	net/nit_if.h			(possible overlap)
 *   p	net/nit_pf.h			(possible overlap)
 *   p	sundev/fpareg.h			(possible overlap)
 *   p	sys/sockio.h			(possible overlap)
 *   p	vaxuba/psreg.h			(possible overlap)
 *   q	sun/sqz.h
 *   r	sys/sockio.h
 *   s	sys/sockio.h
 *   t	sys/ttold.h			(possible overlap)
 *   t	sys/ttycom.h			(possible overlap)
 *   v	sundev/vuid_event.h		*overlap*
 *   v	sys/vcmd.h			*overlap*
 *
 * End of Registry
 */

#ifdef linux

	switch ((code >> 8) & 0xff) {
	case 'T':
		return term_ioctl(tcp, code, arg);
	default:
		break;
	}
	return 0;

#else

#ifdef someday
	switch ((code >> 8) & 0xff) {
	case 'r':
	case 's':
		sock_ioctl(tcp, code, arg);
		break;
	case 't':
		term_ioctl(tcp, code, arg);
		break;
	default:
		break;
	}
#endif

	return 0;
#endif
}

