#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <string.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>


#include "filemgr.h"
#include "debug.h"
#include <X11/extensions/shape.h>


extern Display *dpy;
extern int x_fd,screen, ScreenWidth,ScreenHeight, d_depth;
extern Window Root;
extern char *MyName;
extern char *iconPath, *pixmapPath, *ForeColor, *BackColor;
extern char *font_string;
extern int w,h,x,y;
extern Atom wm_del_win;

extern GC  NormalGC,ShadowGC,ReliefGC, rvGC;
extern Pixel hilite_pix, back_pix, shadow_pix, fore_pix;
extern XFontStruct *font;

#define IW_EVENTS   (StructureNotifyMask)
extern int fd[2];

extern char *actual_command2[];

void MoveIcon(struct dir_win *dir, struct filelist *filelist,XEvent *Event,
	      int select_x, int select_y)
{
  if(filelist)
    {
      if(filelist->CheckedOut)
	return;

      filelist->icon_x = Event->xbutton.x - select_x;
      filelist->icon_y = Event->xbutton.y - select_y;
      if((Event->xbutton.x < 0)||
	 (Event->xbutton.y < -(font->ascent+font->descent+7))||
	 (Event->xbutton.x > dir->w)||(Event->xbutton.y > dir->h))
	CheckOut(filelist,Event->xbutton.x_root, Event->xbutton.y_root);
      else
	ConfigureIconWindow(filelist,filelist->icon_w, filelist->icon_h);
    }
}


void CheckOut(struct filelist *filelist, int x, int y)
{
  char *temp_string;
  XClassHint class1;
  XWMHints wmhints;
  XSizeHints mysizehints;

  filelist->icon_loc_count= 0;
  mysizehints.flags = PWinGravity | USPosition;
  mysizehints.x = -10000;
  mysizehints.y = -10000;
  mysizehints.win_gravity = NorthWestGravity;
  
  XSetWMProtocols(dpy,filelist->HoldingWin,&wm_del_win,1);
  
  XSetWMNormalHints(dpy,filelist->HoldingWin,&mysizehints);
  
  wmhints.initial_state = IconicState;
  wmhints.icon_window = filelist->IconWin;
  wmhints.input = True;
  wmhints.icon_x = x;
  wmhints.icon_y = y;

  wmhints.flags = InputHint | StateHint | IconWindowHint | IconPositionHint;
  class1.res_name = "FvwmFileManagerWindow";
  
  temp_string = safemalloc(strlen(filelist->filename)+3,"temp2");
  strcpy(temp_string,"[");
  strcat(temp_string,filelist->filename);
  strcat(temp_string,"]");
  class1.res_class = temp_string;
  
  XSetWMProperties(dpy,filelist->HoldingWin,NULL,NULL,NULL,0,
		   &mysizehints,&wmhints,&class1);
  
  change_window_name(filelist->HoldingWin,temp_string);
  safefree(temp_string,"temp2","CheckOut");
  
  XSelectInput(dpy,filelist->HoldingWin,IW_EVENTS);
  XSelectInput(dpy,filelist->IconWin,IW_EVENTS);
  
  XUnmapWindow(dpy,filelist->IconWin);
  XUnmapWindow(dpy,filelist->HoldingWin);
  
  XUnmapWindow(dpy,filelist->LabelWin);
  XReparentWindow(dpy, filelist->HoldingWin,Root, x,y);
  XReparentWindow(dpy,  filelist->IconWin, Root,x,y);
  XMapWindow(dpy,filelist->HoldingWin);
  XSync(dpy,0);
/*  while(XCheckTypedWindowEvent (dpy, filelist->IconWin, MapNotify,&dummy)==0) ;*/
  SendInfo(fd,"Raise",filelist->HoldingWin);
  XUngrabPointer(dpy,CurrentTime);
  XSync(dpy,0);
  SendInfo(fd,"Move",filelist->HoldingWin);
  filelist->CheckedOut = 1;
  return;
}


void MoveToNewDir(struct dir_win *olddir, struct filelist *list, struct dir_win *new_dir, struct dir_win **dir_root, struct mapping *mapping_root)
{
  char *name1,*name2,*command1,*command2;
  extern int do_all;

  if(olddir == new_dir)
    {
      list->CheckedOut = 0;
      XUnmapWindow(dpy,list->HoldingWin);
      XUnmapWindow(dpy,list->LabelWin);
      strcpy(list->filename,"");
      refresh_dir_list(new_dir,dir_root,do_all,mapping_root);
      return;
    }

  name1 = safemalloc(strlen(olddir->dir_name) + strlen(list->filename)+2,
		     "move");
  name2 = safemalloc(strlen(new_dir->dir_name) + strlen(list->filename)+2,
		     "move");

  strcpy(name1,olddir->dir_name);
  strcat(name1,"/");
  strcat(name1,list->filename);

  strcpy(name2,new_dir->dir_name);
  strcat(name2,"/");
  strcat(name2,list->filename);
  XUnmapWindow(dpy,list->HoldingWin);  
  XUnmapWindow(dpy,list->LabelWin);  
  command1 = ExpandDollarsignFile(actual_command2[olddir->two_op_cmd],
				  "$file1", name1,0);
  command2 = ExpandDollarsignFile(command1,"$file2", name2,0);
  safefree(command1,"command1","dkdk");

  system(command2);

  safefree(name1,"name1","rename");
  safefree(name2,"name2","rename");
  safefree(command2,"name1","rename");
  list->CheckedOut = 0;
  XUnmapWindow(dpy,list->HoldingWin);
  XUnmapWindow(dpy,list->LabelWin);
  strcpy(list->filename,"");  

  refresh_dir_list(new_dir,dir_root,do_all,mapping_root);
  refresh_dir_list(olddir,dir_root,do_all,mapping_root);
}

