/* TI-99/4A emulator memory access handler.
   This part handles all memory read/write operations.
   The memory is assumed to contain 32,768 words of 16 bits each.
   The memory mapped devices will be hard-coded, and any access to them
   will be initiated via this memory access handler.
*/
int exbaspage=0;

void init_cpu(void)
{
	mem=(word *)calloc(CPU_MEMSIZE,1);
	if (mem==NULL)
	{
		printf("Not enough memory for CPU ram\n");
		exit(0);
	}
}

word memory_read(word adr)
{
	word address;

	address=adr>>1;        		/* address is word oriented	*/
	if (paging&&(adr>=0x7000)&&(adr<0x8000)&&exbaspage) address+=0x1000;

	if ((adr<(word)0x8400)||(adr>=(word)0xA000))
	{
		if 	(adr&1) return(word)(*(mem+address)<<8);
			else	return(*(mem+address));
	}

	if ((adr&0x1c00)==0x0800)	 return(vdp_read(address));
	if ((adr&0x1c00)==0x1800)	 return(grom_read(address));
	return((word)0);	/* undecoded memory */
}

void memory_write(word adr,word data)
{
	word 	page,address;

	address=adr>>1;
	page=adr>>13;

	if ((page==0)||(page==2)) return; /* write has no effect in ROM */

	if (paging&&(page==3))
	{
		if (adr<0x6004) exbaspage=address&1;
		return;
	}
	if (!((page==4)&&(adr>=(word)0x8400)))
	{
		if (adr&1)
		*(mem+address)=(*(mem+address)&0xFF00)|(data>>8);
		else *(mem+address)=data;
		return;
	}

	if ((adr&0x1c00)==0x0c00) {  vdp_write(address,data); return; }
	if ((adr&0x1c00)==0x1c00) { grom_write(address,data); return; }
	if ((adr&0x1f00)==0x0400) { sound_access(data);	      return; }

} /* end of memory_write() */

void vdp_interrupt(void)
{
	if (IMASK)
	{
		int val;

		/* Interrupt counter */

		val=*(mem+0x41bc);
		*(mem+0x41bc)=(val&0xFF00)|((val+1)&0xFF);
		sound_handler();
	}
}

