/*
**  SOUND chip emulation.
**  This section partly emulates sound generator 1, by playing each
**  specified frequency for 500 milliseconds.
*/

void sound_access(word data)
{
	static word fcode=0,lastaccess=0;
	word soundbyte;

	soundbyte=data>>8;

	if (((soundbyte&0xC0)==0)&&(lastaccess==0x80))
		fcode=(fcode&0xF)|(soundbyte<<4);
	if ((soundbyte&0xF0)==0x80) fcode=(fcode&0x3F0)|(soundbyte&0xF);
	if (((soundbyte&0xF0)==0x90)&&(soundbyte!=0x9F))
#ifdef FLOAT
		my_sound((word)((float)111860.8/(float)fcode));
#else
		my_sound((word)(111861/fcode));
#endif
	lastaccess=soundbyte&0xF0;
}

void sound_handler(void)
{
int duration;
duration=*(mem+0x41e7)>>8;
if (duration)
{
	if (!--duration)
	{
		word soundlist,listlen;
		soundlist=*(mem+0x41e6);
		listlen=soundbyte(soundlist++);
		if (listlen)
		{
			while(listlen--)
			sound_access(soundbyte(soundlist++)<<8);
			duration=soundbyte(soundlist++);
		}
		else
                {
			 soundlist=(soundbyte(soundlist++)<<8)|
				    soundbyte(soundlist);
			 duration=1;
		}
		*(mem+0x41e6)=soundlist;
	}
	*(mem+0x41e7)=(*(mem+0x41e7)&0xFF)|(duration<<8);
}
}


byte soundbyte(word address)
{
	if (*(mem+R14)&1)	return(*(vdp+address));
	else 			return(*(grom+address));
}