.TH LUIT 1 __vendorversion__
.SH NAME
luit \- Locale and ISO\ 2022 support for Unicode terminals

.SH SYNOPSIS
.B luit
[
.I options
] [
.B \-\-
] [
.I program 
[
.I args
] ]

.SH DESCRIPTION

.B Luit
is a filter that can be run between an arbitrary application and a
UTF-8 terminal emulator.  It will convert application output from the
locale's encoding into UTF-8, and convert terminal input from UTF-8
into the locale's encoding.

An application may also request switching to a different output
encoding using ISO\ 2022 and ISO\ 6429 escape sequences.  Use of this
feature is discouraged: multilingual applications should be modified
to directly generate UTF-8 instead.

.SH OPTIONS

.TP
.B \-h
Display some summary help and quit.
.TP
.B \-list
List the supported charsets and quit.
.TP
.B \-v
Be verbose.
.TP
.B \-c
Function as a simple converter from standard input to standard output.
.TP
.BI \-argv0 " name"
Set the child's name (as passed in argv[0]).
.TP
.B +oss
Disable interpretation of single shifts in application output.
.TP
.B +ols
Disable interpretation of locking shifts in application output.
.TP
.B +osl
Disable interpretation of character set selection sequences in
application output.
.TP
.B +ot
Disable interpretation of all sequences and pass all sequences in
application output to the terminal unchanged.  This may lead to
interesting results.
.TP
.B \-k7
Generate seven-bit characters for keyboard input.
.TP
.B \+kss
Disable generation of single-shifts for keyboard input.
.TP
.B \-kls
Generate locking shifts (SO/SI) for keyboard input.
.TP
.BI \-gl " gn"
Set the initial assignment of GL.  The argument should be one of
.BR g0 ,
.BR g1 ,
.B g2
or
.BR g3 .
The default depends on the locale, but is usually
.BR g0 .
.TP
.BI \-gr " gk"
Set the initial assignment of GR.  The default depends on the locale,
and is usually 
.B g2
except for EUC locales, where it is
.BR g1 .
.TP
.BI \-g0 " charset"
Set the charset initially selected in G0.  The default depends on
the locale, but is usually
.BR ASCII .
.TP
.BI \-g1 " charset"
Set the charset initially selected in G1.  The default depends on the
locale.
.TP
.BI \-g2 " charset"
Set the charset initially selected in G2.  The default depends on the
locale.
.TP
.BI \-g3 " charset"
Set the charset initially selected in G3.  The default depends on the
locale.
.TP
.BI \-ilog " filename"
Log into
.I filename
all the bytes received from the child.
.TP
.BI \-olog " filename"
Log into
.I filename
all the bytes sent to the terminal emulator.
.TP
.B \-\-
End of options.

.SH EXAMPLES

The most typical use of
.B luit
is to adapt an instance of
.B XTerm
in UTF-8 mode to the locale's encoding.  For most locales, this
doesn't require using any flags:
.IP
$ xterm \-u8 \-e luit
.PP

.B Luit
may also be used with applications that hard-wire an encoding that is
different from the one normally used on the system.  In order to use
such applications, you will need to directly manipulate
.BR luit 's
ISO\ 2022 state:
.IP
$ xterm \-u8 \-e luit \-g2 'CP 1252'
.PP
The
.B \-v
flag may be used in order to examine
.BR luit 's
initial state.

Future versions of
.B XTerm
will automatically invoke
.B luit
when necessary.

.SH FILES

.TP
.B __projectroot__/lib/X11/fonts/encodings/encodings.dir
The system-wide encodings directory.

.TP
.B __projectroot__/lib/X11/locale/locale.alias
The file mapping locales to locale encodings.

.SH SECURITY

On systems with SVR4 (``Unix-98'') ptys (Linux version 2.2 and later,
SVR4),
.B luit
should be run as the invoking user.

On systems without SVR4 (``Unix-98'') ptys (notably BSD variants),
running
.B luit
as an ordinary user will leave the tty world-writable; this is a
security hole, and luit will generate a warning (but still accept to
run).  A possible solution is to make
.B luit
suid root;
.B luit
should drop privileges sufficiently early to make this safe.  However,
the startup code has not been exhaustively audited, and the author
takes no responsibility for any resulting security issues.

.B Luit
will refuse to run if it is installed setuid and the underlying system
does not have POSIX saved ids.

.SH BUGS
None of this complexity should be necessary.  Stateless UTF-8
throughout the system is the way to go.

Charsets with a non-trivial intermediary byte are not yet supported.

Selecting alternate sets of control characters is not supported and
will never be.

.SH SEE ALSO
xterm(1), unicode(7), utf-8(7), charsets(7).
.I Character Code Structure and Extension Techniques (ISO\ 2022, ECMA-35).
.I Control Functions for Coded Character Sets (ISO\ 6429, ECMA-48).

.SH AUTHOR
Luit was written by Juliusz Chroboczek <jch@xfree86.org> for the
XFree86 project.
