/* This file is part of the KDE Linux Kernel Configurator
   Copyright (c) 2001 Malte Starostik <malte@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

// $Id: kcmlinuz.cpp,v 1.9.2.1 2002/04/14 08:28:05 lukas Exp $

#include <qlayout.h>

#include <kglobal.h>
#include <klocale.h>

#include "configuration.h"
#include "kcmlinuz.moc"

using namespace Config;

KCMLinuz::KCMLinuz(QWidget *parent, const char *name)
	: KCModule(parent, name)
{
	QVBoxLayout *lay = new QVBoxLayout(this);
	m_configPage = new Configuration(this);
	lay->addWidget(m_configPage);
	connect(m_configPage, SIGNAL(changed(bool)), SIGNAL(changed(bool)));
}

void KCMLinuz::load()
{
	m_configPage->load();
}

void KCMLinuz::save()
{
	m_configPage->save();
}

void KCMLinuz::defaults()
{
	m_configPage->defaults();
}

extern "C"
{
	KCModule *create_linuz(QWidget *parent, const char *)
	{
		KGlobal::locale()->insertCatalogue("kcmlinuz");
		return new KCMLinuz(parent, "kcmlinuz");
	}
}
// vim: ts=4 sw=4 noet
