#include <qlayout.h>
#include <qtimer.h>

#include <kapp.h>

#include "kasgroupitem.h"
#include "kastasker.h"

#include "kasgrouppopup.h"
#include "kasgrouppopup.moc"

#ifndef KDE_USE_FINAL
const int TITLE_HEIGHT = 13;
#endif

const int KAS_GROUP_POPUP_KILL_DELAY = 6000;

KasGroupPopup::KasGroupPopup( KasGroupItem *item, const char *name )
    : KasPopup( item, name )
{
    this->item = item;

    QHBoxLayout *box = new QHBoxLayout( this );

    KasTasker *master = static_cast<KasTasker *> (kasbar());
    childBar_ = new KasTasker( ( kasbar()->orientation() == Horizontal ) ? Vertical : Horizontal,
			       master, this );


    box->addWidget( childBar_ );
    resize( childBar_->size() );

    killTimer_ = new QTimer( this, "kill_timer" );
    connect( killTimer_, SIGNAL( timeout() ), this, SLOT( maybeHide() ) );
    killTimer_->start( KAS_GROUP_POPUP_KILL_DELAY, true );
}

KasGroupPopup::~KasGroupPopup()
{
}

void KasGroupPopup::maybeHide()
{
    if ( childBar_->itemUnderMouse() ) {
	killTimer_->start( KAS_GROUP_POPUP_KILL_DELAY, true );
	return;
    }

    doHide();
}

void KasGroupPopup::doHide()
{
    item->hidePopup();
}

