/*****************************************************************
kwin - the KDE window manager
								
Copyright (C) 1999, 2000    Daniel M. Duley <mosfet@kde.org>
******************************************************************/
#ifndef __PLUGINS_H
#define __PLUGINS_H

#include <qpopupmenu.h>
#include <qstringlist.h>

class QFileInfo;
class KLibrary;

namespace KWinInternal {

class Client;
class Workspace;

class PluginMgr : public QObject
{
    Q_OBJECT
public:
    PluginMgr();
    ~PluginMgr();
    Client *allocateClient(Workspace *ws, WId w, bool tool);
    bool loadPlugin(QString name);
    QString currentPlugin() { return pluginStr; }
public slots:
    void updatePlugin();
signals:
    void resetAllClients();
protected:
    void shutdownKWin(const QString& error_msg);
    Client* (*alloc_ptr)(Workspace *ws, WId w, int tool);
    KLibrary *library;
    QString pluginStr;
};

};

#endif
