#ifndef __KCM_LAYOUT_H__
#define __KCM_LAYOUT_H__


class QComboBox;
class QLabel;
class QListView;
class QCheckBox;
class QGroupBox;
class QButtonGroup;

#include <kcmodule.h>
#include <kglobalaccel.h>

#include <qstring.h>


#include "rules.h"

class LayoutConfig : public KCModule
{
  Q_OBJECT

public:

  LayoutConfig(QWidget *parent = 0L, const char *name = 0L);
  virtual ~LayoutConfig();

  void load();
  void save();
  void defaults();

  QString quickHelp() const;

  void itemStateChanged(); // must be slot?

protected slots:

  void configChanged();
  void primLayoutChanged();
  void primVariantChanged();
  void addLayoutSelChanged();
  void addVariantChanged();

  void ruleChanged(const QString &rule);


private:

  QComboBox *ruleCombo;
  QComboBox *modelCombo;
  QComboBox *layoutCombo;
  QComboBox *variantCombo;
  QComboBox *addVariantCombo;
  QCheckBox *resetOldCheckbox;
  QButtonGroup* modeBtnGroup;
  QDict<QComboBox> optionsComboboxes;
  int numberOfOptions;

  enum SwitchMode { Global, Application, Window } switchMode;

  QDict<char> variants;
  QString m_rule;

  KeyRules *rules;

  QListView *additional;
  QCheckBox *enableCheckbox; 
  KCModule *misc;
  QGroupBox *grp1;
  QGroupBox *grp2;

  QWidget* makeOptionsTab(QWidget* parent);
};


#endif
