/* broker.c generated by valac 0.56.17, the Vala compiler
 * generated from broker.vala, do not modify */

/* libenchant: Broker
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>
#include <relocatable.h>
#include <configmake.h>
#include <sys/types.h>
#include <enchant.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
typedef EnchantProvider* (*EnchantProviderInitFunc) (void);
typedef void (*EnchantPreConfigureFunc) (EnchantProvider* provider, const gchar* module_dir);
typedef struct _EnchantBroker EnchantBroker;

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
#define _enchant_provider_unref0(var) ((var == NULL) ? NULL : (var = (enchant_provider_unref (var), NULL)))
typedef struct _EnchantProviderPrivate EnchantProviderPrivate;
typedef void (*ProviderDispose) (EnchantProvider* me);
typedef EnchantDict* (*ProviderRequestDict) (EnchantProvider* me, const gchar* tag);
typedef void (*ProviderDisposeDict) (EnchantProvider* me, EnchantDict* dict);
typedef gint (*ProviderDictionaryExists) (EnchantProvider* me, const gchar* tag);
typedef const gchar* (*ProviderIdentify) (EnchantProvider* me);
typedef const gchar* (*ProviderDescribe) (EnchantProvider* me);
typedef gchar** (*ProviderListDicts) (EnchantProvider* me, size_t* result_length1);
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_ENCHANT_SESSION (enchant_session_get_type ())
#define ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_SESSION, EnchantSession))
#define ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_SESSION, EnchantSessionClass))
#define IS_ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_SESSION))
#define IS_ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_SESSION))
#define ENCHANT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_SESSION, EnchantSessionClass))

typedef struct _EnchantSession EnchantSession;
typedef struct _EnchantSessionClass EnchantSessionClass;
#define _enchant_session_unref0(var) ((var == NULL) ? NULL : (var = (enchant_session_unref (var), NULL)))
typedef struct _EnchantSessionPrivate EnchantSessionPrivate;

#define TYPE_ENCHANT_PWL (enchant_pwl_get_type ())
#define ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL, EnchantPWL))
#define ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL, EnchantPWLClass))
#define IS_ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL))
#define IS_ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL))
#define ENCHANT_PWL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL, EnchantPWLClass))

typedef struct _EnchantPWL EnchantPWL;
typedef struct _EnchantPWLClass EnchantPWLClass;
typedef struct _EnchantDictPrivate EnchantDictPrivate;
typedef gint (*DictCheck) (EnchantDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantDict* me);
typedef gint (*DictIsWordCharacter) (EnchantDict* me, guint32 uc_in, size_t n);

#define TYPE_ENCHANT_COMPOSITE_DICT (enchant_composite_dict_get_type ())
#define ENCHANT_COMPOSITE_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict))
#define ENCHANT_COMPOSITE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDictClass))
#define IS_ENCHANT_COMPOSITE_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_COMPOSITE_DICT))
#define IS_ENCHANT_COMPOSITE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_COMPOSITE_DICT))
#define ENCHANT_COMPOSITE_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDictClass))

typedef struct _EnchantCompositeDict EnchantCompositeDict;
typedef struct _EnchantCompositeDictClass EnchantCompositeDictClass;
typedef struct _EnchantCompositeDictPrivate EnchantCompositeDictPrivate;
#define _enchant_composite_dict_unref0(var) ((var == NULL) ? NULL : (var = (enchant_composite_dict_unref (var), NULL)))
#define _enchant_dict_unref0(var) ((var == NULL) ? NULL : (var = (enchant_dict_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EnchantBroker {
	GSList* provider_list;
	GHashTable* provider_ordering;
	GHashTable* dicts;
	gchar* _error;
};

struct _EnchantProvider {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderPrivate * priv;
	void* user_data;
	GModule* module;
	EnchantBroker* owner;
	ProviderDispose dispose;
	ProviderRequestDict request_dict;
	ProviderDisposeDict dispose_dict;
	ProviderDictionaryExists dictionary_exists;
	ProviderIdentify identify;
	ProviderDescribe describe;
	ProviderListDicts list_dicts;
};

struct _EnchantProviderClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProvider *self);
};

struct _EnchantSession {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantSessionPrivate * priv;
	GHashTable* session_include;
	GHashTable* session_exclude;
	EnchantPWL* pwl;
	EnchantPWL* exclude_pwl;
	gchar* personal_filename;
	gchar* exclude_filename;
	gchar* language_tag;
	gchar* error;
	gboolean is_pwl;
	EnchantProvider* provider;
};

struct _EnchantSessionClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantSession *self);
};

struct _EnchantDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantDictPrivate * priv;
	void* user_data;
	EnchantSession* session;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantDict *self);
};

struct _EnchantCompositeDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantCompositeDictPrivate * priv;
	GSList* dict_list;
};

struct _EnchantCompositeDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantCompositeDict *self);
};

VALA_EXTERN gchar* normalize_dictionary_tag (const gchar* dict_tag);
VALA_EXTERN gchar* iso_639_from_tag (const gchar* dict_tag);
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN void enchant_broker_free (EnchantBroker * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantBroker, enchant_broker_free)
VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
static void enchant_broker_instance_init (EnchantBroker * self);
static void _enchant_provider_unref0_ (gpointer var);
static inline void _g_slist_free__enchant_provider_unref0_ (GSList* self);
VALA_EXTERN EnchantBroker* enchant_broker_init (void);
static void enchant_broker_load_providers (EnchantBroker* self);
VALA_EXTERN void enchant_broker_load_provider_ordering (EnchantBroker* self);
static void _enchant_dict_unref0_ (gpointer var);
VALA_EXTERN void enchant_broker_clear_error (EnchantBroker* self);
VALA_EXTERN void enchant_broker_set_error (EnchantBroker* self,
                               const gchar* value);
VALA_EXTERN void enchant_broker_set_ordering (EnchantBroker* self,
                                  const gchar* tag,
                                  const gchar* ordering);
static void enchant_broker_load_providers_in_dir (EnchantBroker* self,
                                           const gchar* dir_name);
VALA_EXTERN gboolean enchant_provider_is_valid (EnchantProvider* provider);
static void enchant_broker_load_ordering_from_file (EnchantBroker* self,
                                             const gchar* file);
static void _g_free0_ (gpointer var);
VALA_EXTERN GSList* enchant_get_conf_dirs (void);
static inline void _g_slist_free__g_free0_ (GSList* self);
VALA_EXTERN GSList* enchant_broker_get_ordered_providers (EnchantBroker* self,
                                              const gchar* tag);
VALA_EXTERN EnchantDict* enchant_broker_request_pwl_dict (EnchantBroker* self,
                                              const gchar* pwl);
VALA_EXTERN gpointer enchant_session_ref (gpointer instance);
VALA_EXTERN void enchant_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_session (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_enchant_session (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_enchant_session (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_session (const GValue* value);
VALA_EXTERN GType enchant_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantSession, enchant_session_unref)
VALA_EXTERN EnchantSession* enchant_session_with_pwl (EnchantProvider* provider,
                                          const gchar* pwlname,
                                          const gchar* exclname,
                                          const gchar* lang,
                                          gboolean fail_if_no_pwl);
VALA_EXTERN gpointer enchant_pwl_ref (gpointer instance);
VALA_EXTERN void enchant_pwl_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_pwl (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_enchant_pwl (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_enchant_pwl (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_pwl (const GValue* value);
VALA_EXTERN GType enchant_pwl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPWL, enchant_pwl_unref)
VALA_EXTERN EnchantDict* enchant_broker_new_dict (EnchantBroker* self);
static EnchantDict* _enchant_broker_request_dict (EnchantBroker* self,
                                           const gchar* tag,
                                           const gchar* pwl);
VALA_EXTERN EnchantSession* enchant_session_with_implicit_pwl (EnchantProvider* provider,
                                                   const gchar* lang,
                                                   const gchar* pwl);
VALA_EXTERN EnchantDict* enchant_broker_request_dict_with_pwl (EnchantBroker* self,
                                                   const gchar* composite_tag,
                                                   const gchar* pwl);
VALA_EXTERN gpointer enchant_composite_dict_ref (gpointer instance);
VALA_EXTERN void enchant_composite_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_composite_dict (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_enchant_composite_dict (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_enchant_composite_dict (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_composite_dict (const GValue* value);
VALA_EXTERN GType enchant_composite_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantCompositeDict, enchant_composite_dict_unref)
VALA_EXTERN EnchantCompositeDict* enchant_composite_dict_new (void);
VALA_EXTERN EnchantCompositeDict* enchant_composite_dict_construct (GType object_type);
VALA_EXTERN gint composite_dict_check (EnchantDict* _self_,
                           const gchar* word_buf,
                           size_t len);
static gint _composite_dict_check_dict_check (EnchantDict* me,
                                       const gchar* word,
                                       size_t len);
VALA_EXTERN gchar** composite_dict_suggest (EnchantDict* me,
                                const gchar* word,
                                size_t len,
                                gint* result_length1);
static gchar** _composite_dict_suggest_dict_suggest (EnchantDict* me,
                                              const gchar* word,
                                              size_t len,
                                              size_t* result_length1);
VALA_EXTERN void composite_dict_add_to_session (EnchantDict* me,
                                    const gchar* word,
                                    size_t len);
static void _composite_dict_add_to_session_dict_add_to_session (EnchantDict* me,
                                                         const gchar* word,
                                                         size_t len);
VALA_EXTERN void composite_dict_remove_from_session (EnchantDict* me,
                                         const gchar* word,
                                         size_t len);
static void _composite_dict_remove_from_session_dict_remove_from_session (EnchantDict* me,
                                                                   const gchar* word,
                                                                   size_t len);
VALA_EXTERN EnchantDict* enchant_broker_request_dict (EnchantBroker* self,
                                          const gchar* tag);
VALA_EXTERN void enchant_broker_describe (EnchantBroker* self,
                              EnchantBrokerDescribeFn fn,
                              void* user_data);
VALA_EXTERN void enchant_broker_list_dicts (EnchantBroker* self,
                                EnchantDictDescribeFn fn,
                                void* user_data);
VALA_EXTERN gint _enchant_broker_dict_exists (EnchantBroker* self,
                                  const gchar* tag);
VALA_EXTERN gint _enchant_provider_dictionary_exists (EnchantProvider* self,
                                          const gchar* tag);
VALA_EXTERN gint enchant_broker_dict_exists (EnchantBroker* self,
                                 const gchar* tag);
VALA_EXTERN EnchantDict* enchant_dict_new (void);
VALA_EXTERN EnchantDict* enchant_dict_construct (GType object_type);
VALA_EXTERN void enchant_broker_free_dict (EnchantBroker* self,
                               EnchantDict* dict);
VALA_EXTERN const gchar* enchant_broker_get_error (EnchantBroker* self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1415 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1416 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1416 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1417 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1418 "glib-2.0.vapi"
	result = _result_;
#line 1418 "glib-2.0.vapi"
	return result;
#line 415 "broker.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1503 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1503 "glib-2.0.vapi"
	end = _tmp0_;
#line 1504 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1504 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1505 "glib-2.0.vapi"
		result = maxlen;
#line 1505 "glib-2.0.vapi"
		return result;
#line 438 "broker.c"
	} else {
		gchar* _tmp2_;
#line 1507 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1507 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1507 "glib-2.0.vapi"
		return result;
#line 447 "broker.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1514 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1516 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1516 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 466 "broker.c"
	} else {
#line 1516 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 470 "broker.c"
	}
#line 1516 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1518 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 476 "broker.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1520 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1520 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1520 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 486 "broker.c"
	}
#line 1523 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1524 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 494 "broker.c"
	} else {
#line 1527 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 498 "broker.c"
	}
#line 1529 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1530 "glib-2.0.vapi"
		len = string_length - offset;
#line 504 "broker.c"
	}
#line 1532 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1533 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1533 "glib-2.0.vapi"
	result = _tmp3_;
#line 1533 "glib-2.0.vapi"
	return result;
#line 514 "broker.c"
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1204 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1205 "glib-2.0.vapi"
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
#line 1205 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1207 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1207 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 536 "broker.c"
		gchar* _tmp2_;
#line 1208 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1208 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1208 "glib-2.0.vapi"
		return result;
#line 544 "broker.c"
	} else {
#line 1210 "glib-2.0.vapi"
		result = -1;
#line 1210 "glib-2.0.vapi"
		return result;
#line 550 "broker.c"
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 568 "broker.c"
}

gchar*
normalize_dictionary_tag (const gchar* dict_tag)
{
	gchar* new_tag = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GString* sb = NULL;
	GString* _tmp7_;
	gint i = 0;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	const gchar* _tmp21_;
	GString* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* result;
#line 32 "broker.vala"
	g_return_val_if_fail (dict_tag != NULL, NULL);
#line 33 "broker.vala"
	_tmp0_ = string_strip (dict_tag);
#line 33 "broker.vala"
	new_tag = _tmp0_;
#line 36 "broker.vala"
	_tmp1_ = new_tag;
#line 36 "broker.vala"
	_tmp2_ = new_tag;
#line 36 "broker.vala"
	_tmp3_ = string_substring (_tmp1_, (glong) 0, (glong) string_index_of_char (_tmp2_, (gunichar) '@', 0));
#line 36 "broker.vala"
	_g_free0 (new_tag);
#line 36 "broker.vala"
	new_tag = _tmp3_;
#line 38 "broker.vala"
	_tmp4_ = new_tag;
#line 38 "broker.vala"
	_tmp5_ = new_tag;
#line 38 "broker.vala"
	_tmp6_ = string_substring (_tmp4_, (glong) 0, (glong) string_index_of_char (_tmp5_, (gunichar) '.', 0));
#line 38 "broker.vala"
	_g_free0 (new_tag);
#line 38 "broker.vala"
	new_tag = _tmp6_;
#line 41 "broker.vala"
	_tmp7_ = g_string_new ("");
#line 41 "broker.vala"
	sb = _tmp7_;
#line 622 "broker.c"
	{
		gboolean _tmp8_ = FALSE;
#line 43 "broker.vala"
		i = 0;
#line 43 "broker.vala"
		_tmp8_ = TRUE;
#line 43 "broker.vala"
		while (TRUE) {
#line 631 "broker.c"
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			const gchar* _tmp12_;
			GString* _tmp15_;
			const gchar* _tmp16_;
#line 43 "broker.vala"
			if (!_tmp8_) {
#line 639 "broker.c"
				gint _tmp9_;
#line 45 "broker.vala"
				i = i + 1;
#line 45 "broker.vala"
				_tmp9_ = i;
#line 645 "broker.c"
			}
#line 43 "broker.vala"
			_tmp8_ = FALSE;
#line 44 "broker.vala"
			_tmp12_ = new_tag;
#line 44 "broker.vala"
			if (string_get (_tmp12_, (glong) i) != '\0') {
#line 653 "broker.c"
				const gchar* _tmp13_;
#line 44 "broker.vala"
				_tmp13_ = new_tag;
#line 44 "broker.vala"
				_tmp11_ = string_get (_tmp13_, (glong) i) != '-';
#line 659 "broker.c"
			} else {
#line 44 "broker.vala"
				_tmp11_ = FALSE;
#line 663 "broker.c"
			}
#line 44 "broker.vala"
			if (_tmp11_) {
#line 667 "broker.c"
				const gchar* _tmp14_;
#line 44 "broker.vala"
				_tmp14_ = new_tag;
#line 44 "broker.vala"
				_tmp10_ = string_get (_tmp14_, (glong) i) != '_';
#line 673 "broker.c"
			} else {
#line 44 "broker.vala"
				_tmp10_ = FALSE;
#line 677 "broker.c"
			}
#line 44 "broker.vala"
			if (!_tmp10_) {
#line 44 "broker.vala"
				break;
#line 683 "broker.c"
			}
#line 46 "broker.vala"
			_tmp15_ = sb;
#line 46 "broker.vala"
			_tmp16_ = new_tag;
#line 46 "broker.vala"
			g_string_append_c (_tmp15_, g_ascii_tolower (string_get (_tmp16_, (glong) i)));
#line 691 "broker.c"
		}
	}
#line 49 "broker.vala"
	_tmp18_ = new_tag;
#line 49 "broker.vala"
	if (string_get (_tmp18_, (glong) i) == '-') {
#line 49 "broker.vala"
		_tmp17_ = TRUE;
#line 700 "broker.c"
	} else {
		const gchar* _tmp19_;
#line 49 "broker.vala"
		_tmp19_ = new_tag;
#line 49 "broker.vala"
		_tmp17_ = string_get (_tmp19_, (glong) i) == '_';
#line 707 "broker.c"
	}
#line 49 "broker.vala"
	if (_tmp17_) {
#line 711 "broker.c"
		GString* _tmp20_;
#line 50 "broker.vala"
		_tmp20_ = sb;
#line 50 "broker.vala"
		g_string_append_c (_tmp20_, '_');
#line 717 "broker.c"
	}
#line 54 "broker.vala"
	_tmp21_ = new_tag;
#line 54 "broker.vala"
	if (string_get (_tmp21_, (glong) i) != '\0') {
#line 723 "broker.c"
		{
			gint _tmp22_;
			gboolean _tmp23_ = FALSE;
#line 55 "broker.vala"
			i = i + 1;
#line 55 "broker.vala"
			_tmp22_ = i;
#line 55 "broker.vala"
			_tmp23_ = TRUE;
#line 55 "broker.vala"
			while (TRUE) {
#line 735 "broker.c"
				const gchar* _tmp25_;
				GString* _tmp26_;
				const gchar* _tmp27_;
#line 55 "broker.vala"
				if (!_tmp23_) {
#line 741 "broker.c"
					gint _tmp24_;
#line 55 "broker.vala"
					i = i + 1;
#line 55 "broker.vala"
					_tmp24_ = i;
#line 747 "broker.c"
				}
#line 55 "broker.vala"
				_tmp23_ = FALSE;
#line 55 "broker.vala"
				_tmp25_ = new_tag;
#line 55 "broker.vala"
				if (!g_ascii_isalnum (string_get (_tmp25_, (glong) i))) {
#line 55 "broker.vala"
					break;
#line 757 "broker.c"
				}
#line 56 "broker.vala"
				_tmp26_ = sb;
#line 56 "broker.vala"
				_tmp27_ = new_tag;
#line 56 "broker.vala"
				g_string_append_c (_tmp26_, g_ascii_toupper (string_get (_tmp27_, (glong) i)));
#line 765 "broker.c"
			}
		}
	}
#line 59 "broker.vala"
	while (TRUE) {
#line 771 "broker.c"
		const gchar* _tmp28_;
		GString* _tmp29_;
		const gchar* _tmp30_;
		gint _tmp31_;
#line 59 "broker.vala"
		_tmp28_ = new_tag;
#line 59 "broker.vala"
		if (!(string_get (_tmp28_, (glong) i) != '\0')) {
#line 59 "broker.vala"
			break;
#line 782 "broker.c"
		}
#line 60 "broker.vala"
		_tmp29_ = sb;
#line 60 "broker.vala"
		_tmp30_ = new_tag;
#line 60 "broker.vala"
		_tmp31_ = i;
#line 60 "broker.vala"
		i = _tmp31_ + 1;
#line 60 "broker.vala"
		g_string_append_c (_tmp29_, string_get (_tmp30_, (glong) _tmp31_));
#line 794 "broker.c"
	}
#line 62 "broker.vala"
	_tmp32_ = sb;
#line 62 "broker.vala"
	_tmp33_ = _tmp32_->str;
#line 62 "broker.vala"
	_tmp34_ = g_strdup (_tmp33_);
#line 62 "broker.vala"
	result = _tmp34_;
#line 62 "broker.vala"
	_g_string_free0 (sb);
#line 62 "broker.vala"
	_g_free0 (new_tag);
#line 62 "broker.vala"
	return result;
#line 810 "broker.c"
}

gchar*
iso_639_from_tag (const gchar* dict_tag)
{
	gchar* _tmp0_;
	gchar* result;
#line 65 "broker.vala"
	g_return_val_if_fail (dict_tag != NULL, NULL);
#line 66 "broker.vala"
	_tmp0_ = string_substring (dict_tag, (glong) 0, (glong) string_index_of_char (dict_tag, (gunichar) '_', 0));
#line 66 "broker.vala"
	result = _tmp0_;
#line 66 "broker.vala"
	return result;
#line 826 "broker.c"
}

static void
_enchant_provider_unref0_ (gpointer var)
{
#line 76 "broker.vala"
	(var == NULL) ? NULL : (var = (enchant_provider_unref (var), NULL));
#line 834 "broker.c"
}

static inline void
_g_slist_free__enchant_provider_unref0_ (GSList* self)
{
#line 76 "broker.vala"
	g_slist_free_full (self, (GDestroyNotify) _enchant_provider_unref0_);
#line 842 "broker.c"
}

static void
_enchant_dict_unref0_ (gpointer var)
{
#line 89 "broker.vala"
	(var == NULL) ? NULL : (var = (enchant_dict_unref (var), NULL));
#line 850 "broker.c"
}

EnchantBroker*
enchant_broker_init (void)
{
	EnchantBroker* self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
#line 83 "broker.vala"
	self = g_slice_new0 (EnchantBroker);
#line 83 "broker.vala"
	enchant_broker_instance_init (self);
#line 84 "broker.vala"
	if (!g_module_supported ()) {
#line 85 "broker.vala"
		return self;
#line 868 "broker.c"
	}
#line 87 "broker.vala"
	enchant_broker_load_providers (self);
#line 88 "broker.vala"
	enchant_broker_load_provider_ordering (self);
#line 89 "broker.vala"
	_tmp0_ = g_direct_hash;
#line 89 "broker.vala"
	_tmp1_ = g_direct_equal;
#line 89 "broker.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _enchant_dict_unref0_);
#line 89 "broker.vala"
	_g_hash_table_unref0 (self->dicts);
#line 89 "broker.vala"
	self->dicts = _tmp2_;
#line 83 "broker.vala"
	return self;
#line 886 "broker.c"
}

void
enchant_broker_clear_error (EnchantBroker* self)
{
#line 98 "broker.vala"
	g_return_if_fail (self != NULL);
#line 99 "broker.vala"
	enchant_broker_set_error (self, NULL);
#line 896 "broker.c"
}

void
enchant_broker_set_ordering (EnchantBroker* self,
                             const gchar* tag,
                             const gchar* ordering)
{
	gchar* tag_dupl = NULL;
	gchar* _tmp0_;
	gchar* ordering_dupl = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
#line 107 "broker.vala"
	g_return_if_fail (self != NULL);
#line 107 "broker.vala"
	g_return_if_fail (tag != NULL);
#line 107 "broker.vala"
	g_return_if_fail (ordering != NULL);
#line 108 "broker.vala"
	enchant_broker_clear_error (self);
#line 110 "broker.vala"
	_tmp0_ = normalize_dictionary_tag (tag);
#line 110 "broker.vala"
	tag_dupl = _tmp0_;
#line 111 "broker.vala"
	_tmp1_ = string_strip (ordering);
#line 111 "broker.vala"
	ordering_dupl = _tmp1_;
#line 113 "broker.vala"
	_tmp5_ = tag_dupl;
#line 113 "broker.vala"
	if (_tmp5_ != NULL) {
#line 932 "broker.c"
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 113 "broker.vala"
		_tmp6_ = tag_dupl;
#line 113 "broker.vala"
		_tmp7_ = strlen (_tmp6_);
#line 113 "broker.vala"
		_tmp8_ = _tmp7_;
#line 113 "broker.vala"
		_tmp4_ = _tmp8_ > 0;
#line 944 "broker.c"
	} else {
#line 113 "broker.vala"
		_tmp4_ = FALSE;
#line 948 "broker.c"
	}
#line 113 "broker.vala"
	if (_tmp4_) {
#line 952 "broker.c"
		const gchar* _tmp9_;
#line 114 "broker.vala"
		_tmp9_ = ordering_dupl;
#line 114 "broker.vala"
		_tmp3_ = _tmp9_ != NULL;
#line 958 "broker.c"
	} else {
#line 113 "broker.vala"
		_tmp3_ = FALSE;
#line 962 "broker.c"
	}
#line 113 "broker.vala"
	if (_tmp3_) {
#line 966 "broker.c"
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 114 "broker.vala"
		_tmp10_ = ordering_dupl;
#line 114 "broker.vala"
		_tmp11_ = strlen (_tmp10_);
#line 114 "broker.vala"
		_tmp12_ = _tmp11_;
#line 114 "broker.vala"
		_tmp2_ = _tmp12_ > 0;
#line 978 "broker.c"
	} else {
#line 113 "broker.vala"
		_tmp2_ = FALSE;
#line 982 "broker.c"
	}
#line 113 "broker.vala"
	if (_tmp2_) {
#line 986 "broker.c"
		GHashTable* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
#line 115 "broker.vala"
		_tmp13_ = self->provider_ordering;
#line 115 "broker.vala"
		_tmp14_ = tag_dupl;
#line 115 "broker.vala"
		_tmp15_ = g_strdup (_tmp14_);
#line 115 "broker.vala"
		_tmp16_ = ordering_dupl;
#line 115 "broker.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 115 "broker.vala"
		g_hash_table_insert (_tmp13_, _tmp15_, _tmp17_);
#line 1004 "broker.c"
	}
#line 107 "broker.vala"
	_g_free0 (ordering_dupl);
#line 107 "broker.vala"
	_g_free0 (tag_dupl);
#line 1010 "broker.c"
}

static gchar*
_vala_gnulib_relocate (const gchar* path)
{
	gchar* newpath = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 77 "gnu.vapi"
	g_return_val_if_fail (path != NULL, NULL);
#line 78 "gnu.vapi"
	_tmp0_ = (gchar*) relocate (path);
#line 78 "gnu.vapi"
	newpath = _tmp0_;
#line 79 "gnu.vapi"
	_tmp1_ = newpath;
#line 79 "gnu.vapi"
	if (_tmp1_ != path) {
#line 1030 "broker.c"
		gchar* _tmp2_;
#line 82 "gnu.vapi"
		_tmp2_ = newpath;
#line 82 "gnu.vapi"
		newpath = NULL;
#line 82 "gnu.vapi"
		result = (gchar*) _tmp2_;
#line 82 "gnu.vapi"
		return result;
#line 1040 "broker.c"
	} else {
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 85 "gnu.vapi"
		_tmp3_ = newpath;
#line 85 "gnu.vapi"
		_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 85 "gnu.vapi"
		result = _tmp4_;
#line 85 "gnu.vapi"
		return result;
#line 1052 "broker.c"
	}
}

static void
enchant_broker_load_providers (EnchantBroker* self)
{
	gchar* module_dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
#line 118 "broker.vala"
	g_return_if_fail (self != NULL);
#line 119 "broker.vala"
	_tmp0_ = g_strdup_printf ("%s-%s", PKGLIBDIR, ENCHANT_MAJOR_VERSION);
#line 119 "broker.vala"
	_tmp1_ = _tmp0_;
#line 119 "broker.vala"
	_tmp2_ = _vala_gnulib_relocate (_tmp1_);
#line 119 "broker.vala"
	_tmp3_ = _tmp2_;
#line 119 "broker.vala"
	_g_free0 (_tmp1_);
#line 119 "broker.vala"
	module_dir = _tmp3_;
#line 120 "broker.vala"
	_tmp4_ = module_dir;
#line 120 "broker.vala"
	if (_tmp4_ != NULL) {
#line 1083 "broker.c"
		const gchar* _tmp5_;
#line 121 "broker.vala"
		_tmp5_ = module_dir;
#line 121 "broker.vala"
		enchant_broker_load_providers_in_dir (self, _tmp5_);
#line 1089 "broker.c"
	}
#line 118 "broker.vala"
	_g_free0 (module_dir);
#line 1093 "broker.c"
}

static void
enchant_broker_load_providers_in_dir (EnchantBroker* self,
                                      const gchar* dir_name)
{
	GDir* dir = NULL;
	gchar* dir_entry = NULL;
	gsize g_module_suffix_len = 0UL;
	gint _tmp3_;
	gint _tmp4_;
	GError* _inner_error0_ = NULL;
#line 124 "broker.vala"
	g_return_if_fail (self != NULL);
#line 124 "broker.vala"
	g_return_if_fail (dir_name != NULL);
#line 1110 "broker.c"
	{
		GDir* _tmp0_ = NULL;
		GDir* _tmp1_;
		GDir* _tmp2_;
#line 127 "broker.vala"
		_tmp1_ = g_dir_open (dir_name, (guint) 0, &_inner_error0_);
#line 127 "broker.vala"
		_tmp0_ = _tmp1_;
#line 127 "broker.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 127 "broker.vala"
			if (_inner_error0_->domain == G_FILE_ERROR) {
#line 1123 "broker.c"
				goto __catch0_g_file_error;
			}
#line 127 "broker.vala"
			_g_dir_close0 (dir);
#line 127 "broker.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 127 "broker.vala"
			g_clear_error (&_inner_error0_);
#line 127 "broker.vala"
			return;
#line 1134 "broker.c"
		}
#line 127 "broker.vala"
		_tmp2_ = _tmp0_;
#line 127 "broker.vala"
		_tmp0_ = NULL;
#line 127 "broker.vala"
		_g_dir_close0 (dir);
#line 127 "broker.vala"
		dir = _tmp2_;
#line 126 "broker.vala"
		_g_dir_close0 (_tmp0_);
#line 1146 "broker.c"
	}
	goto __finally0;
	__catch0_g_file_error:
	{
#line 126 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 129 "broker.vala"
		_g_dir_close0 (dir);
#line 129 "broker.vala"
		return;
#line 1157 "broker.c"
	}
	__finally0:
#line 126 "broker.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 126 "broker.vala"
		_g_dir_close0 (dir);
#line 126 "broker.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 126 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 126 "broker.vala"
		return;
#line 1170 "broker.c"
	}
#line 133 "broker.vala"
	_tmp3_ = strlen (G_MODULE_SUFFIX);
#line 133 "broker.vala"
	_tmp4_ = _tmp3_;
#line 133 "broker.vala"
	g_module_suffix_len = (gsize) _tmp4_;
#line 134 "broker.vala"
	while (TRUE) {
#line 1180 "broker.c"
		GDir* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		GModule* module = NULL;
		EnchantProvider* provider = NULL;
		gsize entry_len = 0UL;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		EnchantProvider* _tmp39_;
		EnchantProvider* _tmp54_;
#line 134 "broker.vala"
		_tmp5_ = dir;
#line 134 "broker.vala"
		_tmp6_ = g_dir_read_name (_tmp5_);
#line 134 "broker.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 134 "broker.vala"
		_g_free0 (dir_entry);
#line 134 "broker.vala"
		dir_entry = _tmp7_;
#line 134 "broker.vala"
		_tmp8_ = dir_entry;
#line 134 "broker.vala"
		if (!(_tmp8_ != NULL)) {
#line 134 "broker.vala"
			break;
#line 1211 "broker.c"
		}
#line 135 "broker.vala"
		module = NULL;
#line 136 "broker.vala"
		provider = NULL;
#line 138 "broker.vala"
		_tmp9_ = dir_entry;
#line 138 "broker.vala"
		_tmp10_ = strlen (_tmp9_);
#line 138 "broker.vala"
		_tmp11_ = _tmp10_;
#line 138 "broker.vala"
		entry_len = (gsize) _tmp11_;
#line 139 "broker.vala"
		if (entry_len > g_module_suffix_len) {
#line 1227 "broker.c"
			const gchar* _tmp14_;
#line 140 "broker.vala"
			_tmp14_ = dir_entry;
#line 140 "broker.vala"
			_tmp13_ = string_get (_tmp14_, (glong) 0) != '.';
#line 1233 "broker.c"
		} else {
#line 139 "broker.vala"
			_tmp13_ = FALSE;
#line 1237 "broker.c"
		}
#line 139 "broker.vala"
		if (_tmp13_) {
#line 1241 "broker.c"
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
#line 141 "broker.vala"
			_tmp15_ = dir_entry;
#line 141 "broker.vala"
			_tmp16_ = string_substring (_tmp15_, (glong) (entry_len - g_module_suffix_len), (glong) -1);
#line 141 "broker.vala"
			_tmp17_ = _tmp16_;
#line 141 "broker.vala"
			_tmp12_ = g_strcmp0 (_tmp17_, G_MODULE_SUFFIX) == 0;
#line 141 "broker.vala"
			_g_free0 (_tmp17_);
#line 1255 "broker.c"
		} else {
#line 139 "broker.vala"
			_tmp12_ = FALSE;
#line 1259 "broker.c"
		}
#line 139 "broker.vala"
		if (_tmp12_) {
#line 1263 "broker.c"
			gchar* filename = NULL;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			GModule* _tmp21_;
			GModule* _tmp22_;
#line 142 "broker.vala"
			_tmp18_ = dir_entry;
#line 142 "broker.vala"
			_tmp19_ = g_build_filename (dir_name, _tmp18_, NULL);
#line 142 "broker.vala"
			filename = _tmp19_;
#line 143 "broker.vala"
			_tmp20_ = filename;
#line 143 "broker.vala"
			_tmp21_ = g_module_open (_tmp20_, 0);
#line 143 "broker.vala"
			_g_module_close0 (module);
#line 143 "broker.vala"
			module = _tmp21_;
#line 144 "broker.vala"
			_tmp22_ = module;
#line 144 "broker.vala"
			if (_tmp22_ != NULL) {
#line 1288 "broker.c"
				void* init_func = NULL;
				gboolean _tmp23_ = FALSE;
				GModule* _tmp24_;
				void* _tmp25_ = NULL;
				gboolean _tmp26_;
#line 146 "broker.vala"
				_tmp24_ = module;
#line 146 "broker.vala"
				_tmp26_ = g_module_symbol (_tmp24_, "init_enchant_provider", &_tmp25_);
#line 146 "broker.vala"
				init_func = _tmp25_;
#line 146 "broker.vala"
				if (_tmp26_) {
#line 1302 "broker.c"
					void* _tmp27_;
#line 147 "broker.vala"
					_tmp27_ = init_func;
#line 147 "broker.vala"
					_tmp23_ = _tmp27_ != NULL;
#line 1308 "broker.c"
				} else {
#line 146 "broker.vala"
					_tmp23_ = FALSE;
#line 1312 "broker.c"
				}
#line 146 "broker.vala"
				if (_tmp23_) {
#line 1316 "broker.c"
					void* _tmp28_;
					EnchantProvider* _tmp29_;
					EnchantProvider* _tmp30_;
#line 148 "broker.vala"
					_tmp28_ = init_func;
#line 148 "broker.vala"
					_tmp29_ = ((EnchantProviderInitFunc) _tmp28_) ();
#line 148 "broker.vala"
					_enchant_provider_unref0 (provider);
#line 148 "broker.vala"
					provider = _tmp29_;
#line 149 "broker.vala"
					_tmp30_ = provider;
#line 149 "broker.vala"
					if (!enchant_provider_is_valid (_tmp30_)) {
#line 1332 "broker.c"
						const gchar* _tmp31_;
						EnchantProvider* _tmp32_;
#line 150 "broker.vala"
						_tmp31_ = dir_entry;
#line 150 "broker.vala"
						g_warning ("broker.vala:150: Error loading plugin: %s's init_enchant_provider retu" \
"rned invalid provider", _tmp31_);
#line 151 "broker.vala"
						_tmp32_ = provider;
#line 151 "broker.vala"
						if (_tmp32_ != NULL) {
#line 1343 "broker.c"
							EnchantProvider* _tmp33_;
							ProviderDispose _tmp34_;
#line 152 "broker.vala"
							_tmp33_ = provider;
#line 152 "broker.vala"
							_tmp34_ = _tmp33_->dispose;
#line 152 "broker.vala"
							if (_tmp34_ != NULL) {
#line 1352 "broker.c"
								EnchantProvider* _tmp35_;
								ProviderDispose _tmp36_;
								EnchantProvider* _tmp37_;
#line 153 "broker.vala"
								_tmp35_ = provider;
#line 153 "broker.vala"
								_tmp36_ = _tmp35_->dispose;
#line 153 "broker.vala"
								_tmp37_ = provider;
#line 153 "broker.vala"
								_tmp36_ (_tmp37_);
#line 1364 "broker.c"
							}
#line 154 "broker.vala"
							_enchant_provider_unref0 (provider);
#line 154 "broker.vala"
							provider = NULL;
#line 1370 "broker.c"
						}
					}
				}
			} else {
				const gchar* _tmp38_;
#line 159 "broker.vala"
				_tmp38_ = g_module_error ();
#line 159 "broker.vala"
				g_warning ("broker.vala:159: Error loading plugin: %s", _tmp38_);
#line 1380 "broker.c"
			}
#line 139 "broker.vala"
			_g_free0 (filename);
#line 1384 "broker.c"
		}
#line 161 "broker.vala"
		_tmp39_ = provider;
#line 161 "broker.vala"
		if (_tmp39_ != NULL) {
#line 1390 "broker.c"
			void* conf_func = NULL;
			gboolean _tmp40_ = FALSE;
			GModule* _tmp41_;
			void* _tmp42_ = NULL;
			gboolean _tmp43_;
#line 164 "broker.vala"
			_tmp41_ = module;
#line 164 "broker.vala"
			_tmp43_ = g_module_symbol (_tmp41_, "configure_enchant_provider", &_tmp42_);
#line 164 "broker.vala"
			conf_func = _tmp42_;
#line 164 "broker.vala"
			if (_tmp43_) {
#line 1404 "broker.c"
				void* _tmp44_;
#line 165 "broker.vala"
				_tmp44_ = conf_func;
#line 165 "broker.vala"
				_tmp40_ = _tmp44_ != NULL;
#line 1410 "broker.c"
			} else {
#line 164 "broker.vala"
				_tmp40_ = FALSE;
#line 1414 "broker.c"
			}
#line 164 "broker.vala"
			if (_tmp40_) {
#line 1418 "broker.c"
				void* _tmp45_;
				EnchantProvider* _tmp46_;
				EnchantProvider* _tmp47_;
#line 166 "broker.vala"
				_tmp45_ = conf_func;
#line 166 "broker.vala"
				_tmp46_ = provider;
#line 166 "broker.vala"
				((EnchantPreConfigureFunc) _tmp45_) (_tmp46_, dir_name);
#line 167 "broker.vala"
				_tmp47_ = provider;
#line 167 "broker.vala"
				if (!enchant_provider_is_valid (_tmp47_)) {
#line 1432 "broker.c"
					const gchar* _tmp48_;
					EnchantProvider* _tmp49_;
					ProviderDispose _tmp50_;
#line 168 "broker.vala"
					_tmp48_ = dir_entry;
#line 168 "broker.vala"
					g_warning ("broker.vala:168: Error loading plugin: %s's configure_enchant_provider" \
" modified provider and it is now invalid", _tmp48_);
#line 169 "broker.vala"
					_tmp49_ = provider;
#line 169 "broker.vala"
					_tmp50_ = _tmp49_->dispose;
#line 169 "broker.vala"
					if (_tmp50_ != NULL) {
#line 1446 "broker.c"
						EnchantProvider* _tmp51_;
						ProviderDispose _tmp52_;
						EnchantProvider* _tmp53_;
#line 170 "broker.vala"
						_tmp51_ = provider;
#line 170 "broker.vala"
						_tmp52_ = _tmp51_->dispose;
#line 170 "broker.vala"
						_tmp53_ = provider;
#line 170 "broker.vala"
						_tmp52_ (_tmp53_);
#line 1458 "broker.c"
					}
#line 171 "broker.vala"
					_enchant_provider_unref0 (provider);
#line 171 "broker.vala"
					provider = NULL;
#line 1464 "broker.c"
				}
			}
		}
#line 175 "broker.vala"
		_tmp54_ = provider;
#line 175 "broker.vala"
		if (_tmp54_ != NULL) {
#line 1472 "broker.c"
			EnchantProvider* _tmp55_;
			GModule* _tmp56_;
			EnchantProvider* _tmp57_;
			EnchantProvider* _tmp58_;
#line 176 "broker.vala"
			_tmp55_ = provider;
#line 176 "broker.vala"
			_tmp56_ = module;
#line 176 "broker.vala"
			module = NULL;
#line 176 "broker.vala"
			_g_module_close0 (_tmp55_->module);
#line 176 "broker.vala"
			_tmp55_->module = _tmp56_;
#line 177 "broker.vala"
			_tmp57_ = provider;
#line 177 "broker.vala"
			_tmp57_->owner = self;
#line 178 "broker.vala"
			_tmp58_ = provider;
#line 178 "broker.vala"
			provider = NULL;
#line 178 "broker.vala"
			self->provider_list = g_slist_append (self->provider_list, _tmp58_);
#line 1497 "broker.c"
		}
#line 134 "broker.vala"
		_enchant_provider_unref0 (provider);
#line 134 "broker.vala"
		_g_module_close0 (module);
#line 1503 "broker.c"
	}
#line 124 "broker.vala"
	_g_free0 (dir_entry);
#line 124 "broker.vala"
	_g_dir_close0 (dir);
#line 1509 "broker.c"
}

static void
enchant_broker_load_ordering_from_file (EnchantBroker* self,
                                        const gchar* file)
{
	GIOChannel* ch = NULL;
	GIOChannel* _tmp5_;
	gchar* line = NULL;
	gsize terminator = 0UL;
	GError* _inner_error0_ = NULL;
#line 183 "broker.vala"
	g_return_if_fail (self != NULL);
#line 183 "broker.vala"
	g_return_if_fail (file != NULL);
#line 184 "broker.vala"
	ch = NULL;
#line 1527 "broker.c"
	{
		GIOChannel* _tmp0_ = NULL;
		GIOChannel* _tmp1_;
		GIOChannel* _tmp2_;
#line 186 "broker.vala"
		_tmp1_ = g_io_channel_new_file (file, "r", &_inner_error0_);
#line 186 "broker.vala"
		_tmp0_ = _tmp1_;
#line 186 "broker.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 186 "broker.vala"
			if (_inner_error0_->domain == G_FILE_ERROR) {
#line 1540 "broker.c"
				goto __catch0_g_file_error;
			}
#line 186 "broker.vala"
			_g_io_channel_unref0 (ch);
#line 186 "broker.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 186 "broker.vala"
			g_clear_error (&_inner_error0_);
#line 186 "broker.vala"
			return;
#line 1551 "broker.c"
		}
#line 186 "broker.vala"
		_tmp2_ = _tmp0_;
#line 186 "broker.vala"
		_tmp0_ = NULL;
#line 186 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 186 "broker.vala"
		ch = _tmp2_;
#line 185 "broker.vala"
		_g_io_channel_unref0 (_tmp0_);
#line 1563 "broker.c"
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 185 "broker.vala"
		e = _inner_error0_;
#line 185 "broker.vala"
		_inner_error0_ = NULL;
#line 188 "broker.vala"
		_tmp3_ = e;
#line 188 "broker.vala"
		_tmp4_ = _tmp3_->message;
#line 188 "broker.vala"
		g_debug ("broker.vala:188: could not open ordering file %s: %s", file, _tmp4_);
#line 189 "broker.vala"
		_g_error_free0 (e);
#line 189 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 189 "broker.vala"
		return;
#line 1587 "broker.c"
	}
	__finally0:
#line 185 "broker.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 185 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 185 "broker.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 185 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 185 "broker.vala"
		return;
#line 1600 "broker.c"
	}
#line 191 "broker.vala"
	_tmp5_ = ch;
#line 191 "broker.vala"
	_vala_assert (_tmp5_ != NULL, "ch != null");
#line 193 "broker.vala"
	g_debug ("broker.vala:193: reading ordering file %s", file);
#line 1608 "broker.c"
	{
#line 197 "broker.vala"
		while (TRUE) {
#line 1612 "broker.c"
			GIOStatus _tmp6_ = 0;
			GIOChannel* _tmp7_;
			gchar* _tmp8_ = NULL;
			gsize _tmp9_ = 0UL;
			GIOStatus _tmp10_;
			gint colon = 0;
			const gchar* _tmp11_;
#line 197 "broker.vala"
			_tmp7_ = ch;
#line 197 "broker.vala"
			_tmp10_ = g_io_channel_read_line (_tmp7_, &_tmp8_, NULL, &_tmp9_, &_inner_error0_);
#line 197 "broker.vala"
			_g_free0 (line);
#line 197 "broker.vala"
			line = _tmp8_;
#line 197 "broker.vala"
			terminator = _tmp9_;
#line 197 "broker.vala"
			_tmp6_ = _tmp10_;
#line 197 "broker.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 197 "broker.vala"
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 1636 "broker.c"
					goto __catch1_g_convert_error;
				}
#line 197 "broker.vala"
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
#line 1641 "broker.c"
					goto __catch1_g_io_channel_error;
				}
#line 197 "broker.vala"
				_g_free0 (line);
#line 197 "broker.vala"
				_g_io_channel_unref0 (ch);
#line 197 "broker.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 197 "broker.vala"
				g_clear_error (&_inner_error0_);
#line 197 "broker.vala"
				return;
#line 1654 "broker.c"
			}
#line 197 "broker.vala"
			if (!(G_IO_STATUS_NORMAL == _tmp6_)) {
#line 197 "broker.vala"
				break;
#line 1660 "broker.c"
			}
#line 198 "broker.vala"
			_tmp11_ = line;
#line 198 "broker.vala"
			colon = string_index_of_char (_tmp11_, (gunichar) ':', 0);
#line 199 "broker.vala"
			if (colon != -1) {
#line 1668 "broker.c"
				gchar* tag = NULL;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* ordering = NULL;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
#line 200 "broker.vala"
				_tmp12_ = line;
#line 200 "broker.vala"
				_tmp13_ = string_substring (_tmp12_, (glong) 0, (glong) colon);
#line 200 "broker.vala"
				tag = _tmp13_;
#line 201 "broker.vala"
				_tmp14_ = line;
#line 201 "broker.vala"
				_tmp15_ = string_substring (_tmp14_, (glong) (colon + 1), (((glong) terminator) - colon) - 1);
#line 201 "broker.vala"
				ordering = _tmp15_;
#line 202 "broker.vala"
				_tmp16_ = tag;
#line 202 "broker.vala"
				_tmp17_ = ordering;
#line 202 "broker.vala"
				enchant_broker_set_ordering (self, _tmp16_, _tmp17_);
#line 199 "broker.vala"
				_g_free0 (ordering);
#line 199 "broker.vala"
				_g_free0 (tag);
#line 1699 "broker.c"
			}
		}
	}
	goto __finally1;
	__catch1_g_convert_error:
	{
#line 196 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 206 "broker.vala"
		_g_free0 (line);
#line 206 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 206 "broker.vala"
		return;
#line 1714 "broker.c"
	}
	goto __finally1;
	__catch1_g_io_channel_error:
	{
#line 196 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 208 "broker.vala"
		_g_free0 (line);
#line 208 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 208 "broker.vala"
		return;
#line 1727 "broker.c"
	}
	__finally1:
#line 196 "broker.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 196 "broker.vala"
		_g_free0 (line);
#line 196 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 196 "broker.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 196 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 196 "broker.vala"
		return;
#line 1742 "broker.c"
	}
#line 183 "broker.vala"
	_g_free0 (line);
#line 183 "broker.vala"
	_g_io_channel_unref0 (ch);
#line 1748 "broker.c"
}

static void
_g_free0_ (gpointer var)
{
#line 213 "broker.vala"
	var = (g_free (var), NULL);
#line 1756 "broker.c"
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
#line 212 "broker.vala"
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
#line 1764 "broker.c"
}

void
enchant_broker_load_provider_ordering (EnchantBroker* self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GSList* conf_dirs = NULL;
	GSList* _tmp3_;
	GSList* _tmp4_;
#line 212 "broker.vala"
	g_return_if_fail (self != NULL);
#line 213 "broker.vala"
	_tmp0_ = g_str_hash;
#line 213 "broker.vala"
	_tmp1_ = g_str_equal;
#line 213 "broker.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
#line 213 "broker.vala"
	_g_hash_table_unref0 (self->provider_ordering);
#line 213 "broker.vala"
	self->provider_ordering = _tmp2_;
#line 215 "broker.vala"
	_tmp3_ = enchant_get_conf_dirs ();
#line 215 "broker.vala"
	conf_dirs = _tmp3_;
#line 216 "broker.vala"
	_tmp4_ = conf_dirs;
#line 1794 "broker.c"
	{
		GSList* dir_collection = NULL;
		GSList* dir_it = NULL;
#line 216 "broker.vala"
		dir_collection = _tmp4_;
#line 216 "broker.vala"
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
#line 1802 "broker.c"
			gchar* _tmp5_;
			gchar* dir = NULL;
#line 216 "broker.vala"
			_tmp5_ = g_strdup ((const gchar*) dir_it->data);
#line 216 "broker.vala"
			dir = _tmp5_;
#line 1809 "broker.c"
			{
				gchar* ordering_file = NULL;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
#line 217 "broker.vala"
				_tmp6_ = dir;
#line 217 "broker.vala"
				_tmp7_ = g_build_filename (_tmp6_, "enchant.ordering", NULL);
#line 217 "broker.vala"
				ordering_file = _tmp7_;
#line 218 "broker.vala"
				_tmp8_ = ordering_file;
#line 218 "broker.vala"
				enchant_broker_load_ordering_from_file (self, _tmp8_);
#line 216 "broker.vala"
				_g_free0 (ordering_file);
#line 216 "broker.vala"
				_g_free0 (dir);
#line 1829 "broker.c"
			}
		}
	}
#line 212 "broker.vala"
	(conf_dirs == NULL) ? NULL : (conf_dirs = (_g_slist_free__g_free0_ (conf_dirs), NULL));
#line 1835 "broker.c"
}

GSList*
enchant_broker_get_ordered_providers (EnchantBroker* self,
                                      const gchar* tag)
{
	gchar* ordering = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GSList* list = NULL;
	const gchar* _tmp7_;
	GSList* _tmp23_;
	GSList* result;
#line 222 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 222 "broker.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 223 "broker.vala"
	_tmp0_ = self->provider_ordering;
#line 223 "broker.vala"
	_tmp1_ = g_hash_table_lookup (_tmp0_, tag);
#line 223 "broker.vala"
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
#line 223 "broker.vala"
	ordering = _tmp2_;
#line 224 "broker.vala"
	_tmp3_ = ordering;
#line 224 "broker.vala"
	if (_tmp3_ == NULL) {
#line 1867 "broker.c"
		GHashTable* _tmp4_;
		gconstpointer _tmp5_;
		gchar* _tmp6_;
#line 225 "broker.vala"
		_tmp4_ = self->provider_ordering;
#line 225 "broker.vala"
		_tmp5_ = g_hash_table_lookup (_tmp4_, "*");
#line 225 "broker.vala"
		_tmp6_ = g_strdup ((const gchar*) _tmp5_);
#line 225 "broker.vala"
		_g_free0 (ordering);
#line 225 "broker.vala"
		ordering = _tmp6_;
#line 1881 "broker.c"
	}
#line 227 "broker.vala"
	list = NULL;
#line 229 "broker.vala"
	_tmp7_ = ordering;
#line 229 "broker.vala"
	if (_tmp7_ != NULL) {
#line 1889 "broker.c"
		gchar** tokens = NULL;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar** _tmp11_;
		gint _tmp11__length1;
#line 230 "broker.vala"
		_tmp8_ = ordering;
#line 230 "broker.vala"
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, ",", 0);
#line 230 "broker.vala"
		tokens = _tmp10_;
#line 230 "broker.vala"
		tokens_length1 = _vala_array_length (_tmp9_);
#line 230 "broker.vala"
		_tokens_size_ = tokens_length1;
#line 231 "broker.vala"
		_tmp11_ = tokens;
#line 231 "broker.vala"
		_tmp11__length1 = tokens_length1;
#line 1912 "broker.c"
		{
			gchar** token_collection = NULL;
			gint token_collection_length1 = 0;
			gint _token_collection_size_ = 0;
			gint token_it = 0;
#line 231 "broker.vala"
			token_collection = _tmp11_;
#line 231 "broker.vala"
			token_collection_length1 = _tmp11__length1;
#line 231 "broker.vala"
			for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
#line 1924 "broker.c"
				const gchar* token = NULL;
#line 231 "broker.vala"
				token = token_collection[token_it];
#line 1928 "broker.c"
				{
					gchar* tok = NULL;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					GSList* _tmp14_;
#line 232 "broker.vala"
					_tmp12_ = token;
#line 232 "broker.vala"
					_tmp13_ = string_strip (_tmp12_);
#line 232 "broker.vala"
					tok = _tmp13_;
#line 234 "broker.vala"
					_tmp14_ = self->provider_list;
#line 1942 "broker.c"
					{
						GSList* provider_collection = NULL;
						GSList* provider_it = NULL;
#line 234 "broker.vala"
						provider_collection = _tmp14_;
#line 234 "broker.vala"
						for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 1950 "broker.c"
							EnchantProvider* provider = NULL;
#line 234 "broker.vala"
							provider = (EnchantProvider*) provider_it->data;
#line 1954 "broker.c"
							{
								gboolean _tmp15_ = FALSE;
								EnchantProvider* _tmp16_;
#line 235 "broker.vala"
								_tmp16_ = provider;
#line 235 "broker.vala"
								if (_tmp16_ != NULL) {
#line 1962 "broker.c"
									const gchar* _tmp17_;
									EnchantProvider* _tmp18_;
									ProviderIdentify _tmp19_;
									EnchantProvider* _tmp20_;
									const gchar* _tmp21_;
#line 235 "broker.vala"
									_tmp17_ = tok;
#line 235 "broker.vala"
									_tmp18_ = provider;
#line 235 "broker.vala"
									_tmp19_ = _tmp18_->identify;
#line 235 "broker.vala"
									_tmp20_ = provider;
#line 235 "broker.vala"
									_tmp21_ = _tmp19_ (_tmp20_);
#line 235 "broker.vala"
									_tmp15_ = g_strcmp0 (_tmp17_, _tmp21_) == 0;
#line 1980 "broker.c"
								} else {
#line 235 "broker.vala"
									_tmp15_ = FALSE;
#line 1984 "broker.c"
								}
#line 235 "broker.vala"
								if (_tmp15_) {
#line 1988 "broker.c"
									EnchantProvider* _tmp22_;
#line 236 "broker.vala"
									_tmp22_ = provider;
#line 236 "broker.vala"
									list = g_slist_append (list, _tmp22_);
#line 1994 "broker.c"
								}
							}
						}
					}
#line 231 "broker.vala"
					_g_free0 (tok);
#line 2001 "broker.c"
				}
			}
		}
#line 229 "broker.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 2007 "broker.c"
	}
#line 241 "broker.vala"
	_tmp23_ = self->provider_list;
#line 2011 "broker.c"
	{
		GSList* provider_collection = NULL;
		GSList* provider_it = NULL;
#line 241 "broker.vala"
		provider_collection = _tmp23_;
#line 241 "broker.vala"
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 2019 "broker.c"
			EnchantProvider* provider = NULL;
#line 241 "broker.vala"
			provider = (EnchantProvider*) provider_it->data;
#line 2023 "broker.c"
			{
				GSList* _tmp24_;
				EnchantProvider* _tmp25_;
				GSList* _tmp26_;
#line 242 "broker.vala"
				_tmp24_ = list;
#line 242 "broker.vala"
				_tmp25_ = provider;
#line 242 "broker.vala"
				_tmp26_ = g_slist_find (_tmp24_, _tmp25_);
#line 242 "broker.vala"
				if (_tmp26_ == NULL) {
#line 2036 "broker.c"
					EnchantProvider* _tmp27_;
#line 243 "broker.vala"
					_tmp27_ = provider;
#line 243 "broker.vala"
					list = g_slist_append (list, _tmp27_);
#line 2042 "broker.c"
				}
			}
		}
	}
#line 245 "broker.vala"
	result = list;
#line 245 "broker.vala"
	_g_free0 (ordering);
#line 245 "broker.vala"
	return result;
#line 2053 "broker.c"
}

static gpointer
_enchant_session_ref0 (gpointer self)
{
#line 266 "broker.vala"
	return self ? enchant_session_ref (self) : NULL;
#line 2061 "broker.c"
}

EnchantDict*
enchant_broker_request_pwl_dict (EnchantBroker* self,
                                 const gchar* pwl)
{
	gint _tmp0_;
	gint _tmp1_;
	EnchantSession* session = NULL;
	EnchantSession* _tmp2_;
	EnchantSession* _tmp3_;
	EnchantSession* _tmp6_;
	EnchantDict* dict = NULL;
	EnchantDict* _tmp7_;
	EnchantDict* _tmp8_;
	EnchantSession* _tmp9_;
	EnchantSession* _tmp10_;
	EnchantDict* _tmp11_;
	EnchantDict* result;
#line 248 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 248 "broker.vala"
	g_return_val_if_fail (pwl != NULL, NULL);
#line 248 "broker.vala"
	_tmp0_ = strlen (pwl);
#line 248 "broker.vala"
	_tmp1_ = _tmp0_;
#line 248 "broker.vala"
	_vala_return_val_if_fail (_tmp1_ > 0, "pwl.length > 0", NULL);
#line 251 "broker.vala"
	enchant_broker_clear_error (self);
#line 257 "broker.vala"
	_tmp2_ = enchant_session_with_pwl (NULL, pwl, NULL, "Personal Wordlist", TRUE);
#line 257 "broker.vala"
	session = _tmp2_;
#line 258 "broker.vala"
	_tmp3_ = session;
#line 258 "broker.vala"
	if (_tmp3_ == NULL) {
#line 2101 "broker.c"
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 259 "broker.vala"
		_tmp4_ = g_strdup_printf ("Couldn't open personal wordlist '%s'", pwl);
#line 259 "broker.vala"
		_tmp5_ = _tmp4_;
#line 259 "broker.vala"
		enchant_broker_set_error (self, _tmp5_);
#line 259 "broker.vala"
		_g_free0 (_tmp5_);
#line 260 "broker.vala"
		result = NULL;
#line 260 "broker.vala"
		_enchant_session_unref0 (session);
#line 260 "broker.vala"
		return result;
#line 2118 "broker.c"
	}
#line 263 "broker.vala"
	_tmp6_ = session;
#line 263 "broker.vala"
	_tmp6_->is_pwl = TRUE;
#line 265 "broker.vala"
	_tmp7_ = enchant_broker_new_dict (self);
#line 265 "broker.vala"
	dict = _tmp7_;
#line 266 "broker.vala"
	_tmp8_ = dict;
#line 266 "broker.vala"
	_tmp9_ = session;
#line 266 "broker.vala"
	_tmp10_ = _enchant_session_ref0 (_tmp9_);
#line 266 "broker.vala"
	_enchant_session_unref0 (_tmp8_->session);
#line 266 "broker.vala"
	_tmp8_->session = _tmp10_;
#line 267 "broker.vala"
	_tmp11_ = dict;
#line 267 "broker.vala"
	result = _tmp11_;
#line 267 "broker.vala"
	_enchant_session_unref0 (session);
#line 267 "broker.vala"
	return result;
#line 2146 "broker.c"
}

static EnchantDict*
_enchant_broker_request_dict (EnchantBroker* self,
                              const gchar* tag,
                              const gchar* pwl)
{
	GSList* list = NULL;
	GSList* _tmp0_;
	EnchantDict* dict = NULL;
	GSList* _tmp1_;
	EnchantDict* _tmp12_;
	EnchantDict* result;
#line 270 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 270 "broker.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 271 "broker.vala"
	_tmp0_ = enchant_broker_get_ordered_providers (self, tag);
#line 271 "broker.vala"
	list = _tmp0_;
#line 272 "broker.vala"
	dict = NULL;
#line 273 "broker.vala"
	_tmp1_ = list;
#line 2172 "broker.c"
	{
		GSList* provider_collection = NULL;
		GSList* provider_it = NULL;
#line 273 "broker.vala"
		provider_collection = _tmp1_;
#line 273 "broker.vala"
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 2180 "broker.c"
			EnchantProvider* provider = NULL;
#line 273 "broker.vala"
			provider = (EnchantProvider*) provider_it->data;
#line 2184 "broker.c"
			{
				EnchantProvider* _tmp2_;
				ProviderRequestDict _tmp3_;
				EnchantProvider* _tmp4_;
				EnchantDict* _tmp5_;
				EnchantDict* _tmp6_;
#line 274 "broker.vala"
				_tmp2_ = provider;
#line 274 "broker.vala"
				_tmp3_ = _tmp2_->request_dict;
#line 274 "broker.vala"
				_tmp4_ = provider;
#line 274 "broker.vala"
				_tmp5_ = _tmp3_ (_tmp4_, tag);
#line 274 "broker.vala"
				dict = _tmp5_;
#line 275 "broker.vala"
				_tmp6_ = dict;
#line 275 "broker.vala"
				if (_tmp6_ != NULL) {
#line 2205 "broker.c"
					EnchantSession* session = NULL;
					EnchantProvider* _tmp7_;
					EnchantSession* _tmp8_;
					EnchantDict* _tmp9_;
					EnchantSession* _tmp10_;
					EnchantSession* _tmp11_;
#line 276 "broker.vala"
					_tmp7_ = provider;
#line 276 "broker.vala"
					_tmp8_ = enchant_session_with_implicit_pwl (_tmp7_, tag, pwl);
#line 276 "broker.vala"
					session = _tmp8_;
#line 277 "broker.vala"
					_tmp9_ = dict;
#line 277 "broker.vala"
					_tmp10_ = session;
#line 277 "broker.vala"
					_tmp11_ = _enchant_session_ref0 (_tmp10_);
#line 277 "broker.vala"
					_enchant_session_unref0 (_tmp9_->session);
#line 277 "broker.vala"
					_tmp9_->session = _tmp11_;
#line 278 "broker.vala"
					_enchant_session_unref0 (session);
#line 278 "broker.vala"
					break;
#line 2232 "broker.c"
				}
			}
		}
	}
#line 282 "broker.vala"
	_tmp12_ = dict;
#line 282 "broker.vala"
	result = _tmp12_;
#line 282 "broker.vala"
	(list == NULL) ? NULL : (list = (g_slist_free (list), NULL));
#line 282 "broker.vala"
	return result;
#line 2245 "broker.c"
}

static gint
_composite_dict_check_dict_check (EnchantDict* me,
                                  const gchar* word,
                                  size_t len)
{
	gint result;
	result = composite_dict_check (me, word, len);
#line 318 "broker.vala"
	return result;
#line 2257 "broker.c"
}

static gchar**
_composite_dict_suggest_dict_suggest (EnchantDict* me,
                                      const gchar* word,
                                      size_t len,
                                      size_t* result_length1)
{
	gchar** result;
	result = composite_dict_suggest (me, word, len, result_length1);
#line 319 "broker.vala"
	return result;
#line 2270 "broker.c"
}

static void
_composite_dict_add_to_session_dict_add_to_session (EnchantDict* me,
                                                    const gchar* word,
                                                    size_t len)
{
#line 320 "broker.vala"
	composite_dict_add_to_session (me, word, len);
#line 2280 "broker.c"
}

static void
_composite_dict_remove_from_session_dict_remove_from_session (EnchantDict* me,
                                                              const gchar* word,
                                                              size_t len)
{
#line 321 "broker.vala"
	composite_dict_remove_from_session (me, word, len);
#line 2290 "broker.c"
}

EnchantDict*
enchant_broker_request_dict_with_pwl (EnchantBroker* self,
                                      const gchar* composite_tag,
                                      const gchar* pwl)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar** tags = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint tags_length1;
	gint _tags_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GSList* dict_list = NULL;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GSList* _tmp20_;
	EnchantCompositeDict* comp_dict = NULL;
	EnchantCompositeDict* _tmp23_;
	EnchantCompositeDict* _tmp24_;
	GSList* _tmp25_;
	EnchantDict* dict = NULL;
	EnchantDict* _tmp26_;
	EnchantDict* _tmp27_;
	EnchantCompositeDict* _tmp28_;
	EnchantDict* _tmp29_;
	EnchantDict* _tmp30_;
	EnchantDict* _tmp31_;
	EnchantDict* _tmp32_;
	EnchantDict* _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	const gchar* _tmp35_;
	EnchantSession* _tmp36_;
	EnchantDict* _tmp37_;
	EnchantDict* result;
#line 285 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 285 "broker.vala"
	g_return_val_if_fail (composite_tag != NULL, NULL);
#line 285 "broker.vala"
	_tmp0_ = strlen (composite_tag);
#line 285 "broker.vala"
	_tmp1_ = _tmp0_;
#line 285 "broker.vala"
	_vala_return_val_if_fail (_tmp1_ > 0, "composite_tag.length > 0", NULL);
#line 289 "broker.vala"
	_tmp3_ = _tmp2_ = g_strsplit (composite_tag, ",", 0);
#line 289 "broker.vala"
	tags = _tmp3_;
#line 289 "broker.vala"
	tags_length1 = _vala_array_length (_tmp2_);
#line 289 "broker.vala"
	_tags_size_ = tags_length1;
#line 290 "broker.vala"
	_tmp4_ = tags;
#line 290 "broker.vala"
	_tmp4__length1 = tags_length1;
#line 2352 "broker.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 290 "broker.vala"
		tag_collection = _tmp4_;
#line 290 "broker.vala"
		tag_collection_length1 = _tmp4__length1;
#line 290 "broker.vala"
		for (tag_it = 0; tag_it < tag_collection_length1; tag_it = tag_it + 1) {
#line 2364 "broker.c"
			const gchar* tag = NULL;
#line 290 "broker.vala"
			tag = tag_collection[tag_it];
#line 2368 "broker.c"
			{
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
#line 291 "broker.vala"
				_tmp5_ = tag;
#line 291 "broker.vala"
				_tmp6_ = strlen (_tmp5_);
#line 291 "broker.vala"
				_tmp7_ = _tmp6_;
#line 291 "broker.vala"
				if (_tmp7_ == 0) {
#line 292 "broker.vala"
					result = NULL;
#line 292 "broker.vala"
					tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 292 "broker.vala"
					return result;
#line 2387 "broker.c"
				}
			}
		}
	}
#line 294 "broker.vala"
	enchant_broker_clear_error (self);
#line 297 "broker.vala"
	dict_list = NULL;
#line 298 "broker.vala"
	_tmp8_ = tags;
#line 298 "broker.vala"
	_tmp8__length1 = tags_length1;
#line 2400 "broker.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 298 "broker.vala"
		tag_collection = _tmp8_;
#line 298 "broker.vala"
		tag_collection_length1 = _tmp8__length1;
#line 298 "broker.vala"
		for (tag_it = 0; tag_it < tag_collection_length1; tag_it = tag_it + 1) {
#line 2412 "broker.c"
			const gchar* tag = NULL;
#line 298 "broker.vala"
			tag = tag_collection[tag_it];
#line 2416 "broker.c"
			{
				gchar* normalized_tag = NULL;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				EnchantDict* dict = NULL;
				const gchar* _tmp11_;
				EnchantDict* _tmp12_;
				EnchantDict* _tmp13_;
				EnchantDict* _tmp18_;
				EnchantDict* _tmp19_;
#line 299 "broker.vala"
				_tmp9_ = tag;
#line 299 "broker.vala"
				_tmp10_ = normalize_dictionary_tag (_tmp9_);
#line 299 "broker.vala"
				normalized_tag = _tmp10_;
#line 300 "broker.vala"
				_tmp11_ = normalized_tag;
#line 300 "broker.vala"
				_tmp12_ = _enchant_broker_request_dict (self, _tmp11_, pwl);
#line 300 "broker.vala"
				dict = _tmp12_;
#line 301 "broker.vala"
				_tmp13_ = dict;
#line 301 "broker.vala"
				if (_tmp13_ == NULL) {
#line 2443 "broker.c"
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					EnchantDict* _tmp17_;
#line 302 "broker.vala"
					_tmp14_ = normalized_tag;
#line 302 "broker.vala"
					_tmp15_ = iso_639_from_tag (_tmp14_);
#line 302 "broker.vala"
					_tmp16_ = _tmp15_;
#line 302 "broker.vala"
					_tmp17_ = _enchant_broker_request_dict (self, _tmp16_, pwl);
#line 302 "broker.vala"
					dict = _tmp17_;
#line 302 "broker.vala"
					_g_free0 (_tmp16_);
#line 2460 "broker.c"
				}
#line 303 "broker.vala"
				_tmp18_ = dict;
#line 303 "broker.vala"
				if (_tmp18_ == NULL) {
#line 304 "broker.vala"
					result = NULL;
#line 304 "broker.vala"
					_g_free0 (normalized_tag);
#line 304 "broker.vala"
					(dict_list == NULL) ? NULL : (dict_list = (g_slist_free (dict_list), NULL));
#line 304 "broker.vala"
					tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 304 "broker.vala"
					return result;
#line 2476 "broker.c"
				}
#line 305 "broker.vala"
				_tmp19_ = dict;
#line 305 "broker.vala"
				dict_list = g_slist_append (dict_list, _tmp19_);
#line 298 "broker.vala"
				_g_free0 (normalized_tag);
#line 2484 "broker.c"
			}
		}
	}
#line 309 "broker.vala"
	_tmp20_ = dict_list;
#line 309 "broker.vala"
	if (g_slist_length (_tmp20_) == ((guint) 1)) {
#line 2492 "broker.c"
		GSList* _tmp21_;
		gconstpointer _tmp22_;
#line 310 "broker.vala"
		_tmp21_ = dict_list;
#line 310 "broker.vala"
		_tmp22_ = _tmp21_->data;
#line 310 "broker.vala"
		result = (EnchantDict*) _tmp22_;
#line 310 "broker.vala"
		(dict_list == NULL) ? NULL : (dict_list = (g_slist_free (dict_list), NULL));
#line 310 "broker.vala"
		tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 310 "broker.vala"
		return result;
#line 2507 "broker.c"
	}
#line 313 "broker.vala"
	_tmp23_ = enchant_composite_dict_new ();
#line 313 "broker.vala"
	comp_dict = _tmp23_;
#line 314 "broker.vala"
	_tmp24_ = comp_dict;
#line 314 "broker.vala"
	_tmp25_ = dict_list;
#line 314 "broker.vala"
	dict_list = NULL;
#line 314 "broker.vala"
	(_tmp24_->dict_list == NULL) ? NULL : (_tmp24_->dict_list = (g_slist_free (_tmp24_->dict_list), NULL));
#line 314 "broker.vala"
	_tmp24_->dict_list = _tmp25_;
#line 316 "broker.vala"
	_tmp26_ = enchant_broker_new_dict (self);
#line 316 "broker.vala"
	dict = _tmp26_;
#line 317 "broker.vala"
	_tmp27_ = dict;
#line 317 "broker.vala"
	_tmp28_ = comp_dict;
#line 317 "broker.vala"
	comp_dict = NULL;
#line 317 "broker.vala"
	_tmp27_->user_data = (void*) _tmp28_;
#line 318 "broker.vala"
	_tmp29_ = dict;
#line 318 "broker.vala"
	_tmp29_->check_method = _composite_dict_check_dict_check;
#line 319 "broker.vala"
	_tmp30_ = dict;
#line 319 "broker.vala"
	_tmp30_->suggest_method = _composite_dict_suggest_dict_suggest;
#line 320 "broker.vala"
	_tmp31_ = dict;
#line 320 "broker.vala"
	_tmp31_->add_to_session_method = _composite_dict_add_to_session_dict_add_to_session;
#line 321 "broker.vala"
	_tmp32_ = dict;
#line 321 "broker.vala"
	_tmp32_->remove_from_session_method = _composite_dict_remove_from_session_dict_remove_from_session;
#line 322 "broker.vala"
	_tmp33_ = dict;
#line 322 "broker.vala"
	_tmp34_ = tags;
#line 322 "broker.vala"
	_tmp34__length1 = tags_length1;
#line 322 "broker.vala"
	_tmp35_ = _tmp34_[0];
#line 322 "broker.vala"
	_tmp36_ = enchant_session_with_implicit_pwl (NULL, _tmp35_, pwl);
#line 322 "broker.vala"
	_enchant_session_unref0 (_tmp33_->session);
#line 322 "broker.vala"
	_tmp33_->session = _tmp36_;
#line 323 "broker.vala"
	_tmp37_ = dict;
#line 323 "broker.vala"
	result = _tmp37_;
#line 323 "broker.vala"
	_enchant_composite_dict_unref0 (comp_dict);
#line 323 "broker.vala"
	(dict_list == NULL) ? NULL : (dict_list = (g_slist_free (dict_list), NULL));
#line 323 "broker.vala"
	tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 323 "broker.vala"
	return result;
#line 2577 "broker.c"
}

EnchantDict*
enchant_broker_request_dict (EnchantBroker* self,
                             const gchar* tag)
{
	EnchantDict* _tmp0_;
	EnchantDict* result;
#line 326 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 326 "broker.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 327 "broker.vala"
	_tmp0_ = enchant_broker_request_dict_with_pwl (self, tag, NULL);
#line 327 "broker.vala"
	result = _tmp0_;
#line 327 "broker.vala"
	return result;
#line 2596 "broker.c"
}

void
enchant_broker_describe (EnchantBroker* self,
                         EnchantBrokerDescribeFn fn,
                         void* user_data)
{
	GSList* _tmp0_;
#line 330 "broker.vala"
	g_return_if_fail (self != NULL);
#line 330 "broker.vala"
	_vala_return_if_fail (fn != NULL, "fn != null");
#line 334 "broker.vala"
	enchant_broker_clear_error (self);
#line 336 "broker.vala"
	_tmp0_ = self->provider_list;
#line 2613 "broker.c"
	{
		GSList* provider_collection = NULL;
		GSList* provider_it = NULL;
#line 336 "broker.vala"
		provider_collection = _tmp0_;
#line 336 "broker.vala"
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 2621 "broker.c"
			EnchantProvider* provider = NULL;
#line 336 "broker.vala"
			provider = (EnchantProvider*) provider_it->data;
#line 2625 "broker.c"
			{
				gchar* name = NULL;
				EnchantProvider* _tmp1_;
				ProviderIdentify _tmp2_;
				EnchantProvider* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* desc = NULL;
				EnchantProvider* _tmp6_;
				ProviderDescribe _tmp7_;
				EnchantProvider* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* file = NULL;
				EnchantProvider* _tmp11_;
				GModule* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
#line 337 "broker.vala"
				_tmp1_ = provider;
#line 337 "broker.vala"
				_tmp2_ = _tmp1_->identify;
#line 337 "broker.vala"
				_tmp3_ = provider;
#line 337 "broker.vala"
				_tmp4_ = _tmp2_ (_tmp3_);
#line 337 "broker.vala"
				_tmp5_ = g_strdup (_tmp4_);
#line 337 "broker.vala"
				name = _tmp5_;
#line 338 "broker.vala"
				_tmp6_ = provider;
#line 338 "broker.vala"
				_tmp7_ = _tmp6_->describe;
#line 338 "broker.vala"
				_tmp8_ = provider;
#line 338 "broker.vala"
				_tmp9_ = _tmp7_ (_tmp8_);
#line 338 "broker.vala"
				_tmp10_ = g_strdup (_tmp9_);
#line 338 "broker.vala"
				desc = _tmp10_;
#line 339 "broker.vala"
				_tmp11_ = provider;
#line 339 "broker.vala"
				_tmp12_ = _tmp11_->module;
#line 339 "broker.vala"
				_tmp13_ = g_module_name (_tmp12_);
#line 339 "broker.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 339 "broker.vala"
				file = _tmp14_;
#line 341 "broker.vala"
				_tmp15_ = name;
#line 341 "broker.vala"
				_tmp16_ = desc;
#line 341 "broker.vala"
				_tmp17_ = file;
#line 341 "broker.vala"
				fn (_tmp15_, _tmp16_, _tmp17_, user_data);
#line 336 "broker.vala"
				_g_free0 (file);
#line 336 "broker.vala"
				_g_free0 (desc);
#line 336 "broker.vala"
				_g_free0 (name);
#line 2695 "broker.c"
			}
		}
	}
}

void
enchant_broker_list_dicts (EnchantBroker* self,
                           EnchantDictDescribeFn fn,
                           void* user_data)
{
	GHashTable* tag_map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GSList* _tmp3_;
	GSList* _tmp4_;
	GSList* tags = NULL;
	GHashTable* _tmp30_;
	GList* _tmp31_;
	GSList* _tmp36_;
#line 345 "broker.vala"
	g_return_if_fail (self != NULL);
#line 345 "broker.vala"
	_vala_return_if_fail (fn != NULL, "fn != null");
#line 348 "broker.vala"
	_tmp0_ = g_str_hash;
#line 348 "broker.vala"
	_tmp1_ = g_str_equal;
#line 348 "broker.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
#line 348 "broker.vala"
	tag_map = _tmp2_;
#line 350 "broker.vala"
	enchant_broker_clear_error (self);
#line 351 "broker.vala"
	g_debug ("broker.vala:351: listing dictionaries");
#line 352 "broker.vala"
	_tmp3_ = self->provider_list;
#line 352 "broker.vala"
	if (_tmp3_ == NULL) {
#line 353 "broker.vala"
		g_debug ("broker.vala:353: no providers found!");
#line 2738 "broker.c"
	}
#line 355 "broker.vala"
	_tmp4_ = self->provider_list;
#line 2742 "broker.c"
	{
		GSList* provider_collection = NULL;
		GSList* provider_it = NULL;
#line 355 "broker.vala"
		provider_collection = _tmp4_;
#line 355 "broker.vala"
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 2750 "broker.c"
			EnchantProvider* provider = NULL;
#line 355 "broker.vala"
			provider = (EnchantProvider*) provider_it->data;
#line 2754 "broker.c"
			{
				EnchantProvider* _tmp5_;
				ProviderDescribe _tmp6_;
				EnchantProvider* _tmp7_;
				const gchar* _tmp8_;
				EnchantProvider* _tmp9_;
				ProviderListDicts _tmp10_;
				EnchantProvider* _tmp11_;
				size_t _tmp12_ = 0;
				gchar** _tmp13_;
#line 356 "broker.vala"
				_tmp5_ = provider;
#line 356 "broker.vala"
				_tmp6_ = _tmp5_->describe;
#line 356 "broker.vala"
				_tmp7_ = provider;
#line 356 "broker.vala"
				_tmp8_ = _tmp6_ (_tmp7_);
#line 356 "broker.vala"
				g_debug ("broker.vala:356: provider %s", _tmp8_);
#line 358 "broker.vala"
				_tmp9_ = provider;
#line 358 "broker.vala"
				_tmp10_ = _tmp9_->list_dicts;
#line 358 "broker.vala"
				_tmp11_ = provider;
#line 358 "broker.vala"
				_tmp13_ = _tmp10_ (_tmp11_, &_tmp12_);
#line 2783 "broker.c"
				{
					gchar** tag_collection = NULL;
					gint tag_collection_length1 = 0;
					gint _tag_collection_size_ = 0;
					gint tag_it = 0;
#line 358 "broker.vala"
					tag_collection = _tmp13_;
#line 358 "broker.vala"
					tag_collection_length1 = _tmp12_;
#line 358 "broker.vala"
					for (tag_it = 0; tag_it < tag_collection_length1; tag_it = tag_it + 1) {
#line 2795 "broker.c"
						gchar* _tmp14_;
						gchar* tag = NULL;
#line 358 "broker.vala"
						_tmp14_ = g_strdup (tag_collection[tag_it]);
#line 358 "broker.vala"
						tag = _tmp14_;
#line 2802 "broker.c"
						{
							const gchar* _tmp15_;
							GSList* providers = NULL;
							const gchar* _tmp16_;
							GSList* _tmp17_;
							gint this_priority = 0;
							GSList* _tmp18_;
							EnchantProvider* _tmp19_;
#line 359 "broker.vala"
							_tmp15_ = tag;
#line 359 "broker.vala"
							g_debug ("broker.vala:359: tag %s", _tmp15_);
#line 360 "broker.vala"
							_tmp16_ = tag;
#line 360 "broker.vala"
							_tmp17_ = enchant_broker_get_ordered_providers (self, _tmp16_);
#line 360 "broker.vala"
							providers = _tmp17_;
#line 361 "broker.vala"
							_tmp18_ = providers;
#line 361 "broker.vala"
							_tmp19_ = provider;
#line 361 "broker.vala"
							this_priority = g_slist_index (_tmp18_, _tmp19_);
#line 362 "broker.vala"
							g_debug ("broker.vala:362: priority %d", this_priority);
#line 363 "broker.vala"
							if (this_priority != -1) {
#line 2831 "broker.c"
								gint min_priority = 0;
								EnchantProvider* prov = NULL;
								GHashTable* _tmp20_;
								const gchar* _tmp21_;
								gconstpointer _tmp22_;
								EnchantProvider* _tmp23_;
#line 364 "broker.vala"
								min_priority = this_priority + 1;
#line 365 "broker.vala"
								_tmp20_ = tag_map;
#line 365 "broker.vala"
								_tmp21_ = tag;
#line 365 "broker.vala"
								_tmp22_ = g_hash_table_lookup (_tmp20_, _tmp21_);
#line 365 "broker.vala"
								prov = (EnchantProvider*) _tmp22_;
#line 366 "broker.vala"
								_tmp23_ = prov;
#line 366 "broker.vala"
								if (_tmp23_ != NULL) {
#line 2852 "broker.c"
									GSList* _tmp24_;
									EnchantProvider* _tmp25_;
#line 367 "broker.vala"
									_tmp24_ = providers;
#line 367 "broker.vala"
									_tmp25_ = prov;
#line 367 "broker.vala"
									min_priority = g_slist_index (_tmp24_, _tmp25_);
#line 2861 "broker.c"
								}
#line 368 "broker.vala"
								if (this_priority < min_priority) {
#line 2865 "broker.c"
									GHashTable* _tmp26_;
									const gchar* _tmp27_;
									gchar* _tmp28_;
									EnchantProvider* _tmp29_;
#line 369 "broker.vala"
									_tmp26_ = tag_map;
#line 369 "broker.vala"
									_tmp27_ = tag;
#line 369 "broker.vala"
									_tmp28_ = g_strdup (_tmp27_);
#line 369 "broker.vala"
									_tmp29_ = provider;
#line 369 "broker.vala"
									g_hash_table_insert (_tmp26_, _tmp28_, _tmp29_);
#line 2880 "broker.c"
								}
							}
#line 358 "broker.vala"
							(providers == NULL) ? NULL : (providers = (g_slist_free (providers), NULL));
#line 358 "broker.vala"
							_g_free0 (tag);
#line 2887 "broker.c"
						}
					}
#line 358 "broker.vala"
					tag_collection = (_vala_array_free (tag_collection, tag_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2892 "broker.c"
				}
			}
		}
	}
#line 374 "broker.vala"
	tags = NULL;
#line 375 "broker.vala"
	_tmp30_ = tag_map;
#line 375 "broker.vala"
	_tmp31_ = g_hash_table_get_keys (_tmp30_);
#line 2903 "broker.c"
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
#line 375 "broker.vala"
		key_collection = _tmp31_;
#line 375 "broker.vala"
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 2911 "broker.c"
			gchar* _tmp32_;
			gchar* key = NULL;
#line 375 "broker.vala"
			_tmp32_ = g_strdup ((const gchar*) key_it->data);
#line 375 "broker.vala"
			key = _tmp32_;
#line 2918 "broker.c"
			{
				const gchar* _tmp33_;
				gchar* _tmp34_;
				GCompareFunc _tmp35_;
#line 376 "broker.vala"
				_tmp33_ = key;
#line 376 "broker.vala"
				_tmp34_ = g_strdup (_tmp33_);
#line 376 "broker.vala"
				_tmp35_ = ((GCompareFunc) g_strcmp0);
#line 376 "broker.vala"
				tags = g_slist_insert_sorted (tags, _tmp34_, _tmp35_);
#line 375 "broker.vala"
				_g_free0 (key);
#line 2933 "broker.c"
			}
		}
#line 375 "broker.vala"
		(key_collection == NULL) ? NULL : (key_collection = (g_list_free (key_collection), NULL));
#line 2938 "broker.c"
	}
#line 378 "broker.vala"
	_tmp36_ = tags;
#line 2942 "broker.c"
	{
		GSList* tag_collection = NULL;
		GSList* tag_it = NULL;
#line 378 "broker.vala"
		tag_collection = _tmp36_;
#line 378 "broker.vala"
		for (tag_it = tag_collection; tag_it != NULL; tag_it = tag_it->next) {
#line 2950 "broker.c"
			gchar* _tmp37_;
			gchar* tag = NULL;
#line 378 "broker.vala"
			_tmp37_ = g_strdup ((const gchar*) tag_it->data);
#line 378 "broker.vala"
			tag = _tmp37_;
#line 2957 "broker.c"
			{
				EnchantProvider* provider = NULL;
				GHashTable* _tmp38_;
				const gchar* _tmp39_;
				gconstpointer _tmp40_;
				gchar* name = NULL;
				EnchantProvider* _tmp41_;
				ProviderIdentify _tmp42_;
				EnchantProvider* _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* desc = NULL;
				EnchantProvider* _tmp46_;
				ProviderDescribe _tmp47_;
				EnchantProvider* _tmp48_;
				const gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* file = NULL;
				EnchantProvider* _tmp51_;
				GModule* _tmp52_;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
#line 379 "broker.vala"
				_tmp38_ = tag_map;
#line 379 "broker.vala"
				_tmp39_ = tag;
#line 379 "broker.vala"
				_tmp40_ = g_hash_table_lookup (_tmp38_, _tmp39_);
#line 379 "broker.vala"
				provider = (EnchantProvider*) _tmp40_;
#line 380 "broker.vala"
				_tmp41_ = provider;
#line 380 "broker.vala"
				_tmp42_ = _tmp41_->identify;
#line 380 "broker.vala"
				_tmp43_ = provider;
#line 380 "broker.vala"
				_tmp44_ = _tmp42_ (_tmp43_);
#line 380 "broker.vala"
				_tmp45_ = g_strdup (_tmp44_);
#line 380 "broker.vala"
				name = _tmp45_;
#line 381 "broker.vala"
				_tmp46_ = provider;
#line 381 "broker.vala"
				_tmp47_ = _tmp46_->describe;
#line 381 "broker.vala"
				_tmp48_ = provider;
#line 381 "broker.vala"
				_tmp49_ = _tmp47_ (_tmp48_);
#line 381 "broker.vala"
				_tmp50_ = g_strdup (_tmp49_);
#line 381 "broker.vala"
				desc = _tmp50_;
#line 382 "broker.vala"
				_tmp51_ = provider;
#line 382 "broker.vala"
				_tmp52_ = _tmp51_->module;
#line 382 "broker.vala"
				_tmp53_ = g_module_name (_tmp52_);
#line 382 "broker.vala"
				_tmp54_ = g_strdup (_tmp53_);
#line 382 "broker.vala"
				file = _tmp54_;
#line 383 "broker.vala"
				_tmp55_ = tag;
#line 383 "broker.vala"
				_tmp56_ = name;
#line 383 "broker.vala"
				_tmp57_ = desc;
#line 383 "broker.vala"
				_tmp58_ = file;
#line 383 "broker.vala"
				fn (_tmp55_, _tmp56_, _tmp57_, _tmp58_, user_data);
#line 378 "broker.vala"
				_g_free0 (file);
#line 378 "broker.vala"
				_g_free0 (desc);
#line 378 "broker.vala"
				_g_free0 (name);
#line 378 "broker.vala"
				_g_free0 (tag);
#line 3044 "broker.c"
			}
		}
	}
#line 345 "broker.vala"
	(tags == NULL) ? NULL : (tags = (_g_slist_free__g_free0_ (tags), NULL));
#line 345 "broker.vala"
	_g_hash_table_unref0 (tag_map);
#line 3052 "broker.c"
}

gint
_enchant_broker_dict_exists (EnchantBroker* self,
                             const gchar* tag)
{
	gint _tmp0_;
	gint _tmp1_;
	GSList* _tmp2_;
	gint result;
#line 387 "broker.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 387 "broker.vala"
	g_return_val_if_fail (tag != NULL, 0);
#line 387 "broker.vala"
	_tmp0_ = strlen (tag);
#line 387 "broker.vala"
	_tmp1_ = _tmp0_;
#line 387 "broker.vala"
	_vala_return_val_if_fail (_tmp1_ > 0, "tag.length > 0", 0);
#line 391 "broker.vala"
	_tmp2_ = self->provider_list;
#line 3075 "broker.c"
	{
		GSList* provider_collection = NULL;
		GSList* provider_it = NULL;
#line 391 "broker.vala"
		provider_collection = _tmp2_;
#line 391 "broker.vala"
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 3083 "broker.c"
			EnchantProvider* provider = NULL;
#line 391 "broker.vala"
			provider = (EnchantProvider*) provider_it->data;
#line 3087 "broker.c"
			{
				EnchantProvider* _tmp3_;
#line 392 "broker.vala"
				_tmp3_ = provider;
#line 392 "broker.vala"
				if (_enchant_provider_dictionary_exists (_tmp3_, tag) != 0) {
#line 393 "broker.vala"
					result = 1;
#line 393 "broker.vala"
					return result;
#line 3098 "broker.c"
				}
			}
		}
	}
#line 395 "broker.vala"
	result = 0;
#line 395 "broker.vala"
	return result;
#line 3107 "broker.c"
}

gint
enchant_broker_dict_exists (EnchantBroker* self,
                            const gchar* tag)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* normalized_tag = NULL;
	gchar* _tmp2_;
	gint exists = 0;
	const gchar* _tmp3_;
	gint result;
#line 398 "broker.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 398 "broker.vala"
	g_return_val_if_fail (tag != NULL, 0);
#line 398 "broker.vala"
	_tmp0_ = strlen (tag);
#line 398 "broker.vala"
	_tmp1_ = _tmp0_;
#line 398 "broker.vala"
	_vala_return_val_if_fail (_tmp1_ > 0, "tag.length > 0", 0);
#line 401 "broker.vala"
	enchant_broker_clear_error (self);
#line 403 "broker.vala"
	_tmp2_ = normalize_dictionary_tag (tag);
#line 403 "broker.vala"
	normalized_tag = _tmp2_;
#line 404 "broker.vala"
	exists = 0;
#line 406 "broker.vala"
	_tmp3_ = normalized_tag;
#line 406 "broker.vala"
	exists = _enchant_broker_dict_exists (self, _tmp3_);
#line 406 "broker.vala"
	if (exists == 0) {
#line 3145 "broker.c"
		gchar* iso_639_only_tag = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
#line 407 "broker.vala"
		_tmp4_ = normalized_tag;
#line 407 "broker.vala"
		_tmp5_ = iso_639_from_tag (_tmp4_);
#line 407 "broker.vala"
		iso_639_only_tag = _tmp5_;
#line 408 "broker.vala"
		_tmp6_ = iso_639_only_tag;
#line 408 "broker.vala"
		if (_tmp6_ == NULL) {
#line 409 "broker.vala"
			result = 0;
#line 409 "broker.vala"
			_g_free0 (iso_639_only_tag);
#line 409 "broker.vala"
			_g_free0 (normalized_tag);
#line 409 "broker.vala"
			return result;
#line 3170 "broker.c"
		}
#line 411 "broker.vala"
		_tmp7_ = normalized_tag;
#line 411 "broker.vala"
		_tmp8_ = iso_639_only_tag;
#line 411 "broker.vala"
		if (g_strcmp0 (_tmp7_, _tmp8_) != 0) {
#line 3178 "broker.c"
			const gchar* _tmp9_;
#line 412 "broker.vala"
			_tmp9_ = iso_639_only_tag;
#line 412 "broker.vala"
			exists = _enchant_broker_dict_exists (self, _tmp9_);
#line 3184 "broker.c"
		}
#line 406 "broker.vala"
		_g_free0 (iso_639_only_tag);
#line 3188 "broker.c"
	}
#line 415 "broker.vala"
	result = exists;
#line 415 "broker.vala"
	_g_free0 (normalized_tag);
#line 415 "broker.vala"
	return result;
#line 3196 "broker.c"
}

static gpointer
_enchant_dict_ref0 (gpointer self)
{
#line 420 "broker.vala"
	return self ? enchant_dict_ref (self) : NULL;
#line 3204 "broker.c"
}

EnchantDict*
enchant_broker_new_dict (EnchantBroker* self)
{
	EnchantDict* dict = NULL;
	EnchantDict* _tmp0_;
	GHashTable* _tmp1_;
	EnchantDict* _tmp2_;
	EnchantDict* dict_ref = NULL;
	EnchantDict* result;
#line 418 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 419 "broker.vala"
	_tmp0_ = enchant_dict_new ();
#line 419 "broker.vala"
	dict = _tmp0_;
#line 420 "broker.vala"
	_tmp1_ = self->dicts;
#line 420 "broker.vala"
	_tmp2_ = _enchant_dict_ref0 (dict);
#line 420 "broker.vala"
	g_hash_table_add (_tmp1_, _tmp2_);
#line 421 "broker.vala"
	dict_ref = dict;
#line 422 "broker.vala"
	result = dict_ref;
#line 422 "broker.vala"
	_enchant_dict_unref0 (dict);
#line 422 "broker.vala"
	return result;
#line 3236 "broker.c"
}

void
enchant_broker_free_dict (EnchantBroker* self,
                          EnchantDict* dict)
{
	GHashTable* _tmp0_;
#line 425 "broker.vala"
	g_return_if_fail (self != NULL);
#line 425 "broker.vala"
	g_return_if_fail (dict != NULL);
#line 426 "broker.vala"
	_tmp0_ = self->dicts;
#line 426 "broker.vala"
	g_hash_table_remove (_tmp0_, dict);
#line 427 "broker.vala"
	enchant_broker_clear_error (self);
#line 3254 "broker.c"
}

const gchar*
enchant_broker_get_error (EnchantBroker* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 103 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 103 "broker.vala"
	_tmp0_ = self->_error;
#line 103 "broker.vala"
	result = _tmp0_;
#line 103 "broker.vala"
	return result;
#line 3270 "broker.c"
}

void
enchant_broker_set_error (EnchantBroker* self,
                          const gchar* value)
{
	gchar* _tmp0_;
#line 104 "broker.vala"
	g_return_if_fail (self != NULL);
#line 104 "broker.vala"
	_tmp0_ = g_strdup (value);
#line 104 "broker.vala"
	_g_free0 (self->_error);
#line 104 "broker.vala"
	self->_error = _tmp0_;
#line 3286 "broker.c"
}

static void
enchant_broker_instance_init (EnchantBroker * self)
{
}

void
enchant_broker_free (EnchantBroker * self)
{
#line 95 "broker.vala"
	g_return_if_fail (self != NULL);
#line 76 "broker.vala"
	(self->provider_list == NULL) ? NULL : (self->provider_list = (_g_slist_free__enchant_provider_unref0_ (self->provider_list), NULL));
#line 77 "broker.vala"
	_g_hash_table_unref0 (self->provider_ordering);
#line 78 "broker.vala"
	_g_hash_table_unref0 (self->dicts);
#line 80 "broker.vala"
	_g_free0 (self->_error);
#line 75 "broker.vala"
	g_slice_free (EnchantBroker, self);
#line 3309 "broker.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

